/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.FeatureTagState;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class DelegateRegistrationState
implements Parcelable {
    public static final int DEREGISTERED_REASON_UNKNOWN = 0;
    public static final int DEREGISTERED_REASON_NOT_PROVISIONED = 1;
    public static final int DEREGISTERED_REASON_NOT_REGISTERED = 2;
    public static final int DEREGISTERING_REASON_PDN_CHANGE = 3;
    public static final int DEREGISTERING_REASON_PROVISIONING_CHANGE = 4;
    public static final int DEREGISTERING_REASON_FEATURE_TAGS_CHANGING = 5;
    public static final int DEREGISTERING_REASON_DESTROY_PENDING = 6;
    public static final int DEREGISTERING_REASON_LOSING_PDN = 7;
    public static final int DEREGISTERING_REASON_UNSPECIFIED = 8;
    private ArraySet<String> mRegisteringTags = new ArraySet();
    private ArraySet<String> mRegisteredTags = new ArraySet();
    private final ArraySet<FeatureTagState> mDeregisteringTags = new ArraySet();
    private final ArraySet<FeatureTagState> mDeregisteredTags = new ArraySet();
    @NonNull
    public static final Parcelable.Creator<DelegateRegistrationState> CREATOR = new Parcelable.Creator<DelegateRegistrationState>(){

        @Override
        public DelegateRegistrationState createFromParcel(Parcel source) {
            return new DelegateRegistrationState(source);
        }

        public DelegateRegistrationState[] newArray(int size) {
            return new DelegateRegistrationState[size];
        }
    };

    private DelegateRegistrationState() {
    }

    private DelegateRegistrationState(Parcel source) {
        this.mRegisteredTags = source.readArraySet(null);
        this.readStateFromParcel(source, this.mDeregisteringTags);
        this.readStateFromParcel(source, this.mDeregisteredTags);
        this.mRegisteringTags = source.readArraySet(null);
    }

    @NonNull
    public Set<String> getRegisteringFeatureTags() {
        return new ArraySet<String>(this.mRegisteringTags);
    }

    @NonNull
    public Set<String> getRegisteredFeatureTags() {
        return new ArraySet<String>(this.mRegisteredTags);
    }

    @NonNull
    public Set<FeatureTagState> getDeregisteringFeatureTags() {
        return new ArraySet<FeatureTagState>(this.mDeregisteringTags);
    }

    @NonNull
    public Set<FeatureTagState> getDeregisteredFeatureTags() {
        return new ArraySet<FeatureTagState>(this.mDeregisteredTags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeArraySet(this.mRegisteredTags);
        this.writeStateToParcel(dest, this.mDeregisteringTags);
        this.writeStateToParcel(dest, this.mDeregisteredTags);
        dest.writeArraySet(this.mRegisteringTags);
    }

    private void writeStateToParcel(Parcel dest, Set<FeatureTagState> state) {
        dest.writeInt(state.size());
        for (FeatureTagState s : state) {
            dest.writeString(s.getFeatureTag());
            dest.writeInt(s.getState());
        }
    }

    private void readStateFromParcel(Parcel source, Set<FeatureTagState> emptyState) {
        int len = source.readInt();
        for (int i = 0; i < len; ++i) {
            String ft = source.readString();
            int reason = source.readInt();
            emptyState.add(new FeatureTagState(ft, reason));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegateRegistrationState that = (DelegateRegistrationState)o;
        return this.mRegisteringTags.equals(that.mRegisteringTags) && this.mRegisteredTags.equals(that.mRegisteredTags) && this.mDeregisteringTags.equals(that.mDeregisteringTags) && this.mDeregisteredTags.equals(that.mDeregisteredTags);
    }

    public int hashCode() {
        return Objects.hash(this.mRegisteringTags, this.mRegisteredTags, this.mDeregisteringTags, this.mDeregisteredTags);
    }

    public String toString() {
        return "DelegateRegistrationState{ registered={" + this.mRegisteredTags + "}, registering={" + this.mRegisteringTags + "}, deregistering={" + this.mDeregisteringTags + "}, deregistered={" + this.mDeregisteredTags + "}}";
    }

    public static class Builder {
        private final DelegateRegistrationState mState = new DelegateRegistrationState();

        @NonNull
        public Builder addRegisteringFeatureTags(@NonNull Set<String> featureTags) {
            this.mState.mRegisteringTags.addAll(featureTags);
            return this;
        }

        @NonNull
        public Builder addRegisteredFeatureTag(@NonNull String featureTag) {
            this.mState.mRegisteredTags.add(featureTag);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder addRegisteredFeatureTags(@NonNull Set<String> featureTags) {
            this.mState.mRegisteredTags.addAll(featureTags);
            return this;
        }

        @NonNull
        public Builder addDeregisteringFeatureTag(@NonNull String featureTag, int reason) {
            this.mState.mDeregisteringTags.add(new FeatureTagState(featureTag, reason));
            return this;
        }

        @NonNull
        public Builder addDeregisteredFeatureTag(@NonNull String featureTag, int reason) {
            this.mState.mDeregisteredTags.add(new FeatureTagState(featureTag, reason));
            return this;
        }

        @NonNull
        public DelegateRegistrationState build() {
            return this.mState;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeregisteringReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeregisteredReason {
    }
}

