/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.euicc;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class EuiccNotification
implements Parcelable {
    public static final int EVENT_INSTALL = 1;
    public static final int EVENT_ENABLE = 2;
    public static final int EVENT_DISABLE = 4;
    public static final int EVENT_DELETE = 8;
    public static final int ALL_EVENTS = 15;
    private final int mSeq;
    private final String mTargetAddr;
    private final int mEvent;
    @Nullable
    private final byte[] mData;
    @NonNull
    public static final Parcelable.Creator<EuiccNotification> CREATOR = new Parcelable.Creator<EuiccNotification>(){

        @Override
        public EuiccNotification createFromParcel(Parcel source) {
            return new EuiccNotification(source);
        }

        public EuiccNotification[] newArray(int size) {
            return new EuiccNotification[size];
        }
    };

    public EuiccNotification(int seq, String targetAddr, int event, @Nullable byte[] data) {
        this.mSeq = seq;
        this.mTargetAddr = targetAddr;
        this.mEvent = event;
        this.mData = data;
    }

    public int getSeq() {
        return this.mSeq;
    }

    public String getTargetAddr() {
        return this.mTargetAddr;
    }

    public int getEvent() {
        return this.mEvent;
    }

    @Nullable
    public byte[] getData() {
        return this.mData;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EuiccNotification that = (EuiccNotification)obj;
        return this.mSeq == that.mSeq && Objects.equals(this.mTargetAddr, that.mTargetAddr) && this.mEvent == that.mEvent && Arrays.equals(this.mData, that.mData);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.mSeq;
        result = 31 * result + Objects.hashCode(this.mTargetAddr);
        result = 31 * result + this.mEvent;
        result = 31 * result + Arrays.hashCode(this.mData);
        return result;
    }

    @NonNull
    public String toString() {
        return "EuiccNotification (seq=" + this.mSeq + ", targetAddr=" + this.mTargetAddr + ", event=" + this.mEvent + ", data=" + (this.mData == null ? "null" : "byte[" + this.mData.length + "]") + ")";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSeq);
        dest.writeString(this.mTargetAddr);
        dest.writeInt(this.mEvent);
        dest.writeByteArray(this.mData);
    }

    private EuiccNotification(Parcel source) {
        this.mSeq = source.readInt();
        this.mTargetAddr = source.readString();
        this.mEvent = source.readInt();
        this.mData = source.createByteArray();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Event {
    }
}

