/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.euicc;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.UiccAccessRule;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DownloadableSubscription
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<DownloadableSubscription> CREATOR = new Parcelable.Creator<DownloadableSubscription>(){

        @Override
        public DownloadableSubscription createFromParcel(Parcel in) {
            return new DownloadableSubscription(in);
        }

        public DownloadableSubscription[] newArray(int size) {
            return new DownloadableSubscription[size];
        }
    };
    @Deprecated
    @Nullable
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final String encodedActivationCode;
    @Nullable
    private String confirmationCode;
    @Nullable
    private String carrierName;
    @Nullable
    private List<UiccAccessRule> accessRules;

    @Nullable
    public String getEncodedActivationCode() {
        return this.encodedActivationCode;
    }

    private DownloadableSubscription(String encodedActivationCode) {
        this.encodedActivationCode = encodedActivationCode;
    }

    private DownloadableSubscription(Parcel in) {
        this.encodedActivationCode = in.readString();
        this.confirmationCode = in.readString();
        this.carrierName = in.readString();
        this.accessRules = new ArrayList<UiccAccessRule>();
        in.readTypedList(this.accessRules, UiccAccessRule.CREATOR);
    }

    private DownloadableSubscription(String encodedActivationCode, String confirmationCode, String carrierName, List<UiccAccessRule> accessRules) {
        this.encodedActivationCode = encodedActivationCode;
        this.confirmationCode = confirmationCode;
        this.carrierName = carrierName;
        this.accessRules = accessRules;
    }

    public static DownloadableSubscription forActivationCode(String encodedActivationCode) {
        Preconditions.checkNotNull(encodedActivationCode, "Activation code may not be null");
        return new DownloadableSubscription(encodedActivationCode);
    }

    @Deprecated
    public void setConfirmationCode(String confirmationCode) {
        this.confirmationCode = confirmationCode;
    }

    @Nullable
    public String getConfirmationCode() {
        return this.confirmationCode;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    @SystemApi
    @Nullable
    public String getCarrierName() {
        return this.carrierName;
    }

    @SystemApi
    public List<UiccAccessRule> getAccessRules() {
        return this.accessRules;
    }

    @Deprecated
    public void setAccessRules(List<UiccAccessRule> accessRules) {
        this.accessRules = accessRules;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setAccessRules(UiccAccessRule[] accessRules) {
        this.accessRules = Arrays.asList(accessRules);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.encodedActivationCode);
        dest.writeString(this.confirmationCode);
        dest.writeString(this.carrierName);
        dest.writeTypedList(this.accessRules);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        @Nullable
        private String encodedActivationCode;
        @Nullable
        private String confirmationCode;
        @Nullable
        private String carrierName;
        List<UiccAccessRule> accessRules;

        @SystemApi
        public Builder() {
        }

        public Builder(@NonNull DownloadableSubscription baseSubscription) {
            this.encodedActivationCode = baseSubscription.getEncodedActivationCode();
            this.confirmationCode = baseSubscription.getConfirmationCode();
            this.carrierName = baseSubscription.getCarrierName();
            this.accessRules = baseSubscription.getAccessRules();
        }

        public Builder(@NonNull String encodedActivationCode) {
            this.encodedActivationCode = encodedActivationCode;
        }

        @NonNull
        public DownloadableSubscription build() {
            return new DownloadableSubscription(this.encodedActivationCode, this.confirmationCode, this.carrierName, this.accessRules);
        }

        @NonNull
        public Builder setEncodedActivationCode(@NonNull String value) {
            this.encodedActivationCode = value;
            return this;
        }

        @NonNull
        public Builder setConfirmationCode(@NonNull String value) {
            this.confirmationCode = value;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setCarrierName(@NonNull String value) {
            this.carrierName = value;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setAccessRules(@NonNull List<UiccAccessRule> value) {
            this.accessRules = value;
            return this;
        }
    }
}

