/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.telephony.SubscriptionManager;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import com.android.telephony.Rlog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SubscriptionInfo
implements Parcelable {
    private static final int TEXT_SIZE = 16;
    private final int mId;
    @NonNull
    private final String mIccId;
    private final int mSimSlotIndex;
    @NonNull
    private final CharSequence mDisplayName;
    @NonNull
    private final CharSequence mCarrierName;
    private final int mDisplayNameSource;
    private final int mIconTint;
    @NonNull
    private final String mNumber;
    private final int mDataRoaming;
    @Nullable
    private final String mMcc;
    @Nullable
    private final String mMnc;
    @NonNull
    private final String[] mEhplmns;
    @NonNull
    private final String[] mHplmns;
    private final boolean mIsEmbedded;
    @NonNull
    private final String mCardString;
    @Nullable
    private final UiccAccessRule[] mNativeAccessRules;
    @Nullable
    private final UiccAccessRule[] mCarrierConfigAccessRules;
    private final boolean mIsOpportunistic;
    @Nullable
    private final ParcelUuid mGroupUuid;
    @NonNull
    private final String mCountryIso;
    private final int mCarrierId;
    private final int mProfileClass;
    private final int mType;
    @NonNull
    private final String mGroupOwner;
    private final boolean mAreUiccApplicationsEnabled;
    private final int mPortIndex;
    private final int mUsageSetting;
    private final int mTransferStatus;
    @Nullable
    private Bitmap mIconBitmap;
    private final int mCardId;
    private final boolean mIsGroupDisabled;
    private final boolean mIsOnlyNonTerrestrialNetwork;
    private final int mServiceCapabilities;
    private final boolean mIsSatelliteESOSSupported;
    @NonNull
    public static final Parcelable.Creator<SubscriptionInfo> CREATOR = new Parcelable.Creator<SubscriptionInfo>(){

        @Override
        public SubscriptionInfo createFromParcel(Parcel source) {
            return new Builder().setId(source.readInt()).setIccId(source.readString()).setSimSlotIndex(source.readInt()).setDisplayName(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source)).setCarrierName(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source)).setDisplayNameSource(source.readInt()).setIconTint(source.readInt()).setNumber(source.readString()).setDataRoaming(source.readInt()).setMcc(source.readString()).setMnc(source.readString()).setCountryIso(source.readString()).setEmbedded(source.readBoolean()).setNativeAccessRules(source.createTypedArray(UiccAccessRule.CREATOR)).setCardString(source.readString()).setCardId(source.readInt()).setPortIndex(source.readInt()).setOpportunistic(source.readBoolean()).setGroupUuid(source.readString8()).setGroupDisabled(source.readBoolean()).setCarrierId(source.readInt()).setProfileClass(source.readInt()).setType(source.readInt()).setEhplmns(source.createStringArray()).setHplmns(source.createStringArray()).setGroupOwner(source.readString()).setCarrierConfigAccessRules(source.createTypedArray(UiccAccessRule.CREATOR)).setUiccApplicationsEnabled(source.readBoolean()).setUsageSetting(source.readInt()).setOnlyNonTerrestrialNetwork(source.readBoolean()).setServiceCapabilities(SubscriptionManager.getServiceCapabilitiesSet(source.readInt())).setTransferStatus(source.readInt()).setSatelliteESOSSupported(source.readBoolean()).build();
        }

        public SubscriptionInfo[] newArray(int size) {
            return new SubscriptionInfo[size];
        }
    };

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, @Nullable UiccAccessRule[] nativeAccessRules, String cardString) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, -1, false, null, false, -1, -1, 0, null, null, true);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, @Nullable UiccAccessRule[] nativeAccessRules, String cardString, boolean isOpportunistic, @Nullable String groupUUID, int carrierId, int profileClass) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, -1, isOpportunistic, groupUUID, false, carrierId, profileClass, 0, null, null, true);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, @Nullable UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, @Nullable String groupUUID, boolean isGroupDisabled, int carrierId, int profileClass, int subType, @Nullable String groupOwner, @Nullable UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, cardId, isOpportunistic, groupUUID, isGroupDisabled, carrierId, profileClass, subType, groupOwner, carrierConfigAccessRules, areUiccApplicationsEnabled, 0);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int displayNameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, @Nullable UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, @Nullable String groupUUID, boolean isGroupDisabled, int carrierId, int profileClass, int subType, @Nullable String groupOwner, @Nullable UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled, int portIndex) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, displayNameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, cardId, isOpportunistic, groupUUID, isGroupDisabled, carrierId, profileClass, subType, groupOwner, carrierConfigAccessRules, areUiccApplicationsEnabled, portIndex, 0);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, @Nullable UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, @Nullable String groupUuid, boolean isGroupDisabled, int carrierId, int profileClass, int subType, @Nullable String groupOwner, @Nullable UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled, int portIndex, int usageSetting) {
        this.mId = id2;
        this.mIccId = iccId;
        this.mSimSlotIndex = simSlotIndex;
        this.mDisplayName = displayName;
        this.mCarrierName = carrierName;
        this.mDisplayNameSource = nameSource;
        this.mIconTint = iconTint;
        this.mNumber = number;
        this.mDataRoaming = roaming;
        this.mIconBitmap = icon;
        this.mMcc = TextUtils.emptyIfNull(mcc);
        this.mMnc = TextUtils.emptyIfNull(mnc);
        this.mHplmns = null;
        this.mEhplmns = null;
        this.mCountryIso = TextUtils.emptyIfNull(countryIso);
        this.mIsEmbedded = isEmbedded;
        this.mNativeAccessRules = nativeAccessRules;
        this.mCardString = TextUtils.emptyIfNull(cardString);
        this.mCardId = cardId;
        this.mIsOpportunistic = isOpportunistic;
        this.mGroupUuid = groupUuid == null ? null : ParcelUuid.fromString(groupUuid);
        this.mIsGroupDisabled = isGroupDisabled;
        this.mCarrierId = carrierId;
        this.mProfileClass = profileClass;
        this.mType = subType;
        this.mGroupOwner = TextUtils.emptyIfNull(groupOwner);
        this.mCarrierConfigAccessRules = carrierConfigAccessRules;
        this.mAreUiccApplicationsEnabled = areUiccApplicationsEnabled;
        this.mPortIndex = portIndex;
        this.mUsageSetting = usageSetting;
        this.mIsOnlyNonTerrestrialNetwork = false;
        this.mServiceCapabilities = 0;
        this.mTransferStatus = 0;
        this.mIsSatelliteESOSSupported = false;
    }

    private SubscriptionInfo(@NonNull Builder builder) {
        this.mId = builder.mId;
        this.mIccId = builder.mIccId;
        this.mSimSlotIndex = builder.mSimSlotIndex;
        this.mDisplayName = builder.mDisplayName;
        this.mCarrierName = builder.mCarrierName;
        this.mDisplayNameSource = builder.mDisplayNameSource;
        this.mIconTint = builder.mIconTint;
        this.mNumber = builder.mNumber;
        this.mDataRoaming = builder.mDataRoaming;
        this.mIconBitmap = builder.mIconBitmap;
        this.mMcc = builder.mMcc;
        this.mMnc = builder.mMnc;
        this.mEhplmns = builder.mEhplmns;
        this.mHplmns = builder.mHplmns;
        this.mCountryIso = builder.mCountryIso;
        this.mIsEmbedded = builder.mIsEmbedded;
        this.mNativeAccessRules = builder.mNativeAccessRules;
        this.mCardString = builder.mCardString;
        this.mCardId = builder.mCardId;
        this.mIsOpportunistic = builder.mIsOpportunistic;
        this.mGroupUuid = builder.mGroupUuid;
        this.mIsGroupDisabled = builder.mIsGroupDisabled;
        this.mCarrierId = builder.mCarrierId;
        this.mProfileClass = builder.mProfileClass;
        this.mType = builder.mType;
        this.mGroupOwner = builder.mGroupOwner;
        this.mCarrierConfigAccessRules = builder.mCarrierConfigAccessRules;
        this.mAreUiccApplicationsEnabled = builder.mAreUiccApplicationsEnabled;
        this.mPortIndex = builder.mPortIndex;
        this.mUsageSetting = builder.mUsageSetting;
        this.mIsOnlyNonTerrestrialNetwork = builder.mIsOnlyNonTerrestrialNetwork;
        this.mServiceCapabilities = builder.mServiceCapabilities;
        this.mTransferStatus = builder.mTransferStatus;
        this.mIsSatelliteESOSSupported = builder.mIsSatelliteESOSSupported;
    }

    public int getSubscriptionId() {
        return this.mId;
    }

    public String getIccId() {
        return this.mIccId;
    }

    public int getSimSlotIndex() {
        return this.mSimSlotIndex;
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    public CharSequence getCarrierName() {
        return this.mCarrierName;
    }

    public int getDisplayNameSource() {
        return this.mDisplayNameSource;
    }

    public Bitmap createIconBitmap(Context context) {
        if (this.mIconBitmap == null) {
            this.mIconBitmap = BitmapFactory.decodeResource(context.getResources(), 17303024);
        }
        int width = this.mIconBitmap.getWidth();
        int height = this.mIconBitmap.getHeight();
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        Bitmap workingBitmap = Bitmap.createBitmap(metrics, width, height, this.mIconBitmap.getConfig());
        Canvas canvas = new Canvas(workingBitmap);
        Paint paint = new Paint();
        paint.setColorFilter(new PorterDuffColorFilter(this.mIconTint, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(this.mIconBitmap, 0.0f, 0.0f, paint);
        paint.setColorFilter(null);
        paint.setAntiAlias(true);
        paint.setTypeface(Typeface.create("sans-serif", 0));
        paint.setColor(-1);
        paint.setTextSize(16.0f * metrics.density);
        String index = TextUtils.formatSimple("%d", this.mSimSlotIndex + 1);
        Rect textBound = new Rect();
        paint.getTextBounds(index, 0, 1, textBound);
        float xOffset = (float)width / 2.0f - (float)textBound.centerX();
        float yOffset = (float)height / 2.0f - (float)textBound.centerY();
        canvas.drawText(index, xOffset, yOffset, paint);
        return workingBitmap;
    }

    public int getIconTint() {
        return this.mIconTint;
    }

    @Deprecated
    public String getNumber() {
        return this.mNumber;
    }

    public int getDataRoaming() {
        return this.mDataRoaming;
    }

    @Deprecated
    public int getMcc() {
        try {
            return TextUtils.isEmpty(this.mMcc) ? 0 : Integer.parseInt(this.mMcc);
        }
        catch (NumberFormatException e) {
            Log.w(SubscriptionInfo.class.getSimpleName(), "MCC string is not a number: " + this.mMcc);
            return 0;
        }
    }

    @Deprecated
    public int getMnc() {
        try {
            return TextUtils.isEmpty(this.mMnc) ? 0 : Integer.parseInt(this.mMnc);
        }
        catch (NumberFormatException e) {
            Log.w(SubscriptionInfo.class.getSimpleName(), "MNC string is not a number: " + this.mMnc);
            return 0;
        }
    }

    @Nullable
    public String getMccString() {
        return this.mMcc;
    }

    @Nullable
    public String getMncString() {
        return this.mMnc;
    }

    public String getCountryIso() {
        return this.mCountryIso;
    }

    public boolean isEmbedded() {
        return this.mIsEmbedded;
    }

    public boolean isOpportunistic() {
        return this.mIsOpportunistic;
    }

    public boolean isActive() {
        return this.mSimSlotIndex >= 0 || this.mType == 1;
    }

    @Nullable
    public ParcelUuid getGroupUuid() {
        return this.mGroupUuid;
    }

    @NonNull
    public List<String> getEhplmns() {
        return Collections.unmodifiableList(this.mEhplmns == null ? Collections.emptyList() : Arrays.asList(this.mEhplmns));
    }

    @NonNull
    public List<String> getHplmns() {
        return Collections.unmodifiableList(this.mHplmns == null ? Collections.emptyList() : Arrays.asList(this.mHplmns));
    }

    @NonNull
    public String getGroupOwner() {
        return this.mGroupOwner;
    }

    @SystemApi
    public int getProfileClass() {
        return this.mProfileClass;
    }

    public int getSubscriptionType() {
        return this.mType;
    }

    @Deprecated
    public boolean canManageSubscription(Context context) {
        return this.canManageSubscription(context, context.getPackageName());
    }

    @Deprecated
    public boolean canManageSubscription(Context context, String packageName) {
        PackageInfo packageInfo;
        List<UiccAccessRule> allAccessRules = this.getAccessRules();
        if (allAccessRules == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0x8000000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d("SubscriptionInfo", "canManageSubscription: Unknown package: " + packageName, e);
            return false;
        }
        for (UiccAccessRule rule : allAccessRules) {
            if (rule.getCarrierPrivilegeStatus(packageInfo) != 1) continue;
            return true;
        }
        return false;
    }

    @SystemApi
    @Nullable
    public List<UiccAccessRule> getAccessRules() {
        ArrayList<UiccAccessRule> merged = new ArrayList<UiccAccessRule>();
        if (this.mNativeAccessRules != null) {
            merged.addAll(Arrays.asList(this.mNativeAccessRules));
        }
        if (this.mCarrierConfigAccessRules != null) {
            merged.addAll(Arrays.asList(this.mCarrierConfigAccessRules));
        }
        return merged.isEmpty() ? null : Collections.unmodifiableList(merged);
    }

    @NonNull
    public String getCardString() {
        return this.mCardString;
    }

    public int getCardId() {
        return this.mCardId;
    }

    public int getPortIndex() {
        return this.mPortIndex;
    }

    @SystemApi
    public boolean isGroupDisabled() {
        return this.mIsGroupDisabled;
    }

    @SystemApi
    public boolean areUiccApplicationsEnabled() {
        return this.mAreUiccApplicationsEnabled;
    }

    public int getUsageSetting() {
        return this.mUsageSetting;
    }

    public boolean isOnlyNonTerrestrialNetwork() {
        return this.mIsOnlyNonTerrestrialNetwork;
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.carrier_roaming_nb_iot_ntn")
    public boolean isSatelliteESOSSupported() {
        return this.mIsSatelliteESOSSupported;
    }

    @NonNull
    public Set<Integer> getServiceCapabilities() {
        return SubscriptionManager.getServiceCapabilitiesSet(this.mServiceCapabilities);
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_psim_to_esim_conversion")
    public int getTransferStatus() {
        return this.mTransferStatus;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mIccId);
        dest.writeInt(this.mSimSlotIndex);
        TextUtils.writeToParcel(this.mDisplayName, dest, 0);
        TextUtils.writeToParcel(this.mCarrierName, dest, 0);
        dest.writeInt(this.mDisplayNameSource);
        dest.writeInt(this.mIconTint);
        dest.writeString(this.mNumber);
        dest.writeInt(this.mDataRoaming);
        dest.writeString(this.mMcc);
        dest.writeString(this.mMnc);
        dest.writeString(this.mCountryIso);
        dest.writeBoolean(this.mIsEmbedded);
        dest.writeTypedArray(this.mNativeAccessRules, flags);
        dest.writeString(this.mCardString);
        dest.writeInt(this.mCardId);
        dest.writeInt(this.mPortIndex);
        dest.writeBoolean(this.mIsOpportunistic);
        dest.writeString8(this.mGroupUuid == null ? null : this.mGroupUuid.toString());
        dest.writeBoolean(this.mIsGroupDisabled);
        dest.writeInt(this.mCarrierId);
        dest.writeInt(this.mProfileClass);
        dest.writeInt(this.mType);
        dest.writeStringArray(this.mEhplmns);
        dest.writeStringArray(this.mHplmns);
        dest.writeString(this.mGroupOwner);
        dest.writeTypedArray(this.mCarrierConfigAccessRules, flags);
        dest.writeBoolean(this.mAreUiccApplicationsEnabled);
        dest.writeInt(this.mUsageSetting);
        dest.writeBoolean(this.mIsOnlyNonTerrestrialNetwork);
        dest.writeInt(this.mServiceCapabilities);
        dest.writeInt(this.mTransferStatus);
        dest.writeBoolean(this.mIsSatelliteESOSSupported);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Nullable
    public static String getPrintableId(@Nullable String id2) {
        String idToPrint = null;
        if (id2 != null) {
            idToPrint = id2.length() > 9 && !TelephonyUtils.IS_DEBUGGABLE ? id2.substring(0, 9) + Rlog.pii(false, (Object)id2.substring(9)) : id2;
        }
        return idToPrint;
    }

    public String toString() {
        String iccIdToPrint = SubscriptionInfo.getPrintableId(this.mIccId);
        String cardStringToPrint = SubscriptionInfo.getPrintableId(this.mCardString);
        return "[SubscriptionInfo: id=" + this.mId + " iccId=" + iccIdToPrint + " simSlotIndex=" + this.mSimSlotIndex + " portIndex=" + this.mPortIndex + " isEmbedded=" + this.mIsEmbedded + " carrierId=" + this.mCarrierId + " displayName=" + this.mDisplayName + " carrierName=" + this.mCarrierName + " isOpportunistic=" + this.mIsOpportunistic + " groupUuid=" + this.mGroupUuid + " groupOwner=" + this.mGroupOwner + " isGroupDisabled=" + this.mIsGroupDisabled + " displayNameSource=" + SubscriptionManager.displayNameSourceToString(this.mDisplayNameSource) + " iconTint=" + this.mIconTint + " number=" + Rlog.pii(TelephonyUtils.IS_DEBUGGABLE, (Object)this.mNumber) + " dataRoaming=" + this.mDataRoaming + " mcc=" + this.mMcc + " mnc=" + this.mMnc + " ehplmns=" + Arrays.toString(this.mEhplmns) + " hplmns=" + Arrays.toString(this.mHplmns) + " cardString=" + cardStringToPrint + " cardId=" + this.mCardId + " nativeAccessRules=" + Arrays.toString(this.mNativeAccessRules) + " carrierConfigAccessRules=" + Arrays.toString(this.mCarrierConfigAccessRules) + " countryIso=" + this.mCountryIso + " profileClass=" + this.mProfileClass + " mType=" + SubscriptionManager.subscriptionTypeToString(this.mType) + " areUiccApplicationsEnabled=" + this.mAreUiccApplicationsEnabled + " usageSetting=" + SubscriptionManager.usageSettingToString(this.mUsageSetting) + " isOnlyNonTerrestrialNetwork=" + this.mIsOnlyNonTerrestrialNetwork + " serviceCapabilities=" + SubscriptionManager.getServiceCapabilitiesSet(this.mServiceCapabilities).toString() + " transferStatus=" + this.mTransferStatus + " isSatelliteESOSSupported=" + this.mIsSatelliteESOSSupported + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionInfo that = (SubscriptionInfo)o;
        return this.mId == that.mId && this.mSimSlotIndex == that.mSimSlotIndex && this.mDisplayNameSource == that.mDisplayNameSource && this.mIconTint == that.mIconTint && this.mDataRoaming == that.mDataRoaming && this.mIsEmbedded == that.mIsEmbedded && this.mIsOpportunistic == that.mIsOpportunistic && this.mCarrierId == that.mCarrierId && this.mProfileClass == that.mProfileClass && this.mType == that.mType && this.mAreUiccApplicationsEnabled == that.mAreUiccApplicationsEnabled && this.mPortIndex == that.mPortIndex && this.mUsageSetting == that.mUsageSetting && this.mCardId == that.mCardId && this.mIsGroupDisabled == that.mIsGroupDisabled && this.mIccId.equals(that.mIccId) && this.mDisplayName.equals(that.mDisplayName) && this.mCarrierName.equals(that.mCarrierName) && this.mNumber.equals(that.mNumber) && Objects.equals(this.mMcc, that.mMcc) && Objects.equals(this.mMnc, that.mMnc) && Arrays.equals(this.mEhplmns, that.mEhplmns) && Arrays.equals(this.mHplmns, that.mHplmns) && this.mCardString.equals(that.mCardString) && Arrays.equals(this.mNativeAccessRules, that.mNativeAccessRules) && Arrays.equals(this.mCarrierConfigAccessRules, that.mCarrierConfigAccessRules) && Objects.equals(this.mGroupUuid, that.mGroupUuid) && this.mCountryIso.equals(that.mCountryIso) && this.mGroupOwner.equals(that.mGroupOwner) && this.mIsOnlyNonTerrestrialNetwork == that.mIsOnlyNonTerrestrialNetwork && this.mServiceCapabilities == that.mServiceCapabilities && this.mTransferStatus == that.mTransferStatus && this.mIsSatelliteESOSSupported == that.mIsSatelliteESOSSupported;
    }

    public int hashCode() {
        int result = Objects.hash(this.mId, this.mIccId, this.mSimSlotIndex, this.mDisplayName, this.mCarrierName, this.mDisplayNameSource, this.mIconTint, this.mNumber, this.mDataRoaming, this.mMcc, this.mMnc, this.mIsEmbedded, this.mCardString, this.mIsOpportunistic, this.mGroupUuid, this.mCountryIso, this.mCarrierId, this.mProfileClass, this.mType, this.mGroupOwner, this.mAreUiccApplicationsEnabled, this.mPortIndex, this.mUsageSetting, this.mCardId, this.mIsGroupDisabled, this.mIsOnlyNonTerrestrialNetwork, this.mServiceCapabilities, this.mTransferStatus, this.mIsSatelliteESOSSupported);
        result = 31 * result + Arrays.hashCode(this.mEhplmns);
        result = 31 * result + Arrays.hashCode(this.mHplmns);
        result = 31 * result + Arrays.hashCode(this.mNativeAccessRules);
        result = 31 * result + Arrays.hashCode(this.mCarrierConfigAccessRules);
        return result;
    }

    public static class Builder {
        private int mId = -1;
        @NonNull
        private String mIccId = "";
        private int mSimSlotIndex = -1;
        @NonNull
        private CharSequence mDisplayName = "";
        @NonNull
        private CharSequence mCarrierName = "";
        private int mDisplayNameSource = -1;
        private int mIconTint = 0;
        @NonNull
        private String mNumber = "";
        private int mDataRoaming = 0;
        @Nullable
        private Bitmap mIconBitmap = null;
        @Nullable
        private String mMcc = null;
        @Nullable
        private String mMnc = null;
        @NonNull
        private String[] mEhplmns = new String[0];
        @NonNull
        private String[] mHplmns = new String[0];
        @NonNull
        private String mCountryIso = "";
        private boolean mIsEmbedded = false;
        @Nullable
        private UiccAccessRule[] mNativeAccessRules = null;
        @NonNull
        private String mCardString = "";
        private int mCardId = -2;
        private boolean mIsOpportunistic = false;
        @Nullable
        private ParcelUuid mGroupUuid = null;
        private boolean mIsGroupDisabled = false;
        private int mCarrierId = -1;
        private int mProfileClass = -1;
        private int mType = 0;
        @NonNull
        private String mGroupOwner = "";
        @Nullable
        private UiccAccessRule[] mCarrierConfigAccessRules = null;
        private boolean mAreUiccApplicationsEnabled = true;
        private int mPortIndex = -1;
        private int mUsageSetting = -1;
        private boolean mIsOnlyNonTerrestrialNetwork = false;
        private int mTransferStatus = 0;
        private int mServiceCapabilities = 0;
        private boolean mIsSatelliteESOSSupported = false;

        public Builder() {
        }

        public Builder(@NonNull SubscriptionInfo info) {
            this.mId = info.mId;
            this.mIccId = info.mIccId;
            this.mSimSlotIndex = info.mSimSlotIndex;
            this.mDisplayName = info.mDisplayName;
            this.mCarrierName = info.mCarrierName;
            this.mDisplayNameSource = info.mDisplayNameSource;
            this.mIconTint = info.mIconTint;
            this.mNumber = info.mNumber;
            this.mDataRoaming = info.mDataRoaming;
            this.mIconBitmap = info.mIconBitmap;
            this.mMcc = info.mMcc;
            this.mMnc = info.mMnc;
            this.mEhplmns = info.mEhplmns;
            this.mHplmns = info.mHplmns;
            this.mCountryIso = info.mCountryIso;
            this.mIsEmbedded = info.mIsEmbedded;
            this.mNativeAccessRules = info.mNativeAccessRules;
            this.mCardString = info.mCardString;
            this.mCardId = info.mCardId;
            this.mIsOpportunistic = info.mIsOpportunistic;
            this.mGroupUuid = info.mGroupUuid;
            this.mIsGroupDisabled = info.mIsGroupDisabled;
            this.mCarrierId = info.mCarrierId;
            this.mProfileClass = info.mProfileClass;
            this.mType = info.mType;
            this.mGroupOwner = info.mGroupOwner;
            this.mCarrierConfigAccessRules = info.mCarrierConfigAccessRules;
            this.mAreUiccApplicationsEnabled = info.mAreUiccApplicationsEnabled;
            this.mPortIndex = info.mPortIndex;
            this.mUsageSetting = info.mUsageSetting;
            this.mIsOnlyNonTerrestrialNetwork = info.mIsOnlyNonTerrestrialNetwork;
            this.mServiceCapabilities = info.mServiceCapabilities;
            this.mTransferStatus = info.mTransferStatus;
            this.mIsSatelliteESOSSupported = info.mIsSatelliteESOSSupported;
        }

        @NonNull
        public Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setIccId(@Nullable String iccId) {
            this.mIccId = TextUtils.emptyIfNull(iccId);
            return this;
        }

        @NonNull
        public Builder setSimSlotIndex(int simSlotIndex) {
            this.mSimSlotIndex = simSlotIndex;
            return this;
        }

        @NonNull
        public Builder setDisplayName(@Nullable CharSequence displayName) {
            this.mDisplayName = displayName == null ? "" : displayName;
            return this;
        }

        @NonNull
        public Builder setCarrierName(@Nullable CharSequence carrierName) {
            this.mCarrierName = carrierName == null ? "" : carrierName;
            return this;
        }

        @NonNull
        public Builder setDisplayNameSource(int displayNameSource) {
            this.mDisplayNameSource = displayNameSource;
            return this;
        }

        @NonNull
        public Builder setIconTint(int iconTint) {
            this.mIconTint = iconTint;
            return this;
        }

        @NonNull
        public Builder setNumber(@Nullable String number) {
            this.mNumber = TextUtils.emptyIfNull(number);
            return this;
        }

        @NonNull
        public Builder setDataRoaming(int dataRoaming) {
            this.mDataRoaming = dataRoaming;
            return this;
        }

        @NonNull
        public Builder setIcon(@Nullable Bitmap iconBitmap) {
            this.mIconBitmap = iconBitmap;
            return this;
        }

        @NonNull
        public Builder setMcc(@Nullable String mcc) {
            this.mMcc = mcc;
            return this;
        }

        @NonNull
        public Builder setMnc(@Nullable String mnc) {
            this.mMnc = mnc;
            return this;
        }

        @NonNull
        public Builder setEhplmns(@Nullable String[] ehplmns) {
            this.mEhplmns = ehplmns == null ? new String[]{} : ehplmns;
            return this;
        }

        @NonNull
        public Builder setHplmns(@Nullable String[] hplmns) {
            this.mHplmns = hplmns == null ? new String[]{} : hplmns;
            return this;
        }

        @NonNull
        public Builder setCountryIso(@Nullable String countryIso) {
            this.mCountryIso = TextUtils.emptyIfNull(countryIso);
            return this;
        }

        @NonNull
        public Builder setEmbedded(boolean isEmbedded) {
            this.mIsEmbedded = isEmbedded;
            return this;
        }

        @NonNull
        public Builder setNativeAccessRules(@Nullable UiccAccessRule[] nativeAccessRules) {
            this.mNativeAccessRules = nativeAccessRules;
            return this;
        }

        @NonNull
        public Builder setCardString(@Nullable String cardString) {
            this.mCardString = TextUtils.emptyIfNull(cardString);
            return this;
        }

        @NonNull
        public Builder setCardId(int cardId) {
            this.mCardId = cardId;
            return this;
        }

        @NonNull
        public Builder setOpportunistic(boolean isOpportunistic) {
            this.mIsOpportunistic = isOpportunistic;
            return this;
        }

        @NonNull
        public Builder setGroupUuid(@Nullable String groupUuid) {
            this.mGroupUuid = TextUtils.isEmpty(groupUuid) ? null : ParcelUuid.fromString(groupUuid);
            return this;
        }

        @NonNull
        public Builder setGroupDisabled(boolean isGroupDisabled) {
            this.mIsGroupDisabled = isGroupDisabled;
            return this;
        }

        @NonNull
        public Builder setCarrierId(int carrierId) {
            this.mCarrierId = carrierId;
            return this;
        }

        @NonNull
        public Builder setProfileClass(int profileClass) {
            this.mProfileClass = profileClass;
            return this;
        }

        @NonNull
        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setGroupOwner(@Nullable String groupOwner) {
            this.mGroupOwner = TextUtils.emptyIfNull(groupOwner);
            return this;
        }

        @NonNull
        public Builder setCarrierConfigAccessRules(@Nullable UiccAccessRule[] carrierConfigAccessRules) {
            this.mCarrierConfigAccessRules = carrierConfigAccessRules;
            return this;
        }

        @NonNull
        public Builder setUiccApplicationsEnabled(boolean uiccApplicationsEnabled) {
            this.mAreUiccApplicationsEnabled = uiccApplicationsEnabled;
            return this;
        }

        @NonNull
        public Builder setPortIndex(int portIndex) {
            this.mPortIndex = portIndex;
            return this;
        }

        @NonNull
        public Builder setUsageSetting(int usageSetting) {
            this.mUsageSetting = usageSetting;
            return this;
        }

        @NonNull
        public Builder setOnlyNonTerrestrialNetwork(boolean isOnlyNonTerrestrialNetwork) {
            this.mIsOnlyNonTerrestrialNetwork = isOnlyNonTerrestrialNetwork;
            return this;
        }

        @NonNull
        public Builder setServiceCapabilities(@NonNull Set<Integer> capabilities) {
            int combinedCapabilities = 0;
            for (int capability : capabilities) {
                if (capability < 1 || capability > 3) {
                    throw new IllegalArgumentException("Invalid service capability value: " + capability);
                }
                combinedCapabilities |= SubscriptionManager.serviceCapabilityToBitmask(capability);
            }
            this.mServiceCapabilities = combinedCapabilities;
            return this;
        }

        @FlaggedApi(value="com.android.internal.telephony.flags.support_psim_to_esim_conversion")
        @NonNull
        public Builder setTransferStatus(int status) {
            this.mTransferStatus = status;
            return this;
        }

        @FlaggedApi(value="com.android.internal.telephony.flags.carrier_roaming_nb_iot_ntn")
        @NonNull
        public Builder setSatelliteESOSSupported(boolean isSatelliteESOSSupported) {
            this.mIsSatelliteESOSSupported = isSatelliteESOSSupported;
            return this;
        }

        public SubscriptionInfo build() {
            return new SubscriptionInfo(this);
        }
    }
}

