/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.telephony.ServiceState;
import java.util.Arrays;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class ActivityStatsTechSpecificInfo
implements Parcelable {
    private static final int TX_POWER_LEVELS = 5;
    private int mRat;
    private int mFrequencyRange;
    private int[] mTxTimeMs;
    private int mRxTimeMs;
    @NonNull
    public static final Parcelable.Creator<ActivityStatsTechSpecificInfo> CREATOR = new Parcelable.Creator<ActivityStatsTechSpecificInfo>(){

        @Override
        public ActivityStatsTechSpecificInfo createFromParcel(@NonNull Parcel in) {
            int rat = in.readInt();
            int frequencyRange = in.readInt();
            int[] txTimeMs = new int[5];
            in.readIntArray(txTimeMs);
            int rxTimeMs = in.readInt();
            return new ActivityStatsTechSpecificInfo(rat, frequencyRange, txTimeMs, rxTimeMs);
        }

        public ActivityStatsTechSpecificInfo[] newArray(int size) {
            return new ActivityStatsTechSpecificInfo[size];
        }
    };

    public ActivityStatsTechSpecificInfo(int rat, int frequencyRange, @NonNull int[] txTimeMs, int rxTimeMs) {
        Objects.requireNonNull(txTimeMs);
        if (txTimeMs.length != 5) {
            throw new IllegalArgumentException("txTimeMs must have length == TX_POWER_LEVELS");
        }
        this.mRat = rat;
        this.mFrequencyRange = frequencyRange;
        this.mTxTimeMs = txTimeMs;
        this.mRxTimeMs = rxTimeMs;
    }

    public int getRat() {
        return this.mRat;
    }

    public int getFrequencyRange() {
        return this.mFrequencyRange;
    }

    public long getTransmitTimeMillis(int powerLevel) {
        return this.mTxTimeMs[powerLevel];
    }

    @NonNull
    public int[] getTransmitTimeMillis() {
        return this.mTxTimeMs;
    }

    public long getReceiveTimeMillis() {
        return this.mRxTimeMs;
    }

    public void setRat(int rat) {
        this.mRat = rat;
    }

    public void setFrequencyRange(int frequencyRange) {
        this.mFrequencyRange = frequencyRange;
    }

    public void setReceiveTimeMillis(int receiveTimeMillis) {
        this.mRxTimeMs = receiveTimeMillis;
    }

    public void setReceiveTimeMillis(long receiveTimeMillis) {
        this.mRxTimeMs = (int)receiveTimeMillis;
    }

    public void setTransmitTimeMillis(int[] txTimeMs) {
        this.mTxTimeMs = Arrays.copyOf(txTimeMs, 5);
    }

    public boolean isTxPowerValid() {
        return Arrays.stream(this.mTxTimeMs).allMatch(i -> i >= 0);
    }

    public boolean isRxPowerValid() {
        return this.getReceiveTimeMillis() >= 0L;
    }

    public boolean isTxPowerEmpty() {
        boolean isTxPowerEmpty = this.mTxTimeMs == null || this.mTxTimeMs.length == 0 || Arrays.stream(this.mTxTimeMs).allMatch(i -> i == 0);
        return isTxPowerEmpty;
    }

    public boolean isRxPowerEmpty() {
        return this.getReceiveTimeMillis() == 0L;
    }

    public int hashCode() {
        int result = Objects.hash(this.mRat, this.mFrequencyRange, this.mRxTimeMs);
        result = 31 * result + Arrays.hashCode(this.mTxTimeMs);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityStatsTechSpecificInfo)) {
            return false;
        }
        ActivityStatsTechSpecificInfo that = (ActivityStatsTechSpecificInfo)o;
        return this.mRat == that.mRat && this.mFrequencyRange == that.mFrequencyRange && Arrays.equals(this.mTxTimeMs, that.mTxTimeMs) && this.mRxTimeMs == that.mRxTimeMs;
    }

    private static String ratToString(int type) {
        switch (type) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "GERAN";
            }
            case 2: {
                return "UTRAN";
            }
            case 3: {
                return "EUTRAN";
            }
            case 4: {
                return "CDMA2000";
            }
            case 5: {
                return "IWLAN";
            }
            case 6: {
                return "NGRAN";
            }
        }
        return Integer.toString(type);
    }

    public String toString() {
        return "{mRat=" + ActivityStatsTechSpecificInfo.ratToString(this.mRat) + ",mFrequencyRange=" + ServiceState.frequencyRangeToString(this.mFrequencyRange) + ",mTxTimeMs[]=" + Arrays.toString(this.mTxTimeMs) + ",mRxTimeMs=" + this.mRxTimeMs + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRat);
        dest.writeInt(this.mFrequencyRange);
        dest.writeIntArray(this.mTxTimeMs);
        dest.writeInt(this.mRxTimeMs);
    }
}

