/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class VideoProfile
implements Parcelable {
    public static final int QUALITY_UNKNOWN = 0;
    public static final int QUALITY_HIGH = 1;
    public static final int QUALITY_MEDIUM = 2;
    public static final int QUALITY_LOW = 3;
    public static final int QUALITY_DEFAULT = 4;
    public static final int STATE_AUDIO_ONLY = 0;
    public static final int STATE_TX_ENABLED = 1;
    public static final int STATE_RX_ENABLED = 2;
    public static final int STATE_BIDIRECTIONAL = 3;
    public static final int STATE_PAUSED = 4;
    private final int mVideoState;
    private final int mQuality;
    @NonNull
    public static final Parcelable.Creator<VideoProfile> CREATOR = new Parcelable.Creator<VideoProfile>(){

        @Override
        public VideoProfile createFromParcel(Parcel source) {
            int state = source.readInt();
            int quality = source.readInt();
            ClassLoader classLoader = VideoProfile.class.getClassLoader();
            return new VideoProfile(state, quality);
        }

        public VideoProfile[] newArray(int size) {
            return new VideoProfile[size];
        }
    };

    public VideoProfile(int videoState) {
        this(videoState, 4);
    }

    public VideoProfile(int videoState, int quality) {
        this.mVideoState = videoState;
        this.mQuality = quality;
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    public int getQuality() {
        return this.mQuality;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mVideoState);
        dest.writeInt(this.mQuality);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[VideoProfile videoState = ");
        sb.append(VideoProfile.videoStateToString(this.mVideoState));
        sb.append(" videoQuality = ");
        sb.append(this.mQuality);
        sb.append("]");
        return sb.toString();
    }

    public static String videoStateToString(int videoState) {
        StringBuilder sb = new StringBuilder();
        sb.append("Audio");
        if (videoState == 0) {
            sb.append(" Only");
        } else {
            if (VideoProfile.isTransmissionEnabled(videoState)) {
                sb.append(" Tx");
            }
            if (VideoProfile.isReceptionEnabled(videoState)) {
                sb.append(" Rx");
            }
            if (VideoProfile.isPaused(videoState)) {
                sb.append(" Pause");
            }
        }
        return sb.toString();
    }

    public static boolean isAudioOnly(int videoState) {
        return !VideoProfile.hasState(videoState, 1) && !VideoProfile.hasState(videoState, 2);
    }

    public static boolean isVideo(int videoState) {
        return VideoProfile.hasState(videoState, 1) || VideoProfile.hasState(videoState, 2) || VideoProfile.hasState(videoState, 3);
    }

    public static boolean isTransmissionEnabled(int videoState) {
        return VideoProfile.hasState(videoState, 1);
    }

    public static boolean isReceptionEnabled(int videoState) {
        return VideoProfile.hasState(videoState, 2);
    }

    public static boolean isBidirectional(int videoState) {
        return VideoProfile.hasState(videoState, 3);
    }

    public static boolean isPaused(int videoState) {
        return VideoProfile.hasState(videoState, 4);
    }

    private static boolean hasState(int videoState, int state) {
        return (videoState & state) == state;
    }

    public static class CameraCapabilities
    implements Parcelable {
        private final int mWidth;
        private final int mHeight;
        private final boolean mZoomSupported;
        private final float mMaxZoom;
        @NonNull
        public static final Parcelable.Creator<CameraCapabilities> CREATOR = new Parcelable.Creator<CameraCapabilities>(){

            @Override
            public CameraCapabilities createFromParcel(Parcel source) {
                int width = source.readInt();
                int height = source.readInt();
                boolean supportsZoom = source.readByte() != 0;
                float maxZoom = source.readFloat();
                return new CameraCapabilities(width, height, supportsZoom, maxZoom);
            }

            public CameraCapabilities[] newArray(int size) {
                return new CameraCapabilities[size];
            }
        };

        public CameraCapabilities(int width, int height) {
            this(width, height, false, 1.0f);
        }

        public CameraCapabilities(int width, int height, boolean zoomSupported, float maxZoom) {
            this.mWidth = width;
            this.mHeight = height;
            this.mZoomSupported = zoomSupported;
            this.mMaxZoom = maxZoom;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.getWidth());
            dest.writeInt(this.getHeight());
            dest.writeByte((byte)(this.isZoomSupported() ? 1 : 0));
            dest.writeFloat(this.getMaxZoom());
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public boolean isZoomSupported() {
            return this.mZoomSupported;
        }

        public float getMaxZoom() {
            return this.mMaxZoom;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoQuality {
    }
}

