/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class CallAttributes
implements Parcelable {
    private final PhoneAccountHandle mPhoneAccountHandle;
    private final CharSequence mDisplayName;
    private final Uri mAddress;
    private final int mDirection;
    private final int mCallType;
    private final int mCallCapabilities;
    public static final String CALL_CAPABILITIES_KEY = "TelecomCapabilities";
    public static final String DISPLAY_NAME_KEY = "DisplayName";
    public static final String CALLER_PID_KEY = "CallerPid";
    public static final String CALLER_UID_KEY = "CallerUid";
    public static final int DIRECTION_INCOMING = 1;
    public static final int DIRECTION_OUTGOING = 2;
    public static final int AUDIO_CALL = 1;
    public static final int VIDEO_CALL = 2;
    public static final int SUPPORTS_SET_INACTIVE = 2;
    public static final int SUPPORTS_STREAM = 4;
    public static final int SUPPORTS_TRANSFER = 8;
    @FlaggedApi(value="com.android.server.telecom.flags.transactional_video_state")
    public static final int SUPPORTS_VIDEO_CALLING = 16;
    @NonNull
    public static final Parcelable.Creator<CallAttributes> CREATOR = new Parcelable.Creator<CallAttributes>(){

        @Override
        public CallAttributes createFromParcel(Parcel source) {
            return new CallAttributes(source.readParcelable(this.getClass().getClassLoader(), PhoneAccountHandle.class), source.readCharSequence(), source.readParcelable(this.getClass().getClassLoader(), Uri.class), source.readInt(), source.readInt(), source.readInt());
        }

        public CallAttributes[] newArray(int size) {
            return new CallAttributes[size];
        }
    };

    private CallAttributes(@NonNull PhoneAccountHandle phoneAccountHandle, @NonNull CharSequence displayName, @NonNull Uri address, int direction, int callType, int callCapabilities) {
        this.mPhoneAccountHandle = phoneAccountHandle;
        this.mDisplayName = displayName;
        this.mAddress = address;
        this.mDirection = direction;
        this.mCallType = callType;
        this.mCallCapabilities = callCapabilities;
    }

    @NonNull
    public PhoneAccountHandle getPhoneAccountHandle() {
        return this.mPhoneAccountHandle;
    }

    @NonNull
    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    @NonNull
    public Uri getAddress() {
        return this.mAddress;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getCallType() {
        return this.mCallType;
    }

    public int getCallCapabilities() {
        return this.mCallCapabilities;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@Nullable Parcel dest, int flags) {
        dest.writeParcelable(this.mPhoneAccountHandle, flags);
        dest.writeCharSequence(this.mDisplayName);
        dest.writeParcelable(this.mAddress, flags);
        dest.writeInt(this.mDirection);
        dest.writeInt(this.mCallType);
        dest.writeInt(this.mCallCapabilities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ CallAttributes: [phoneAccountHandle: ").append(this.mPhoneAccountHandle).append("], [contactName: ").append(Log.pii(this.mDisplayName)).append("], [address=").append(Log.pii(this.mAddress)).append("], [direction=").append(this.mDirection).append("], [callType=").append(this.mCallType).append("], [mCallCapabilities=").append(this.mCallCapabilities).append("]  }");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CallAttributes that = (CallAttributes)obj;
        return this.mDirection == that.mDirection && this.mCallType == that.mCallType && this.mCallCapabilities == that.mCallCapabilities && Objects.equals(this.mPhoneAccountHandle, that.mPhoneAccountHandle) && Objects.equals(this.mAddress, that.mAddress) && Objects.equals(this.mDisplayName, that.mDisplayName);
    }

    public int hashCode() {
        return Objects.hash(this.mPhoneAccountHandle, this.mAddress, this.mDisplayName, this.mDirection, this.mCallType, this.mCallCapabilities);
    }

    public static class Builder {
        private final PhoneAccountHandle mPhoneAccountHandle;
        private final int mDirection;
        private final CharSequence mDisplayName;
        private final Uri mAddress;
        private int mCallType = 1;
        private int mCallCapabilities = 2;

        public Builder(@NonNull PhoneAccountHandle phoneAccountHandle, int callDirection, @NonNull CharSequence displayName, @NonNull Uri address) {
            if (!this.isInRange(1, 2, callDirection)) {
                throw new IllegalArgumentException(TextUtils.formatSimple("CallDirection=[%d] is invalid. CallDirections value should be within [%d, %d]", callDirection, 1, 2));
            }
            Objects.requireNonNull(phoneAccountHandle);
            Objects.requireNonNull(displayName);
            Objects.requireNonNull(address);
            this.mPhoneAccountHandle = phoneAccountHandle;
            this.mDirection = callDirection;
            this.mDisplayName = displayName;
            this.mAddress = address;
        }

        @NonNull
        public Builder setCallType(int callType) {
            if (!this.isInRange(1, 2, callType)) {
                throw new IllegalArgumentException(TextUtils.formatSimple("CallType=[%d] is invalid. CallTypes value should be within [%d, %d]", callType, 1, 2));
            }
            this.mCallType = callType;
            return this;
        }

        @NonNull
        public Builder setCallCapabilities(int callCapabilities) {
            this.mCallCapabilities = callCapabilities;
            return this;
        }

        @NonNull
        public CallAttributes build() {
            return new CallAttributes(this.mPhoneAccountHandle, this.mDisplayName, this.mAddress, this.mDirection, this.mCallType, this.mCallCapabilities);
        }

        private boolean isInRange(int floor, int ceiling, int value) {
            return value >= floor && value <= ceiling;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallCapability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

