/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.voice.VoiceInteractionSession;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class VisibleActivityInfo
implements Parcelable {
    public static final int TYPE_ACTIVITY_ADDED = 1;
    public static final int TYPE_ACTIVITY_REMOVED = 2;
    private final int mTaskId;
    @NonNull
    private final IBinder mAssistToken;
    @NonNull
    public static final Parcelable.Creator<VisibleActivityInfo> CREATOR = new Parcelable.Creator<VisibleActivityInfo>(){

        public VisibleActivityInfo[] newArray(int size) {
            return new VisibleActivityInfo[size];
        }

        @Override
        public VisibleActivityInfo createFromParcel(@NonNull Parcel in) {
            return new VisibleActivityInfo(in);
        }
    };

    public VisibleActivityInfo(int taskId, @NonNull IBinder assistToken) {
        Objects.requireNonNull(assistToken);
        this.mTaskId = taskId;
        this.mAssistToken = assistToken;
    }

    @NonNull
    public VoiceInteractionSession.ActivityId getActivityId() {
        return new VoiceInteractionSession.ActivityId(this.mTaskId, this.mAssistToken);
    }

    public String toString() {
        return "VisibleActivityInfo { taskId = " + this.mTaskId + ", assistToken = " + this.mAssistToken + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisibleActivityInfo that = (VisibleActivityInfo)o;
        return this.mTaskId == that.mTaskId && Objects.equals(this.mAssistToken, that.mAssistToken);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mTaskId;
        _hash = 31 * _hash + Objects.hashCode(this.mAssistToken);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mTaskId);
        dest.writeStrongBinder(this.mAssistToken);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    VisibleActivityInfo(@NonNull Parcel in) {
        int taskId = in.readInt();
        IBinder assistToken = in.readStrongBinder();
        this.mTaskId = taskId;
        this.mAssistToken = assistToken;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAssistToken);
    }

    @Deprecated
    private void __metadata() {
    }
}

