/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class NotificationStats
implements Parcelable {
    private boolean mSeen;
    private boolean mExpanded;
    private boolean mDirectReplied;
    private boolean mSmartReplied;
    private boolean mSnoozed;
    private boolean mViewedSettings;
    private boolean mInteracted;
    private int mDismissalSurface = -1;
    public static final int DISMISSAL_NOT_DISMISSED = -1;
    public static final int DISMISSAL_OTHER = 0;
    public static final int DISMISSAL_PEEK = 1;
    public static final int DISMISSAL_AOD = 2;
    public static final int DISMISSAL_SHADE = 3;
    public static final int DISMISSAL_BUBBLE = 4;
    public static final int DISMISSAL_LOCKSCREEN = 5;
    public static final int DISMISS_SENTIMENT_UNKNOWN = -1000;
    public static final int DISMISS_SENTIMENT_NEGATIVE = 0;
    public static final int DISMISS_SENTIMENT_NEUTRAL = 1;
    public static final int DISMISS_SENTIMENT_POSITIVE = 2;
    private int mDismissalSentiment = -1000;
    @NonNull
    public static final Parcelable.Creator<NotificationStats> CREATOR = new Parcelable.Creator<NotificationStats>(){

        @Override
        public NotificationStats createFromParcel(Parcel in) {
            return new NotificationStats(in);
        }

        public NotificationStats[] newArray(int size) {
            return new NotificationStats[size];
        }
    };

    public NotificationStats() {
    }

    @SystemApi
    protected NotificationStats(Parcel in) {
        this.mSeen = in.readByte() != 0;
        this.mExpanded = in.readByte() != 0;
        boolean bl = this.mDirectReplied = in.readByte() != 0;
        if (Flags.lifetimeExtensionRefactor()) {
            this.mSmartReplied = in.readByte() != 0;
        }
        this.mSnoozed = in.readByte() != 0;
        this.mViewedSettings = in.readByte() != 0;
        this.mInteracted = in.readByte() != 0;
        this.mDismissalSurface = in.readInt();
        this.mDismissalSentiment = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mSeen ? 1 : 0));
        dest.writeByte((byte)(this.mExpanded ? 1 : 0));
        dest.writeByte((byte)(this.mDirectReplied ? 1 : 0));
        if (Flags.lifetimeExtensionRefactor()) {
            dest.writeByte((byte)(this.mSmartReplied ? 1 : 0));
        }
        dest.writeByte((byte)(this.mSnoozed ? 1 : 0));
        dest.writeByte((byte)(this.mViewedSettings ? 1 : 0));
        dest.writeByte((byte)(this.mInteracted ? 1 : 0));
        dest.writeInt(this.mDismissalSurface);
        dest.writeInt(this.mDismissalSentiment);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean hasSeen() {
        return this.mSeen;
    }

    public void setSeen() {
        this.mSeen = true;
    }

    public boolean hasExpanded() {
        return this.mExpanded;
    }

    public void setExpanded() {
        this.mExpanded = true;
        this.mInteracted = true;
    }

    public boolean hasDirectReplied() {
        return this.mDirectReplied;
    }

    public void setDirectReplied() {
        this.mDirectReplied = true;
        this.mInteracted = true;
    }

    @FlaggedApi(value="android.app.lifetime_extension_refactor")
    public boolean hasSmartReplied() {
        return this.mSmartReplied;
    }

    @SuppressLint(value={"GetterSetterNames"})
    @FlaggedApi(value="android.app.lifetime_extension_refactor")
    public void setSmartReplied() {
        this.mSmartReplied = true;
        this.mInteracted = true;
    }

    public boolean hasSnoozed() {
        return this.mSnoozed;
    }

    public void setSnoozed() {
        this.mSnoozed = true;
        this.mInteracted = true;
    }

    public boolean hasViewedSettings() {
        return this.mViewedSettings;
    }

    public void setViewedSettings() {
        this.mViewedSettings = true;
        this.mInteracted = true;
    }

    public boolean hasInteracted() {
        return this.mInteracted;
    }

    public int getDismissalSurface() {
        return this.mDismissalSurface;
    }

    public void setDismissalSurface(int dismissalSurface) {
        this.mDismissalSurface = dismissalSurface;
    }

    public void setDismissalSentiment(int dismissalSentiment) {
        this.mDismissalSentiment = dismissalSentiment;
    }

    public int getDismissalSentiment() {
        return this.mDismissalSentiment;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationStats that = (NotificationStats)o;
        if (this.mSeen != that.mSeen) {
            return false;
        }
        if (this.mExpanded != that.mExpanded) {
            return false;
        }
        if (this.mDirectReplied != that.mDirectReplied) {
            return false;
        }
        if (Flags.lifetimeExtensionRefactor() && this.mSmartReplied != that.mSmartReplied) {
            return false;
        }
        if (this.mSnoozed != that.mSnoozed) {
            return false;
        }
        if (this.mViewedSettings != that.mViewedSettings) {
            return false;
        }
        if (this.mInteracted != that.mInteracted) {
            return false;
        }
        return this.mDismissalSurface == that.mDismissalSurface;
    }

    public int hashCode() {
        int result = this.mSeen ? 1 : 0;
        result = 31 * result + (this.mExpanded ? 1 : 0);
        result = 31 * result + (this.mDirectReplied ? 1 : 0);
        if (Flags.lifetimeExtensionRefactor()) {
            result = 31 * result + (this.mSmartReplied ? 1 : 0);
        }
        result = 31 * result + (this.mSnoozed ? 1 : 0);
        result = 31 * result + (this.mViewedSettings ? 1 : 0);
        result = 31 * result + (this.mInteracted ? 1 : 0);
        result = 31 * result + this.mDismissalSurface;
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("NotificationStats{");
        sb.append("mSeen=").append(this.mSeen);
        sb.append(", mExpanded=").append(this.mExpanded);
        sb.append(", mDirectReplied=").append(this.mDirectReplied);
        if (Flags.lifetimeExtensionRefactor()) {
            sb.append(", mSmartReplied=").append(this.mSmartReplied);
        }
        sb.append(", mSnoozed=").append(this.mSnoozed);
        sb.append(", mViewedSettings=").append(this.mViewedSettings);
        sb.append(", mInteracted=").append(this.mInteracted);
        sb.append(", mDismissalSurface=").append(this.mDismissalSurface);
        sb.append('}');
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DismissalSentiment {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DismissalSurface {
    }
}

