/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class KeyDerivationParams
implements Parcelable {
    private final int mAlgorithm;
    private final byte[] mSalt;
    private final int mMemoryDifficulty;
    public static final int ALGORITHM_SHA256 = 1;
    public static final int ALGORITHM_SCRYPT = 2;
    @NonNull
    public static final Parcelable.Creator<KeyDerivationParams> CREATOR = new Parcelable.Creator<KeyDerivationParams>(){

        @Override
        public KeyDerivationParams createFromParcel(Parcel in) {
            return new KeyDerivationParams(in);
        }

        public KeyDerivationParams[] newArray(int length) {
            return new KeyDerivationParams[length];
        }
    };

    @NonNull
    public static KeyDerivationParams createSha256Params(@NonNull byte[] salt) {
        return new KeyDerivationParams(1, salt);
    }

    @NonNull
    public static KeyDerivationParams createScryptParams(@NonNull byte[] salt, int memoryDifficulty) {
        return new KeyDerivationParams(2, salt, memoryDifficulty);
    }

    private KeyDerivationParams(int algorithm, @NonNull byte[] salt) {
        this(algorithm, salt, -1);
    }

    private KeyDerivationParams(int algorithm, @NonNull byte[] salt, int memoryDifficulty) {
        this.mAlgorithm = algorithm;
        this.mSalt = Objects.requireNonNull(salt);
        this.mMemoryDifficulty = memoryDifficulty;
    }

    public int getAlgorithm() {
        return this.mAlgorithm;
    }

    @NonNull
    public byte[] getSalt() {
        return this.mSalt;
    }

    public int getMemoryDifficulty() {
        return this.mMemoryDifficulty;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mAlgorithm);
        out.writeByteArray(this.mSalt);
        out.writeInt(this.mMemoryDifficulty);
    }

    protected KeyDerivationParams(Parcel in) {
        this.mAlgorithm = in.readInt();
        this.mSalt = in.createByteArray();
        this.mMemoryDifficulty = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyDerivationAlgorithm {
    }
}

