/*
 * Decompiled with CFR 0.152.
 */
package android.security.advancedprotection;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.security.advancedprotection.AdvancedProtectionFeature;
import android.security.advancedprotection.IAdvancedProtectionCallback;
import java.util.ArrayList;
import java.util.List;

public interface IAdvancedProtectionService
extends IInterface {
    public static final String DESCRIPTOR = "android.security.advancedprotection.IAdvancedProtectionService";

    @EnforcePermission(value="android.permission.QUERY_ADVANCED_PROTECTION_MODE")
    public boolean isAdvancedProtectionEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_ADVANCED_PROTECTION_MODE")
    public void registerAdvancedProtectionCallback(IAdvancedProtectionCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_ADVANCED_PROTECTION_MODE")
    public void unregisterAdvancedProtectionCallback(IAdvancedProtectionCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ADVANCED_PROTECTION_MODE")
    public void setAdvancedProtectionEnabled(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ADVANCED_PROTECTION_MODE")
    public List<AdvancedProtectionFeature> getAdvancedProtectionFeatures() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ADVANCED_PROTECTION_MODE")
    public void logDialogShown(int var1, int var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAdvancedProtectionService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_isAdvancedProtectionEnabled = 1;
        static final int TRANSACTION_registerAdvancedProtectionCallback = 2;
        static final int TRANSACTION_unregisterAdvancedProtectionCallback = 3;
        static final int TRANSACTION_setAdvancedProtectionEnabled = 4;
        static final int TRANSACTION_getAdvancedProtectionFeatures = 5;
        static final int TRANSACTION_logDialogShown = 6;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IAdvancedProtectionService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IAdvancedProtectionService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAdvancedProtectionService.DESCRIPTOR);
            if (iin != null && iin instanceof IAdvancedProtectionService) {
                return (IAdvancedProtectionService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isAdvancedProtectionEnabled";
                }
                case 2: {
                    return "registerAdvancedProtectionCallback";
                }
                case 3: {
                    return "unregisterAdvancedProtectionCallback";
                }
                case 4: {
                    return "setAdvancedProtectionEnabled";
                }
                case 5: {
                    return "getAdvancedProtectionFeatures";
                }
                case 6: {
                    return "logDialogShown";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAdvancedProtectionService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _result = this.isAdvancedProtectionEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    IAdvancedProtectionCallback _arg0 = IAdvancedProtectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAdvancedProtectionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IAdvancedProtectionCallback _arg0 = IAdvancedProtectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAdvancedProtectionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAdvancedProtectionEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    List<AdvancedProtectionFeature> _result = this.getAdvancedProtectionFeatures();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.logDialogShown(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void isAdvancedProtectionEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_ADVANCED_PROTECTION_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerAdvancedProtectionCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_ADVANCED_PROTECTION_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterAdvancedProtectionCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_ADVANCED_PROTECTION_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setAdvancedProtectionEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ADVANCED_PROTECTION_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAdvancedProtectionFeatures_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ADVANCED_PROTECTION_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void logDialogShown_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ADVANCED_PROTECTION_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IAdvancedProtectionService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAdvancedProtectionService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAdvancedProtectionEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedProtectionService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAdvancedProtectionCallback(IAdvancedProtectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedProtectionService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAdvancedProtectionCallback(IAdvancedProtectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedProtectionService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdvancedProtectionEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedProtectionService.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AdvancedProtectionFeature> getAdvancedProtectionFeatures() throws RemoteException {
                ArrayList<AdvancedProtectionFeature> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedProtectionService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AdvancedProtectionFeature.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logDialogShown(int featureId, int type, boolean learnMoreClicked) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAdvancedProtectionService.DESCRIPTOR);
                    _data.writeInt(featureId);
                    _data.writeInt(type);
                    _data.writeBoolean(learnMoreClicked);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAdvancedProtectionService {
        @Override
        public boolean isAdvancedProtectionEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void registerAdvancedProtectionCallback(IAdvancedProtectionCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterAdvancedProtectionCallback(IAdvancedProtectionCallback callback) throws RemoteException {
        }

        @Override
        public void setAdvancedProtectionEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public List<AdvancedProtectionFeature> getAdvancedProtectionFeatures() throws RemoteException {
            return null;
        }

        @Override
        public void logDialogShown(int featureId, int type, boolean learnMoreClicked) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

