/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.annotation.NonNull;
import android.annotation.Nullable;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AttestedKeyPair {
    private final KeyPair mKeyPair;
    private final List<Certificate> mAttestationRecord;

    public AttestedKeyPair(@Nullable KeyPair keyPair, @NonNull List<Certificate> attestationRecord) {
        this.mKeyPair = keyPair;
        this.mAttestationRecord = attestationRecord;
    }

    public AttestedKeyPair(@Nullable KeyPair keyPair, @Nullable Certificate[] attestationRecord) {
        this.mKeyPair = keyPair;
        this.mAttestationRecord = attestationRecord == null ? new ArrayList<Certificate>() : Arrays.asList(attestationRecord);
    }

    @Nullable
    public KeyPair getKeyPair() {
        return this.mKeyPair;
    }

    @NonNull
    public List<Certificate> getAttestationRecord() {
        return Collections.unmodifiableList(this.mAttestationRecord);
    }
}

