/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;

@RequiresApi(value=33)
class BuilderUtils {
    private BuilderUtils() {
    }

    private static void validateAttribute(@Nullable Object attribute, @NonNull String name, boolean required, boolean prohibited, @Nullable Object defaultValue) {
        boolean checkProhibited;
        if (attribute == null && required) {
            BuilderUtils.throwRequiredAttributeMissing(name);
        }
        boolean nonDefaultValueProvided = !Objects.equals(attribute, defaultValue);
        boolean bl = checkProhibited = prohibited && nonDefaultValueProvided;
        if (attribute != null && checkProhibited) {
            BuilderUtils.throwProhibitedAttributePresent(name);
        }
    }

    static void validateAttribute(@Nullable Object attribute, @NonNull String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(attribute, name, required, prohibited, null);
    }

    static void validateId(@Nullable String id2, @NonNull String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(id2, name, required, prohibited, null);
        if (!Pattern.compile("[0-9a-zA-Z_]+").matcher(id2).matches()) {
            throw new IllegalStateException("Attribute " + name + " invalid");
        }
    }

    static int validateResId(@Nullable Integer value, @NonNull String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, 0);
        if (value == null) {
            return 0;
        }
        if (required && value == 0) {
            BuilderUtils.throwRequiredAttributeInvalid(name);
        }
        return value;
    }

    static int validateIntDef(@Nullable Integer value, @NonNull String name, boolean required, boolean prohibited, int defaultValue, int ... validValues) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        boolean found = false;
        for (int i = 0; i < validValues.length; ++i) {
            found |= value == validValues[i];
        }
        if (!found) {
            throw new IllegalStateException("Attribute " + name + " invalid");
        }
        return value;
    }

    static int validateInteger(@Nullable Integer value, @NonNull String name, boolean required, boolean prohibited, int defaultValue) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    static boolean validateBoolean(@Nullable Boolean value, @NonNull String name, boolean required, boolean prohibited, boolean defaultValue) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    static <T> void validateCollection(@NonNull Collection<T> value, @NonNull String name, boolean required, boolean prohibited) {
        if (value.isEmpty() && required) {
            BuilderUtils.throwRequiredAttributeMissing(name);
        }
        if (!value.isEmpty() && prohibited) {
            BuilderUtils.throwProhibitedAttributePresent(name);
        }
    }

    static void throwRequiredAttributeMissing(@NonNull String attribute) {
        throw new IllegalStateException("Required attribute " + attribute + " missing");
    }

    static void throwProhibitedAttributePresent(@NonNull String attribute) {
        throw new IllegalStateException("Prohibited attribute " + attribute + " present");
    }

    static void throwRequiredAttributeInvalid(@NonNull String attribute) {
        throw new IllegalStateException("Required attribute " + attribute + " invalid");
    }
}

