/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.safetycenter.SafetyCenterEntryOrGroup;
import android.safetycenter.SafetyCenterIssue;
import android.safetycenter.SafetyCenterStaticEntryGroup;
import android.safetycenter.SafetyCenterStatus;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterData
implements Parcelable {
    private static final String ISSUES_TO_GROUPS_BUNDLE_KEY = "IssuesToGroups";
    private static final String STATIC_ENTRIES_TO_IDS_BUNDLE_KEY = "StaticEntriesToIds";
    @NonNull
    public static final Parcelable.Creator<SafetyCenterData> CREATOR = new Parcelable.Creator<SafetyCenterData>(){

        @Override
        public SafetyCenterData createFromParcel(Parcel in) {
            SafetyCenterStatus status = in.readTypedObject(SafetyCenterStatus.CREATOR);
            ArrayList<SafetyCenterIssue> issues = in.createTypedArrayList(SafetyCenterIssue.CREATOR);
            ArrayList<SafetyCenterEntryOrGroup> entryOrGroups = in.createTypedArrayList(SafetyCenterEntryOrGroup.CREATOR);
            ArrayList<SafetyCenterStaticEntryGroup> staticEntryGroups = in.createTypedArrayList(SafetyCenterStaticEntryGroup.CREATOR);
            if (SdkLevel.isAtLeastU()) {
                int i;
                ArrayList<SafetyCenterIssue> dismissedIssues = in.createTypedArrayList(SafetyCenterIssue.CREATOR);
                Bundle extras = in.readBundle(this.getClass().getClassLoader());
                Builder builder = new Builder(status);
                for (i = 0; i < issues.size(); ++i) {
                    builder.addIssue((SafetyCenterIssue)issues.get(i));
                }
                for (i = 0; i < entryOrGroups.size(); ++i) {
                    builder.addEntryOrGroup((SafetyCenterEntryOrGroup)entryOrGroups.get(i));
                }
                for (i = 0; i < staticEntryGroups.size(); ++i) {
                    builder.addStaticEntryGroup((SafetyCenterStaticEntryGroup)staticEntryGroups.get(i));
                }
                for (i = 0; i < dismissedIssues.size(); ++i) {
                    builder.addDismissedIssue((SafetyCenterIssue)dismissedIssues.get(i));
                }
                if (extras != null) {
                    builder.setExtras(extras);
                }
                return builder.build();
            }
            return new SafetyCenterData(status, issues, entryOrGroups, staticEntryGroups);
        }

        public SafetyCenterData[] newArray(int size) {
            return new SafetyCenterData[size];
        }
    };
    @NonNull
    private final SafetyCenterStatus mStatus;
    @NonNull
    private final List<SafetyCenterIssue> mIssues;
    @NonNull
    private final List<SafetyCenterEntryOrGroup> mEntriesOrGroups;
    @NonNull
    private final List<SafetyCenterStaticEntryGroup> mStaticEntryGroups;
    @NonNull
    private final List<SafetyCenterIssue> mDismissedIssues;
    @NonNull
    private final Bundle mExtras;

    public SafetyCenterData(@NonNull SafetyCenterStatus status, @NonNull List<SafetyCenterIssue> issues, @NonNull List<SafetyCenterEntryOrGroup> entriesOrGroups, @NonNull List<SafetyCenterStaticEntryGroup> staticEntryGroups) {
        this.mStatus = Objects.requireNonNull(status);
        this.mIssues = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(issues)));
        this.mEntriesOrGroups = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(entriesOrGroups)));
        this.mStaticEntryGroups = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(staticEntryGroups)));
        this.mDismissedIssues = Collections.unmodifiableList(new ArrayList());
        this.mExtras = Bundle.EMPTY;
    }

    private SafetyCenterData(@NonNull SafetyCenterStatus status, @NonNull List<SafetyCenterIssue> issues, @NonNull List<SafetyCenterEntryOrGroup> entriesOrGroups, @NonNull List<SafetyCenterStaticEntryGroup> staticEntryGroups, @NonNull List<SafetyCenterIssue> dismissedIssues, @NonNull Bundle extras) {
        this.mStatus = status;
        this.mIssues = issues;
        this.mEntriesOrGroups = entriesOrGroups;
        this.mStaticEntryGroups = staticEntryGroups;
        this.mDismissedIssues = dismissedIssues;
        this.mExtras = extras;
    }

    @NonNull
    public SafetyCenterStatus getStatus() {
        return this.mStatus;
    }

    @NonNull
    public List<SafetyCenterIssue> getIssues() {
        return this.mIssues;
    }

    @NonNull
    public List<SafetyCenterEntryOrGroup> getEntriesOrGroups() {
        return this.mEntriesOrGroups;
    }

    @NonNull
    public List<SafetyCenterStaticEntryGroup> getStaticEntryGroups() {
        return this.mStaticEntryGroups;
    }

    @NonNull
    @RequiresApi(value=34)
    public List<SafetyCenterIssue> getDismissedIssues() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mDismissedIssues;
    }

    @NonNull
    @RequiresApi(value=34)
    public Bundle getExtras() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mExtras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterData)) {
            return false;
        }
        SafetyCenterData that = (SafetyCenterData)o;
        return Objects.equals(this.mStatus, that.mStatus) && Objects.equals(this.mIssues, that.mIssues) && Objects.equals(this.mEntriesOrGroups, that.mEntriesOrGroups) && Objects.equals(this.mStaticEntryGroups, that.mStaticEntryGroups) && Objects.equals(this.mDismissedIssues, that.mDismissedIssues) && SafetyCenterData.areKnownExtrasContentsEqual(this.mExtras, that.mExtras);
    }

    private static boolean areKnownExtrasContentsEqual(@NonNull Bundle left, @NonNull Bundle right) {
        return SafetyCenterData.areBundlesEqual(left, right, ISSUES_TO_GROUPS_BUNDLE_KEY) && SafetyCenterData.areBundlesEqual(left, right, STATIC_ENTRIES_TO_IDS_BUNDLE_KEY);
    }

    private static boolean areBundlesEqual(@NonNull Bundle left, @NonNull Bundle right, @NonNull String bundleKey) {
        Set<String> rightKeys;
        Bundle leftBundle = left.getBundle(bundleKey);
        Bundle rightBundle = right.getBundle(bundleKey);
        if (leftBundle == null && rightBundle == null) {
            return true;
        }
        if (leftBundle == null || rightBundle == null) {
            return false;
        }
        Set<String> leftKeys = leftBundle.keySet();
        if (!Objects.equals(leftKeys, rightKeys = rightBundle.keySet())) {
            return false;
        }
        for (String key : leftKeys) {
            if (Objects.equals(SafetyCenterData.getBundleValue(leftBundle, bundleKey, key), SafetyCenterData.getBundleValue(rightBundle, bundleKey, key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mIssues, this.mEntriesOrGroups, this.mStaticEntryGroups, this.mDismissedIssues, this.getExtrasHash());
    }

    private int getExtrasHash() {
        return Objects.hash(this.bundleHash(ISSUES_TO_GROUPS_BUNDLE_KEY), this.bundleHash(STATIC_ENTRIES_TO_IDS_BUNDLE_KEY));
    }

    private int bundleHash(@NonNull String bundleKey) {
        Bundle bundle = this.mExtras.getBundle(bundleKey);
        if (bundle == null) {
            return 0;
        }
        int hash = 0;
        for (String key : bundle.keySet()) {
            hash += Objects.hashCode(key) ^ Objects.hashCode(SafetyCenterData.getBundleValue(bundle, bundleKey, key));
        }
        return hash;
    }

    public String toString() {
        return "SafetyCenterData{mStatus=" + this.mStatus + ", mIssues=" + this.mIssues + ", mEntriesOrGroups=" + this.mEntriesOrGroups + ", mStaticEntryGroups=" + this.mStaticEntryGroups + ", mDismissedIssues=" + this.mDismissedIssues + ", mExtras=" + this.extrasToString() + '}';
    }

    @NonNull
    private String extrasToString() {
        boolean hasUnknownExtras;
        int knownExtras = 0;
        StringBuilder sb = new StringBuilder();
        if (this.appendBundleString(sb, ISSUES_TO_GROUPS_BUNDLE_KEY)) {
            ++knownExtras;
        }
        if (this.appendBundleString(sb, STATIC_ENTRIES_TO_IDS_BUNDLE_KEY)) {
            ++knownExtras;
        }
        boolean bl = hasUnknownExtras = knownExtras != this.mExtras.keySet().size();
        if (hasUnknownExtras) {
            sb.append("(has unknown extras)");
        } else if (knownExtras == 0) {
            sb.append("(no extras)");
        }
        return sb.toString();
    }

    private boolean appendBundleString(@NonNull StringBuilder sb, @NonNull String bundleKey) {
        Bundle bundle = this.mExtras.getBundle(bundleKey);
        if (bundle == null) {
            return false;
        }
        sb.append(bundleKey);
        sb.append(":[");
        for (String key : bundle.keySet()) {
            sb.append("(key=").append(key).append(";value=").append(SafetyCenterData.getBundleValue(bundle, bundleKey, key)).append(")");
        }
        sb.append("]");
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mStatus, flags);
        dest.writeTypedList(this.mIssues);
        dest.writeTypedList(this.mEntriesOrGroups);
        dest.writeTypedList(this.mStaticEntryGroups);
        if (SdkLevel.isAtLeastU()) {
            dest.writeTypedList(this.mDismissedIssues);
            dest.writeBundle(this.mExtras);
        }
    }

    @Nullable
    private static Object getBundleValue(@NonNull Bundle bundle, @NonNull String bundleParentKey, @NonNull String key) {
        switch (bundleParentKey) {
            case "IssuesToGroups": {
                return bundle.getStringArrayList(key);
            }
            case "StaticEntriesToIds": {
                return bundle.getString(key);
            }
        }
        throw new IllegalArgumentException("Unexpected bundle parent key: " + bundleParentKey);
    }

    @RequiresApi(value=34)
    public static class Builder {
        @NonNull
        private final SafetyCenterStatus mStatus;
        @NonNull
        private final List<SafetyCenterIssue> mIssues = new ArrayList<SafetyCenterIssue>();
        @NonNull
        private final List<SafetyCenterEntryOrGroup> mEntriesOrGroups = new ArrayList<SafetyCenterEntryOrGroup>();
        @NonNull
        private final List<SafetyCenterStaticEntryGroup> mStaticEntryGroups = new ArrayList<SafetyCenterStaticEntryGroup>();
        @NonNull
        private final List<SafetyCenterIssue> mDismissedIssues = new ArrayList<SafetyCenterIssue>();
        @NonNull
        private Bundle mExtras = Bundle.EMPTY;

        public Builder(@NonNull SafetyCenterStatus status) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mStatus = Objects.requireNonNull(status);
        }

        public Builder(@NonNull SafetyCenterData safetyCenterData) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            Objects.requireNonNull(safetyCenterData);
            this.mStatus = safetyCenterData.mStatus;
            this.mIssues.addAll(safetyCenterData.mIssues);
            this.mEntriesOrGroups.addAll(safetyCenterData.mEntriesOrGroups);
            this.mStaticEntryGroups.addAll(safetyCenterData.mStaticEntryGroups);
            this.mDismissedIssues.addAll(safetyCenterData.mDismissedIssues);
            this.mExtras = safetyCenterData.mExtras.deepCopy();
        }

        @NonNull
        public Builder addIssue(@NonNull SafetyCenterIssue safetyCenterIssue) {
            this.mIssues.add(Objects.requireNonNull(safetyCenterIssue));
            return this;
        }

        @NonNull
        public Builder addEntryOrGroup(@NonNull SafetyCenterEntryOrGroup safetyCenterEntryOrGroup) {
            this.mEntriesOrGroups.add(Objects.requireNonNull(safetyCenterEntryOrGroup));
            return this;
        }

        @NonNull
        public Builder addStaticEntryGroup(@NonNull SafetyCenterStaticEntryGroup safetyCenterStaticEntryGroup) {
            this.mStaticEntryGroups.add(Objects.requireNonNull(safetyCenterStaticEntryGroup));
            return this;
        }

        @NonNull
        public Builder addDismissedIssue(@NonNull SafetyCenterIssue dismissedSafetyCenterIssue) {
            this.mDismissedIssues.add(Objects.requireNonNull(dismissedSafetyCenterIssue));
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        @NonNull
        public Builder clearExtras() {
            this.mExtras = Bundle.EMPTY;
            return this;
        }

        @NonNull
        public Builder clearIssues() {
            this.mIssues.clear();
            return this;
        }

        @NonNull
        public Builder clearEntriesOrGroups() {
            this.mEntriesOrGroups.clear();
            return this;
        }

        @NonNull
        public Builder clearStaticEntryGroups() {
            this.mStaticEntryGroups.clear();
            return this;
        }

        @NonNull
        public Builder clearDismissedIssues() {
            this.mDismissedIssues.clear();
            return this;
        }

        @NonNull
        public SafetyCenterData build() {
            List<SafetyCenterIssue> issues = Collections.unmodifiableList(new ArrayList<SafetyCenterIssue>(this.mIssues));
            List<SafetyCenterEntryOrGroup> entriesOrGroups = Collections.unmodifiableList(new ArrayList<SafetyCenterEntryOrGroup>(this.mEntriesOrGroups));
            List<SafetyCenterStaticEntryGroup> staticEntryGroups = Collections.unmodifiableList(new ArrayList<SafetyCenterStaticEntryGroup>(this.mStaticEntryGroups));
            List<SafetyCenterIssue> dismissedIssues = Collections.unmodifiableList(new ArrayList<SafetyCenterIssue>(this.mDismissedIssues));
            return new SafetyCenterData(this.mStatus, issues, entriesOrGroups, staticEntryGroups, dismissedIssues, this.mExtras);
        }
    }
}

