/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.raw;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingDevice;
import android.ranging.ble.cs.BleCsConstants;
import android.ranging.ble.cs.BleCsRangingParams;
import android.ranging.ble.rssi.BleRssiConstants;
import android.ranging.ble.rssi.BleRssiRangingParams;
import android.ranging.uwb.UwbConstants;
import android.ranging.uwb.UwbRangingParams;
import android.ranging.wifi.rtt.RttRangingParams;
import android.ranging.wifi.rtt.WifiRttConstants;
import android.util.ArrayMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RawRangingDevice
implements Parcelable {
    public static final int UPDATE_RATE_NORMAL = 1;
    public static final int UPDATE_RATE_INFREQUENT = 2;
    public static final int UPDATE_RATE_FREQUENT = 3;
    private final RangingDevice mRangingDevice;
    private final UwbRangingParams mUwbRangingParams;
    private final BleCsRangingParams mBleCsRangingParams;
    private final RttRangingParams mRttRangingParams;
    private final BleRssiRangingParams mBleRssiRangingParams;
    @NonNull
    public static final Parcelable.Creator<RawRangingDevice> CREATOR = new Parcelable.Creator<RawRangingDevice>(){

        @Override
        public RawRangingDevice createFromParcel(Parcel in) {
            return new RawRangingDevice(in);
        }

        public RawRangingDevice[] newArray(int size) {
            return new RawRangingDevice[size];
        }
    };

    private RawRangingDevice(Builder builder) {
        this.mRangingDevice = builder.mRangingDevice;
        this.mUwbRangingParams = builder.mUwbRangingParams;
        this.mBleCsRangingParams = builder.mBleCsRangingParams;
        this.mRttRangingParams = builder.mRttRangingParams;
        this.mBleRssiRangingParams = builder.mBleRssiRangingParams;
    }

    private RawRangingDevice(Parcel in) {
        this.mRangingDevice = in.readParcelable(RangingDevice.class.getClassLoader(), RangingDevice.class);
        this.mUwbRangingParams = in.readParcelable(UwbRangingParams.class.getClassLoader(), UwbRangingParams.class);
        this.mBleCsRangingParams = in.readParcelable(BleCsRangingParams.class.getClassLoader(), BleCsRangingParams.class);
        this.mRttRangingParams = in.readParcelable(RttRangingParams.class.getClassLoader(), RttRangingParams.class);
        this.mBleRssiRangingParams = in.readParcelable(BleRssiRangingParams.class.getClassLoader(), BleRssiRangingParams.class);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mRangingDevice, flags);
        dest.writeParcelable(this.mUwbRangingParams, flags);
        dest.writeParcelable(this.mBleCsRangingParams, flags);
        dest.writeParcelable(this.mRttRangingParams, flags);
        dest.writeParcelable(this.mBleRssiRangingParams, flags);
    }

    @NonNull
    public RangingDevice getRangingDevice() {
        return this.mRangingDevice;
    }

    @Nullable
    public UwbRangingParams getUwbRangingParams() {
        return this.mUwbRangingParams;
    }

    @Nullable
    public BleCsRangingParams getCsRangingParams() {
        return this.mBleCsRangingParams;
    }

    @Nullable
    public RttRangingParams getRttRangingParams() {
        return this.mRttRangingParams;
    }

    @Nullable
    public BleRssiRangingParams getBleRssiRangingParams() {
        return this.mBleRssiRangingParams;
    }

    @FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_updates_25q4")
    @NonNull
    public Map<Integer, Duration> getRangingIntervalValues() {
        ArrayMap<Integer, Duration> map = new ArrayMap<Integer, Duration>();
        if (this.mUwbRangingParams != null) {
            int uwbUpdateRate = this.mUwbRangingParams.getRangingUpdateRate();
            int uwbConfigId = this.mUwbRangingParams.getConfigId();
            map.put(0, Duration.ofMillis(UwbConstants.getIntervalMs(uwbConfigId, uwbUpdateRate)));
        }
        if (this.mBleCsRangingParams != null) {
            int bleCsUpdateRate = this.mBleCsRangingParams.getRangingUpdateRate();
            map.put(1, Duration.ofMillis(BleCsConstants.getIntervalInMs(bleCsUpdateRate)));
        }
        if (this.mRttRangingParams != null) {
            int wifiNanRttUpdateRateMs = WifiRttConstants.getIntervalMs(this.mRttRangingParams.getRangingUpdateRate(), this.mRttRangingParams.isPeriodicRangingHwFeatureEnabled());
            map.put(2, Duration.ofMillis(wifiNanRttUpdateRateMs));
        }
        if (this.mBleRssiRangingParams != null) {
            int bleRssiUpdateRate = this.mBleRssiRangingParams.getRangingUpdateRate();
            map.put(3, Duration.ofMillis(BleRssiConstants.getIntervalInMs(bleRssiUpdateRate)));
        }
        return map;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "RawRangingDevice{ mRangingDevice=" + this.mRangingDevice + ", mUwbRangingParams=" + this.mUwbRangingParams + ", mBleCsRangingParams=" + this.mBleCsRangingParams + ", mRttRangingParams=" + this.mRttRangingParams + ", mBleRssiRangingParams=" + this.mBleRssiRangingParams + " }";
    }

    public static class Builder {
        private RangingDevice mRangingDevice;
        private UwbRangingParams mUwbRangingParams;
        private BleCsRangingParams mBleCsRangingParams;
        private RttRangingParams mRttRangingParams;
        private BleRssiRangingParams mBleRssiRangingParams;

        @NonNull
        public Builder setRangingDevice(@NonNull RangingDevice rangingDevice) {
            Objects.requireNonNull(rangingDevice);
            this.mRangingDevice = rangingDevice;
            return this;
        }

        @NonNull
        public Builder setUwbRangingParams(@NonNull UwbRangingParams params) {
            Objects.requireNonNull(params);
            this.mUwbRangingParams = params;
            return this;
        }

        @NonNull
        public Builder setRttRangingParams(@NonNull RttRangingParams params) {
            Objects.requireNonNull(params);
            this.mRttRangingParams = params;
            return this;
        }

        @NonNull
        public Builder setCsRangingParams(@NonNull BleCsRangingParams params) {
            Objects.requireNonNull(params);
            this.mBleCsRangingParams = params;
            return this;
        }

        @NonNull
        public Builder setBleRssiRangingParams(@NonNull BleRssiRangingParams params) {
            Objects.requireNonNull(params);
            this.mBleRssiRangingParams = params;
            return this;
        }

        @NonNull
        public RawRangingDevice build() {
            Objects.requireNonNull(this.mRangingDevice);
            if (Stream.of(this.mUwbRangingParams, this.mBleCsRangingParams, this.mBleRssiRangingParams, this.mRttRangingParams).allMatch(Objects::isNull)) {
                throw new IllegalArgumentException("At least one ranging params should be configured");
            }
            return new RawRangingDevice(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface RangingUpdateRate {
    }
}

