/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.oob;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingConfig;
import android.ranging.oob.DeviceHandle;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class OobResponderRangingConfig
extends RangingConfig
implements Parcelable {
    private final DeviceHandle mDeviceHandle;
    @NonNull
    public static final Parcelable.Creator<OobResponderRangingConfig> CREATOR = new Parcelable.Creator<OobResponderRangingConfig>(){

        @Override
        public OobResponderRangingConfig createFromParcel(Parcel in) {
            return new OobResponderRangingConfig(in);
        }

        public OobResponderRangingConfig[] newArray(int size) {
            return new OobResponderRangingConfig[size];
        }
    };

    private OobResponderRangingConfig(Builder builder) {
        this.setRangingSessionType(1);
        this.mDeviceHandle = builder.mDeviceHandle;
    }

    private OobResponderRangingConfig(Parcel in) {
        this.setRangingSessionType(in.readInt());
        this.mDeviceHandle = in.readParcelable(DeviceHandle.class.getClassLoader(), DeviceHandle.class);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.getRangingSessionType());
        dest.writeParcelable(this.mDeviceHandle, flags);
    }

    @NonNull
    public DeviceHandle getDeviceHandle() {
        return this.mDeviceHandle;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public String toString() {
        return "OobResponderRangingParams{ mDeviceHandle=" + this.mDeviceHandle + ", " + super.toString() + ",  }";
    }

    public static class Builder {
        private final DeviceHandle mDeviceHandle;

        public Builder(@NonNull DeviceHandle deviceHandle) {
            Objects.requireNonNull(deviceHandle);
            this.mDeviceHandle = deviceHandle;
        }

        @NonNull
        public OobResponderRangingConfig build() {
            return new OobResponderRangingConfig(this);
        }
    }
}

