/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.DataNotificationConfig;
import android.ranging.SensorFusionParams;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class SessionConfig
implements Parcelable {
    private final SensorFusionParams mFusionParams;
    private final DataNotificationConfig mDataNotificationConfig;
    private final boolean mIsAngleOfArrivalNeeded;
    private final int mRangingMeasurementsLimit;
    @NonNull
    public static final Parcelable.Creator<SessionConfig> CREATOR = new Parcelable.Creator<SessionConfig>(){

        @Override
        public SessionConfig createFromParcel(Parcel in) {
            return new SessionConfig(in);
        }

        public SessionConfig[] newArray(int size) {
            return new SessionConfig[size];
        }
    };

    private SessionConfig(Builder builder) {
        this.mFusionParams = builder.mFusionParams;
        this.mDataNotificationConfig = builder.mDataNotificationConfig;
        this.mIsAngleOfArrivalNeeded = builder.mIsAngleOfArrivalNeeded;
        this.mRangingMeasurementsLimit = builder.mRangingMeasurementsLimit;
    }

    private SessionConfig(Parcel in) {
        this.mFusionParams = in.readParcelable(SensorFusionParams.class.getClassLoader(), SensorFusionParams.class);
        this.mDataNotificationConfig = in.readParcelable(DataNotificationConfig.class.getClassLoader(), DataNotificationConfig.class);
        this.mIsAngleOfArrivalNeeded = in.readBoolean();
        this.mRangingMeasurementsLimit = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mFusionParams, flags);
        dest.writeParcelable(this.mDataNotificationConfig, flags);
        dest.writeBoolean(this.mIsAngleOfArrivalNeeded);
        dest.writeInt(this.mRangingMeasurementsLimit);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public SensorFusionParams getSensorFusionParams() {
        return this.mFusionParams;
    }

    @NonNull
    public DataNotificationConfig getDataNotificationConfig() {
        return this.mDataNotificationConfig;
    }

    public boolean isAngleOfArrivalNeeded() {
        return this.mIsAngleOfArrivalNeeded;
    }

    public int getRangingMeasurementsLimit() {
        return this.mRangingMeasurementsLimit;
    }

    public String toString() {
        return "SessionConfig{mFusionParams=" + this.mFusionParams + ", mDataNotificationConfig=" + this.mDataNotificationConfig + ", mIsAngleOfArrivalNeeded=" + this.mIsAngleOfArrivalNeeded + ", mRangingMeasurementsLimit=" + this.mRangingMeasurementsLimit + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionConfig)) {
            return false;
        }
        SessionConfig that = (SessionConfig)o;
        return this.mIsAngleOfArrivalNeeded == that.mIsAngleOfArrivalNeeded && this.mRangingMeasurementsLimit == that.mRangingMeasurementsLimit && Objects.equals(this.mFusionParams, that.mFusionParams) && Objects.equals(this.mDataNotificationConfig, that.mDataNotificationConfig);
    }

    public int hashCode() {
        return Objects.hash(this.mFusionParams, this.mDataNotificationConfig, this.mIsAngleOfArrivalNeeded, this.mRangingMeasurementsLimit);
    }

    public static class Builder {
        private DataNotificationConfig mDataNotificationConfig = new DataNotificationConfig.Builder().build();
        private SensorFusionParams mFusionParams = new SensorFusionParams.Builder().build();
        private boolean mIsAngleOfArrivalNeeded = false;
        private int mRangingMeasurementsLimit = 0;

        @NonNull
        public Builder setSensorFusionParams(@NonNull SensorFusionParams parameters) {
            this.mFusionParams = parameters;
            return this;
        }

        @NonNull
        public Builder setDataNotificationConfig(@NonNull DataNotificationConfig config) {
            this.mDataNotificationConfig = config;
            return this;
        }

        @NonNull
        public Builder setAngleOfArrivalNeeded(boolean isAngleOfArrivalNeeded) {
            this.mIsAngleOfArrivalNeeded = isAngleOfArrivalNeeded;
            return this;
        }

        @NonNull
        public Builder setRangingMeasurementsLimit(int rangingMeasurementsLimit) {
            if (rangingMeasurementsLimit < 0 || rangingMeasurementsLimit > 65535) {
                throw new IllegalArgumentException("Ranging measurements limit must be between 0 and 65535");
            }
            this.mRangingMeasurementsLimit = rangingMeasurementsLimit;
            return this;
        }

        @NonNull
        public SessionConfig build() {
            return new SessionConfig(this);
        }
    }
}

