/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.content.AttributionSource;
import android.os.Process;
import android.os.RemoteException;
import android.ranging.IRangingAdapter;
import android.ranging.IRangingCallbacks;
import android.ranging.RangingData;
import android.ranging.RangingDevice;
import android.ranging.RangingSession;
import android.ranging.SessionHandle;
import android.ranging.oob.IOobSendDataListener;
import android.ranging.oob.OobHandle;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class RangingSessionManager
extends IRangingCallbacks.Stub {
    private static final String TAG = "RangingSessionManager";
    private static long sSessionIdCounter = 1L;
    private final IRangingAdapter mRangingAdapter;
    private final Map<SessionHandle, RangingSession> mSessions = new ConcurrentHashMap<SessionHandle, RangingSession>();
    private boolean mOobListenerRegistered = false;

    public RangingSessionManager(IRangingAdapter rangingAdapter) {
        this.mRangingAdapter = rangingAdapter;
    }

    public void registerOobSendDataListener() {
        if (!this.mOobListenerRegistered) {
            try {
                this.mRangingAdapter.registerOobSendDataListener(new OobSendDataListener());
                this.mOobListenerRegistered = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to register OobSendDataListener", e);
            }
        }
    }

    RangingSession createRangingSessionInstance(AttributionSource attributionSource, RangingSession.Callback callback, Executor executor) {
        SessionHandle sessionHandle = new SessionHandle(sSessionIdCounter++, attributionSource, Process.myPid());
        Log.v(TAG, "Create ranging session - sessionHandle: " + sessionHandle);
        RangingSession rangingSession = new RangingSession(this, attributionSource, sessionHandle, this.mRangingAdapter, callback, executor);
        this.mSessions.put(sessionHandle, rangingSession);
        return rangingSession;
    }

    @Override
    public void onOpened(SessionHandle session) {
        Log.v(TAG, "onOpened - sessionHandle: " + session);
        if (!this.mSessions.containsKey(session)) {
            Log.e(TAG, "SessionHandle not found");
            return;
        }
        this.mSessions.get(session).onOpened();
    }

    @Override
    public void onOpenFailed(SessionHandle session, int reason) {
        Log.v(TAG, "onOpenFailed - sessionHandle: " + session + " reason: " + reason);
        if (!this.mSessions.containsKey(session)) {
            Log.e(TAG, "SessionHandle not found");
            return;
        }
        this.mSessions.get(session).onOpenFailed(reason);
    }

    @Override
    public void onStarted(SessionHandle session, RangingDevice peer, int technology) {
        Log.v(TAG, "onStarted - sessionHandle: " + session + " technology: " + technology);
        if (!this.mSessions.containsKey(session)) {
            Log.e(TAG, "SessionHandle not found");
            return;
        }
        this.mSessions.get(session).onStarted(peer, technology);
    }

    @Override
    public void onResults(SessionHandle session, RangingDevice peer, RangingData data) {
        Log.v(TAG, "onResults - sessionHandle: " + session + " peer: " + peer.toString());
        if (!this.mSessions.containsKey(session)) {
            Log.e(TAG, "SessionHandle not found");
            return;
        }
        this.mSessions.get(session).onResults(peer, data);
    }

    @Override
    public void onStopped(SessionHandle session, RangingDevice peer, int technology) {
        Log.v(TAG, "onStopped - sessionHandle: " + session + " technology: " + technology);
        if (!this.mSessions.containsKey(session)) {
            Log.e(TAG, "SessionHandle not found");
            return;
        }
        this.mSessions.get(session).onStopped(peer, technology);
    }

    @Override
    public void onClosed(SessionHandle session, int reason) {
        Log.v(TAG, "onClosed - sessionHandle: " + session + " reason: " + reason);
        if (!this.mSessions.containsKey(session)) {
            Log.e(TAG, "SessionHandle not found");
            return;
        }
        this.mSessions.get(session).onClosed(reason);
    }

    public void oobDataReceived(OobHandle oobHandle, byte[] data) {
        Log.v(TAG, "oobDataReceived - " + oobHandle);
        try {
            this.mRangingAdapter.oobDataReceived(oobHandle, data);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed mRangingAdapter.oobDataReceived", e);
        }
    }

    public void deviceOobReconnected(OobHandle oobHandle) {
        Log.v(TAG, "deviceOobReconnected - " + oobHandle);
        try {
            this.mRangingAdapter.deviceOobReconnected(oobHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed mRangingAdapter.deviceOobReconnected", e);
        }
    }

    public void deviceOobDisconnected(OobHandle oobHandle) {
        Log.v(TAG, "deviceOobReconnected - " + oobHandle);
        try {
            this.mRangingAdapter.deviceOobDisconnected(oobHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed mRangingAdapter.deviceOobDisconnected", e);
        }
    }

    public void deviceOobClosed(OobHandle oobHandle) {
        Log.v(TAG, "deviceOobClosed - " + oobHandle);
        try {
            this.mRangingAdapter.deviceOobClosed(oobHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed mRangingAdapter.deviceOobClosed", e);
        }
    }

    class OobSendDataListener
    extends IOobSendDataListener.Stub {
        OobSendDataListener() {
        }

        @Override
        public void sendOobData(OobHandle oobHandle, byte[] data) throws RemoteException {
            SessionHandle session = oobHandle.getSessionHandle();
            if (!RangingSessionManager.this.mSessions.containsKey(session)) {
                Log.e(RangingSessionManager.TAG, "SessionHandle not found, session: " + session);
                return;
            }
            RangingSessionManager.this.mSessions.get(session).sendOobData(oobHandle.getRangingDevice(), data);
        }
    }
}

