/*
 * Decompiled with CFR 0.152.
 */
package android.provider.internal.aconfig.storage.com.android.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.provider.internal.aconfig.storage.com.google.errorprone.annotations.CompileTimeConstant;
import android.provider.internal.aconfig.storage.com.google.errorprone.annotations.FormatMethod;
import android.provider.internal.aconfig.storage.com.google.errorprone.annotations.FormatString;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class Preconditions {
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @CompileTimeConstant Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    @FormatMethod
    public static void checkArgument(boolean expression, @FormatString @CompileTimeConstant String messageTemplate, Object ... messageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(messageTemplate, messageArgs));
        }
    }

    @NonNull
    public static <T extends CharSequence> T checkStringNotEmpty(T string2) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException();
        }
        return string2;
    }

    @NonNull
    public static <T extends CharSequence> T checkStringNotEmpty(T string2, @CompileTimeConstant Object errorMessage) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return string2;
    }

    @FormatMethod
    @NonNull
    public static <T extends CharSequence> T checkStringNotEmpty(T string2, @FormatString @CompileTimeConstant String messageTemplate, Object ... messageArgs) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException(String.format(messageTemplate, messageArgs));
        }
        return string2;
    }

    @Deprecated
    @NonNull
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    @Deprecated
    @NonNull
    public static <T> T checkNotNull(T reference, @CompileTimeConstant Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    @FormatMethod
    @NonNull
    public static <T> T checkNotNull(T reference, @FormatString @CompileTimeConstant String messageTemplate, Object ... messageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(messageTemplate, messageArgs));
        }
        return reference;
    }

    public static void checkState(boolean expression) {
        Preconditions.checkState(expression, null);
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    @FormatMethod
    public static void checkState(boolean expression, @FormatString @CompileTimeConstant String messageTemplate, Object ... messageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(messageTemplate, messageArgs));
        }
    }

    public static void checkCallAuthorization(boolean expression) {
        if (!expression) {
            throw new SecurityException("Calling identity is not authorized");
        }
    }

    public static void checkCallAuthorization(boolean expression, String message) {
        if (!expression) {
            throw new SecurityException(message);
        }
    }

    @FormatMethod
    public static void checkCallAuthorization(boolean expression, @FormatString @CompileTimeConstant String messageTemplate, Object ... messageArgs) {
        if (!expression) {
            throw new SecurityException(String.format(messageTemplate, messageArgs));
        }
    }

    public static void checkCallingUser(boolean expression) {
        if (!expression) {
            throw new SecurityException("Calling user is not authorized");
        }
    }

    public static int checkFlagsArgument(int requestedFlags, int allowedFlags) {
        if ((requestedFlags & allowedFlags) != requestedFlags) {
            throw new IllegalArgumentException("Requested flags 0x" + Integer.toHexString(requestedFlags) + ", but only 0x" + Integer.toHexString(allowedFlags) + " are allowed");
        }
        return requestedFlags;
    }

    public static int checkArgumentNonnegative(int value, String errorMessage) {
        if (value < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int checkArgumentNonnegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static long checkArgumentNonnegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static long checkArgumentNonnegative(long value, String errorMessage) {
        if (value < 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int checkArgumentPositive(int value, String errorMessage) {
        if (value <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static float checkArgumentNonNegative(float value, String errorMessage) {
        if (value < 0.0f) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static float checkArgumentPositive(float value, String errorMessage) {
        if (value <= 0.0f) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static float checkArgumentFinite(float value, String valueName) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException(valueName + " must not be infinite");
        }
        return value;
    }

    public static float checkArgumentInRange(float value, float lower, float upper, String valueName) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (value < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too low)", valueName, Float.valueOf(lower), Float.valueOf(upper)));
        }
        if (value > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too high)", valueName, Float.valueOf(lower), Float.valueOf(upper)));
        }
        return value;
    }

    public static double checkArgumentInRange(double value, double lower, double upper, String valueName) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (value < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too low)", valueName, lower, upper));
        }
        if (value > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too high)", valueName, lower, upper));
        }
        return value;
    }

    public static int checkArgumentInRange(int value, int lower, int upper, String valueName) {
        if (value < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too low)", valueName, lower, upper));
        }
        if (value > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too high)", valueName, lower, upper));
        }
        return value;
    }

    public static long checkArgumentInRange(long value, long lower, long upper, String valueName) {
        if (value < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too low)", valueName, lower, upper));
        }
        if (value > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too high)", valueName, lower, upper));
        }
        return value;
    }

    public static <T> T[] checkArrayElementsNotNull(T[] value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] != null) continue;
            throw new NullPointerException(String.format("%s[%d] must not be null", valueName, i));
        }
        return value;
    }

    @NonNull
    public static <C extends Collection<T>, T> C checkCollectionElementsNotNull(C value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        long ctr = 0L;
        for (T elem : value) {
            if (elem == null) {
                throw new NullPointerException(String.format("%s[%d] must not be null", valueName, ctr));
            }
            ++ctr;
        }
        return value;
    }

    public static <T> Collection<T> checkCollectionNotEmpty(Collection<T> value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException(valueName + " is empty");
        }
        return value;
    }

    @NonNull
    public static byte[] checkByteArrayNotEmpty(byte[] value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        if (value.length == 0) {
            throw new IllegalArgumentException(valueName + " is empty");
        }
        return value;
    }

    @NonNull
    public static String checkArgumentIsSupported(String[] supportedValues, String value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull(supportedValues);
        if (!Preconditions.contains(supportedValues, value)) {
            throw new IllegalArgumentException(value + "is not supported " + Arrays.toString(supportedValues));
        }
        return value;
    }

    private static boolean contains(String[] values, String value) {
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!Objects.equals(value, values[i])) continue;
            return true;
        }
        return false;
    }

    public static float[] checkArrayElementsInRange(float[] value, float lower, float upper, String valueName) {
        Preconditions.checkNotNull(value, "%s must not be null", valueName);
        for (int i = 0; i < value.length; ++i) {
            float v = value[i];
            if (Float.isNaN(v)) {
                throw new IllegalArgumentException(valueName + "[" + i + "] must not be NaN");
            }
            if (v < lower) {
                throw new IllegalArgumentException(String.format("%s[%d]: %f is out of range of [%f, %f] (too low)", valueName, i, Float.valueOf(v), Float.valueOf(lower), Float.valueOf(upper)));
            }
            if (!(v > upper)) continue;
            throw new IllegalArgumentException(String.format("%s[%d]: %f is out of range of [%f, %f] (too high)", valueName, i, Float.valueOf(v), Float.valueOf(lower), Float.valueOf(upper)));
        }
        return value;
    }

    public static int[] checkArrayElementsInRange(int[] value, int lower, int upper, String valueName) {
        Preconditions.checkNotNull(value, "%s must not be null", valueName);
        for (int i = 0; i < value.length; ++i) {
            int v = value[i];
            if (v < lower) {
                throw new IllegalArgumentException(String.format("%s[%d]: %d is out of range of [%d, %d] (too low)", valueName, v, i, lower, upper));
            }
            if (v <= upper) continue;
            throw new IllegalArgumentException(String.format("%s[%d]: %d is out of range of [%d, %d] (too high)", valueName, v, i, lower, upper));
        }
        return value;
    }

    @NonNull
    public static <T> T requireNonNullViaRavenwoodRule(@Nullable T t) {
        if (t == null) {
            throw new IllegalStateException("This operation requires that a RavenwoodRule be configured to accurately define the expected test environment");
        }
        return t;
    }
}

