/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.provider.DeviceConfig;
import android.provider.DeviceConfigDataStore;
import android.provider.Settings;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;

public class SettingsConfigDataStore
implements DeviceConfigDataStore {
    @Override
    @NonNull
    public Map<String, String> getAllProperties() {
        return Settings.Config.getAllStrings();
    }

    @Override
    @NonNull
    public DeviceConfig.Properties getProperties(@NonNull String namespace, String ... names) {
        return new DeviceConfig.Properties(namespace, Settings.Config.getStrings(namespace, Arrays.asList(names)));
    }

    @Override
    public boolean setProperties(@NonNull DeviceConfig.Properties properties) throws DeviceConfig.BadConfigException {
        return Settings.Config.setStrings(properties.getNamespace(), properties.getPropertyValues());
    }

    @Override
    public boolean setProperty(@NonNull String namespace, @NonNull String name, @Nullable String value, boolean makeDefault) {
        return Settings.Config.putString(namespace, name, value, makeDefault);
    }

    @Override
    public boolean deleteProperty(@NonNull String namespace, @NonNull String name) {
        return Settings.Config.deleteString(namespace, name);
    }

    @Override
    public void resetToDefaults(int resetMode, @Nullable String namespace) {
        Settings.Config.resetToDefaults(resetMode, namespace);
    }

    @Override
    public void setSyncDisabledMode(int syncDisabledMode) {
        Settings.Config.setSyncDisabledMode(syncDisabledMode);
    }

    @Override
    public int getSyncDisabledMode() {
        return Settings.Config.getSyncDisabledMode();
    }

    @Override
    public void setMonitorCallback(@NonNull ContentResolver resolver, @NonNull Executor executor, @NonNull DeviceConfig.MonitorCallback callback) {
        Settings.Config.setMonitorCallback(resolver, executor, callback);
    }

    @Override
    public void clearMonitorCallback(@NonNull ContentResolver resolver) {
        Settings.Config.clearMonitorCallback(resolver);
    }

    @Override
    public void registerContentObserver(@NonNull String namespace, boolean notifyForescendants, ContentObserver contentObserver) {
        Settings.Config.registerContentObserver(namespace, true, contentObserver);
    }

    @Override
    public void unregisterContentObserver(@NonNull ContentObserver contentObserver) {
        Settings.Config.unregisterContentObserver(contentObserver);
    }
}

