/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.IMPCancellationSignal;
import android.provider.IOpenAssetFileCallback;

public class OpenAssetFileRequest
implements Parcelable {
    private final Uri mUri;
    private final String mMimeType;
    private final Bundle mOpts;
    private final IOpenAssetFileCallback mCallback;
    private final IMPCancellationSignal mCancellationSignal;
    @NonNull
    public static final Parcelable.Creator<OpenAssetFileRequest> CREATOR = new Parcelable.Creator<OpenAssetFileRequest>(){

        @Override
        public OpenAssetFileRequest createFromParcel(Parcel source) {
            return new OpenAssetFileRequest(source);
        }

        public OpenAssetFileRequest[] newArray(int size) {
            return new OpenAssetFileRequest[size];
        }
    };

    public OpenAssetFileRequest(@NonNull Uri uri, @NonNull String mimeType, @Nullable Bundle opts, @NonNull IOpenAssetFileCallback callback, @Nullable IMPCancellationSignal cancellationSignal) {
        this.mUri = uri;
        this.mMimeType = mimeType;
        this.mOpts = opts;
        this.mCallback = callback;
        this.mCancellationSignal = cancellationSignal;
    }

    @NonNull
    public Uri getUri() {
        return this.mUri;
    }

    @NonNull
    public String getMimeType() {
        return this.mMimeType;
    }

    @Nullable
    public Bundle getOpts() {
        return this.mOpts;
    }

    @NonNull
    public IOpenAssetFileCallback getCallback() {
        return this.mCallback;
    }

    @Nullable
    public IMPCancellationSignal getCancellationSignal() {
        return this.mCancellationSignal;
    }

    @SuppressLint(value={"ParcelClassLoader"})
    private OpenAssetFileRequest(Parcel p) {
        this.mUri = Uri.CREATOR.createFromParcel(p);
        this.mMimeType = p.readString();
        this.mOpts = p.readBundle();
        this.mCallback = IOpenAssetFileCallback.Stub.asInterface(p.readStrongBinder());
        this.mCancellationSignal = IMPCancellationSignal.Stub.asInterface(p.readStrongBinder());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mUri.writeToParcel(dest, flags);
        dest.writeString(this.mMimeType);
        dest.writeBundle(this.mOpts);
        dest.writeStrongBinder(this.mCallback.asBinder());
        dest.writeStrongBinder(this.mCancellationSignal != null ? this.mCancellationSignal.asBinder() : null);
    }
}

