/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.res.AssetFileDescriptor;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.provider.ParcelableException;

public interface IOpenAssetFileCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.provider.IOpenAssetFileCallback";

    public void onSuccess(AssetFileDescriptor var1) throws RemoteException;

    public void onFailure(ParcelableException var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOpenAssetFileCallback {
        static final int TRANSACTION_onSuccess = 1;
        static final int TRANSACTION_onFailure = 2;

        public Stub() {
            this.attachInterface(this, IOpenAssetFileCallback.DESCRIPTOR);
        }

        public static IOpenAssetFileCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOpenAssetFileCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IOpenAssetFileCallback) {
                return (IOpenAssetFileCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSuccess";
                }
                case 2: {
                    return "onFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOpenAssetFileCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AssetFileDescriptor _arg0 = data.readTypedObject(AssetFileDescriptor.CREATOR);
                    this.onSuccess(_arg0);
                    break;
                }
                case 2: {
                    ParcelableException _arg0 = data.readTypedObject(ParcelableException.CREATOR);
                    this.onFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IOpenAssetFileCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOpenAssetFileCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(AssetFileDescriptor afd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOpenAssetFileCallback.DESCRIPTOR);
                    _data.writeTypedObject(afd, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(ParcelableException exception) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOpenAssetFileCallback.DESCRIPTOR);
                    _data.writeTypedObject(exception, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOpenAssetFileCallback {
        @Override
        public void onSuccess(AssetFileDescriptor afd) throws RemoteException {
        }

        @Override
        public void onFailure(ParcelableException exception) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

