/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMPCancellationSignal
extends IInterface {
    public static final String DESCRIPTOR = "android.provider.IMPCancellationSignal";

    public void cancel() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMPCancellationSignal {
        static final int TRANSACTION_cancel = 1;

        public Stub() {
            this.attachInterface(this, IMPCancellationSignal.DESCRIPTOR);
        }

        public static IMPCancellationSignal asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMPCancellationSignal.DESCRIPTOR);
            if (iin != null && iin instanceof IMPCancellationSignal) {
                return (IMPCancellationSignal)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "cancel";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMPCancellationSignal.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.cancel();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IMPCancellationSignal {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMPCancellationSignal.DESCRIPTOR;
            }

            @Override
            public void cancel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMPCancellationSignal.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMPCancellationSignal {
        @Override
        public void cancel() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

