/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Binder;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.print.PageRange;
import android.text.TextUtils;

public interface IWriteResultCallback
extends IInterface {
    public void onWriteStarted(ICancellationSignal var1, int var2) throws RemoteException;

    public void onWriteFinished(PageRange[] var1, int var2) throws RemoteException;

    public void onWriteFailed(CharSequence var1, int var2) throws RemoteException;

    public void onWriteCanceled(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWriteResultCallback {
        public static final String DESCRIPTOR = "android.print.IWriteResultCallback";
        static final int TRANSACTION_onWriteStarted = 1;
        static final int TRANSACTION_onWriteFinished = 2;
        static final int TRANSACTION_onWriteFailed = 3;
        static final int TRANSACTION_onWriteCanceled = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWriteResultCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWriteResultCallback) {
                return (IWriteResultCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onWriteStarted";
                }
                case 2: {
                    return "onWriteFinished";
                }
                case 3: {
                    return "onWriteFailed";
                }
                case 4: {
                    return "onWriteCanceled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ICancellationSignal _arg0 = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onWriteStarted(_arg0, _arg1);
                    break;
                }
                case 2: {
                    PageRange[] _arg0 = data.createTypedArray(PageRange.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onWriteFinished(_arg0, _arg1);
                    break;
                }
                case 3: {
                    CharSequence _arg0 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onWriteFailed(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onWriteCanceled(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IWriteResultCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWriteStarted(ICancellationSignal cancellation, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cancellation);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWriteFinished(PageRange[] pages, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(pages, 0);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWriteFailed(CharSequence error, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (error != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(error, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWriteCanceled(int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWriteResultCallback {
        @Override
        public void onWriteStarted(ICancellationSignal cancellation, int sequence) throws RemoteException {
        }

        @Override
        public void onWriteFinished(PageRange[] pages, int sequence) throws RemoteException {
        }

        @Override
        public void onWriteFailed(CharSequence error, int sequence) throws RemoteException {
        }

        @Override
        public void onWriteCanceled(int sequence) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

