/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.permission.ILegacyPermissionManager;
import com.android.internal.annotations.VisibleForTesting;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class LegacyPermissionManager {
    private final ILegacyPermissionManager mLegacyPermissionManager;

    public LegacyPermissionManager() throws ServiceManager.ServiceNotFoundException {
        this(ILegacyPermissionManager.Stub.asInterface(ServiceManager.getServiceOrThrow("legacy_permission")));
    }

    @VisibleForTesting
    public LegacyPermissionManager(@NonNull ILegacyPermissionManager legacyPermissionManager) {
        this.mLegacyPermissionManager = legacyPermissionManager;
    }

    public int checkDeviceIdentifierAccess(@Nullable String packageName, @Nullable String message, @Nullable String callingFeatureId, int pid, int uid) {
        try {
            return this.mLegacyPermissionManager.checkDeviceIdentifierAccess(packageName, message, callingFeatureId, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkPhoneNumberAccess(@Nullable String packageName, @Nullable String message, @Nullable String callingFeatureId, int pid, int uid) {
        try {
            return this.mLegacyPermissionManager.checkPhoneNumberAccess(packageName, message, callingFeatureId, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToLuiApp(@NonNull String packageName, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToActiveLuiApp(packageName, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void revokeDefaultPermissionsFromLuiApps(@NonNull String[] packageNames, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.revokeDefaultPermissionsFromLuiApps(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToEnabledImsServices(@NonNull String[] packageNames, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToEnabledImsServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToEnabledTelephonyDataServices(@NonNull String[] packageNames, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToEnabledTelephonyDataServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(@NonNull String[] packageNames, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.revokeDefaultPermissionsFromDisabledTelephonyDataServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToEnabledCarrierApps(@NonNull String[] packageNames, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToEnabledCarrierApps(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void grantDefaultPermissionsToCarrierServiceApp(@NonNull String packageName, int userId) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToCarrierServiceApp(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

