/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import android.util.Xml;
import com.android.internal.vibrator.persistence.LegacyVibrationEffectXmlSerializer;
import com.android.internal.vibrator.persistence.VibrationEffectSerializer;
import com.android.internal.vibrator.persistence.XmlSerializedVibration;
import com.android.internal.vibrator.persistence.XmlSerializerException;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class VibrationXmlSerializer {
    public static final int FLAG_ALLOW_HIDDEN_APIS = 1;
    public static final int FLAG_PRETTY_PRINT = 2;
    private static final String XML_ENCODING = Xml.Encoding.UTF_8.name();
    private static final String XML_FEATURE_INDENT_OUTPUT = "http://xmlpull.org/v1/doc/features.html#indent-output";

    public static void serialize(@NonNull VibrationEffect effect, @NonNull Writer writer) throws IOException {
        VibrationXmlSerializer.serialize(effect, writer, 0);
    }

    public static void serialize(@NonNull VibrationEffect effect, @NonNull Writer writer, int flags) throws IOException {
        XmlSerializedVibration<? extends VibrationEffect> serializedVibration = VibrationXmlSerializer.toSerializedVibration(effect, flags);
        TypedXmlSerializer xmlSerializer = Xml.newFastSerializer();
        xmlSerializer.setFeature(XML_FEATURE_INDENT_OUTPUT, (flags & 2) != 0);
        xmlSerializer.setOutput(writer);
        xmlSerializer.startDocument(XML_ENCODING, false);
        serializedVibration.write(xmlSerializer);
        xmlSerializer.endDocument();
    }

    private static XmlSerializedVibration<? extends VibrationEffect> toSerializedVibration(VibrationEffect effect, int flags) throws SerializationFailedException {
        XmlSerializedVibration<? extends VibrationEffect> serializedVibration;
        int serializerFlags = 0;
        if ((flags & 1) != 0) {
            serializerFlags |= 1;
        }
        try {
            serializedVibration = com.android.internal.hidden_from_bootclasspath.android.os.vibrator.Flags.normalizedPwleEffects() ? VibrationEffectSerializer.serialize(effect, serializerFlags) : LegacyVibrationEffectXmlSerializer.serialize(effect, serializerFlags);
            XmlValidator.checkSerializedVibration(serializedVibration, effect);
        }
        catch (XmlSerializerException e) {
            throw new SerializationFailedException(effect, (Throwable)e);
        }
        return serializedVibration;
    }

    private VibrationXmlSerializer() {
    }

    public static class SerializationFailedException
    extends IOException {
        private SerializationFailedException(VibrationEffect effect, Throwable cause) {
            super("Serialization failed for vibration effect " + effect, cause);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

