/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibratorInfo;
import android.os.vibrator.BasicPwleSegment;
import android.os.vibrator.PrebakedSegment;
import android.os.vibrator.PrimitiveSegment;
import android.os.vibrator.PwleSegment;
import android.os.vibrator.RampSegment;
import android.os.vibrator.StepSegment;
import com.android.internal.hidden_from_bootclasspath.android.os.vibrator.Flags;

public abstract class VibrationEffectSegment
implements Parcelable {
    static final int PARCEL_TOKEN_PREBAKED = 1;
    static final int PARCEL_TOKEN_PRIMITIVE = 2;
    static final int PARCEL_TOKEN_STEP = 3;
    static final int PARCEL_TOKEN_RAMP = 4;
    static final int PARCEL_TOKEN_PWLE = 5;
    static final int PARCEL_TOKEN_BASIC_PWLE = 6;
    @NonNull
    public static final Parcelable.Creator<VibrationEffectSegment> CREATOR = new Parcelable.Creator<VibrationEffectSegment>(){

        @Override
        public VibrationEffectSegment createFromParcel(Parcel in) {
            switch (in.readInt()) {
                case 3: {
                    return new StepSegment(in);
                }
                case 4: {
                    return new RampSegment(in);
                }
                case 1: {
                    return new PrebakedSegment(in);
                }
                case 2: {
                    return new PrimitiveSegment(in);
                }
                case 5: {
                    if (Flags.normalizedPwleEffects()) {
                        return new PwleSegment(in);
                    }
                }
                case 6: {
                    if (!Flags.normalizedPwleEffects()) break;
                    return new BasicPwleSegment(in);
                }
            }
            throw new IllegalStateException("Unexpected vibration event type token in parcel.");
        }

        public VibrationEffectSegment[] newArray(int size) {
            return new VibrationEffectSegment[size];
        }
    };

    VibrationEffectSegment() {
    }

    public abstract long getDuration();

    public long getDuration(@Nullable VibratorInfo vibratorInfo) {
        return this.getDuration();
    }

    public abstract boolean areVibrationFeaturesSupported(@NonNull VibratorInfo var1);

    public abstract boolean isHapticFeedbackCandidate();

    public abstract void validate();

    @NonNull
    public abstract <T extends VibrationEffectSegment> T resolve(int var1);

    @NonNull
    public abstract <T extends VibrationEffectSegment> T scale(float var1);

    @NonNull
    public abstract <T extends VibrationEffectSegment> T scaleLinearly(float var1);

    @NonNull
    public abstract <T extends VibrationEffectSegment> T applyEffectStrength(int var1);

    public abstract String toDebugString();

    public static void checkFrequencyArgument(float value, @NonNull String name) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(name + " must not be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException(name + " must not be infinite");
        }
        if (value < 0.0f) {
            throw new IllegalArgumentException(name + " must be >= 0, got " + value);
        }
    }

    public static void checkDurationArgument(long value, @NonNull String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + " must be >= 0, got " + value);
        }
    }

    protected static boolean amplitudeRequiresAmplitudeControl(float amplitude) {
        return amplitude != 0.0f && amplitude != 1.0f && amplitude != -1.0f;
    }

    protected static boolean frequencyRequiresFrequencyControl(float frequency) {
        return frequency != 0.0f;
    }
}

