/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import java.util.Objects;

@FlaggedApi(value="android.os.vibrator.haptic_feedback_with_custom_usage")
public class HapticFeedbackRequest {
    private final int mFeedbackConstant;
    private final int mUsage;
    private final int mFlags;

    private HapticFeedbackRequest(int feedbackConstant, int usage, int flags) {
        this.mFeedbackConstant = feedbackConstant;
        this.mUsage = usage;
        this.mFlags = flags;
    }

    public int getFeedbackConstant() {
        return this.mFeedbackConstant;
    }

    public int getUsage() {
        return this.mUsage;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HapticFeedbackRequest rhs = (HapticFeedbackRequest)o;
        return this.mFeedbackConstant == rhs.mFeedbackConstant && this.mUsage == rhs.mUsage && this.mFlags == rhs.mFlags;
    }

    public int hashCode() {
        return Objects.hash(this.mFeedbackConstant, this.mUsage, this.mFlags);
    }

    public static class Builder {
        private final int mFeedbackConstant;
        private int mUsage = 0;
        private int mFlags = 0;

        public Builder(int constant) {
            this.mFeedbackConstant = constant;
        }

        public Builder(@NonNull HapticFeedbackRequest request) {
            Objects.requireNonNull(request);
            this.mFeedbackConstant = request.mFeedbackConstant;
            this.mUsage = request.mUsage;
            this.mFlags = request.mFlags;
        }

        @NonNull
        public Builder setUsage(int usage) {
            this.mUsage = usage;
            return this;
        }

        @NonNull
        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        @NonNull
        public HapticFeedbackRequest build() {
            return new HapticFeedbackRequest(this.mFeedbackConstant, this.mUsage, this.mFlags);
        }
    }
}

