/*
 * Decompiled with CFR 0.152.
 */
package android.os.incremental;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.DataLoaderParams;
import android.content.pm.IDataLoaderStatusListener;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.incremental.IIncrementalService;
import android.os.incremental.IStorageHealthListener;
import android.os.incremental.IStorageLoadingProgressListener;
import android.os.incremental.IncrementalNewFileParams;
import android.os.incremental.PerUidReadTimeouts;
import android.os.incremental.StorageHealthCheckParams;
import android.os.incremental.V4Signature;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public class IncrementalStorage {
    private static final String TAG = "IncrementalStorage";
    private final int mId;
    private final IIncrementalService mService;
    private static final int UUID_BYTE_SIZE = 16;
    private static final int INCFS_MAX_HASH_SIZE = 32;
    private static final int INCFS_MAX_ADD_DATA_SIZE = 128;

    public IncrementalStorage(@NonNull IIncrementalService is, int id2) {
        this.mService = is;
        this.mId = id2;
    }

    public int getId() {
        return this.mId;
    }

    public void bind(@NonNull String targetPath) throws IOException {
        this.bind("", targetPath);
    }

    public void bind(@NonNull String sourcePath, @NonNull String targetPath) throws IOException {
        try {
            int res = this.mService.makeBindMount(this.mId, sourcePath, targetPath, 0);
            if (res < 0) {
                throw new IOException("bind() failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void bindPermanent(@NonNull String targetPath) throws IOException {
        this.bindPermanent("", targetPath);
    }

    public void bindPermanent(@NonNull String sourcePath, @NonNull String targetPath) throws IOException {
        try {
            int res = this.mService.makeBindMount(this.mId, sourcePath, targetPath, 1);
            if (res < 0) {
                throw new IOException("bind() permanent failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void unBind(@NonNull String targetPath) throws IOException {
        try {
            int res = this.mService.deleteBindMount(this.mId, targetPath);
            if (res < 0) {
                throw new IOException("unbind() failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void makeDirectory(@NonNull String path) throws IOException {
        try {
            int res = this.mService.makeDirectory(this.mId, path);
            if (res < 0) {
                throw new IOException("makeDirectory() failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void makeDirectories(@NonNull String path) throws IOException {
        try {
            int res = this.mService.makeDirectories(this.mId, path);
            if (res < 0) {
                throw new IOException("makeDirectory() failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void makeFile(@NonNull String path, long size, int mode, @Nullable UUID id2, @Nullable byte[] metadata, @Nullable byte[] v4signatureBytes, @Nullable byte[] content) throws IOException {
        try {
            if (id2 == null && metadata == null) {
                throw new IOException("File ID and metadata cannot both be null");
            }
            IncrementalStorage.validateV4Signature(v4signatureBytes);
            IncrementalNewFileParams params = new IncrementalNewFileParams();
            params.size = size;
            params.metadata = metadata == null ? new byte[]{} : metadata;
            params.fileId = IncrementalStorage.idToBytes(id2);
            params.signature = v4signatureBytes;
            int res = this.mService.makeFile(this.mId, path, mode, params, content);
            if (res != 0) {
                throw new IOException("makeFile() failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void makeFileFromRange(@NonNull String destPath, @NonNull String sourcePath, long rangeStart, long rangeEnd) throws IOException {
        try {
            int res = this.mService.makeFileFromRange(this.mId, destPath, sourcePath, rangeStart, rangeEnd);
            if (res < 0) {
                throw new IOException("makeFileFromRange() failed, errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void makeLink(@NonNull String sourcePath, IncrementalStorage destStorage, @NonNull String destPath) throws IOException {
        try {
            int res = this.mService.makeLink(this.mId, sourcePath, destStorage.getId(), destPath);
            if (res < 0) {
                throw new IOException("makeLink() failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void unlink(@NonNull String path) throws IOException {
        try {
            int res = this.mService.unlink(this.mId, path);
            if (res < 0) {
                throw new IOException("unlink() failed with errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void moveFile(@NonNull String sourcepath, @NonNull String destpath) throws IOException {
        try {
            int res = this.mService.makeLink(this.mId, sourcepath, this.mId, destpath);
            if (res < 0) {
                throw new IOException("moveFile() failed at makeLink(), errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        try {
            this.mService.unlink(this.mId, sourcepath);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void moveDir(@NonNull String sourcePath, @NonNull String destPath) throws IOException {
        if (!new File(destPath).exists()) {
            throw new IOException("moveDir() requires that destination dir already exists.");
        }
        try {
            int res = this.mService.makeBindMount(this.mId, sourcePath, destPath, 1);
            if (res < 0) {
                throw new IOException("moveDir() failed at making bind mount, errno " + -res);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        try {
            this.mService.deleteBindMount(this.mId, sourcePath);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean isFileFullyLoaded(@NonNull String path) throws IOException {
        try {
            int res = this.mService.isFileFullyLoaded(this.mId, path);
            if (res < 0) {
                throw new IOException("isFileFullyLoaded() failed, errno " + -res);
            }
            return res == 0;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean isFullyLoaded() throws IOException {
        try {
            int res = this.mService.isFullyLoaded(this.mId);
            if (res < 0) {
                throw new IOException("isFullyLoaded() failed at querying loading progress, errno " + -res);
            }
            return res == 0;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public float getLoadingProgress() throws IOException {
        try {
            float res = this.mService.getLoadingProgress(this.mId);
            if (res < 0.0f) {
                throw new IOException("getLoadingProgress() failed at querying loading progress, errno " + -res);
            }
            return res;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return 0.0f;
        }
    }

    @Nullable
    public byte[] getFileMetadata(@NonNull String path) {
        try {
            return this.mService.getMetadataByPath(this.mId, path);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    @Nullable
    public byte[] getFileMetadata(@NonNull UUID id2) {
        try {
            byte[] rawId = IncrementalStorage.idToBytes(id2);
            return this.mService.getMetadataById(this.mId, rawId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public boolean startLoading(@NonNull DataLoaderParams dataLoaderParams, @Nullable IDataLoaderStatusListener statusListener, @Nullable StorageHealthCheckParams healthCheckParams, @Nullable IStorageHealthListener healthListener, @NonNull PerUidReadTimeouts[] perUidReadTimeouts) {
        Objects.requireNonNull(perUidReadTimeouts);
        try {
            return this.mService.startLoading(this.mId, dataLoaderParams.getData(), statusListener, healthCheckParams, healthListener, perUidReadTimeouts);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public void onInstallationComplete() {
        try {
            this.mService.onInstallationComplete(this.mId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public static byte[] idToBytes(@Nullable UUID id2) {
        if (id2 == null) {
            return new byte[0];
        }
        ByteBuffer buf = ByteBuffer.wrap(new byte[16]);
        buf.putLong(id2.getMostSignificantBits());
        buf.putLong(id2.getLeastSignificantBits());
        return buf.array();
    }

    @NonNull
    public static UUID bytesToId(byte[] bytes) throws IllegalArgumentException {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Expected array of size 16, got " + bytes.length);
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        long msb = buf.getLong();
        long lsb = buf.getLong();
        return new UUID(msb, lsb);
    }

    public void disallowReadLogs() {
        try {
            this.mService.disallowReadLogs(this.mId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private static void validateV4Signature(@Nullable byte[] v4signatureBytes) throws IOException {
        V4Signature signature;
        if (v4signatureBytes == null || v4signatureBytes.length == 0) {
            return;
        }
        try {
            signature = V4Signature.readFrom(v4signatureBytes);
        }
        catch (IOException e) {
            throw new IOException("Failed to read v4 signature:", e);
        }
        if (!signature.isVersionSupported()) {
            throw new IOException("v4 signature version " + signature.version + " is not supported");
        }
        V4Signature.HashingInfo hashingInfo = V4Signature.HashingInfo.fromByteArray(signature.hashingInfo);
        V4Signature.SigningInfos signingInfos = V4Signature.SigningInfos.fromByteArray(signature.signingInfos);
        if (hashingInfo.hashAlgorithm != 1) {
            throw new IOException("Unsupported hashAlgorithm: " + hashingInfo.hashAlgorithm);
        }
        if (hashingInfo.log2BlockSize != 12) {
            throw new IOException("Unsupported log2BlockSize: " + hashingInfo.log2BlockSize);
        }
        if (hashingInfo.salt != null && hashingInfo.salt.length > 0) {
            throw new IOException("Unsupported salt: " + Arrays.toString(hashingInfo.salt));
        }
        if (hashingInfo.rawRootHash.length != 32) {
            throw new IOException("rawRootHash has to be 32 bytes");
        }
        if (signingInfos.signingInfo.additionalData.length > 128) {
            throw new IOException("additionalData has to be at most 128 bytes");
        }
    }

    public boolean configureNativeBinaries(String apkFullPath, String libDirRelativePath, String abi, boolean extractNativeLibs) {
        try {
            return this.mService.configureNativeBinaries(this.mId, apkFullPath, libDirRelativePath, abi, extractNativeLibs);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean waitForNativeBinariesExtraction() {
        try {
            return this.mService.waitForNativeBinariesExtraction(this.mId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean registerLoadingProgressListener(IStorageLoadingProgressListener listener) {
        try {
            return this.mService.registerLoadingProgressListener(this.mId, listener);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean unregisterLoadingProgressListener() {
        try {
            return this.mService.unregisterLoadingProgressListener(this.mId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public PersistableBundle getMetrics() {
        try {
            return this.mService.getMetrics(this.mId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }
}

