/*
 * Decompiled with CFR 0.152.
 */
package android.os.connectivity;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.BatteryStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.telephony.CellSignalStrength;
import android.telephony.ModemActivityInfo;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@RavenwoodKeepWholeClass
public class CellularBatteryStats
implements Parcelable {
    private final long mLoggingDurationMs;
    private final long mKernelActiveTimeMs;
    private final long mNumPacketsTx;
    private final long mNumBytesTx;
    private final long mNumPacketsRx;
    private final long mNumBytesRx;
    private final long mSleepTimeMs;
    private final long mIdleTimeMs;
    private final long mRxTimeMs;
    private final long mEnergyConsumedMaMs;
    private final long[] mTimeInRatMs;
    private final long[] mTimeInRxSignalStrengthLevelMs;
    private final long[] mTxTimeMs;
    private final long mMonitoredRailChargeConsumedMaMs;
    @NonNull
    public static final Parcelable.Creator<CellularBatteryStats> CREATOR = new Parcelable.Creator<CellularBatteryStats>(){

        @Override
        public CellularBatteryStats createFromParcel(Parcel in) {
            long loggingDurationMs = in.readLong();
            long kernelActiveTimeMs = in.readLong();
            long numPacketsTx = in.readLong();
            long numBytesTx = in.readLong();
            long numPacketsRx = in.readLong();
            long numBytesRx = in.readLong();
            long sleepTimeMs = in.readLong();
            long idleTimeMs = in.readLong();
            long rxTimeMs = in.readLong();
            long energyConsumedMaMs = in.readLong();
            long[] timeInRatMs = in.createLongArray();
            long[] timeInRxSignalStrengthLevelMs = in.createLongArray();
            long[] txTimeMs = in.createLongArray();
            long monitoredRailChargeConsumedMaMs = in.readLong();
            return new CellularBatteryStats(loggingDurationMs, kernelActiveTimeMs, numPacketsTx, numBytesTx, numPacketsRx, numBytesRx, sleepTimeMs, idleTimeMs, rxTimeMs, energyConsumedMaMs, timeInRatMs, timeInRxSignalStrengthLevelMs, txTimeMs, monitoredRailChargeConsumedMaMs);
        }

        public CellularBatteryStats[] newArray(int size) {
            return new CellularBatteryStats[size];
        }
    };

    @FlaggedApi(value="com.android.server.power.optimization.streamlined_connectivity_battery_stats")
    public CellularBatteryStats(long loggingDurationMs, long kernelActiveTimeMs, long numPacketsTx, long numBytesTx, long numPacketsRx, long numBytesRx, long sleepTimeMs, long idleTimeMs, long rxTimeMs, long energyConsumedMaMs, @NonNull long[] timeInRatMs, @NonNull long[] timeInRxSignalStrengthLevelMs, @NonNull long[] txTimeMs, long monitoredRailChargeConsumedMaMs) {
        this.mLoggingDurationMs = loggingDurationMs;
        this.mKernelActiveTimeMs = kernelActiveTimeMs;
        this.mNumPacketsTx = numPacketsTx;
        this.mNumBytesTx = numBytesTx;
        this.mNumPacketsRx = numPacketsRx;
        this.mNumBytesRx = numBytesRx;
        this.mSleepTimeMs = sleepTimeMs;
        this.mIdleTimeMs = idleTimeMs;
        this.mRxTimeMs = rxTimeMs;
        this.mEnergyConsumedMaMs = energyConsumedMaMs;
        this.mTimeInRatMs = Arrays.copyOfRange(timeInRatMs, 0, Math.min(timeInRatMs.length, BatteryStats.NUM_DATA_CONNECTION_TYPES));
        this.mTimeInRxSignalStrengthLevelMs = Arrays.copyOfRange(timeInRxSignalStrengthLevelMs, 0, Math.min(timeInRxSignalStrengthLevelMs.length, CellSignalStrength.getNumSignalStrengthLevels()));
        this.mTxTimeMs = Arrays.copyOfRange(txTimeMs, 0, Math.min(txTimeMs.length, ModemActivityInfo.getNumTxPowerLevels()));
        this.mMonitoredRailChargeConsumedMaMs = monitoredRailChargeConsumedMaMs;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeLong(this.mLoggingDurationMs);
        out.writeLong(this.mKernelActiveTimeMs);
        out.writeLong(this.mNumPacketsTx);
        out.writeLong(this.mNumBytesTx);
        out.writeLong(this.mNumPacketsRx);
        out.writeLong(this.mNumBytesRx);
        out.writeLong(this.mSleepTimeMs);
        out.writeLong(this.mIdleTimeMs);
        out.writeLong(this.mRxTimeMs);
        out.writeLong(this.mEnergyConsumedMaMs);
        out.writeLongArray(this.mTimeInRatMs);
        out.writeLongArray(this.mTimeInRxSignalStrengthLevelMs);
        out.writeLongArray(this.mTxTimeMs);
        out.writeLong(this.mMonitoredRailChargeConsumedMaMs);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof CellularBatteryStats)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        CellularBatteryStats otherStats = (CellularBatteryStats)other;
        return this.mLoggingDurationMs == otherStats.mLoggingDurationMs && this.mKernelActiveTimeMs == otherStats.mKernelActiveTimeMs && this.mNumPacketsTx == otherStats.mNumPacketsTx && this.mNumBytesTx == otherStats.mNumBytesTx && this.mNumPacketsRx == otherStats.mNumPacketsRx && this.mNumBytesRx == otherStats.mNumBytesRx && this.mSleepTimeMs == otherStats.mSleepTimeMs && this.mIdleTimeMs == otherStats.mIdleTimeMs && this.mRxTimeMs == otherStats.mRxTimeMs && this.mEnergyConsumedMaMs == otherStats.mEnergyConsumedMaMs && Arrays.equals(this.mTimeInRatMs, otherStats.mTimeInRatMs) && Arrays.equals(this.mTimeInRxSignalStrengthLevelMs, otherStats.mTimeInRxSignalStrengthLevelMs) && Arrays.equals(this.mTxTimeMs, otherStats.mTxTimeMs) && this.mMonitoredRailChargeConsumedMaMs == otherStats.mMonitoredRailChargeConsumedMaMs;
    }

    public int hashCode() {
        return Objects.hash(this.mLoggingDurationMs, this.mKernelActiveTimeMs, this.mNumPacketsTx, this.mNumBytesTx, this.mNumPacketsRx, this.mNumBytesRx, this.mSleepTimeMs, this.mIdleTimeMs, this.mRxTimeMs, this.mEnergyConsumedMaMs, Arrays.hashCode(this.mTimeInRatMs), Arrays.hashCode(this.mTimeInRxSignalStrengthLevelMs), Arrays.hashCode(this.mTxTimeMs), this.mMonitoredRailChargeConsumedMaMs);
    }

    public long getLoggingDurationMillis() {
        return this.mLoggingDurationMs;
    }

    public long getKernelActiveTimeMillis() {
        return this.mKernelActiveTimeMs;
    }

    public long getNumPacketsTx() {
        return this.mNumPacketsTx;
    }

    public long getNumBytesTx() {
        return this.mNumBytesTx;
    }

    public long getNumPacketsRx() {
        return this.mNumPacketsRx;
    }

    public long getNumBytesRx() {
        return this.mNumBytesRx;
    }

    public long getSleepTimeMillis() {
        return this.mSleepTimeMs;
    }

    public long getIdleTimeMillis() {
        return this.mIdleTimeMs;
    }

    public long getRxTimeMillis() {
        return this.mRxTimeMs;
    }

    public long getEnergyConsumedMaMillis() {
        return this.mEnergyConsumedMaMs;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public long getTimeInRatMicros(int networkType) {
        if (networkType >= this.mTimeInRatMs.length) {
            return -1L;
        }
        return this.mTimeInRatMs[networkType];
    }

    @SuppressLint(value={"MethodNameUnits"})
    public long getTimeInRxSignalStrengthLevelMicros(int signalStrengthBin) {
        if (signalStrengthBin >= this.mTimeInRxSignalStrengthLevelMs.length) {
            return -1L;
        }
        return this.mTimeInRxSignalStrengthLevelMs[signalStrengthBin];
    }

    @FlaggedApi(value="com.android.server.power.optimization.streamlined_connectivity_battery_stats")
    public long getTxTimeMillis(int level) {
        if (level >= this.mTxTimeMs.length) {
            return -1L;
        }
        return this.mTxTimeMs[level];
    }

    public long getMonitoredRailChargeConsumedMaMillis() {
        return this.mMonitoredRailChargeConsumedMaMs;
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

