/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.EventLogTags;
import android.os.IBinder;
import android.os.IServiceCallback;
import android.os.IServiceManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceDebugInfo;
import android.os.ServiceManager;
import android.os.ServiceManagerNative;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BinderInternal;
import com.android.internal.util.Preconditions;
import com.android.internal.util.StatLogger;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Map;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@RavenwoodKeepPartialClass
public class _Original_ServiceManager {
    private static final String TAG = "ServiceManager";
    private static final Object sLock = new Object();
    @UnsupportedAppUsage
    private static IServiceManager sServiceManager;
    @UnsupportedAppUsage
    private static Map<String, IBinder> sCache;
    @GuardedBy(value={"ServiceManager.class"})
    private static Map<String, IBinder> sCache$ravenwood;
    private static final int SLOW_LOG_INTERVAL_MS = 5000;
    private static final int STATS_LOG_INTERVAL_MS = 5000;
    private static final long GET_SERVICE_SLOW_THRESHOLD_US_CORE;
    private static final long GET_SERVICE_SLOW_THRESHOLD_US_NON_CORE;
    private static final int GET_SERVICE_LOG_EVERY_CALLS_CORE;
    private static final int GET_SERVICE_LOG_EVERY_CALLS_NON_CORE;
    @GuardedBy(value={"sLock"})
    private static int sGetServiceAccumulatedUs;
    @GuardedBy(value={"sLock"})
    private static int sGetServiceAccumulatedCallCount;
    @GuardedBy(value={"sLock"})
    private static long sLastStatsLogUptime;
    @GuardedBy(value={"sLock"})
    private static long sLastSlowLogUptime;
    @GuardedBy(value={"sLock"})
    private static long sLastSlowLogActualTime;
    public static final StatLogger sStatLogger;

    @UnsupportedAppUsage
    @RavenwoodKeep
    public _Original_ServiceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RavenwoodKeep
    public static void init$ravenwood() {
        Class<_Original_ServiceManager> clazz = _Original_ServiceManager.class;
        synchronized (_Original_ServiceManager.class) {
            sCache$ravenwood = new ArrayMap<String, IBinder>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RavenwoodKeep
    public static void reset$ravenwood() {
        Class<_Original_ServiceManager> clazz = _Original_ServiceManager.class;
        synchronized (_Original_ServiceManager.class) {
            sCache$ravenwood.clear();
            sCache$ravenwood = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @UnsupportedAppUsage
    private static IServiceManager getIServiceManager() {
        if (sServiceManager != null) {
            return sServiceManager;
        }
        sServiceManager = ServiceManagerNative.asInterface(Binder.allowBlocking(BinderInternal.getContextObject()));
        return sServiceManager;
    }

    @UnsupportedAppUsage
    @RavenwoodReplace
    public static IBinder getService(String name) {
        try {
            IBinder service = sCache.get(name);
            if (service != null) {
                return service;
            }
            return Binder.allowBlocking(_Original_ServiceManager.rawGetService(name));
        }
        catch (RemoteException e) {
            Log.e(TAG, "error in getService", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBinder getService$ravenwood(String name) {
        Class<_Original_ServiceManager> clazz = _Original_ServiceManager.class;
        synchronized (_Original_ServiceManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Preconditions.requireNonNullViaRavenwoodRule(sCache$ravenwood).get(name);
        }
    }

    @RavenwoodKeep
    public static IBinder getServiceOrThrow(String name) throws ServiceManager.ServiceNotFoundException {
        IBinder binder = _Original_ServiceManager.getService(name);
        if (binder != null) {
            return binder;
        }
        throw new ServiceNotFoundException(name);
    }

    @UnsupportedAppUsage
    @RavenwoodKeep
    public static void addService(String name, IBinder service) {
        _Original_ServiceManager.addService(name, service, false, 8);
    }

    @UnsupportedAppUsage
    @RavenwoodKeep
    public static void addService(String name, IBinder service, boolean allowIsolated) {
        _Original_ServiceManager.addService(name, service, allowIsolated, 8);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RavenwoodReplace
    public static void addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) {
        try {
            _Original_ServiceManager.getIServiceManager().addService(name, service, allowIsolated, dumpPriority);
        }
        catch (RemoteException e) {
            Log.e(TAG, "error in addService", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addService$ravenwood(String name, IBinder service, boolean allowIsolated, int dumpPriority) {
        Class<_Original_ServiceManager> clazz = _Original_ServiceManager.class;
        synchronized (_Original_ServiceManager.class) {
            Preconditions.requireNonNullViaRavenwoodRule(sCache$ravenwood).put(name, service);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @UnsupportedAppUsage
    public static IBinder checkService(String name) {
        try {
            IBinder service = sCache.get(name);
            if (service != null) {
                return service;
            }
            return Binder.allowBlocking(_Original_ServiceManager.getIServiceManager().checkService2((String)name).getServiceWithMetadata().service);
        }
        catch (RemoteException e) {
            Log.e(TAG, "error in checkService", e);
            return null;
        }
    }

    public static boolean isDeclared(@NonNull String name) {
        try {
            return _Original_ServiceManager.getIServiceManager().isDeclared(name);
        }
        catch (RemoteException | SecurityException e) {
            Log.e(TAG, "error in isDeclared", e);
            return false;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public static String[] getDeclaredInstances(@NonNull String iface) {
        try {
            return _Original_ServiceManager.getIServiceManager().getDeclaredInstances(iface);
        }
        catch (RemoteException e) {
            Log.e(TAG, "error in getDeclaredInstances", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public static IBinder waitForService(@NonNull String name) {
        return Binder.allowBlocking(_Original_ServiceManager.waitForServiceNative(name));
    }

    private static IBinder waitForServiceNative(@NonNull String string2) {
        return (IBinder)OverrideMethod.invokeA("android.os._Original_ServiceManager#waitForServiceNative(Ljava/lang/String;)Landroid/os/IBinder;", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @Nullable
    public static IBinder waitForDeclaredService(@NonNull String name) {
        return _Original_ServiceManager.isDeclared(name) ? _Original_ServiceManager.waitForService(name) : null;
    }

    public static void registerForNotifications(@NonNull String name, @NonNull IServiceCallback callback) throws RemoteException {
        _Original_ServiceManager.getIServiceManager().registerForNotifications(name, callback);
    }

    @UnsupportedAppUsage
    public static String[] listServices() {
        try {
            return _Original_ServiceManager.getIServiceManager().listServices(15);
        }
        catch (RemoteException e) {
            Log.e(TAG, "error in listServices", e);
            return null;
        }
    }

    public static ServiceDebugInfo[] getServiceDebugInfo() {
        try {
            return _Original_ServiceManager.getIServiceManager().getServiceDebugInfo();
        }
        catch (RemoteException e) {
            Log.e(TAG, "error in getServiceDebugInfo", e);
            return null;
        }
    }

    public static void initServiceCache(Map<String, IBinder> cache) {
        if (sCache.size() != 0) {
            throw new IllegalStateException("setServiceCache may only be called once");
        }
        sCache.putAll(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IBinder rawGetService(String name) throws RemoteException {
        long start = sStatLogger.getTime();
        IBinder binder = _Original_ServiceManager.getIServiceManager().getService2((String)name).getServiceWithMetadata().service;
        int time = (int)sStatLogger.logDurationStat(0, start);
        int myUid = Process.myUid();
        boolean isCore = UserHandle.isCore(myUid);
        long slowThreshold = isCore ? GET_SERVICE_SLOW_THRESHOLD_US_CORE : GET_SERVICE_SLOW_THRESHOLD_US_NON_CORE;
        Object object = sLock;
        synchronized (object) {
            int logInterval;
            sGetServiceAccumulatedUs += time;
            ++sGetServiceAccumulatedCallCount;
            long nowUptime = SystemClock.uptimeMillis();
            if ((long)time >= slowThreshold && (nowUptime > sLastSlowLogUptime + 5000L || sLastSlowLogActualTime < (long)time)) {
                EventLogTags.writeServiceManagerSlow(time / 1000, name);
                sLastSlowLogUptime = nowUptime;
                sLastSlowLogActualTime = time;
            }
            int n = logInterval = isCore ? GET_SERVICE_LOG_EVERY_CALLS_CORE : GET_SERVICE_LOG_EVERY_CALLS_NON_CORE;
            if (sGetServiceAccumulatedCallCount >= logInterval && nowUptime >= sLastStatsLogUptime + 5000L) {
                EventLogTags.writeServiceManagerStats(sGetServiceAccumulatedCallCount, sGetServiceAccumulatedUs / 1000, (int)(nowUptime - sLastStatsLogUptime));
                sGetServiceAccumulatedCallCount = 0;
                sGetServiceAccumulatedUs = 0;
                sLastStatsLogUptime = nowUptime;
            }
        }
        return binder;
    }

    static {
        sCache = new ArrayMap<String, IBinder>();
        GET_SERVICE_SLOW_THRESHOLD_US_CORE = SystemProperties.getInt("debug.servicemanager.slow_call_core_ms", 10) * 1000;
        GET_SERVICE_SLOW_THRESHOLD_US_NON_CORE = SystemProperties.getInt("debug.servicemanager.slow_call_ms", 50) * 1000;
        GET_SERVICE_LOG_EVERY_CALLS_CORE = SystemProperties.getInt("debug.servicemanager.log_calls_core", 100);
        GET_SERVICE_LOG_EVERY_CALLS_NON_CORE = SystemProperties.getInt("debug.servicemanager.log_calls", 200);
        sStatLogger = new StatLogger(new String[]{"getService()"});
    }

    @RavenwoodKeepWholeClass
    public static class ServiceNotFoundException
    extends Exception {
        public ServiceNotFoundException(String name) {
            super("No service published for: " + name);
        }
    }

    static interface Stats {
        public static final int GET_SERVICE = 0;
        public static final int COUNT = 1;
    }
}

