/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.Instrumentation;
import android.app.UiAutomation;
import android.os.ParcelFileDescriptor;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.util.Map;

public class VintfObject {
    private static final String LOG_TAG = "VintfObject";

    public static String[] report() {
        return (String[])OverrideMethod.invokeA("android.os.VintfObject#report()[Ljava/lang/String;", true, null);
    }

    public static int verifyBuildAtBoot() {
        return OverrideMethod.invokeI("android.os.VintfObject#verifyBuildAtBoot()I", true, null);
    }

    public static String[] getHalNamesAndVersions() {
        return (String[])OverrideMethod.invokeA("android.os.VintfObject#getHalNamesAndVersions()[Ljava/lang/String;", true, null);
    }

    public static String getSepolicyVersion() {
        return (String)OverrideMethod.invokeA("android.os.VintfObject#getSepolicyVersion()Ljava/lang/String;", true, null);
    }

    @NonNull
    public static String getPlatformSepolicyVersion() {
        return (String)OverrideMethod.invokeA("android.os.VintfObject#getPlatformSepolicyVersion()Ljava/lang/String;", true, null);
    }

    public static Map<String, String[]> getVndkSnapshots() {
        return (Map)OverrideMethod.invokeA("android.os.VintfObject#getVndkSnapshots()Ljava/util/Map;", true, null);
    }

    public static Long getTargetFrameworkCompatibilityMatrixVersion() {
        return (Long)OverrideMethod.invokeA("android.os.VintfObject#getTargetFrameworkCompatibilityMatrixVersion()Ljava/lang/Long;", true, null);
    }

    @Nullable
    private static String runShellCommand(@NonNull String command) throws IOException {
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        Instrumentation instrumentation = activityThread.getInstrumentation();
        UiAutomation automation = instrumentation.getUiAutomation();
        ParcelFileDescriptor pfd = automation.executeShellCommand(command);
        try (ParcelFileDescriptor.AutoCloseInputStream is = new ParcelFileDescriptor.AutoCloseInputStream(pfd);){
            String string2 = new String(is.readAllBytes());
            return string2;
        }
    }

    private VintfObject() {
    }

    static {
        System_Delegate.loadLibrary("vintf_jni");
    }
}

