/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.ServiceManager;

public class TelephonyServiceManager {
    @NonNull
    public ServiceRegisterer getTelephonyServiceRegisterer() {
        return new ServiceRegisterer("phone");
    }

    @NonNull
    public ServiceRegisterer getTelephonyImsServiceRegisterer() {
        return new ServiceRegisterer("telephony_ims");
    }

    @NonNull
    public ServiceRegisterer getTelephonyRcsMessageServiceRegisterer() {
        return new ServiceRegisterer("ircsmessage");
    }

    @NonNull
    public ServiceRegisterer getSubscriptionServiceRegisterer() {
        return new ServiceRegisterer("isub");
    }

    @NonNull
    public ServiceRegisterer getPhoneSubServiceRegisterer() {
        return new ServiceRegisterer("iphonesubinfo");
    }

    @NonNull
    public ServiceRegisterer getOpportunisticNetworkServiceRegisterer() {
        return new ServiceRegisterer("ions");
    }

    @NonNull
    public ServiceRegisterer getCarrierConfigServiceRegisterer() {
        return new ServiceRegisterer("carrier_config");
    }

    @NonNull
    public ServiceRegisterer getSmsServiceRegisterer() {
        return new ServiceRegisterer("isms");
    }

    @NonNull
    public ServiceRegisterer getEuiccControllerService() {
        return new ServiceRegisterer("econtroller");
    }

    @NonNull
    public ServiceRegisterer getEuiccCardControllerServiceRegisterer() {
        return new ServiceRegisterer("euicc_card_controller");
    }

    @NonNull
    public ServiceRegisterer getIccPhoneBookServiceRegisterer() {
        return new ServiceRegisterer("simphonebook");
    }

    public static class ServiceRegisterer {
        private final String mServiceName;

        public ServiceRegisterer(String serviceName) {
            this.mServiceName = serviceName;
        }

        public void register(@NonNull IBinder service) {
            ServiceManager.addService(this.mServiceName, service);
        }

        @Nullable
        public IBinder get() {
            return ServiceManager.getService(this.mServiceName);
        }

        @NonNull
        public IBinder getOrThrow() throws ServiceNotFoundException {
            try {
                return ServiceManager.getServiceOrThrow(this.mServiceName);
            }
            catch (ServiceManager.ServiceNotFoundException e) {
                throw new ServiceNotFoundException(this.mServiceName);
            }
        }

        @Nullable
        public IBinder tryGet() {
            return ServiceManager.checkService(this.mServiceName);
        }
    }

    public static class ServiceNotFoundException
    extends ServiceManager.ServiceNotFoundException {
        public ServiceNotFoundException(@NonNull String name) {
            super(name);
        }
    }
}

