/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.CombinedVibration;
import android.os.ICancellationSignal;
import android.os.IVibratorManagerService;
import android.os.IVibratorStateListener;
import android.os.NullVibrator;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Trace;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import android.os.VibratorManager;
import android.os.vibrator.IVibrationSession;
import android.os.vibrator.IVibrationSessionCallback;
import android.os.vibrator.VendorVibrationSession;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SystemVibratorManager
extends VibratorManager {
    private static final String TAG = "VibratorManager";
    private final IVibratorManagerService mService;
    private final Context mContext;
    private final int mUid;
    private final Binder mToken = new Binder();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private int[] mVibratorIds;
    @GuardedBy(value={"mLock"})
    private int mCapabilities;
    @GuardedBy(value={"mLock"})
    private final SparseArray<Vibrator> mVibrators = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> mListeners = new ArrayMap();

    public SystemVibratorManager(Context context) {
        super(context);
        this.mContext = context;
        this.mUid = Process.myUid();
        this.mService = IVibratorManagerService.Stub.asInterface(ServiceManager.getService("vibrator_manager"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public int[] getVibratorIds() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVibratorIds != null) {
                return this.mVibratorIds;
            }
            try {
                if (this.mService != null) {
                    this.mVibratorIds = this.mService.getVibratorIds();
                    return this.mVibratorIds;
                }
                Log.w(TAG, "Failed to retrieve vibrator ids; no vibrator manager service.");
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
            return new int[0];
        }
    }

    @Override
    public boolean hasCapabilities(int capabilities) {
        return (this.getCapabilities() & capabilities) == capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Vibrator getVibrator(int vibratorId) {
        Object object = this.mLock;
        synchronized (object) {
            Vibrator vibrator = this.mVibrators.get(vibratorId);
            if (vibrator != null) {
                return vibrator;
            }
            VibratorInfo info = null;
            try {
                if (this.mService == null) {
                    Log.w(TAG, "Failed to retrieve vibrator; no vibrator manager service.");
                } else {
                    info = this.mService.getVibratorInfo(vibratorId);
                }
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
            if (info != null) {
                vibrator = new SingleVibrator(info);
                this.mVibrators.put(vibratorId, vibrator);
            } else {
                vibrator = NullVibrator.getInstance();
            }
            return vibrator;
        }
    }

    @Override
    @NonNull
    public Vibrator getDefaultVibrator() {
        return this.mContext.getSystemService(Vibrator.class);
    }

    @Override
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, @Nullable CombinedVibration effect, @Nullable VibrationAttributes attributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to set always-on effect; no vibrator manager service.");
            return false;
        }
        try {
            return this.mService.setAlwaysOnEffect(uid, opPkg, alwaysOnId, effect, attributes);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to set always-on effect.", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vibrate(int uid, String opPkg, @NonNull CombinedVibration effect, String reason, @Nullable VibrationAttributes attributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager service.");
            return;
        }
        Trace.traceBegin(0x800000L, "vibrate");
        try {
            this.mService.vibrate(uid, this.mContext.getDeviceId(), opPkg, effect, attributes, reason, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to vibrate.", e);
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performHapticFeedback(int constant, int usage, String reason, int flags, int privFlags) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to perform haptic feedback; no vibrator manager service.");
            return;
        }
        Trace.traceBegin(0x800000L, "performHapticFeedback");
        try {
            this.mService.performHapticFeedback(this.mUid, this.mContext.getDeviceId(), this.mPackageName, constant, usage, reason, flags, privFlags);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to perform haptic feedback.", e);
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performHapticFeedbackForInputDevice(int constant, int inputDeviceId, int inputSource, String reason, int flags, int privFlags) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to perform haptic feedback for input device; no vibrator manager service.");
            return;
        }
        Trace.traceBegin(0x800000L, "performHapticFeedbackForInputDevice");
        try {
            this.mService.performHapticFeedbackForInputDevice(this.mUid, this.mContext.getDeviceId(), this.mPackageName, constant, inputDeviceId, inputSource, reason, flags, privFlags);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to perform haptic feedback for input device.", e);
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    @Override
    public void cancel() {
        this.cancelVibration(-1);
    }

    @Override
    public void cancel(int usageFilter) {
        this.cancelVibration(usageFilter);
    }

    @Override
    public void startVendorSession(@NonNull int[] vibratorIds, @NonNull VibrationAttributes attrs, @Nullable String reason, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull VendorVibrationSession.Callback callback) {
        Objects.requireNonNull(vibratorIds);
        VendorVibrationSessionCallbackDelegate callbackDelegate = new VendorVibrationSessionCallbackDelegate(executor, callback);
        if (this.mService == null) {
            Log.w(TAG, "Failed to start vibration session; no vibrator manager service.");
            callbackDelegate.onFinished(3);
            return;
        }
        try {
            ICancellationSignal remoteCancellationSignal = this.mService.startVendorVibrationSession(this.mUid, this.mContext.getDeviceId(), this.mPackageName, vibratorIds, attrs, reason, callbackDelegate);
            if (cancellationSignal != null) {
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to start vibration session.", e);
            callbackDelegate.onFinished(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCapabilities() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCapabilities != 0) {
                return this.mCapabilities;
            }
            try {
                if (this.mService != null) {
                    this.mCapabilities = this.mService.getCapabilities();
                    return this.mCapabilities;
                }
                Log.w(TAG, "Failed to retrieve vibrator manager capabilities; no vibrator manager service.");
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
            return 0;
        }
    }

    private void cancelVibration(int usageFilter) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to cancel vibration; no vibrator manager service.");
            return;
        }
        try {
            this.mService.cancelVibrate(usageFilter, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to cancel vibration.", e);
        }
    }

    private class SingleVibrator
    extends Vibrator {
        private final VibratorInfo mVibratorInfo;
        private final int[] mVibratorId;

        SingleVibrator(VibratorInfo vibratorInfo) {
            this.mVibratorInfo = vibratorInfo;
            this.mVibratorId = new int[]{this.mVibratorInfo.getId()};
        }

        @Override
        public VibratorInfo getInfo() {
            return this.mVibratorInfo;
        }

        @Override
        public boolean hasVibrator() {
            return true;
        }

        @Override
        public boolean hasAmplitudeControl() {
            return this.mVibratorInfo.hasAmplitudeControl();
        }

        @Override
        public boolean areVendorSessionsSupported() {
            return SystemVibratorManager.this.hasCapabilities(256);
        }

        @Override
        public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, @Nullable VibrationEffect effect, @Nullable VibrationAttributes attrs) {
            CombinedVibration combined = CombinedVibration.startParallel().addVibrator(this.mVibratorInfo.getId(), effect).combine();
            return SystemVibratorManager.this.setAlwaysOnEffect(uid, opPkg, alwaysOnId, combined, attrs);
        }

        @Override
        public void vibrate(int uid, String opPkg, @NonNull VibrationEffect vibe, String reason, @NonNull VibrationAttributes attributes) {
            CombinedVibration combined = CombinedVibration.startParallel().addVibrator(this.mVibratorInfo.getId(), vibe).combine();
            SystemVibratorManager.this.vibrate(uid, opPkg, combined, reason, attributes);
        }

        @Override
        public void performHapticFeedback(int effectId, int usage, String reason, int flags, int privFlags) {
            SystemVibratorManager.this.performHapticFeedback(effectId, usage, reason, flags, privFlags);
        }

        @Override
        public void cancel() {
            SystemVibratorManager.this.cancel();
        }

        @Override
        public void cancel(int usageFilter) {
            SystemVibratorManager.this.cancel(usageFilter);
        }

        @Override
        public boolean isVibrating() {
            if (SystemVibratorManager.this.mService == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to check status of vibrator " + this.mVibratorInfo.getId() + "; no vibrator service.");
                return false;
            }
            try {
                return SystemVibratorManager.this.mService.isVibrating(this.mVibratorInfo.getId());
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
                return false;
            }
        }

        @Override
        public void addVibratorStateListener(@NonNull Vibrator.OnVibratorStateChangedListener listener) {
            Objects.requireNonNull(listener);
            if (SystemVibratorManager.this.mContext == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to add vibrate state listener; no vibrator context.");
                return;
            }
            this.addVibratorStateListener(SystemVibratorManager.this.mContext.getMainExecutor(), listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addVibratorStateListener(@NonNull Executor executor, @NonNull Vibrator.OnVibratorStateChangedListener listener) {
            Objects.requireNonNull(listener);
            Objects.requireNonNull(executor);
            if (SystemVibratorManager.this.mService == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to add vibrate state listener to vibrator " + this.mVibratorInfo.getId() + "; no vibrator service.");
                return;
            }
            Object object = SystemVibratorManager.this.mLock;
            synchronized (object) {
                if (SystemVibratorManager.this.mListeners.containsKey(listener)) {
                    Log.w(SystemVibratorManager.TAG, "Listener already registered.");
                    return;
                }
                try {
                    OnVibratorStateChangedListenerDelegate delegate = new OnVibratorStateChangedListenerDelegate(listener, executor);
                    if (!SystemVibratorManager.this.mService.registerVibratorStateListener(this.mVibratorInfo.getId(), delegate)) {
                        Log.w(SystemVibratorManager.TAG, "Failed to add vibrate state listener to vibrator " + this.mVibratorInfo.getId());
                        return;
                    }
                    SystemVibratorManager.this.mListeners.put(listener, delegate);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeVibratorStateListener(@NonNull Vibrator.OnVibratorStateChangedListener listener) {
            Objects.requireNonNull(listener);
            if (SystemVibratorManager.this.mService == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to remove vibrate state listener from vibrator " + this.mVibratorInfo.getId() + "; no vibrator service.");
                return;
            }
            Object object = SystemVibratorManager.this.mLock;
            synchronized (object) {
                if (SystemVibratorManager.this.mListeners.containsKey(listener)) {
                    OnVibratorStateChangedListenerDelegate delegate = SystemVibratorManager.this.mListeners.get(listener);
                    try {
                        if (!SystemVibratorManager.this.mService.unregisterVibratorStateListener(this.mVibratorInfo.getId(), delegate)) {
                            Log.w(SystemVibratorManager.TAG, "Failed to remove vibrate state listener from vibrator " + this.mVibratorInfo.getId());
                            return;
                        }
                        SystemVibratorManager.this.mListeners.remove(listener);
                    }
                    catch (RemoteException e) {
                        e.rethrowFromSystemServer();
                    }
                }
            }
        }

        @Override
        public void startVendorSession(@NonNull VibrationAttributes attrs, String reason, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull VendorVibrationSession.Callback callback) {
            SystemVibratorManager.this.startVendorSession(this.mVibratorId, attrs, reason, cancellationSignal, executor, callback);
        }
    }

    private static class VendorVibrationSessionCallbackDelegate
    extends IVibrationSessionCallback.Stub {
        private final Executor mExecutor;
        private final VendorVibrationSession.Callback mCallback;

        VendorVibrationSessionCallbackDelegate(@NonNull Executor executor, @NonNull VendorVibrationSession.Callback callback) {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(callback);
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onStarted(IVibrationSession session) {
            this.mExecutor.execute(() -> this.mCallback.onStarted(new VendorVibrationSession(session)));
        }

        @Override
        public void onFinishing() {
            this.mExecutor.execute(() -> this.mCallback.onFinishing());
        }

        @Override
        public void onFinished(int status) {
            this.mExecutor.execute(() -> this.mCallback.onFinished(status));
        }
    }

    private static class OnVibratorStateChangedListenerDelegate
    extends IVibratorStateListener.Stub {
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mListener;

        OnVibratorStateChangedListenerDelegate(@NonNull Vibrator.OnVibratorStateChangedListener listener, @NonNull Executor executor) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onVibrating(boolean isVibrating) {
            this.mExecutor.execute(() -> this.mListener.onVibratorStateChanged(isVibrating));
        }
    }
}

