/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Debug;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import android.util.Slog;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@RavenwoodKeepWholeClass
public class RemoteCallbackList<E extends IInterface> {
    private static final String TAG = "RemoteCallbackList";
    private static final int DEFAULT_MAX_QUEUE_SIZE = 1000;
    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public static final int FROZEN_CALLEE_POLICY_UNSET = 0;
    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public static final int FROZEN_CALLEE_POLICY_ENQUEUE_ALL = 1;
    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public static final int FROZEN_CALLEE_POLICY_ENQUEUE_MOST_RECENT = 2;
    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public static final int FROZEN_CALLEE_POLICY_DROP = 3;
    @UnsupportedAppUsage
    ArrayMap<IBinder, Interface> mInterfaces = new ArrayMap();
    private Object[] mActiveBroadcast;
    private int mBroadcastCount = -1;
    private boolean mKilled = false;
    private StringBuilder mRecentCallers;
    private final int mFrozenCalleePolicy;
    private final int mMaxQueueSize;
    private final Executor mExecutor;

    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public int getFrozenCalleePolicy() {
        return this.mFrozenCalleePolicy;
    }

    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public int getMaxQueueSize() {
        return this.mMaxQueueSize;
    }

    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    @Nullable
    public Executor getExecutor() {
        return this.mExecutor;
    }

    public RemoteCallbackList() {
        this(0, 1000, null);
    }

    private RemoteCallbackList(int frozenCalleePolicy, int maxQueueSize, Executor executor) {
        this.mFrozenCalleePolicy = frozenCalleePolicy;
        this.mMaxQueueSize = maxQueueSize;
        this.mExecutor = executor;
    }

    public boolean register(E callbackInterface) {
        return this.register(callbackInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(E callbackInterface, Object cookie) {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return false;
            }
            this.logExcessiveInterfaces();
            IBinder binder = callbackInterface.asBinder();
            try {
                Interface i = new Interface(this, callbackInterface, cookie);
                this.unregister(callbackInterface);
                binder.linkToDeath(i, 0);
                i.maybeSubscribeToFrozenCallback();
                this.mInterfaces.put(binder, i);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(E callbackInterface) {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            Interface i = this.mInterfaces.remove(callbackInterface.asBinder());
            if (i != null) {
                i.mInterface.asBinder().unlinkToDeath(i, 0);
                i.maybeUnsubscribeFromFrozenCallback();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            for (int cbi = this.mInterfaces.size() - 1; cbi >= 0; --cbi) {
                Interface i = this.mInterfaces.valueAt(cbi);
                i.mInterface.asBinder().unlinkToDeath(i, 0);
                i.maybeUnsubscribeFromFrozenCallback();
            }
            this.mInterfaces.clear();
            this.mKilled = true;
        }
    }

    public void onCallbackDied(E callbackInterface) {
    }

    public void onCallbackDied(E callbackInterface, Object cookie) {
        this.onCallbackDied(callbackInterface);
    }

    public int beginBroadcast() {
        if (this.mFrozenCalleePolicy != 0) {
            throw new UnsupportedOperationException();
        }
        return this.beginBroadcastInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int beginBroadcastInternal() {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            if (this.mBroadcastCount > 0) {
                throw new IllegalStateException("beginBroadcast() called while already in a broadcast");
            }
            this.mBroadcastCount = this.mInterfaces.size();
            int n = this.mBroadcastCount;
            if (n <= 0) {
                return 0;
            }
            Object[] active = this.mActiveBroadcast;
            if (active == null || active.length < n) {
                this.mActiveBroadcast = active = new Object[n];
            }
            for (int i = 0; i < n; ++i) {
                active[i] = this.mInterfaces.valueAt(i);
            }
            return n;
        }
    }

    public E getBroadcastItem(int index) {
        return ((Interface)this.mActiveBroadcast[index]).mInterface;
    }

    public Object getBroadcastCookie(int index) {
        return ((Interface)this.mActiveBroadcast[index]).mCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBroadcast() {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            if (this.mBroadcastCount < 0) {
                throw new IllegalStateException("finishBroadcast() called outside of a broadcast");
            }
            Object[] active = this.mActiveBroadcast;
            if (active != null) {
                int N2 = this.mBroadcastCount;
                for (int i = 0; i < N2; ++i) {
                    active[i] = null;
                }
            }
            this.mBroadcastCount = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public void broadcast(@NonNull Consumer<E> callback) {
        int itemCount = this.beginBroadcastInternal();
        try {
            for (int i = 0; i < itemCount; ++i) {
                ((Interface)this.mActiveBroadcast[i]).addCallback(callback);
            }
        }
        finally {
            this.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> void broadcastForEachCookie(Consumer<C> callback) {
        int itemCount = this.beginBroadcast();
        try {
            for (int i = 0; i < itemCount; ++i) {
                callback.accept(this.getBroadcastCookie(i));
            }
        }
        finally {
            this.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> void broadcast(BiConsumer<E, C> callback) {
        int itemCount = this.beginBroadcast();
        try {
            for (int i = 0; i < itemCount; ++i) {
                callback.accept(this.getBroadcastItem(i), this.getBroadcastCookie(i));
            }
        }
        finally {
            this.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRegisteredCallbackCount() {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return 0;
            }
            return this.mInterfaces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getRegisteredCallbackItem(int index) {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return null;
            }
            return this.mInterfaces.valueAt((int)index).mInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRegisteredCallbackCookie(int index) {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            if (this.mKilled) {
                return null;
            }
            return this.mInterfaces.valueAt((int)index).mCookie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        ArrayMap<IBinder, Interface> arrayMap = this.mInterfaces;
        synchronized (arrayMap) {
            pw.print(prefix);
            pw.print("callbacks: ");
            pw.println(this.mInterfaces.size());
            pw.print(prefix);
            pw.print("killed: ");
            pw.println(this.mKilled);
            pw.print(prefix);
            pw.print("broadcasts count: ");
            pw.println(this.mBroadcastCount);
        }
    }

    private void logExcessiveInterfaces() {
        long size = this.mInterfaces.size();
        long TOO_MANY = 3000L;
        long MAX_CHARS = 1000L;
        if (size >= 3000L) {
            if (size == 3000L && this.mRecentCallers == null) {
                this.mRecentCallers = new StringBuilder();
            }
            if (this.mRecentCallers != null && (long)this.mRecentCallers.length() < 1000L) {
                this.mRecentCallers.append(Debug.getCallers(5));
                this.mRecentCallers.append('\n');
                if ((long)this.mRecentCallers.length() >= 1000L) {
                    Slog.wtf(TAG, "More than 3000 remote callbacks registered. Recent callers:\n" + this.mRecentCallers.toString());
                    this.mRecentCallers = null;
                }
            }
        }
    }

    private static class Interface
    implements IBinder.DeathRecipient,
    IBinder.FrozenStateChangeCallback {
        final IBinder mBinder;
        final E mInterface;
        final Object mCookie;
        final Queue<Consumer<E>> mCallbackQueue;
        int mCurrentState = 1;
        final /* synthetic */ RemoteCallbackList this$0;

        Interface(E callbackInterface, Object cookie) {
            this.this$0 = var1_1;
            this.mBinder = callbackInterface.asBinder();
            this.mInterface = callbackInterface;
            this.mCookie = cookie;
            this.mCallbackQueue = var1_1.mFrozenCalleePolicy == 1 || var1_1.mFrozenCalleePolicy == 2 ? new ConcurrentLinkedQueue() : null;
        }

        @Override
        public synchronized void onFrozenStateChanged(@NonNull IBinder who, int state) {
            if (state == 1 && this.mCallbackQueue != null) {
                while (!this.mCallbackQueue.isEmpty()) {
                    Consumer callback = this.mCallbackQueue.poll();
                    callback.accept(this.mInterface);
                }
            }
            this.mCurrentState = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addCallback(@NonNull Consumer<E> callback) {
            if (this.this$0.mFrozenCalleePolicy == 0) {
                callback.accept(this.mInterface);
                return;
            }
            Interface interface_ = this;
            synchronized (interface_) {
                if (this.mCurrentState == 1) {
                    callback.accept(this.mInterface);
                    return;
                }
                switch (this.this$0.mFrozenCalleePolicy) {
                    case 1: {
                        if (this.mCallbackQueue.size() >= this.this$0.mMaxQueueSize) {
                            this.mCallbackQueue.poll();
                        }
                        this.mCallbackQueue.offer(callback);
                        break;
                    }
                    case 2: {
                        this.mCallbackQueue.clear();
                        this.mCallbackQueue.offer(callback);
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }

        void maybeSubscribeToFrozenCallback() throws RemoteException {
            if (this.this$0.mFrozenCalleePolicy != 0) {
                try {
                    this.mBinder.addFrozenStateChangeCallback(this.this$0.mExecutor, this);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }

        void maybeUnsubscribeFromFrozenCallback() {
            if (this.this$0.mFrozenCalleePolicy != 0) {
                try {
                    this.mBinder.removeFrozenStateChangeCallback(this);
                }
                catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ArrayMap<IBinder, Interface> arrayMap = this.this$0.mInterfaces;
            synchronized (arrayMap) {
                this.this$0.mInterfaces.remove(this.mBinder);
                this.maybeUnsubscribeFromFrozenCallback();
            }
            this.this$0.onCallbackDied(this.mInterface, this.mCookie);
        }
    }

    @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
    public static class Builder<E extends IInterface> {
        private int mFrozenCalleePolicy;
        private int mMaxQueueSize = 1000;
        private InterfaceDiedCallback mInterfaceDiedCallback;
        private Executor mExecutor;

        public Builder(int frozenCalleePolicy) {
            this.mFrozenCalleePolicy = frozenCalleePolicy;
        }

        @NonNull
        public Builder setMaxQueueSize(int maxQueueSize) {
            if (maxQueueSize <= 0) {
                throw new IllegalArgumentException("maxQueueSize must be positive");
            }
            if (this.mFrozenCalleePolicy != 1) {
                throw new UnsupportedOperationException("setMaxQueueSize can only be called for FROZEN_CALLEE_POLICY_ENQUEUE_ALL");
            }
            this.mMaxQueueSize = maxQueueSize;
            return this;
        }

        @NonNull
        public Builder setInterfaceDiedCallback(@NonNull InterfaceDiedCallback<E> callback) {
            this.mInterfaceDiedCallback = callback;
            return this;
        }

        @NonNull
        public Builder setExecutor(@NonNull Executor executor) {
            this.mExecutor = executor;
            return this;
        }

        @NonNull
        public RemoteCallbackList<E> build() {
            Executor executor = this.mExecutor;
            if (executor == null && this.mFrozenCalleePolicy != 0) {
                executor = new HandlerExecutor(Handler.getMain());
            }
            if (this.mInterfaceDiedCallback != null) {
                return new RemoteCallbackList<E>(this.mFrozenCalleePolicy, this.mMaxQueueSize, executor){

                    @Override
                    public void onCallbackDied(E deadInterface, Object cookie) {
                        mInterfaceDiedCallback.onInterfaceDied(this, deadInterface, cookie);
                    }
                };
            }
            return new RemoteCallbackList(this.mFrozenCalleePolicy, this.mMaxQueueSize, executor);
        }

        @FlaggedApi(value="android.os.binder_frozen_state_change_callback")
        public static interface InterfaceDiedCallback<E extends IInterface> {
            public void onInterfaceDied(@NonNull RemoteCallbackList<E> var1, E var2, @Nullable Object var3);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface FrozenCalleePolicy {
    }
}

