/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.hardware.display.DisplayManager;
import android.os.ConditionVariable;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IRecoverySystem;
import android.os.IRecoverySystemProgressListener;
import android.os.IVold;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.euicc.EuiccManager;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class RecoverySystem {
    private static final String TAG = "RecoverySystem";
    private static final File DEFAULT_KEYSTORE = new File("/system/etc/security/otacerts.zip");
    private static final long PUBLISH_PROGRESS_INTERVAL_MS = 500L;
    private static final long DEFAULT_EUICC_FACTORY_RESET_TIMEOUT_MILLIS = 30000L;
    private static final long MIN_EUICC_FACTORY_RESET_TIMEOUT_MILLIS = 5000L;
    private static final long MAX_EUICC_FACTORY_RESET_TIMEOUT_MILLIS = 60000L;
    private static final long DEFAULT_EUICC_REMOVING_INVISIBLE_PROFILES_TIMEOUT_MILLIS = 45000L;
    private static final long MIN_EUICC_REMOVING_INVISIBLE_PROFILES_TIMEOUT_MILLIS = 15000L;
    private static final long MAX_EUICC_REMOVING_INVISIBLE_PROFILES_TIMEOUT_MILLIS = 90000L;
    private static final File RECOVERY_DIR = new File("/cache/recovery");
    private static final File LOG_FILE = new File(RECOVERY_DIR, "log");
    private static final String LAST_INSTALL_PATH = "last_install";
    private static final String LAST_PREFIX = "last_";
    private static final String ACTION_EUICC_FACTORY_RESET = "com.android.internal.action.EUICC_FACTORY_RESET";
    private static final String ACTION_EUICC_REMOVE_INVISIBLE_SUBSCRIPTIONS = "com.android.internal.action.EUICC_REMOVE_INVISIBLE_SUBSCRIPTIONS";
    private static final String PACKAGE_NAME_EUICC_DATA_MANAGEMENT_CALLBACK = "android";
    public static final File BLOCK_MAP_FILE = new File(RECOVERY_DIR, "block.map");
    public static final File UNCRYPT_PACKAGE_FILE = new File(RECOVERY_DIR, "uncrypt_file");
    public static final File UNCRYPT_STATUS_FILE = new File(RECOVERY_DIR, "uncrypt_status");
    private static final int LOG_FILE_MAX_LENGTH = 65536;
    private static final Object sRequestLock = new Object();
    private final IRecoverySystem mService;
    public static final int RESUME_ON_REBOOT_REBOOT_ERROR_NONE = 0;
    @SystemApi
    public static final int RESUME_ON_REBOOT_REBOOT_ERROR_UNSPECIFIED = 1000;
    @SystemApi
    public static final int RESUME_ON_REBOOT_REBOOT_ERROR_INVALID_PACKAGE_NAME = 2000;
    @SystemApi
    public static final int RESUME_ON_REBOOT_REBOOT_ERROR_LSKF_NOT_CAPTURED = 3000;
    @SystemApi
    public static final int RESUME_ON_REBOOT_REBOOT_ERROR_SLOT_MISMATCH = 4000;
    @SystemApi
    public static final int RESUME_ON_REBOOT_REBOOT_ERROR_PROVIDER_PREPARATION_FAILURE = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<X509Certificate> getTrustedCerts(File keystore) throws IOException, GeneralSecurityException {
        HashSet<X509Certificate> trusted = new HashSet<X509Certificate>();
        if (keystore == null) {
            keystore = DEFAULT_KEYSTORE;
        }
        try (ZipFile zip = new ZipFile(keystore);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                try (InputStream is = zip.getInputStream(entry);){
                    trusted.add((X509Certificate)cf.generateCertificate(is));
                }
            }
        }
        return trusted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyPackage(File packageFile, ProgressListener listener, File deviceCertsZipFile) throws IOException, GeneralSecurityException {
        final long fileLen = packageFile.length();
        try (final RandomAccessFile raf = new RandomAccessFile(packageFile, "r");){
            final long startTimeMillis = System_Delegate.currentTimeMillis();
            if (listener != null) {
                listener.onProgress(0);
            }
            raf.seek(fileLen - 6L);
            byte[] footer = new byte[6];
            raf.readFully(footer);
            if (footer[2] != -1 || footer[3] != -1) {
                throw new SignatureException("no signature in file (no footer)");
            }
            final int commentSize = footer[4] & 0xFF | (footer[5] & 0xFF) << 8;
            int signatureStart = footer[0] & 0xFF | (footer[1] & 0xFF) << 8;
            byte[] eocd = new byte[commentSize + 22];
            raf.seek(fileLen - (long)(commentSize + 22));
            raf.readFully(eocd);
            if (eocd[0] != 80 || eocd[1] != 75 || eocd[2] != 5 || eocd[3] != 6) {
                throw new SignatureException("no signature in file (bad footer)");
            }
            for (int i = 4; i < eocd.length - 3; ++i) {
                if (eocd[i] != 80 || eocd[i + 1] != 75 || eocd[i + 2] != 5 || eocd[i + 3] != 6) continue;
                throw new SignatureException("EOCD marker found after start of EOCD");
            }
            PKCS7 block = new PKCS7(new ByteArrayInputStream(eocd, commentSize + 22 - signatureStart, signatureStart));
            X509Certificate[] certificates = block.getCertificates();
            if (certificates == null || certificates.length == 0) {
                throw new SignatureException("signature contains no certificates");
            }
            X509Certificate cert = certificates[0];
            PublicKey signatureKey = cert.getPublicKey();
            SignerInfo[] signerInfos = block.getSignerInfos();
            if (signerInfos == null || signerInfos.length == 0) {
                throw new SignatureException("signature contains no signedData");
            }
            SignerInfo signerInfo = signerInfos[0];
            boolean verified = false;
            HashSet<X509Certificate> trusted = RecoverySystem.getTrustedCerts(deviceCertsZipFile == null ? DEFAULT_KEYSTORE : deviceCertsZipFile);
            for (X509Certificate c : trusted) {
                if (!c.getPublicKey().equals(signatureKey)) continue;
                verified = true;
                break;
            }
            if (!verified) {
                throw new SignatureException("signature doesn't match any trusted key");
            }
            raf.seek(0L);
            final ProgressListener listenerForInner = listener;
            SignerInfo verifyResult = block.verify(signerInfo, new InputStream(){
                long toRead;
                long soFar;
                int lastPercent;
                long lastPublishTime;
                {
                    this.toRead = fileLen - (long)commentSize - 2L;
                    this.soFar = 0L;
                    this.lastPercent = 0;
                    this.lastPublishTime = startTimeMillis;
                }

                @Override
                public int read() throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    if (this.soFar >= this.toRead) {
                        return -1;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        return -1;
                    }
                    int size = len;
                    if (this.soFar + (long)size > this.toRead) {
                        size = (int)(this.toRead - this.soFar);
                    }
                    int read = raf.read(b, off, size);
                    this.soFar += (long)read;
                    if (listenerForInner != null) {
                        long now = System_Delegate.currentTimeMillis();
                        int p = (int)(this.soFar * 100L / this.toRead);
                        if (p > this.lastPercent && now - this.lastPublishTime > 500L) {
                            this.lastPercent = p;
                            this.lastPublishTime = now;
                            listenerForInner.onProgress(this.lastPercent);
                        }
                    }
                    return read;
                }
            });
            boolean interrupted = Thread.interrupted();
            if (listener != null) {
                listener.onProgress(100);
            }
            if (interrupted) {
                throw new SignatureException("verification was interrupted");
            }
            if (verifyResult == null) {
                throw new SignatureException("signature digest verification failed");
            }
        }
    }

    @Deprecated
    @UnsupportedAppUsage(publicAlternatives="Use {@code true} directly", maxTargetSdk=35)
    private static boolean verifyPackageCompatibility(InputStream inputStream) throws IOException {
        return true;
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public static boolean verifyPackageCompatibility(File compatibilityFile) throws IOException {
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RECOVERY")
    public static void processPackage(Context context, File packageFile, final ProgressListener listener, Handler handler) throws IOException {
        String filename = packageFile.getCanonicalPath();
        if (!filename.startsWith("/data/")) {
            return;
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        IRecoverySystemProgressListener.Stub progressListener = null;
        if (listener != null) {
            final Handler progressHandler = handler != null ? handler : new Handler(context.getMainLooper());
            progressListener = new IRecoverySystemProgressListener.Stub(){
                int lastProgress = 0;
                long lastPublishTime = System_Delegate.currentTimeMillis();

                @Override
                public void onProgress(final int progress) {
                    final long now = System_Delegate.currentTimeMillis();
                    progressHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (progress > lastProgress && now - lastPublishTime > 500L) {
                                lastProgress = progress;
                                lastPublishTime = now;
                                listener.onProgress(progress);
                            }
                        }
                    });
                }
            };
        }
        if (!rs.uncrypt(filename, progressListener)) {
            throw new IOException("process package failed");
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RECOVERY")
    public static void processPackage(Context context, File packageFile, ProgressListener listener) throws IOException {
        RecoverySystem.processPackage(context, packageFile, listener, null);
    }

    @RequiresPermission(value="android.permission.RECOVERY")
    public static void installPackage(Context context, File packageFile) throws IOException {
        RecoverySystem.installPackage(context, packageFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.RECOVERY")
    public static void installPackage(Context context, File packageFile, boolean processed) throws IOException {
        Object object = sRequestLock;
        synchronized (object) {
            DisplayManager dm;
            RecoverySystem rs;
            LOG_FILE.delete();
            UNCRYPT_PACKAGE_FILE.delete();
            String filename = packageFile.getCanonicalPath();
            Log.w(TAG, "!!! REBOOTING TO INSTALL " + filename + " !!!");
            boolean securityUpdate = filename.endsWith("_s.zip");
            if (filename.startsWith("/data/")) {
                if (processed) {
                    if (!BLOCK_MAP_FILE.exists()) {
                        Log.e(TAG, "Package claimed to have been processed but failed to find the block map file.");
                        throw new IOException("Failed to find block map file");
                    }
                } else {
                    try (FileWriter uncryptFile = new FileWriter(UNCRYPT_PACKAGE_FILE);){
                        uncryptFile.write(filename + "\n");
                    }
                    if (!UNCRYPT_PACKAGE_FILE.setReadable(true, false) || !UNCRYPT_PACKAGE_FILE.setWritable(true, false)) {
                        Log.e(TAG, "Error setting permission for " + UNCRYPT_PACKAGE_FILE);
                    }
                    BLOCK_MAP_FILE.delete();
                }
                filename = "@/cache/recovery/block.map";
            }
            String filenameArg = "--update_package=" + filename + "\n";
            String localeArg = "--locale=" + AndroidLocale.getDefault().toLanguageTag() + "\n";
            String securityArg = "--security\n";
            String command = filenameArg + localeArg;
            if (securityUpdate) {
                command = command + "--security\n";
            }
            if (!(rs = (RecoverySystem)context.getSystemService("recovery")).setupBcb(command)) {
                throw new IOException("Setup BCB failed");
            }
            try {
                if (!rs.allocateSpaceForUpdate(packageFile)) {
                    rs.clearBcb();
                    throw new IOException("Failed to allocate space for update " + packageFile.getAbsolutePath());
                }
            }
            catch (RemoteException e) {
                rs.clearBcb();
                e.rethrowAsRuntimeException();
            }
            PowerManager pm = (PowerManager)context.getSystemService("power");
            String reason = "recovery-update";
            if (context.getPackageManager().hasSystemFeature("android.software.leanback") && (dm = context.getSystemService(DisplayManager.class)).getDisplay(0).getState() != 2) {
                reason = reason + ",quiescent";
            }
            pm.reboot(reason);
            throw new IOException("Reboot failed (no permissions?)");
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.RECOVERY", "android.permission.REBOOT"})
    public static void prepareForUnattendedUpdate(@NonNull Context context, @NonNull String updateToken, @Nullable IntentSender intentSender) throws IOException {
        if (updateToken == null) {
            throw new NullPointerException("updateToken == null");
        }
        KeyguardManager keyguardManager = context.getSystemService(KeyguardManager.class);
        if (keyguardManager == null || !keyguardManager.isDeviceSecure()) {
            throw new IOException("Failed to request LSKF because the device doesn't have a lock screen. ");
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        if (!rs.requestLskf(context.getPackageName(), intentSender)) {
            throw new IOException("preparation for update failed");
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.RECOVERY", "android.permission.REBOOT"})
    public static void clearPrepareForUnattendedUpdate(@NonNull Context context) throws IOException {
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        if (!rs.clearLskf(context.getPackageName())) {
            throw new IOException("could not reset unattended update state");
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RECOVERY")
    public static void rebootAndApply(@NonNull Context context, @NonNull String updateToken, @NonNull String reason) throws IOException {
        if (updateToken == null) {
            throw new NullPointerException("updateToken == null");
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        if (rs.rebootWithLskfAssumeSlotSwitch(context.getPackageName(), reason) != 0) {
            throw new IOException("system not prepared to apply update");
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.RECOVERY", "android.permission.REBOOT"})
    public static boolean isPreparedForUnattendedUpdate(@NonNull Context context) throws IOException {
        RecoverySystem rs = context.getSystemService(RecoverySystem.class);
        return rs.isLskfCaptured(context.getPackageName());
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.RECOVERY", "android.permission.REBOOT"})
    public static int rebootAndApply(@NonNull Context context, @NonNull String reason, boolean slotSwitch) throws IOException {
        RecoverySystem rs = context.getSystemService(RecoverySystem.class);
        return rs.rebootWithLskf(context.getPackageName(), reason, slotSwitch);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RECOVERY")
    public static void scheduleUpdateOnBoot(Context context, File packageFile) throws IOException {
        RecoverySystem rs;
        String filename = packageFile.getCanonicalPath();
        boolean securityUpdate = filename.endsWith("_s.zip");
        if (filename.startsWith("/data/")) {
            filename = "@/cache/recovery/block.map";
        }
        String filenameArg = "--update_package=" + filename + "\n";
        String localeArg = "--locale=" + AndroidLocale.getDefault().toLanguageTag() + "\n";
        String securityArg = "--security\n";
        String command = filenameArg + localeArg;
        if (securityUpdate) {
            command = command + "--security\n";
        }
        if (!(rs = (RecoverySystem)context.getSystemService("recovery")).setupBcb(command)) {
            throw new IOException("schedule update on boot failed");
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RECOVERY")
    public static void cancelScheduledUpdate(Context context) throws IOException {
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        if (!rs.clearBcb()) {
            throw new IOException("cancel scheduled update failed");
        }
    }

    public static void rebootWipeUserData(Context context) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, context.getPackageName(), false, false);
    }

    public static void rebootWipeUserData(Context context, String reason) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, reason, false, false);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown) throws IOException {
        RecoverySystem.rebootWipeUserData(context, shutdown, context.getPackageName(), false, false);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown, String reason, boolean force) throws IOException {
        RecoverySystem.rebootWipeUserData(context, shutdown, reason, force, false);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown, String reason, boolean force, boolean wipeEuicc) throws IOException {
        RecoverySystem.rebootWipeUserData(context, shutdown, reason, force, wipeEuicc, false);
    }

    public static void rebootWipeUserData(Context context, boolean shutdown, String reason, boolean force, boolean wipeEuicc, boolean keepMemtagMode) throws IOException {
        UserManager um = (UserManager)context.getSystemService("user");
        if (!force && um.hasUserRestriction("no_factory_reset")) {
            throw new SecurityException("Wiping data is not allowed for this user.");
        }
        final ConditionVariable condition = new ConditionVariable();
        Intent intent = new Intent("android.intent.action.MASTER_CLEAR_NOTIFICATION");
        intent.addFlags(0x11000000);
        context.sendOrderedBroadcastAsUser(intent, UserHandle.SYSTEM, "android.permission.MASTER_CLEAR", new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                condition.open();
            }
        }, null, 0, null, null);
        condition.block();
        EuiccManager euiccManager = context.getSystemService(EuiccManager.class);
        if (wipeEuicc) {
            RecoverySystem.wipeEuiccData(context, PACKAGE_NAME_EUICC_DATA_MANAGEMENT_CALLBACK);
        } else {
            RecoverySystem.removeEuiccInvisibleSubs(context, euiccManager);
        }
        String shutdownArg = null;
        if (shutdown) {
            shutdownArg = "--shutdown_after";
        }
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-ddTHH:mm:ssZ", System_Delegate.currentTimeMillis()).toString();
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason + "," + timeStamp);
        }
        String memtagArg = null;
        if (keepMemtagMode) {
            memtagArg = "--keep_memtag_mode";
        }
        String localeArg = "--locale=" + AndroidLocale.getDefault().toLanguageTag();
        RecoverySystem.bootCommand(context, shutdownArg, "--wipe_data", reasonArg, localeArg, memtagArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wipeEuiccData(Context context, String packageName) {
        ContentResolver cr = context.getContentResolver();
        if (Settings.Global.getInt(cr, "euicc_provisioned", 0) == 0) {
            Log.d(TAG, "Skipping eUICC wipe/retain as it is not provisioned");
            return true;
        }
        EuiccManager euiccManager = (EuiccManager)context.getSystemService("euicc");
        if (euiccManager != null && euiccManager.isEnabled()) {
            final CountDownLatch euiccFactoryResetLatch = new CountDownLatch(1);
            final AtomicBoolean wipingSucceeded = new AtomicBoolean(false);
            BroadcastReceiver euiccWipeFinishReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    if (RecoverySystem.ACTION_EUICC_FACTORY_RESET.equals(intent.getAction())) {
                        if (this.getResultCode() != 0) {
                            int detailedCode = intent.getIntExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", 0);
                            Log.e(RecoverySystem.TAG, "Error wiping euicc data, Detailed code = " + detailedCode);
                        } else {
                            Log.d(RecoverySystem.TAG, "Successfully wiped euicc data.");
                            wipingSucceeded.set(true);
                        }
                        euiccFactoryResetLatch.countDown();
                    }
                }
            };
            Intent intent = new Intent(ACTION_EUICC_FACTORY_RESET);
            intent.setPackage(packageName);
            PendingIntent callbackIntent = PendingIntent.getBroadcastAsUser(context, 0, intent, 0xC000000, UserHandle.SYSTEM);
            IntentFilter filterConsent = new IntentFilter();
            filterConsent.addAction(ACTION_EUICC_FACTORY_RESET);
            HandlerThread euiccHandlerThread = new HandlerThread("euiccWipeFinishReceiverThread");
            euiccHandlerThread.start();
            Handler euiccHandler = new Handler(euiccHandlerThread.getLooper());
            context.getApplicationContext().registerReceiver(euiccWipeFinishReceiver, filterConsent, null, euiccHandler);
            euiccManager.eraseSubscriptions(callbackIntent);
            try {
                long waitingTimeMillis = Settings.Global.getLong(context.getContentResolver(), "euicc_factory_reset_timeout_millis", 30000L);
                if (waitingTimeMillis < 5000L) {
                    waitingTimeMillis = 5000L;
                } else if (waitingTimeMillis > 60000L) {
                    waitingTimeMillis = 60000L;
                }
                if (!euiccFactoryResetLatch.await(waitingTimeMillis, TimeUnit.MILLISECONDS)) {
                    Log.e(TAG, "Timeout wiping eUICC data.");
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.e(TAG, "Wiping eUICC data interrupted", e);
                boolean bl = false;
                return bl;
            }
            finally {
                context.getApplicationContext().unregisterReceiver(euiccWipeFinishReceiver);
            }
            return wipingSucceeded.get();
        }
        return false;
    }

    private static void removeEuiccInvisibleSubs(Context context, EuiccManager euiccManager) {
        ContentResolver cr = context.getContentResolver();
        if (Settings.Global.getInt(cr, "euicc_provisioned", 0) == 0) {
            Log.i(TAG, "Skip removing eUICC invisible profiles as it is not provisioned.");
            return;
        }
        if (euiccManager == null || !euiccManager.isEnabled()) {
            Log.i(TAG, "Skip removing eUICC invisible profiles as eUICC manager is not available.");
            return;
        }
        SubscriptionManager subscriptionManager = context.getSystemService(SubscriptionManager.class);
        List<SubscriptionInfo> availableSubs = subscriptionManager.getAvailableSubscriptionInfoList();
        if (availableSubs == null || availableSubs.isEmpty()) {
            Log.i(TAG, "Skip removing eUICC invisible profiles as no available profiles found.");
            return;
        }
        ArrayList<SubscriptionInfo> invisibleSubs = new ArrayList<SubscriptionInfo>();
        for (SubscriptionInfo sub : availableSubs) {
            if (!sub.isEmbedded() || sub.getGroupUuid() == null || !sub.isOpportunistic()) continue;
            invisibleSubs.add(sub);
        }
        RecoverySystem.removeEuiccInvisibleSubs(context, invisibleSubs, euiccManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeEuiccInvisibleSubs(Context context, List<SubscriptionInfo> subscriptionInfos, EuiccManager euiccManager) {
        if (subscriptionInfos == null || subscriptionInfos.isEmpty()) {
            Log.i(TAG, "There are no eUICC invisible profiles needed to be removed.");
            return true;
        }
        final CountDownLatch removeSubsLatch = new CountDownLatch(subscriptionInfos.size());
        final AtomicInteger removedSubsCount = new AtomicInteger(0);
        BroadcastReceiver removeEuiccSubsReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (RecoverySystem.ACTION_EUICC_REMOVE_INVISIBLE_SUBSCRIPTIONS.equals(intent.getAction())) {
                    if (this.getResultCode() != 0) {
                        int detailedCode = intent.getIntExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", 0);
                        Log.e(RecoverySystem.TAG, "Error removing euicc opportunistic profile, Detailed code = " + detailedCode);
                    } else {
                        Log.e(RecoverySystem.TAG, "Successfully remove euicc opportunistic profile.");
                        removedSubsCount.incrementAndGet();
                    }
                    removeSubsLatch.countDown();
                }
            }
        };
        Intent intent = new Intent(ACTION_EUICC_REMOVE_INVISIBLE_SUBSCRIPTIONS);
        intent.setPackage(PACKAGE_NAME_EUICC_DATA_MANAGEMENT_CALLBACK);
        PendingIntent callbackIntent = PendingIntent.getBroadcastAsUser(context, 0, intent, 0xC000000, UserHandle.SYSTEM);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_EUICC_REMOVE_INVISIBLE_SUBSCRIPTIONS);
        HandlerThread euiccHandlerThread = new HandlerThread("euiccRemovingSubsReceiverThread");
        euiccHandlerThread.start();
        Handler euiccHandler = new Handler(euiccHandlerThread.getLooper());
        context.getApplicationContext().registerReceiver(removeEuiccSubsReceiver, intentFilter, null, euiccHandler);
        for (SubscriptionInfo subscriptionInfo : subscriptionInfos) {
            Log.i(TAG, "Remove invisible subscription " + subscriptionInfo.getSubscriptionId() + " from card " + subscriptionInfo.getCardId());
            euiccManager.createForCardId(subscriptionInfo.getCardId()).deleteSubscription(subscriptionInfo.getSubscriptionId(), callbackIntent);
        }
        try {
            long waitingTimeMillis = Settings.Global.getLong(context.getContentResolver(), "euicc_removing_invisible_profiles_timeout_millis", 45000L);
            if (waitingTimeMillis < 15000L) {
                waitingTimeMillis = 15000L;
            } else if (waitingTimeMillis > 90000L) {
                waitingTimeMillis = 90000L;
            }
            if (!removeSubsLatch.await(waitingTimeMillis, TimeUnit.MILLISECONDS)) {
                Log.e(TAG, "Timeout removing invisible euicc profiles.");
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Log.e(TAG, "Removing invisible euicc profiles interrupted", e);
            boolean bl = false;
            return bl;
        }
        finally {
            context.getApplicationContext().unregisterReceiver(removeEuiccSubsReceiver);
            if (euiccHandlerThread != null) {
                euiccHandlerThread.quit();
            }
        }
        return removedSubsCount.get() == subscriptionInfos.size();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RECOVERY")
    @FlaggedApi(value="android.crashrecovery.flags.enable_crashrecovery")
    public static void rebootPromptAndWipeUserData(@NonNull Context context, @NonNull String reason) throws IOException {
        boolean checkpointing = false;
        IVold vold = null;
        try {
            vold = IVold.Stub.asInterface(ServiceManager.checkService("vold"));
            if (vold != null) {
                checkpointing = vold.needsCheckpoint();
            } else {
                Log.w(TAG, "Failed to get vold");
            }
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to check for checkpointing");
        }
        if (checkpointing) {
            try {
                vold.abortChanges("rescueparty", false);
                Log.i(TAG, "Rescue Party requested wipe. Aborting update");
            }
            catch (Exception e) {
                Log.i(TAG, "Rescue Party requested wipe. Rebooting instead.");
                PowerManager pm = (PowerManager)context.getSystemService("power");
                pm.reboot("rescueparty");
            }
            return;
        }
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + ((Object)AndroidLocale.getDefault()).toString();
        RecoverySystem.bootCommand(context, null, "--prompt_and_wipe_data", reasonArg, localeArg);
    }

    public static void rebootWipeCache(Context context) throws IOException {
        RecoverySystem.rebootWipeCache(context, context.getPackageName());
    }

    public static void rebootWipeCache(Context context, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + AndroidLocale.getDefault().toLanguageTag();
        RecoverySystem.bootCommand(context, "--wipe_cache", reasonArg, localeArg);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.RECOVERY", "android.permission.REBOOT"})
    public static void rebootWipeAb(Context context, File packageFile, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String filename = packageFile.getCanonicalPath();
        String filenameArg = "--wipe_package=" + filename;
        String localeArg = "--locale=" + AndroidLocale.getDefault().toLanguageTag();
        RecoverySystem.bootCommand(context, "--wipe_ab", filenameArg, reasonArg, localeArg);
    }

    @RequiresPermission(allOf={"android.permission.RECOVERY", "android.permission.REBOOT"})
    public void wipePartitionToExt4() throws IOException {
        String command = "--wipe_data\n--reformat_data=ext4";
        this.rebootRecoveryWithCommand(command);
    }

    private static void bootCommand(Context context, String ... args) throws IOException {
        LOG_FILE.delete();
        StringBuilder command = new StringBuilder();
        for (String arg : args) {
            if (TextUtils.isEmpty(arg)) continue;
            command.append(arg);
            command.append("\n");
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        rs.rebootRecoveryWithCommand(command.toString());
        throw new IOException("Reboot failed (no permissions?)");
    }

    public static String handleAftermath(Context context) {
        String log = null;
        try {
            log = FileUtils.readTextFile(LOG_FILE, -65536, "...\n");
        }
        catch (FileNotFoundException e) {
            Log.i(TAG, "No recovery log file");
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading recovery log", e);
        }
        boolean reservePackage = BLOCK_MAP_FILE.exists();
        if (!reservePackage && UNCRYPT_PACKAGE_FILE.exists()) {
            String filename = null;
            try {
                filename = FileUtils.readTextFile(UNCRYPT_PACKAGE_FILE, 0, null);
            }
            catch (IOException e) {
                Log.e(TAG, "Error reading uncrypt file", e);
            }
            if (filename != null && filename.startsWith("/data")) {
                if (UNCRYPT_PACKAGE_FILE.delete()) {
                    Log.i(TAG, "Deleted: " + filename);
                } else {
                    Log.e(TAG, "Can't delete: " + filename);
                }
            }
        }
        String[] names = RECOVERY_DIR.list();
        for (int i = 0; names != null && i < names.length; ++i) {
            if (names[i].startsWith(LAST_PREFIX) || names[i].equals(LAST_INSTALL_PATH) || reservePackage && names[i].equals(BLOCK_MAP_FILE.getName()) || reservePackage && names[i].equals(UNCRYPT_PACKAGE_FILE.getName())) continue;
            RecoverySystem.recursiveDelete(new File(RECOVERY_DIR, names[i]));
        }
        return log;
    }

    private static void recursiveDelete(File name) {
        if (name.isDirectory()) {
            String[] files = name.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f = new File(name, files[i]);
                RecoverySystem.recursiveDelete(f);
            }
        }
        if (!name.delete()) {
            Log.e(TAG, "Can't delete: " + name);
        } else {
            Log.i(TAG, "Deleted: " + name);
        }
    }

    private boolean uncrypt(String packageFile, IRecoverySystemProgressListener listener) {
        try {
            return this.mService.uncrypt(packageFile, listener);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private boolean setupBcb(String command) {
        try {
            return this.mService.setupBcb(command);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private boolean allocateSpaceForUpdate(File packageFile) throws RemoteException {
        return this.mService.allocateSpaceForUpdate(packageFile.getAbsolutePath());
    }

    private boolean clearBcb() {
        try {
            return this.mService.clearBcb();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private void rebootRecoveryWithCommand(String command) {
        try {
            this.mService.rebootRecoveryWithCommand(command);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean requestLskf(String packageName, IntentSender sender) throws IOException {
        Log.i(TAG, TextUtils.formatSimple("Package<%s> requesting LSKF", packageName));
        try {
            boolean validRequest = this.mService.requestLskf(packageName, sender);
            Log.i(TAG, TextUtils.formatSimple("LSKF Request isValid = %b", validRequest));
            return validRequest;
        }
        catch (RemoteException | SecurityException e) {
            throw new IOException("could not request LSKF capture", e);
        }
    }

    private boolean clearLskf(String packageName) throws IOException {
        try {
            return this.mService.clearLskf(packageName);
        }
        catch (RemoteException | SecurityException e) {
            throw new IOException("could not clear LSKF", e);
        }
    }

    private boolean isLskfCaptured(String packageName) throws IOException {
        try {
            return this.mService.isLskfCaptured(packageName);
        }
        catch (RemoteException | SecurityException e) {
            throw new IOException("could not get LSKF capture state", e);
        }
    }

    private int rebootWithLskf(String packageName, String reason, boolean slotSwitch) throws IOException {
        try {
            return this.mService.rebootWithLskf(packageName, reason, slotSwitch);
        }
        catch (RemoteException | SecurityException e) {
            throw new IOException("could not reboot for update", e);
        }
    }

    private int rebootWithLskfAssumeSlotSwitch(String packageName, String reason) throws IOException {
        try {
            return this.mService.rebootWithLskfAssumeSlotSwitch(packageName, reason);
        }
        catch (RemoteException | RuntimeException e) {
            throw new IOException("could not reboot for update", e);
        }
    }

    private static String sanitizeArg(String arg) {
        arg = arg.replace('\u0000', '?');
        arg = arg.replace('\n', '?');
        return arg;
    }

    public RecoverySystem() {
        this.mService = null;
    }

    public RecoverySystem(IRecoverySystem service) {
        this.mService = service;
    }

    public static interface ProgressListener {
        public void onProgress(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResumeOnRebootRebootErrorCode {
    }
}

