/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IProfilingResultCallback;
import android.os.IProfilingService;
import android.os.ParcelFileDescriptor;
import android.os.ProfilingFrameworkInitializer;
import android.os.ProfilingResult;
import android.os.ProfilingTrigger;
import android.os.ProfilingTriggerValueParcel;
import android.os.RemoteException;
import android.os.profiling.Flags;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@FlaggedApi(value="android.os.profiling.telemetry_apis")
public class ProfilingManager {
    private static final String TAG = ProfilingManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    public static final int PROFILING_TYPE_JAVA_HEAP_DUMP = 1;
    public static final int PROFILING_TYPE_HEAP_PROFILE = 2;
    public static final int PROFILING_TYPE_STACK_SAMPLING = 3;
    public static final int PROFILING_TYPE_SYSTEM_TRACE = 4;
    public static final String KEY_DURATION_MS = "KEY_DURATION_MS";
    public static final String KEY_SAMPLING_INTERVAL_BYTES = "KEY_SAMPLING_INTERVAL_BYTES";
    public static final String KEY_TRACK_JAVA_ALLOCATIONS = "KEY_TRACK_JAVA_ALLOCATIONS";
    public static final String KEY_FREQUENCY_HZ = "KEY_FREQUENCY_HZ";
    public static final String KEY_SIZE_KB = "KEY_SIZE_KB";
    public static final String KEY_BUFFER_FILL_POLICY = "KEY_BUFFER_FILL_POLICY";
    public static final int VALUE_BUFFER_FILL_POLICY_DISCARD = 1;
    public static final int VALUE_BUFFER_FILL_POLICY_RING_BUFFER = 2;
    private final Object mLock = new Object();
    private final Context mContext;
    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    public final ArrayList<ProfilingRequestCallbackWrapper> mCallbacks = new ArrayList();
    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    public IProfilingService mProfilingService;

    public ProfilingManager(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestProfiling(int profilingType, @Nullable Bundle parameters, @Nullable String tag, @Nullable CancellationSignal cancellationSignal, @Nullable Executor executor, @Nullable Consumer<ProfilingResult> listener) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                UUID key = UUID.randomUUID();
                if (executor != null && listener != null) {
                    this.mCallbacks.add(new ProfilingRequestCallbackWrapper(executor, listener, key));
                } else if (this.mCallbacks.isEmpty()) {
                    throw new IllegalArgumentException("No listeners have been registered. Request has been discarded.");
                }
                IProfilingService service = this.getOrCreateIProfilingServiceLocked(false);
                if (service == null) {
                    executor.execute(() -> listener.accept(new ProfilingResult(8, null, tag, "ProfilingService is not available", Flags.systemTriggeredProfilingNew() ? 0 : 0)));
                    return;
                }
                String packageName = this.mContext.getPackageName();
                if (packageName == null) {
                    executor.execute(() -> listener.accept(new ProfilingResult(8, null, tag, "Failed to resolve package name", Flags.systemTriggeredProfilingNew() ? 0 : 0)));
                    return;
                }
                service.requestProfiling(profilingType, parameters, tag, key.getMostSignificantBits(), key.getLeastSignificantBits(), packageName);
                if (cancellationSignal != null) {
                    cancellationSignal.setOnCancelListener(() -> {
                        Object object = this.mLock;
                        synchronized (object) {
                            try {
                                service.requestCancel(key.getMostSignificantBits(), key.getLeastSignificantBits());
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (RemoteException e) {
                executor.execute(() -> listener.accept(new ProfilingResult(8, null, tag, "Binder exception processing request", Flags.systemTriggeredProfilingNew() ? 0 : 0)));
                throw new RuntimeException("Unable to request profiling.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForAllProfilingResults(@NonNull Executor executor, @NonNull Consumer<ProfilingResult> listener) {
        Object object = this.mLock;
        synchronized (object) {
            boolean shouldNotifyService;
            boolean bl = shouldNotifyService = this.mProfilingService != null;
            if (this.getOrCreateIProfilingServiceLocked(true) == null) {
                executor.execute(() -> listener.accept(new ProfilingResult(8, null, null, "Binder exception processing request", Flags.systemTriggeredProfilingNew() ? 0 : 0)));
                return;
            }
            this.mCallbacks.add(new ProfilingRequestCallbackWrapper(executor, listener, null));
            if (shouldNotifyService) {
                try {
                    this.mProfilingService.generalListenerAdded();
                }
                catch (RemoteException e) {
                    Log.d(TAG, "Exception notifying service of general callback, queued callbacks will not occur.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForAllProfilingResults(@Nullable Consumer<ProfilingResult> listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks.isEmpty()) {
                return;
            }
            if (listener == null) {
                ArrayList<ProfilingRequestCallbackWrapper> listenersToRemove = new ArrayList<ProfilingRequestCallbackWrapper>();
                for (int i = 0; i < this.mCallbacks.size(); ++i) {
                    ProfilingRequestCallbackWrapper wrapper = this.mCallbacks.get(i);
                    if (wrapper.mKey != null) continue;
                    listenersToRemove.add(wrapper);
                }
                this.mCallbacks.removeAll(listenersToRemove);
            } else {
                for (int i = 0; i < this.mCallbacks.size(); ++i) {
                    ProfilingRequestCallbackWrapper wrapper = this.mCallbacks.get(i);
                    if (!listener.equals(wrapper.mListener)) continue;
                    this.mCallbacks.remove(i);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
    public void addProfilingTriggers(@NonNull List<ProfilingTrigger> triggers) {
        Object object = this.mLock;
        synchronized (object) {
            if (triggers.isEmpty()) {
                return;
            }
            IProfilingService service = this.getOrCreateIProfilingServiceLocked(false);
            if (service == null) {
                return;
            }
            String packageName = this.mContext.getPackageName();
            if (packageName == null) {
                return;
            }
            try {
                service.addProfilingTriggers(this.toValueParcelList(triggers), packageName);
            }
            catch (RemoteException e) {
                e.rethrowAsRuntimeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.profiling.profiling_25q4")
    public void addAllProfilingTriggers() {
        Object object = this.mLock;
        synchronized (object) {
            IProfilingService service = this.getOrCreateIProfilingServiceLocked(false);
            if (service == null) {
                throw new RuntimeException("ProfilingService is not available");
            }
            String packageName = this.mContext.getPackageName();
            if (packageName == null) {
                throw new RuntimeException("Failed to resolve package name");
            }
            try {
                service.addAllProfilingTriggers(packageName);
            }
            catch (RemoteException e) {
                e.rethrowAsRuntimeException();
            }
        }
    }

    @FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
    private List<ProfilingTriggerValueParcel> toValueParcelList(List<ProfilingTrigger> triggerList) {
        ArrayList<ProfilingTriggerValueParcel> triggerValueParcelList = new ArrayList<ProfilingTriggerValueParcel>();
        for (int i = 0; i < triggerList.size(); ++i) {
            triggerValueParcelList.add(triggerList.get(i).toValueParcel());
        }
        return triggerValueParcelList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
    public void removeProfilingTriggersByType(@NonNull int[] triggers) {
        Object object = this.mLock;
        synchronized (object) {
            if (triggers.length == 0) {
                return;
            }
            IProfilingService service = this.getOrCreateIProfilingServiceLocked(false);
            if (service == null) {
                return;
            }
            String packageName = this.mContext.getPackageName();
            if (packageName == null) {
                return;
            }
            try {
                service.removeProfilingTriggers(triggers, packageName);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Unable to remove profiling triggers.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
    public void clearProfilingTriggers() {
        Object object = this.mLock;
        synchronized (object) {
            IProfilingService service = this.getOrCreateIProfilingServiceLocked(false);
            if (service == null) {
                return;
            }
            String packageName = this.mContext.getPackageName();
            if (packageName == null) {
                return;
            }
            try {
                service.clearProfilingTriggers(packageName);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Unable to clear profiling triggers.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.profiling.profiling_25q4")
    public void requestRunningSystemTrace(@Nullable String tag) {
        Object object = this.mLock;
        synchronized (object) {
            IProfilingService service = this.getOrCreateIProfilingServiceLocked(false);
            if (service == null) {
                return;
            }
            String packageName = this.mContext.getPackageName();
            if (packageName == null) {
                return;
            }
            try {
                service.processTrigger(Binder.getCallingUid(), packageName, 3, tag);
            }
            catch (RemoteException e) {
                e.rethrowAsRuntimeException();
            }
        }
    }

    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    @Nullable
    public IProfilingService getOrCreateIProfilingServiceLocked(boolean isGeneralListener) {
        if (this.mProfilingService != null) {
            return this.mProfilingService;
        }
        this.mProfilingService = IProfilingService.Stub.asInterface(ProfilingFrameworkInitializer.getProfilingServiceManager().getProfilingServiceRegisterer().get());
        if (this.mProfilingService == null) {
            return this.mProfilingService;
        }
        try {
            this.mProfilingService.registerResultsCallback(isGeneralListener, new IProfilingResultCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendResult(@Nullable String resultFile, long keyMostSigBits, long keyLeastSigBits, int status, @Nullable String tag, @Nullable String error, int triggerType) {
                    Object object = ProfilingManager.this.mLock;
                    synchronized (object) {
                        if (ProfilingManager.this.mCallbacks.isEmpty()) {
                            ProfilingManager.this.mProfilingService = null;
                            return;
                        }
                        boolean overrideStatusToError = resultFile == null && status == 0;
                        UUID key = new UUID(keyMostSigBits, keyLeastSigBits);
                        int removeListenerPos = -1;
                        for (int i = 0; i < ProfilingManager.this.mCallbacks.size(); ++i) {
                            ProfilingRequestCallbackWrapper wrapper = ProfilingManager.this.mCallbacks.get(i);
                            if (((Object)key).equals(wrapper.mKey)) {
                                if (removeListenerPos == -1) {
                                    removeListenerPos = i;
                                }
                            } else if (wrapper.mKey != null) continue;
                            wrapper.mExecutor.execute(() -> wrapper.mListener.accept(new ProfilingResult(overrideStatusToError ? 8 : status, this.getAppFileDir() + resultFile, tag, error, triggerType)));
                        }
                        if (removeListenerPos != -1) {
                            ProfilingManager.this.mCallbacks.remove(removeListenerPos);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void generateFile(String filePathRelative, String fileName, long keyMostSigBits, long keyLeastSigBits) {
                    Object object = ProfilingManager.this.mLock;
                    synchronized (object) {
                        String filePathAbsolute = this.getAppFileDir() + filePathRelative;
                        try {
                            File profilingDir = new File(filePathAbsolute);
                            if (!profilingDir.exists()) {
                                profilingDir.mkdir();
                            }
                            File profilingFile = new File(filePathAbsolute + fileName);
                            profilingFile.createNewFile();
                            if (!profilingFile.exists()) {
                                return;
                            }
                            ParcelFileDescriptor pfd = ParcelFileDescriptor.open(profilingFile, 0x30000000);
                            IProfilingService service = ProfilingManager.this.getOrCreateIProfilingServiceLocked(false);
                            if (service == null) {
                                this.tryToCleanupGeneratedFile(pfd, profilingFile);
                                return;
                            }
                            try {
                                service.receiveFileDescriptor(pfd, keyMostSigBits, keyLeastSigBits);
                            }
                            catch (RemoteException e) {
                                this.tryToCleanupGeneratedFile(pfd, profilingFile);
                            }
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                }

                private void tryToCleanupGeneratedFile(ParcelFileDescriptor fileDescriptor, File file) {
                    if (fileDescriptor != null) {
                        try {
                            fileDescriptor.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (file != null) {
                        try {
                            file.delete();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void deleteFile(String relativeFilePathAndName) {
                    try {
                        Files.delete(Path.of(this.getAppFileDir() + relativeFilePathAndName, new String[0]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                private String getAppFileDir() {
                    return ProfilingManager.this.mContext.getFilesDir().getPath();
                }
            });
        }
        catch (RemoteException e) {
            throw new RuntimeException("Unable to register profiling result callback. All Profiling requests will fail.");
        }
        return this.mProfilingService;
    }

    private static class ProfilingRequestCallbackWrapper {
        @NonNull
        final Executor mExecutor;
        @NonNull
        final Consumer<ProfilingResult> mListener;
        @Nullable
        final UUID mKey;

        ProfilingRequestCallbackWrapper(@NonNull Executor executor, @NonNull Consumer<ProfilingResult> listener, @Nullable UUID key) {
            this.mExecutor = executor;
            this.mListener = listener;
            this.mKey = key;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfilingType {
    }
}

