/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.os.ProfilingManager;
import android.os.ProfilingServiceManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@FlaggedApi(value="android.os.profiling.telemetry_apis")
public class ProfilingFrameworkInitializer {
    private static volatile ProfilingServiceManager sProfilingServiceManager;

    private ProfilingFrameworkInitializer() {
    }

    public static void setProfilingServiceManager(@NonNull ProfilingServiceManager profilingServiceManager) {
        if (sProfilingServiceManager != null) {
            throw new IllegalStateException("setProfilingServiceManager called twice!");
        }
        if (profilingServiceManager == null) {
            throw new NullPointerException("profilingServiceManager is null");
        }
        sProfilingServiceManager = profilingServiceManager;
    }

    public static ProfilingServiceManager getProfilingServiceManager() {
        return sProfilingServiceManager;
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("profiling", ProfilingManager.class, context -> new ProfilingManager(context));
    }
}

