/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.PerfettoTrace;
import android.os.PerfettoTrackEventExtra_Delegate;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import com.android.internal.ravenwood.RavenwoodEnvironment;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class PerfettoTrackEventExtra {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_EXTRA_CACHE_SIZE = 5;
    private static final Builder NO_OP_BUILDER = new Builder(null, false);
    private static final ThreadLocal<PerfettoTrackEventExtra> sTrackEventExtra = new ThreadLocal<PerfettoTrackEventExtra>(){

        @Override
        protected PerfettoTrackEventExtra initialValue() {
            return new PerfettoTrackEventExtra();
        }
    };
    private static final AtomicLong sNamedTrackId = new AtomicLong();
    private static final Supplier<Flow> sFlowSupplier = Flow::new;
    private static final Supplier<Builder> sBuilderSupplier = Builder::new;
    private static final Supplier<FieldInt64> sFieldInt64Supplier = FieldInt64::new;
    private static final Supplier<FieldDouble> sFieldDoubleSupplier = FieldDouble::new;
    private static final Supplier<FieldString> sFieldStringSupplier = FieldString::new;
    private static final Supplier<FieldNested> sFieldNestedSupplier = FieldNested::new;
    private final List<PerfettoPointer> mPendingPointers = new ArrayList<PerfettoPointer>();
    private CounterInt64 mCounterInt64;
    private CounterDouble mCounterDouble;
    private Proto mProto;
    private Flow mFlow;
    private Flow mTerminatingFlow;
    private final RingBuffer<NamedTrack> mNamedTrackCache = new RingBuffer(5);
    private final RingBuffer<CounterTrack> mCounterTrackCache = new RingBuffer(5);
    private final RingBuffer<ArgInt64> mArgInt64Cache = new RingBuffer(5);
    private final RingBuffer<ArgBool> mArgBoolCache = new RingBuffer(5);
    private final RingBuffer<ArgDouble> mArgDoubleCache = new RingBuffer(5);
    private final RingBuffer<ArgString> mArgStringCache = new RingBuffer(5);
    private final Pool<FieldInt64> mFieldInt64Cache = new Pool(5);
    private final Pool<FieldDouble> mFieldDoubleCache = new Pool(5);
    private final Pool<FieldString> mFieldStringCache = new Pool(5);
    private final Pool<FieldNested> mFieldNestedCache = new Pool(5);
    private final Pool<Builder> mBuilderCache = new Pool(5);
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(PerfettoTrackEventExtra.class.getClassLoader(), PerfettoTrackEventExtra.native_delete());
    private final long mPtr = PerfettoTrackEventExtra.native_init();
    private static final String TAG = "PerfettoTrackEventExtra";

    public static Builder builder(boolean isCategoryEnabled) {
        if (isCategoryEnabled) {
            return PerfettoTrackEventExtra.sTrackEventExtra.get().mBuilderCache.get(sBuilderSupplier).initInternal(null, null);
        }
        return NO_OP_BUILDER;
    }

    private PerfettoTrackEventExtra() {
        if (!RavenwoodEnvironment.getInstance().isRunningOnRavenwood()) {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }
    }

    public long getPtr() {
        return this.mPtr;
    }

    public void addPerfettoPointer(PerfettoPointer extra) {
        PerfettoTrackEventExtra.native_add_arg(this.mPtr, extra.getPtr());
        this.mPendingPointers.add(extra);
    }

    public void addPerfettoPointer(FieldContainer container, PerfettoPointer extra) {
        container.addField(extra);
        this.mPendingPointers.add(extra);
    }

    @RavenwoodReplace
    public void reset() {
        PerfettoTrackEventExtra.native_clear_args(this.mPtr);
        this.mPendingPointers.clear();
    }

    @RavenwoodReplace
    CounterInt64 getCounterInt64_Original() {
        if (this.mCounterInt64 == null) {
            this.mCounterInt64 = new CounterInt64();
        }
        return this.mCounterInt64;
    }

    @LayoutlibDelegate
    private CounterInt64 getCounterInt64() {
        return PerfettoTrackEventExtra_Delegate.getCounterInt64(this);
    }

    @RavenwoodReplace
    CounterDouble getCounterDouble_Original() {
        if (this.mCounterDouble == null) {
            this.mCounterDouble = new CounterDouble();
        }
        return this.mCounterDouble;
    }

    @LayoutlibDelegate
    private CounterDouble getCounterDouble() {
        return PerfettoTrackEventExtra_Delegate.getCounterDouble(this);
    }

    @RavenwoodReplace
    Proto getProto_Original() {
        if (this.mProto == null) {
            this.mProto = new Proto();
        }
        return this.mProto;
    }

    @LayoutlibDelegate
    private Proto getProto() {
        return PerfettoTrackEventExtra_Delegate.getProto(this);
    }

    @RavenwoodReplace
    Flow getFlow_Original() {
        if (this.mFlow == null) {
            this.mFlow = new Flow();
        }
        return this.mFlow;
    }

    @LayoutlibDelegate
    private Flow getFlow() {
        return PerfettoTrackEventExtra_Delegate.getFlow(this);
    }

    @RavenwoodReplace
    Flow getTerminatingFlow_Original() {
        if (this.mTerminatingFlow == null) {
            this.mTerminatingFlow = new Flow();
        }
        return this.mTerminatingFlow;
    }

    @LayoutlibDelegate
    private Flow getTerminatingFlow() {
        return PerfettoTrackEventExtra_Delegate.getTerminatingFlow(this);
    }

    @LayoutlibDelegate
    @CriticalNative
    @RavenwoodReplace
    private static long native_init() {
        return PerfettoTrackEventExtra_Delegate.native_init();
    }

    @LayoutlibDelegate
    @CriticalNative
    @RavenwoodReplace
    private static long native_delete() {
        return PerfettoTrackEventExtra_Delegate.native_delete();
    }

    @CriticalNative
    private static void native_add_arg(long l, long l2) {
        OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra#native_add_arg(JJ)V", true, null);
    }

    @CriticalNative
    private static void native_clear_args(long l) {
        OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra#native_clear_args(J)V", true, null);
    }

    @FastNative
    private static void native_emit(int n, long l, String string2, long l2) {
        OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra#native_emit(IJLjava/lang/String;J)V", true, null);
    }

    private static long native_init$ravenwood() {
        return 0L;
    }

    private static long native_delete$ravenwood() {
        return 0L;
    }

    private CounterInt64 getCounterInt64$ravenwood() {
        return null;
    }

    private CounterDouble getCounterDouble$ravenwood() {
        return null;
    }

    private Proto getProto$ravenwood() {
        return null;
    }

    private Flow getFlow$ravenwood() {
        return null;
    }

    private Flow getTerminatingFlow$ravenwood() {
        return null;
    }

    private void reset$ravenwood() {
    }

    private static class Pool<T> {
        private final int mCapacity;
        private final T[] mValueArray;
        private int mIdx = 0;

        Pool(int capacity) {
            this.mCapacity = capacity;
            this.mValueArray = new Object[capacity];
        }

        public void reset() {
            this.mIdx = 0;
        }

        public T get(Supplier<T> supplier) {
            if (this.mIdx >= this.mCapacity) {
                return supplier.get();
            }
            if (this.mValueArray[this.mIdx] == null) {
                this.mValueArray[this.mIdx] = supplier.get();
            }
            return this.mValueArray[this.mIdx++];
        }
    }

    public static class Builder {
        private final PerfettoTrackEventExtra mExtra;
        private int mTraceType;
        private PerfettoTrace.Category mCategory;
        private String mEventName;
        private boolean mIsBuilt;
        private Builder mParent;
        private FieldContainer mCurrentContainer;
        private final boolean mIsCategoryEnabled;
        private final CounterInt64 mCounterInt64;
        private final CounterDouble mCounterDouble;
        private final Proto mProto;
        private final Flow mFlow;
        private final Flow mTerminatingFlow;
        private final RingBuffer<NamedTrack> mNamedTrackCache;
        private final RingBuffer<CounterTrack> mCounterTrackCache;
        private final RingBuffer<ArgInt64> mArgInt64Cache;
        private final RingBuffer<ArgBool> mArgBoolCache;
        private final RingBuffer<ArgDouble> mArgDoubleCache;
        private final RingBuffer<ArgString> mArgStringCache;
        private final Pool<FieldInt64> mFieldInt64Cache;
        private final Pool<FieldDouble> mFieldDoubleCache;
        private final Pool<FieldString> mFieldStringCache;
        private final Pool<FieldNested> mFieldNestedCache;
        private final Pool<Builder> mBuilderCache;

        private Builder() {
            this(sTrackEventExtra.get(), true);
        }

        public Builder(PerfettoTrackEventExtra extra, boolean isCategoryEnabled) {
            this.mIsCategoryEnabled = isCategoryEnabled;
            this.mExtra = extra;
            this.mNamedTrackCache = this.mExtra == null ? null : this.mExtra.mNamedTrackCache;
            this.mCounterTrackCache = this.mExtra == null ? null : this.mExtra.mCounterTrackCache;
            this.mArgInt64Cache = this.mExtra == null ? null : this.mExtra.mArgInt64Cache;
            this.mArgDoubleCache = this.mExtra == null ? null : this.mExtra.mArgDoubleCache;
            this.mArgBoolCache = this.mExtra == null ? null : this.mExtra.mArgBoolCache;
            this.mArgStringCache = this.mExtra == null ? null : this.mExtra.mArgStringCache;
            this.mFieldInt64Cache = this.mExtra == null ? null : this.mExtra.mFieldInt64Cache;
            this.mFieldDoubleCache = this.mExtra == null ? null : this.mExtra.mFieldDoubleCache;
            this.mFieldStringCache = this.mExtra == null ? null : this.mExtra.mFieldStringCache;
            this.mFieldNestedCache = this.mExtra == null ? null : this.mExtra.mFieldNestedCache;
            this.mBuilderCache = this.mExtra == null ? null : this.mExtra.mBuilderCache;
            this.mCounterInt64 = this.mExtra == null ? null : this.mExtra.getCounterInt64();
            this.mCounterDouble = this.mExtra == null ? null : this.mExtra.getCounterDouble();
            this.mProto = this.mExtra == null ? null : this.mExtra.getProto();
            this.mFlow = this.mExtra == null ? null : this.mExtra.getFlow();
            this.mTerminatingFlow = this.mExtra == null ? null : this.mExtra.getTerminatingFlow();
        }

        public void emit() {
            if (!this.mIsCategoryEnabled) {
                return;
            }
            this.mIsBuilt = true;
            PerfettoTrackEventExtra.native_emit(this.mTraceType, this.mCategory.getPtr(), this.mEventName, this.mExtra.getPtr());
        }

        public Builder init(int traceType, PerfettoTrace.Category category) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            this.mTraceType = traceType;
            this.mCategory = category;
            this.mEventName = "";
            this.mFieldInt64Cache.reset();
            this.mFieldDoubleCache.reset();
            this.mFieldStringCache.reset();
            this.mFieldNestedCache.reset();
            this.mBuilderCache.reset();
            this.mExtra.reset();
            return this.initInternal(this, null);
        }

        public Builder setEventName(String eventName) {
            this.mEventName = eventName;
            return this;
        }

        public Builder addArg(String name, long val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            ArgInt64 arg = this.mArgInt64Cache.get(name.hashCode());
            if (arg == null || !arg.getName().equals(name)) {
                arg = new ArgInt64(name);
                this.mArgInt64Cache.put(name.hashCode(), arg);
            }
            arg.setValue(val);
            this.mExtra.addPerfettoPointer(arg);
            return this;
        }

        public Builder addArg(String name, boolean val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            ArgBool arg = this.mArgBoolCache.get(name.hashCode());
            if (arg == null || !arg.getName().equals(name)) {
                arg = new ArgBool(name);
                this.mArgBoolCache.put(name.hashCode(), arg);
            }
            arg.setValue(val);
            this.mExtra.addPerfettoPointer(arg);
            return this;
        }

        public Builder addArg(String name, double val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            ArgDouble arg = this.mArgDoubleCache.get(name.hashCode());
            if (arg == null || !arg.getName().equals(name)) {
                arg = new ArgDouble(name);
                this.mArgDoubleCache.put(name.hashCode(), arg);
            }
            arg.setValue(val);
            this.mExtra.addPerfettoPointer(arg);
            return this;
        }

        public Builder addArg(String name, String val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            ArgString arg = this.mArgStringCache.get(name.hashCode());
            if (arg == null || !arg.getName().equals(name)) {
                arg = new ArgString(name);
                this.mArgStringCache.put(name.hashCode(), arg);
            }
            arg.setValue(val);
            this.mExtra.addPerfettoPointer(arg);
            return this;
        }

        public Builder setFlow(long id2) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            this.mFlow.setProcessFlow(id2);
            this.mExtra.addPerfettoPointer(this.mFlow);
            return this;
        }

        public Builder setTerminatingFlow(long id2) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            this.mTerminatingFlow.setProcessTerminatingFlow(id2);
            this.mExtra.addPerfettoPointer(this.mTerminatingFlow);
            return this;
        }

        public Builder usingNamedTrack(long parentUuid, String name) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            NamedTrack track = this.mNamedTrackCache.get(name.hashCode());
            if (track == null || !track.getName().equals(name)) {
                track = new NamedTrack(name, parentUuid);
                this.mNamedTrackCache.put(name.hashCode(), track);
            }
            this.mExtra.addPerfettoPointer(track);
            return this;
        }

        public Builder usingProcessNamedTrack(String name) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            return this.usingNamedTrack(PerfettoTrace.getProcessTrackUuid(), name);
        }

        public Builder usingThreadNamedTrack(long tid, String name) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            return this.usingNamedTrack(PerfettoTrace.getThreadTrackUuid(tid), name);
        }

        public Builder usingCounterTrack(long parentUuid, String name) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            CounterTrack track = this.mCounterTrackCache.get(name.hashCode());
            if (track == null || !track.getName().equals(name)) {
                track = new CounterTrack(name, parentUuid);
                this.mCounterTrackCache.put(name.hashCode(), track);
            }
            this.mExtra.addPerfettoPointer(track);
            return this;
        }

        public Builder usingProcessCounterTrack(String name) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            return this.usingCounterTrack(PerfettoTrace.getProcessTrackUuid(), name);
        }

        public Builder usingThreadCounterTrack(long tid, String name) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            return this.usingCounterTrack(PerfettoTrace.getThreadTrackUuid(tid), name);
        }

        public Builder setCounter(long val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            this.mCounterInt64.setValue(val);
            this.mExtra.addPerfettoPointer(this.mCounterInt64);
            return this;
        }

        public Builder setCounter(double val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            this.mCounterDouble.setValue(val);
            this.mExtra.addPerfettoPointer(this.mCounterDouble);
            return this;
        }

        public Builder addField(long id2, long val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            FieldInt64 field = this.mFieldInt64Cache.get(sFieldInt64Supplier);
            field.setValue(id2, val);
            this.mExtra.addPerfettoPointer(this.mCurrentContainer, field);
            return this;
        }

        public Builder addField(long id2, double val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            FieldDouble field = this.mFieldDoubleCache.get(sFieldDoubleSupplier);
            field.setValue(id2, val);
            this.mExtra.addPerfettoPointer(this.mCurrentContainer, field);
            return this;
        }

        public Builder addField(long id2, String val) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            FieldString field = this.mFieldStringCache.get(sFieldStringSupplier);
            field.setValue(id2, val);
            this.mExtra.addPerfettoPointer(this.mCurrentContainer, field);
            return this;
        }

        public Builder beginProto() {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            this.mProto.clearFields();
            this.mExtra.addPerfettoPointer(this.mProto);
            return this.mBuilderCache.get(sBuilderSupplier).initInternal(this, this.mProto);
        }

        public Builder endProto() {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            if (this.mParent == null || this.mCurrentContainer == null) {
                throw new IllegalStateException("No proto to end");
            }
            return this.mParent;
        }

        public Builder beginNested(long id2) {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            FieldNested field = this.mFieldNestedCache.get(sFieldNestedSupplier);
            field.setId(id2);
            this.mExtra.addPerfettoPointer(this.mCurrentContainer, field);
            return this.mBuilderCache.get(sBuilderSupplier).initInternal(this, field);
        }

        public Builder endNested() {
            if (!this.mIsCategoryEnabled) {
                return this;
            }
            if (this.mParent == null || this.mCurrentContainer == null) {
                throw new IllegalStateException("No nested field to end");
            }
            return this.mParent;
        }

        private Builder initInternal(Builder parent, FieldContainer field) {
            this.mParent = parent;
            this.mCurrentContainer = field;
            this.mIsBuilt = false;
            return this;
        }

        private void checkState() {
            if (this.mIsBuilt) {
                throw new IllegalStateException("This builder has already been used. Create a new builder for another event.");
            }
        }

        private void checkParent() {
            this.checkState();
            if (!this.equals(this.mParent)) {
                throw new IllegalStateException("Operation not supported for proto");
            }
        }

        private void checkContainer() {
            this.checkState();
            if (this.mCurrentContainer == null) {
                throw new IllegalStateException("Field operations must be within beginProto/endProto block");
            }
        }
    }

    public static interface FieldContainer {
        public void addField(PerfettoPointer var1);
    }

    private static class RingBuffer<T> {
        private final int mCapacity;
        private final int[] mKeyArray;
        private final T[] mValueArray;
        private int mWriteEnd = 0;

        RingBuffer(int capacity) {
            this.mCapacity = capacity;
            this.mKeyArray = new int[capacity];
            this.mValueArray = new Object[capacity];
        }

        public void put(int key, T value) {
            this.mKeyArray[this.mWriteEnd] = key;
            this.mValueArray[this.mWriteEnd] = value;
            this.mWriteEnd = (this.mWriteEnd + 1) % this.mCapacity;
        }

        public T get(int key) {
            for (int i = 0; i < this.mCapacity; ++i) {
                if (this.mKeyArray[i] != key) continue;
                return this.mValueArray[i];
            }
            return null;
        }
    }

    public static interface PerfettoPointer {
        public long getPtr();
    }

    public static class CounterInt64
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(CounterInt64.class.getClassLoader(), CounterInt64.native_delete());
        private final long mPtr = CounterInt64.native_init();
        private final long mExtraPtr = CounterInt64.native_get_extra_ptr(this.mPtr);

        CounterInt64() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public void setValue(long value) {
            CounterInt64.native_set_value(this.mPtr, value);
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterInt64#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterInt64#native_delete()J", true, null);
        }

        @CriticalNative
        private static void native_set_value(long l, long l2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$CounterInt64#native_set_value(JJ)V", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterInt64#native_get_extra_ptr(J)J", true, null);
        }
    }

    public static class CounterDouble
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(CounterDouble.class.getClassLoader(), CounterDouble.native_delete());
        private final long mPtr = CounterDouble.native_init();
        private final long mExtraPtr = CounterDouble.native_get_extra_ptr(this.mPtr);

        CounterDouble() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public void setValue(double value) {
            CounterDouble.native_set_value(this.mPtr, value);
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterDouble#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterDouble#native_delete()J", true, null);
        }

        @CriticalNative
        private static void native_set_value(long l, double d) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$CounterDouble#native_set_value(JD)V", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterDouble#native_get_extra_ptr(J)J", true, null);
        }
    }

    public static class Proto
    implements PerfettoPointer,
    FieldContainer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Proto.class.getClassLoader(), Proto.native_delete());
        private final long mPtr = Proto.native_init();
        private final long mExtraPtr = Proto.native_get_extra_ptr(this.mPtr);

        Proto() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        @Override
        public void addField(PerfettoPointer field) {
            Proto.native_add_field(this.mPtr, field.getPtr());
        }

        public void clearFields() {
            Proto.native_clear_fields(this.mPtr);
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$Proto#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$Proto#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$Proto#native_get_extra_ptr(J)J", true, null);
        }

        @CriticalNative
        private static void native_add_field(long l, long l2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$Proto#native_add_field(JJ)V", true, null);
        }

        @CriticalNative
        private static void native_clear_fields(long l) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$Proto#native_clear_fields(J)V", true, null);
        }
    }

    public static class Flow
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Flow.class.getClassLoader(), Flow.native_delete());
        private final long mPtr = Flow.native_init();
        private final long mExtraPtr = Flow.native_get_extra_ptr(this.mPtr);

        Flow() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        public void setProcessFlow(long type) {
            Flow.native_set_process_flow(this.mPtr, type);
        }

        public void setProcessTerminatingFlow(long id2) {
            Flow.native_set_process_terminating_flow(this.mPtr, id2);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$Flow#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$Flow#native_delete()J", true, null);
        }

        @CriticalNative
        private static void native_set_process_flow(long l, long l2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$Flow#native_set_process_flow(JJ)V", true, null);
        }

        @CriticalNative
        private static void native_set_process_terminating_flow(long l, long l2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$Flow#native_set_process_terminating_flow(JJ)V", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$Flow#native_get_extra_ptr(J)J", true, null);
        }
    }

    private static class FieldNested
    implements PerfettoPointer,
    FieldContainer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(FieldNested.class.getClassLoader(), FieldNested.native_delete());
        private final long mPtr = FieldNested.native_init();
        private final long mFieldPtr = FieldNested.native_get_extra_ptr(this.mPtr);

        FieldNested() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mFieldPtr;
        }

        @Override
        public void addField(PerfettoPointer field) {
            FieldNested.native_add_field(this.mPtr, field.getPtr());
        }

        public void setId(long id2) {
            FieldNested.native_set_id(this.mPtr, id2);
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldNested#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldNested#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldNested#native_get_extra_ptr(J)J", true, null);
        }

        @CriticalNative
        private static void native_add_field(long l, long l2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$FieldNested#native_add_field(JJ)V", true, null);
        }

        @CriticalNative
        private static void native_set_id(long l, long l2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$FieldNested#native_set_id(JJ)V", true, null);
        }
    }

    private static class FieldString
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(FieldString.class.getClassLoader(), FieldString.native_delete());
        private final long mPtr = FieldString.native_init();
        private final long mFieldPtr = FieldString.native_get_extra_ptr(this.mPtr);

        FieldString() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mFieldPtr;
        }

        public void setValue(long id2, String val) {
            FieldString.native_set_value(this.mPtr, id2, val);
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldString#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldString#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldString#native_get_extra_ptr(J)J", true, null);
        }

        @FastNative
        private static void native_set_value(long l, long l2, String string2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$FieldString#native_set_value(JJLjava/lang/String;)V", true, null);
        }
    }

    private static class FieldDouble
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(FieldDouble.class.getClassLoader(), FieldDouble.native_delete());
        private final long mPtr = FieldDouble.native_init();
        private final long mFieldPtr = FieldDouble.native_get_extra_ptr(this.mPtr);

        FieldDouble() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mFieldPtr;
        }

        public void setValue(long id2, double val) {
            FieldDouble.native_set_value(this.mPtr, id2, val);
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldDouble#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldDouble#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldDouble#native_get_extra_ptr(J)J", true, null);
        }

        @CriticalNative
        private static void native_set_value(long l, long l2, double d) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$FieldDouble#native_set_value(JJD)V", true, null);
        }
    }

    private static class FieldInt64
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(FieldInt64.class.getClassLoader(), FieldInt64.native_delete());
        private final long mPtr = FieldInt64.native_init();
        private final long mFieldPtr = FieldInt64.native_get_extra_ptr(this.mPtr);

        FieldInt64() {
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mFieldPtr;
        }

        public void setValue(long id2, long val) {
            FieldInt64.native_set_value(this.mPtr, id2, val);
        }

        @CriticalNative
        private static long native_init() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldInt64#native_init()J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldInt64#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$FieldInt64#native_get_extra_ptr(J)J", true, null);
        }

        @CriticalNative
        private static void native_set_value(long l, long l2, long l3) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$FieldInt64#native_set_value(JJJ)V", true, null);
        }
    }

    private static class ArgString
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(ArgString.class.getClassLoader(), ArgString.native_delete());
        private final long mPtr;
        private final long mExtraPtr;
        private final String mName;

        ArgString(String name) {
            this.mPtr = ArgString.native_init(name);
            this.mExtraPtr = ArgString.native_get_extra_ptr(this.mPtr);
            this.mName = name;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public String getName() {
            return this.mName;
        }

        public void setValue(String val) {
            ArgString.native_set_value(this.mPtr, val);
        }

        @FastNative
        private static long native_init(String string2) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgString#native_init(Ljava/lang/String;)J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgString#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgString#native_get_extra_ptr(J)J", true, null);
        }

        @FastNative
        private static void native_set_value(long l, String string2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$ArgString#native_set_value(JLjava/lang/String;)V", true, null);
        }
    }

    private static class ArgDouble
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(ArgDouble.class.getClassLoader(), ArgDouble.native_delete());
        private final long mPtr;
        private final long mExtraPtr;
        private final String mName;

        ArgDouble(String name) {
            this.mPtr = ArgDouble.native_init(name);
            this.mExtraPtr = ArgDouble.native_get_extra_ptr(this.mPtr);
            this.mName = name;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public String getName() {
            return this.mName;
        }

        public void setValue(double val) {
            ArgDouble.native_set_value(this.mPtr, val);
        }

        @FastNative
        private static long native_init(String string2) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgDouble#native_init(Ljava/lang/String;)J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgDouble#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgDouble#native_get_extra_ptr(J)J", true, null);
        }

        @CriticalNative
        private static void native_set_value(long l, double d) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$ArgDouble#native_set_value(JD)V", true, null);
        }
    }

    private static class ArgBool
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(ArgBool.class.getClassLoader(), ArgBool.native_delete());
        private final long mPtr;
        private final long mExtraPtr;
        private final String mName;

        ArgBool(String name) {
            this.mPtr = ArgBool.native_init(name);
            this.mExtraPtr = ArgBool.native_get_extra_ptr(this.mPtr);
            this.mName = name;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public String getName() {
            return this.mName;
        }

        public void setValue(boolean val) {
            ArgBool.native_set_value(this.mPtr, val);
        }

        @FastNative
        private static long native_init(String string2) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgBool#native_init(Ljava/lang/String;)J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgBool#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgBool#native_get_extra_ptr(J)J", true, null);
        }

        @CriticalNative
        private static void native_set_value(long l, boolean bl) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$ArgBool#native_set_value(JZ)V", true, null);
        }
    }

    private static class ArgInt64
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(ArgInt64.class.getClassLoader(), ArgInt64.native_delete());
        private final long mPtr;
        private final long mExtraPtr;
        private final String mName;

        ArgInt64(String name) {
            this.mPtr = ArgInt64.native_init(name);
            this.mExtraPtr = ArgInt64.native_get_extra_ptr(this.mPtr);
            this.mName = name;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public String getName() {
            return this.mName;
        }

        public void setValue(long val) {
            ArgInt64.native_set_value(this.mPtr, val);
        }

        @FastNative
        private static long native_init(String string2) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgInt64#native_init(Ljava/lang/String;)J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgInt64#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$ArgInt64#native_get_extra_ptr(J)J", true, null);
        }

        @CriticalNative
        private static void native_set_value(long l, long l2) {
            OverrideMethod.invokeV("android.os.PerfettoTrackEventExtra$ArgInt64#native_set_value(JJ)V", true, null);
        }
    }

    private static class CounterTrack
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(CounterTrack.class.getClassLoader(), CounterTrack.native_delete());
        private final long mPtr;
        private final long mExtraPtr;
        private final String mName;

        CounterTrack(String name, long parentUuid) {
            this.mPtr = CounterTrack.native_init(name, parentUuid);
            this.mExtraPtr = CounterTrack.native_get_extra_ptr(this.mPtr);
            this.mName = name;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public String getName() {
            return this.mName;
        }

        @FastNative
        private static long native_init(String string2, long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterTrack#native_init(Ljava/lang/String;J)J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterTrack#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$CounterTrack#native_get_extra_ptr(J)J", true, null);
        }
    }

    private static class NamedTrack
    implements PerfettoPointer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(NamedTrack.class.getClassLoader(), NamedTrack.native_delete());
        private final long mPtr;
        private final long mExtraPtr;
        private final String mName;

        NamedTrack(String name, long parentUuid) {
            this.mPtr = NamedTrack.native_init(sNamedTrackId.incrementAndGet(), name, parentUuid);
            this.mExtraPtr = NamedTrack.native_get_extra_ptr(this.mPtr);
            this.mName = name;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        @Override
        public long getPtr() {
            return this.mExtraPtr;
        }

        public String getName() {
            return this.mName;
        }

        @FastNative
        private static long native_init(long l, String string2, long l2) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$NamedTrack#native_init(JLjava/lang/String;J)J", true, null);
        }

        @CriticalNative
        private static long native_delete() {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$NamedTrack#native_delete()J", true, null);
        }

        @CriticalNative
        private static long native_get_extra_ptr(long l) {
            return OverrideMethod.invokeL("android.os.PerfettoTrackEventExtra$NamedTrack#native_get_extra_ptr(J)J", true, null);
        }
    }
}

