/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.MathUtils;

@SystemApi
public class ParcelableHolder
implements Parcelable {
    private Parcelable mParcelable;
    private Parcel mParcel;
    private int mStability = 0;
    @NonNull
    public static final Parcelable.Creator<ParcelableHolder> CREATOR = new Parcelable.Creator<ParcelableHolder>(){

        @Override
        @NonNull
        public ParcelableHolder createFromParcel(@NonNull Parcel parcel) {
            ParcelableHolder parcelable = new ParcelableHolder();
            parcelable.readFromParcel(parcel);
            return parcelable;
        }

        @NonNull
        public ParcelableHolder[] newArray(int size) {
            return new ParcelableHolder[size];
        }
    };

    public ParcelableHolder(int stability) {
        this.mStability = stability;
    }

    private ParcelableHolder() {
    }

    @Override
    public int getStability() {
        return this.mStability;
    }

    public void setParcelable(@Nullable Parcelable p) {
        if (p != null && this.getStability() > p.getStability()) {
            throw new BadParcelableException("A ParcelableHolder can only hold things at its stability or higher. The ParcelableHolder's stability is " + this.getStability() + ", but the parcelable's stability is " + p.getStability());
        }
        this.mParcelable = p;
        if (this.mParcel != null) {
            this.mParcel.recycle();
            this.mParcel = null;
        }
    }

    @Nullable
    public <T extends Parcelable> T getParcelable(@NonNull Class<T> clazz) {
        if (this.mParcel == null) {
            if (this.mParcelable != null && !clazz.isInstance(this.mParcelable)) {
                throw new BadParcelableException("The ParcelableHolder has " + this.mParcelable.getClass().getName() + ", but the requested type is " + clazz.getName());
            }
            return (T)this.mParcelable;
        }
        this.mParcel.setDataPosition(0);
        Object parcelable = this.mParcel.readParcelable(clazz.getClassLoader());
        if (parcelable != null && !clazz.isInstance(parcelable)) {
            throw new BadParcelableException("The ParcelableHolder has " + parcelable.getClass().getName() + ", but the requested type is " + clazz.getName());
        }
        this.mParcelable = parcelable;
        this.mParcel.recycle();
        this.mParcel = null;
        return parcelable;
    }

    public void readFromParcel(@NonNull Parcel parcel) {
        int wireStability = parcel.readInt();
        if (this.mStability != wireStability) {
            throw new IllegalArgumentException("Expected stability " + this.mStability + " but got " + wireStability);
        }
        this.mParcelable = null;
        int dataSize = parcel.readInt();
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize from parcel is negative");
        }
        if (dataSize == 0) {
            if (this.mParcel != null) {
                this.mParcel.recycle();
                this.mParcel = null;
            }
            return;
        }
        if (this.mParcel == null) {
            this.mParcel = Parcel.obtain();
        }
        this.mParcel.setDataPosition(0);
        this.mParcel.setDataSize(0);
        int dataStartPos = parcel.dataPosition();
        this.mParcel.appendFrom(parcel, dataStartPos, dataSize);
        parcel.setDataPosition(MathUtils.addOrThrow(dataStartPos, dataSize));
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(this.mStability);
        if (this.mParcel != null) {
            parcel.writeInt(this.mParcel.dataSize());
            parcel.appendFrom(this.mParcel, 0, this.mParcel.dataSize());
            return;
        }
        if (this.mParcelable == null) {
            parcel.writeInt(0);
            return;
        }
        int sizePos = parcel.dataPosition();
        parcel.writeInt(0);
        int dataStartPos = parcel.dataPosition();
        parcel.writeParcelable(this.mParcelable, 0);
        int dataSize = parcel.dataPosition() - dataStartPos;
        parcel.setDataPosition(sizePos);
        parcel.writeInt(dataSize);
        parcel.setDataPosition(MathUtils.addOrThrow(parcel.dataPosition(), dataSize));
    }

    @Override
    public int describeContents() {
        if (this.mParcel != null) {
            return this.mParcel.hasFileDescriptors() ? 1 : 0;
        }
        if (this.mParcelable != null) {
            return this.mParcelable.describeContents();
        }
        return 0;
    }
}

