/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;

public interface IPowerStatsService
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IPowerStatsService";
    public static final String KEY_MONITORS = "monitors";
    public static final String KEY_ENERGY = "energy";
    public static final String KEY_TIMESTAMPS = "timestamps";
    public static final String KEY_GRANULARITY = "granularity";
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_UNSUPPORTED_POWER_MONITOR = 1;

    public void getSupportedPowerMonitors(ResultReceiver var1) throws RemoteException;

    public void getPowerMonitorReadings(int[] var1, ResultReceiver var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPowerStatsService {
        static final int TRANSACTION_getSupportedPowerMonitors = 1;
        static final int TRANSACTION_getPowerMonitorReadings = 2;

        public Stub() {
            this.attachInterface(this, IPowerStatsService.DESCRIPTOR);
        }

        public static IPowerStatsService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPowerStatsService.DESCRIPTOR);
            if (iin != null && iin instanceof IPowerStatsService) {
                return (IPowerStatsService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSupportedPowerMonitors";
                }
                case 2: {
                    return "getPowerMonitorReadings";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPowerStatsService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ResultReceiver _arg0 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getSupportedPowerMonitors(_arg0);
                    break;
                }
                case 2: {
                    int[] _arg0 = data.createIntArray();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getPowerMonitorReadings(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IPowerStatsService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPowerStatsService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSupportedPowerMonitors(ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPowerStatsService.DESCRIPTOR);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPowerMonitorReadings(int[] powerMonitorIndices, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPowerStatsService.DESCRIPTOR);
                    _data.writeIntArray(powerMonitorIndices);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPowerStatsService {
        @Override
        public void getSupportedPowerMonitors(ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void getPowerMonitorReadings(int[] powerMonitorIndices, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

