/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadParcelableException;
import android.os.BatterySaverPolicyConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IScreenTimeoutPolicyListener;
import android.os.IWakeLockCallback;
import android.os.Parcel;
import android.os.ParcelDuration;
import android.os.Parcelable;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;

public interface IPowerManager
extends IInterface {
    public static final int LOCATION_MODE_NO_CHANGE = 0;
    public static final int LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF = 1;
    public static final int LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF = 2;
    public static final int LOCATION_MODE_FOREGROUND_ONLY = 3;
    public static final int LOCATION_MODE_THROTTLE_REQUESTS_WHEN_SCREEN_OFF = 4;
    public static final int MIN_LOCATION_MODE = 0;
    public static final int MAX_LOCATION_MODE = 4;
    public static final int GO_TO_SLEEP_REASON_MIN = 0;
    public static final int GO_TO_SLEEP_REASON_APPLICATION = 0;
    public static final int GO_TO_SLEEP_REASON_TIMEOUT = 2;
    public static final int GO_TO_SLEEP_REASON_LID_SWITCH = 3;
    public static final int GO_TO_SLEEP_REASON_POWER_BUTTON = 4;
    public static final int GO_TO_SLEEP_REASON_HDMI = 5;
    public static final int GO_TO_SLEEP_REASON_SLEEP_BUTTON = 6;
    public static final int GO_TO_SLEEP_REASON_ACCESSIBILITY = 7;
    public static final int GO_TO_SLEEP_REASON_FORCE_SUSPEND = 8;
    public static final int GO_TO_SLEEP_REASON_INATTENTIVE = 9;
    public static final int GO_TO_SLEEP_REASON_QUIESCENT = 10;
    public static final int GO_TO_SLEEP_REASON_MAX = 10;
    public static final int GO_TO_SLEEP_FLAG_NO_DOZE = 1;

    public void acquireWakeLock(IBinder var1, int var2, String var3, String var4, WorkSource var5, String var6, int var7, IWakeLockCallback var8) throws RemoteException;

    public void acquireWakeLockWithUid(IBinder var1, int var2, String var3, String var4, int var5, int var6, IWakeLockCallback var7) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:35:1:35:25")
    public void releaseWakeLock(IBinder var1, int var2) throws RemoteException;

    public void updateWakeLockUids(IBinder var1, int[] var2) throws RemoteException;

    public void setPowerBoost(int var1, int var2) throws RemoteException;

    public void setPowerMode(int var1, boolean var2) throws RemoteException;

    public boolean setPowerModeChecked(int var1, boolean var2) throws RemoteException;

    public void updateWakeLockWorkSource(IBinder var1, WorkSource var2, String var3) throws RemoteException;

    public void updateWakeLockCallback(IBinder var1, IWakeLockCallback var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:46:1:46:25")
    public boolean isWakeLockLevelSupported(int var1) throws RemoteException;

    public boolean isWakeLockLevelSupportedWithDisplayId(int var1, int var2) throws RemoteException;

    public void addScreenTimeoutPolicyListener(int var1, IScreenTimeoutPolicyListener var2) throws RemoteException;

    public void removeScreenTimeoutPolicyListener(int var1, IScreenTimeoutPolicyListener var2) throws RemoteException;

    public void userActivity(int var1, long var2, int var4, int var5) throws RemoteException;

    public void wakeUp(long var1, int var3, String var4, String var5) throws RemoteException;

    public void wakeUpWithDisplayId(long var1, int var3, String var4, String var5, int var6) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:57:1:57:69")
    public void goToSleep(long var1, int var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:59:1:59:69")
    public void goToSleepWithDisplayId(int var1, long var2, int var4, int var5) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:61:1:61:44")
    public void nap(long var1) throws RemoteException;

    public float getBrightnessConstraint(int var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:64:1:64:25")
    public boolean isInteractive() throws RemoteException;

    public boolean isDisplayInteractive(int var1) throws RemoteException;

    public boolean areAutoPowerSaveModesEnabled() throws RemoteException;

    public boolean isPowerSaveMode() throws RemoteException;

    public PowerSaveState getPowerSaveState(int var1) throws RemoteException;

    public boolean setPowerSaveModeEnabled(boolean var1) throws RemoteException;

    public boolean isBatterySaverSupported() throws RemoteException;

    public BatterySaverPolicyConfig getFullPowerSavePolicy() throws RemoteException;

    public boolean setFullPowerSavePolicy(BatterySaverPolicyConfig var1) throws RemoteException;

    public boolean setDynamicPowerSaveHint(boolean var1, int var2) throws RemoteException;

    public boolean setAdaptivePowerSavePolicy(BatterySaverPolicyConfig var1) throws RemoteException;

    public boolean setAdaptivePowerSaveEnabled(boolean var1) throws RemoteException;

    public int getPowerSaveModeTrigger() throws RemoteException;

    public void setBatteryDischargePrediction(ParcelDuration var1, boolean var2) throws RemoteException;

    public ParcelDuration getBatteryDischargePrediction() throws RemoteException;

    public boolean isBatteryDischargePredictionPersonalized() throws RemoteException;

    public boolean isDeviceIdleMode() throws RemoteException;

    public boolean isLightDeviceIdleMode() throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public boolean isLowPowerStandbySupported() throws RemoteException;

    public boolean isLowPowerStandbyEnabled() throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyEnabled(boolean var1) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyActiveDuringMaintenance(boolean var1) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void forceLowPowerStandbyActive(boolean var1) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyPolicy(LowPowerStandbyPolicy var1) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public LowPowerStandbyPolicy getLowPowerStandbyPolicy() throws RemoteException;

    public boolean isExemptFromLowPowerStandby() throws RemoteException;

    public boolean isReasonAllowedInLowPowerStandby(int var1) throws RemoteException;

    public boolean isFeatureAllowedInLowPowerStandby(String var1) throws RemoteException;

    @RequiresPermission(value="android.permission.SET_LOW_POWER_STANDBY_PORTS")
    public void acquireLowPowerStandbyPorts(IBinder var1, List<LowPowerStandbyPortDescription> var2) throws RemoteException;

    @RequiresPermission(value="android.permission.SET_LOW_POWER_STANDBY_PORTS")
    public void releaseLowPowerStandbyPorts(IBinder var1) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public List<LowPowerStandbyPortDescription> getActiveLowPowerStandbyPorts() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/os/IPowerManager.aidl:120:1:120:25")
    public void reboot(boolean var1, String var2, boolean var3) throws RemoteException;

    public void rebootSafeMode(boolean var1, boolean var2) throws RemoteException;

    public void shutdown(boolean var1, String var2, boolean var3) throws RemoteException;

    public void crash(String var1) throws RemoteException;

    public int getLastShutdownReason() throws RemoteException;

    public int getLastSleepReason() throws RemoteException;

    public void setStayOnSetting(int var1) throws RemoteException;

    public void boostScreenBrightness(long var1) throws RemoteException;

    public void acquireWakeLockAsync(IBinder var1, int var2, String var3, String var4, WorkSource var5, String var6) throws RemoteException;

    public void releaseWakeLockAsync(IBinder var1, int var2) throws RemoteException;

    public void updateWakeLockUidsAsync(IBinder var1, int[] var2) throws RemoteException;

    public boolean isScreenBrightnessBoosted() throws RemoteException;

    public void setAttentionLight(boolean var1, int var2) throws RemoteException;

    public void setDozeAfterScreenOff(boolean var1) throws RemoteException;

    public boolean isAmbientDisplayAvailable() throws RemoteException;

    public void suppressAmbientDisplay(String var1, boolean var2) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void suppressAmbientDisplayBehavior(String var1, int var2) throws RemoteException;

    public boolean isAmbientDisplaySuppressedForToken(String var1) throws RemoteException;

    public boolean isAmbientDisplaySuppressed() throws RemoteException;

    public boolean isAmbientDisplaySuppressedForTokenByApp(String var1, int var2) throws RemoteException;

    public boolean forceSuspend() throws RemoteException;

    public static class LowPowerStandbyPortDescription
    implements Parcelable {
        public int protocol = 0;
        public int portMatcher = 0;
        public int portNumber = 0;
        public byte[] localAddress;
        public static final Parcelable.Creator<LowPowerStandbyPortDescription> CREATOR = new Parcelable.Creator<LowPowerStandbyPortDescription>(){

            @Override
            public LowPowerStandbyPortDescription createFromParcel(Parcel _aidl_source) {
                LowPowerStandbyPortDescription _aidl_out = new LowPowerStandbyPortDescription();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public LowPowerStandbyPortDescription[] newArray(int _aidl_size) {
                return new LowPowerStandbyPortDescription[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeInt(this.protocol);
            _aidl_parcel.writeInt(this.portMatcher);
            _aidl_parcel.writeInt(this.portNumber);
            _aidl_parcel.writeByteArray(this.localAddress);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.protocol = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.portMatcher = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.portNumber = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.localAddress = _aidl_parcel.createByteArray();
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask;
        }
    }

    public static class LowPowerStandbyPolicy
    implements Parcelable {
        public String identifier;
        public List<String> exemptPackages;
        public int allowedReasons = 0;
        public List<String> allowedFeatures;
        public static final Parcelable.Creator<LowPowerStandbyPolicy> CREATOR = new Parcelable.Creator<LowPowerStandbyPolicy>(){

            @Override
            public LowPowerStandbyPolicy createFromParcel(Parcel _aidl_source) {
                LowPowerStandbyPolicy _aidl_out = new LowPowerStandbyPolicy();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public LowPowerStandbyPolicy[] newArray(int _aidl_size) {
                return new LowPowerStandbyPolicy[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeString(this.identifier);
            _aidl_parcel.writeStringList(this.exemptPackages);
            _aidl_parcel.writeInt(this.allowedReasons);
            _aidl_parcel.writeStringList(this.allowedFeatures);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.identifier = _aidl_parcel.readString();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.exemptPackages = _aidl_parcel.createStringArrayList();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.allowedReasons = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.allowedFeatures = _aidl_parcel.createStringArrayList();
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask;
        }
    }

    public static abstract class Stub
    extends Binder
    implements IPowerManager {
        public static final String DESCRIPTOR = "android.os.IPowerManager";
        static final int TRANSACTION_acquireWakeLock = 1;
        static final int TRANSACTION_acquireWakeLockWithUid = 2;
        static final int TRANSACTION_releaseWakeLock = 3;
        static final int TRANSACTION_updateWakeLockUids = 4;
        static final int TRANSACTION_setPowerBoost = 5;
        static final int TRANSACTION_setPowerMode = 6;
        static final int TRANSACTION_setPowerModeChecked = 7;
        static final int TRANSACTION_updateWakeLockWorkSource = 8;
        static final int TRANSACTION_updateWakeLockCallback = 9;
        static final int TRANSACTION_isWakeLockLevelSupported = 10;
        static final int TRANSACTION_isWakeLockLevelSupportedWithDisplayId = 11;
        static final int TRANSACTION_addScreenTimeoutPolicyListener = 12;
        static final int TRANSACTION_removeScreenTimeoutPolicyListener = 13;
        static final int TRANSACTION_userActivity = 14;
        static final int TRANSACTION_wakeUp = 15;
        static final int TRANSACTION_wakeUpWithDisplayId = 16;
        static final int TRANSACTION_goToSleep = 17;
        static final int TRANSACTION_goToSleepWithDisplayId = 18;
        static final int TRANSACTION_nap = 19;
        static final int TRANSACTION_getBrightnessConstraint = 20;
        static final int TRANSACTION_isInteractive = 21;
        static final int TRANSACTION_isDisplayInteractive = 22;
        static final int TRANSACTION_areAutoPowerSaveModesEnabled = 23;
        static final int TRANSACTION_isPowerSaveMode = 24;
        static final int TRANSACTION_getPowerSaveState = 25;
        static final int TRANSACTION_setPowerSaveModeEnabled = 26;
        static final int TRANSACTION_isBatterySaverSupported = 27;
        static final int TRANSACTION_getFullPowerSavePolicy = 28;
        static final int TRANSACTION_setFullPowerSavePolicy = 29;
        static final int TRANSACTION_setDynamicPowerSaveHint = 30;
        static final int TRANSACTION_setAdaptivePowerSavePolicy = 31;
        static final int TRANSACTION_setAdaptivePowerSaveEnabled = 32;
        static final int TRANSACTION_getPowerSaveModeTrigger = 33;
        static final int TRANSACTION_setBatteryDischargePrediction = 34;
        static final int TRANSACTION_getBatteryDischargePrediction = 35;
        static final int TRANSACTION_isBatteryDischargePredictionPersonalized = 36;
        static final int TRANSACTION_isDeviceIdleMode = 37;
        static final int TRANSACTION_isLightDeviceIdleMode = 38;
        static final int TRANSACTION_isLowPowerStandbySupported = 39;
        static final int TRANSACTION_isLowPowerStandbyEnabled = 40;
        static final int TRANSACTION_setLowPowerStandbyEnabled = 41;
        static final int TRANSACTION_setLowPowerStandbyActiveDuringMaintenance = 42;
        static final int TRANSACTION_forceLowPowerStandbyActive = 43;
        static final int TRANSACTION_setLowPowerStandbyPolicy = 44;
        static final int TRANSACTION_getLowPowerStandbyPolicy = 45;
        static final int TRANSACTION_isExemptFromLowPowerStandby = 46;
        static final int TRANSACTION_isReasonAllowedInLowPowerStandby = 47;
        static final int TRANSACTION_isFeatureAllowedInLowPowerStandby = 48;
        static final int TRANSACTION_acquireLowPowerStandbyPorts = 49;
        static final int TRANSACTION_releaseLowPowerStandbyPorts = 50;
        static final int TRANSACTION_getActiveLowPowerStandbyPorts = 51;
        static final int TRANSACTION_reboot = 52;
        static final int TRANSACTION_rebootSafeMode = 53;
        static final int TRANSACTION_shutdown = 54;
        static final int TRANSACTION_crash = 55;
        static final int TRANSACTION_getLastShutdownReason = 56;
        static final int TRANSACTION_getLastSleepReason = 57;
        static final int TRANSACTION_setStayOnSetting = 58;
        static final int TRANSACTION_boostScreenBrightness = 59;
        static final int TRANSACTION_acquireWakeLockAsync = 60;
        static final int TRANSACTION_releaseWakeLockAsync = 61;
        static final int TRANSACTION_updateWakeLockUidsAsync = 62;
        static final int TRANSACTION_isScreenBrightnessBoosted = 63;
        static final int TRANSACTION_setAttentionLight = 64;
        static final int TRANSACTION_setDozeAfterScreenOff = 65;
        static final int TRANSACTION_isAmbientDisplayAvailable = 66;
        static final int TRANSACTION_suppressAmbientDisplay = 67;
        static final int TRANSACTION_suppressAmbientDisplayBehavior = 68;
        static final int TRANSACTION_isAmbientDisplaySuppressedForToken = 69;
        static final int TRANSACTION_isAmbientDisplaySuppressed = 70;
        static final int TRANSACTION_isAmbientDisplaySuppressedForTokenByApp = 71;
        static final int TRANSACTION_forceSuspend = 72;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPowerManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPowerManager) {
                return (IPowerManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "acquireWakeLock";
                }
                case 2: {
                    return "acquireWakeLockWithUid";
                }
                case 3: {
                    return "releaseWakeLock";
                }
                case 4: {
                    return "updateWakeLockUids";
                }
                case 5: {
                    return "setPowerBoost";
                }
                case 6: {
                    return "setPowerMode";
                }
                case 7: {
                    return "setPowerModeChecked";
                }
                case 8: {
                    return "updateWakeLockWorkSource";
                }
                case 9: {
                    return "updateWakeLockCallback";
                }
                case 10: {
                    return "isWakeLockLevelSupported";
                }
                case 11: {
                    return "isWakeLockLevelSupportedWithDisplayId";
                }
                case 12: {
                    return "addScreenTimeoutPolicyListener";
                }
                case 13: {
                    return "removeScreenTimeoutPolicyListener";
                }
                case 14: {
                    return "userActivity";
                }
                case 15: {
                    return "wakeUp";
                }
                case 16: {
                    return "wakeUpWithDisplayId";
                }
                case 17: {
                    return "goToSleep";
                }
                case 18: {
                    return "goToSleepWithDisplayId";
                }
                case 19: {
                    return "nap";
                }
                case 20: {
                    return "getBrightnessConstraint";
                }
                case 21: {
                    return "isInteractive";
                }
                case 22: {
                    return "isDisplayInteractive";
                }
                case 23: {
                    return "areAutoPowerSaveModesEnabled";
                }
                case 24: {
                    return "isPowerSaveMode";
                }
                case 25: {
                    return "getPowerSaveState";
                }
                case 26: {
                    return "setPowerSaveModeEnabled";
                }
                case 27: {
                    return "isBatterySaverSupported";
                }
                case 28: {
                    return "getFullPowerSavePolicy";
                }
                case 29: {
                    return "setFullPowerSavePolicy";
                }
                case 30: {
                    return "setDynamicPowerSaveHint";
                }
                case 31: {
                    return "setAdaptivePowerSavePolicy";
                }
                case 32: {
                    return "setAdaptivePowerSaveEnabled";
                }
                case 33: {
                    return "getPowerSaveModeTrigger";
                }
                case 34: {
                    return "setBatteryDischargePrediction";
                }
                case 35: {
                    return "getBatteryDischargePrediction";
                }
                case 36: {
                    return "isBatteryDischargePredictionPersonalized";
                }
                case 37: {
                    return "isDeviceIdleMode";
                }
                case 38: {
                    return "isLightDeviceIdleMode";
                }
                case 39: {
                    return "isLowPowerStandbySupported";
                }
                case 40: {
                    return "isLowPowerStandbyEnabled";
                }
                case 41: {
                    return "setLowPowerStandbyEnabled";
                }
                case 42: {
                    return "setLowPowerStandbyActiveDuringMaintenance";
                }
                case 43: {
                    return "forceLowPowerStandbyActive";
                }
                case 44: {
                    return "setLowPowerStandbyPolicy";
                }
                case 45: {
                    return "getLowPowerStandbyPolicy";
                }
                case 46: {
                    return "isExemptFromLowPowerStandby";
                }
                case 47: {
                    return "isReasonAllowedInLowPowerStandby";
                }
                case 48: {
                    return "isFeatureAllowedInLowPowerStandby";
                }
                case 49: {
                    return "acquireLowPowerStandbyPorts";
                }
                case 50: {
                    return "releaseLowPowerStandbyPorts";
                }
                case 51: {
                    return "getActiveLowPowerStandbyPorts";
                }
                case 52: {
                    return "reboot";
                }
                case 53: {
                    return "rebootSafeMode";
                }
                case 54: {
                    return "shutdown";
                }
                case 55: {
                    return "crash";
                }
                case 56: {
                    return "getLastShutdownReason";
                }
                case 57: {
                    return "getLastSleepReason";
                }
                case 58: {
                    return "setStayOnSetting";
                }
                case 59: {
                    return "boostScreenBrightness";
                }
                case 60: {
                    return "acquireWakeLockAsync";
                }
                case 61: {
                    return "releaseWakeLockAsync";
                }
                case 62: {
                    return "updateWakeLockUidsAsync";
                }
                case 63: {
                    return "isScreenBrightnessBoosted";
                }
                case 64: {
                    return "setAttentionLight";
                }
                case 65: {
                    return "setDozeAfterScreenOff";
                }
                case 66: {
                    return "isAmbientDisplayAvailable";
                }
                case 67: {
                    return "suppressAmbientDisplay";
                }
                case 68: {
                    return "suppressAmbientDisplayBehavior";
                }
                case 69: {
                    return "isAmbientDisplaySuppressedForToken";
                }
                case 70: {
                    return "isAmbientDisplaySuppressed";
                }
                case 71: {
                    return "isAmbientDisplaySuppressedForTokenByApp";
                }
                case 72: {
                    return "forceSuspend";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    WorkSource _arg4 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    IWakeLockCallback _arg7 = IWakeLockCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.acquireWakeLock(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    IWakeLockCallback _arg6 = IWakeLockCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.acquireWakeLockWithUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseWakeLock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.updateWakeLockUids(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setPowerBoost(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setPowerMode(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setPowerModeChecked(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.updateWakeLockWorkSource(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    IWakeLockCallback _arg1 = IWakeLockCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateWakeLockCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWakeLockLevelSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWakeLockLevelSupportedWithDisplayId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    IScreenTimeoutPolicyListener _arg1 = IScreenTimeoutPolicyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addScreenTimeoutPolicyListener(_arg0, _arg1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    IScreenTimeoutPolicyListener _arg1 = IScreenTimeoutPolicyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeScreenTimeoutPolicyListener(_arg0, _arg1);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.userActivity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.wakeUp(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.wakeUpWithDisplayId(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.goToSleep(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.goToSleepWithDisplayId(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.nap(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getBrightnessConstraint(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 21: {
                    boolean _result = this.isInteractive();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDisplayInteractive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    boolean _result = this.areAutoPowerSaveModesEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    boolean _result = this.isPowerSaveMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    PowerSaveState _result = this.getPowerSaveState(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 26: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setPowerSaveModeEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    boolean _result = this.isBatterySaverSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    BatterySaverPolicyConfig _result = this.getFullPowerSavePolicy();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 29: {
                    BatterySaverPolicyConfig _arg0 = data.readTypedObject(BatterySaverPolicyConfig.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setFullPowerSavePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDynamicPowerSaveHint(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    BatterySaverPolicyConfig _arg0 = data.readTypedObject(BatterySaverPolicyConfig.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setAdaptivePowerSavePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAdaptivePowerSaveEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 33: {
                    int _result = this.getPowerSaveModeTrigger();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 34: {
                    ParcelDuration _arg0 = data.readTypedObject(ParcelDuration.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBatteryDischargePrediction(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    ParcelDuration _result = this.getBatteryDischargePrediction();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 36: {
                    boolean _result = this.isBatteryDischargePredictionPersonalized();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 37: {
                    boolean _result = this.isDeviceIdleMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 38: {
                    boolean _result = this.isLightDeviceIdleMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    boolean _result = this.isLowPowerStandbySupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    boolean _result = this.isLowPowerStandbyEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 41: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLowPowerStandbyEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLowPowerStandbyActiveDuringMaintenance(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceLowPowerStandbyActive(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    LowPowerStandbyPolicy _arg0 = data.readTypedObject(LowPowerStandbyPolicy.CREATOR);
                    data.enforceNoDataAvail();
                    this.setLowPowerStandbyPolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    LowPowerStandbyPolicy _result = this.getLowPowerStandbyPolicy();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 46: {
                    boolean _result = this.isExemptFromLowPowerStandby();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isReasonAllowedInLowPowerStandby(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 48: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isFeatureAllowedInLowPowerStandby(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 49: {
                    IBinder _arg0 = data.readStrongBinder();
                    ArrayList<LowPowerStandbyPortDescription> _arg1 = data.createTypedArrayList(LowPowerStandbyPortDescription.CREATOR);
                    data.enforceNoDataAvail();
                    this.acquireLowPowerStandbyPorts(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.releaseLowPowerStandbyPorts(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    List<LowPowerStandbyPortDescription> _result = this.getActiveLowPowerStandbyPorts();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 52: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reboot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.rebootSafeMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.shutdown(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.crash(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    int _result = this.getLastShutdownReason();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 57: {
                    int _result = this.getLastSleepReason();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setStayOnSetting(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.boostScreenBrightness(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    WorkSource _arg4 = data.readTypedObject(WorkSource.CREATOR);
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.acquireWakeLockAsync(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 61: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseWakeLockAsync(_arg0, _arg1);
                    break;
                }
                case 62: {
                    IBinder _arg0 = data.readStrongBinder();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.updateWakeLockUidsAsync(_arg0, _arg1);
                    break;
                }
                case 63: {
                    boolean _result = this.isScreenBrightnessBoosted();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 64: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAttentionLight(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDozeAfterScreenOff(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    boolean _result = this.isAmbientDisplayAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 67: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.suppressAmbientDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.suppressAmbientDisplayBehavior(_arg0, _arg1);
                    break;
                }
                case 69: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAmbientDisplaySuppressedForToken(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 70: {
                    boolean _result = this.isAmbientDisplaySuppressed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 71: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAmbientDisplaySuppressedForTokenByApp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 72: {
                    boolean _result = this.forceSuspend();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 71;
        }

        private static class Proxy
        implements IPowerManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireWakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag, int displayId, IWakeLockCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    _data.writeString(tag);
                    _data.writeString(packageName);
                    _data.writeTypedObject(ws, 0);
                    _data.writeString(historyTag);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireWakeLockWithUid(IBinder lock, int flags, String tag, String packageName, int uidtoblame, int displayId, IWakeLockCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    _data.writeString(tag);
                    _data.writeString(packageName);
                    _data.writeInt(uidtoblame);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseWakeLock(IBinder lock, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockUids(IBinder lock, int[] uids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeIntArray(uids);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPowerBoost(int boost, int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(boost);
                    _data.writeInt(durationMs);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPowerMode(int mode, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPowerModeChecked(int mode, boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockWorkSource(IBinder lock, WorkSource ws, String historyTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeTypedObject(ws, 0);
                    _data.writeString(historyTag);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockCallback(IBinder lock, IWakeLockCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWakeLockLevelSupported(int level) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(level);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWakeLockLevelSupportedWithDisplayId(int level, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(level);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addScreenTimeoutPolicyListener(int displayId, IScreenTimeoutPolicyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeScreenTimeoutPolicyListener(int displayId, IScreenTimeoutPolicyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void userActivity(int displayId, long time, int event, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeLong(time);
                    _data.writeInt(event);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wakeUp(long time, int reason, String details, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    _data.writeInt(reason);
                    _data.writeString(details);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wakeUpWithDisplayId(long time, int reason, String details, String opPackageName, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    _data.writeInt(reason);
                    _data.writeString(details);
                    _data.writeString(opPackageName);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void goToSleep(long time, int reason, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    _data.writeInt(reason);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void goToSleepWithDisplayId(int displayId, long time, int reason, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeLong(time);
                    _data.writeInt(reason);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nap(long time) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getBrightnessConstraint(int displayId, int constraint) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(constraint);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInteractive() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDisplayInteractive(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areAutoPowerSaveModesEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPowerSaveMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PowerSaveState getPowerSaveState(int serviceType) throws RemoteException {
                PowerSaveState _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serviceType);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PowerSaveState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPowerSaveModeEnabled(boolean mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mode);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBatterySaverSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BatterySaverPolicyConfig getFullPowerSavePolicy() throws RemoteException {
                BatterySaverPolicyConfig _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BatterySaverPolicyConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setFullPowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDynamicPowerSaveHint(boolean powerSaveHint, int disableThreshold) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(powerSaveHint);
                    _data.writeInt(disableThreshold);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAdaptivePowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAdaptivePowerSaveEnabled(boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPowerSaveModeTrigger() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBatteryDischargePrediction(ParcelDuration timeRemaining, boolean isCustomized) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(timeRemaining, 0);
                    _data.writeBoolean(isCustomized);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelDuration getBatteryDischargePrediction() throws RemoteException {
                ParcelDuration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelDuration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBatteryDischargePredictionPersonalized() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceIdleMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLightDeviceIdleMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLowPowerStandbySupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLowPowerStandbyEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLowPowerStandbyEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLowPowerStandbyActiveDuringMaintenance(boolean activeDuringMaintenance) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(activeDuringMaintenance);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceLowPowerStandbyActive(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLowPowerStandbyPolicy(LowPowerStandbyPolicy policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policy, 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LowPowerStandbyPolicy getLowPowerStandbyPolicy() throws RemoteException {
                LowPowerStandbyPolicy _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LowPowerStandbyPolicy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isExemptFromLowPowerStandby() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isReasonAllowedInLowPowerStandby(int reason) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFeatureAllowedInLowPowerStandby(String feature) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(feature);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireLowPowerStandbyPorts(IBinder token, List<LowPowerStandbyPortDescription> ports) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedList(ports, 0);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseLowPowerStandbyPorts(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LowPowerStandbyPortDescription> getActiveLowPowerStandbyPorts() throws RemoteException {
                ArrayList<LowPowerStandbyPortDescription> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(LowPowerStandbyPortDescription.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reboot(boolean confirm, String reason, boolean wait) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(confirm);
                    _data.writeString(reason);
                    _data.writeBoolean(wait);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rebootSafeMode(boolean confirm, boolean wait) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(confirm);
                    _data.writeBoolean(wait);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown(boolean confirm, String reason, boolean wait) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(confirm);
                    _data.writeString(reason);
                    _data.writeBoolean(wait);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void crash(String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastShutdownReason() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastSleepReason() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStayOnSetting(int val) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(val);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void boostScreenBrightness(long time) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(time);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireWakeLockAsync(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    _data.writeString(tag);
                    _data.writeString(packageName);
                    _data.writeTypedObject(ws, 0);
                    _data.writeString(historyTag);
                    boolean bl = this.mRemote.transact(60, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseWakeLockAsync(IBinder lock, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(flags);
                    boolean bl = this.mRemote.transact(61, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWakeLockUidsAsync(IBinder lock, int[] uids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeIntArray(uids);
                    boolean bl = this.mRemote.transact(62, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScreenBrightnessBoosted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAttentionLight(boolean on, int color2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    _data.writeInt(color2);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDozeAfterScreenOff(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplayAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressAmbientDisplay(String token, boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    _data.writeBoolean(suppress);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressAmbientDisplayBehavior(String token, int suppressionFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    _data.writeInt(suppressionFlags);
                    boolean bl = this.mRemote.transact(68, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplaySuppressedForToken(String token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplaySuppressed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientDisplaySuppressedForTokenByApp(String token, int appUid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(token);
                    _data.writeInt(appUid);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean forceSuspend() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPowerManager {
        @Override
        public void acquireWakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag, int displayId, IWakeLockCallback callback) throws RemoteException {
        }

        @Override
        public void acquireWakeLockWithUid(IBinder lock, int flags, String tag, String packageName, int uidtoblame, int displayId, IWakeLockCallback callback) throws RemoteException {
        }

        @Override
        public void releaseWakeLock(IBinder lock, int flags) throws RemoteException {
        }

        @Override
        public void updateWakeLockUids(IBinder lock, int[] uids) throws RemoteException {
        }

        @Override
        public void setPowerBoost(int boost, int durationMs) throws RemoteException {
        }

        @Override
        public void setPowerMode(int mode, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean setPowerModeChecked(int mode, boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public void updateWakeLockWorkSource(IBinder lock, WorkSource ws, String historyTag) throws RemoteException {
        }

        @Override
        public void updateWakeLockCallback(IBinder lock, IWakeLockCallback callback) throws RemoteException {
        }

        @Override
        public boolean isWakeLockLevelSupported(int level) throws RemoteException {
            return false;
        }

        @Override
        public boolean isWakeLockLevelSupportedWithDisplayId(int level, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void addScreenTimeoutPolicyListener(int displayId, IScreenTimeoutPolicyListener listener) throws RemoteException {
        }

        @Override
        public void removeScreenTimeoutPolicyListener(int displayId, IScreenTimeoutPolicyListener listener) throws RemoteException {
        }

        @Override
        public void userActivity(int displayId, long time, int event, int flags) throws RemoteException {
        }

        @Override
        public void wakeUp(long time, int reason, String details, String opPackageName) throws RemoteException {
        }

        @Override
        public void wakeUpWithDisplayId(long time, int reason, String details, String opPackageName, int displayId) throws RemoteException {
        }

        @Override
        public void goToSleep(long time, int reason, int flags) throws RemoteException {
        }

        @Override
        public void goToSleepWithDisplayId(int displayId, long time, int reason, int flags) throws RemoteException {
        }

        @Override
        public void nap(long time) throws RemoteException {
        }

        @Override
        public float getBrightnessConstraint(int displayId, int constraint) throws RemoteException {
            return 0.0f;
        }

        @Override
        public boolean isInteractive() throws RemoteException {
            return false;
        }

        @Override
        public boolean isDisplayInteractive(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public boolean areAutoPowerSaveModesEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isPowerSaveMode() throws RemoteException {
            return false;
        }

        @Override
        public PowerSaveState getPowerSaveState(int serviceType) throws RemoteException {
            return null;
        }

        @Override
        public boolean setPowerSaveModeEnabled(boolean mode) throws RemoteException {
            return false;
        }

        @Override
        public boolean isBatterySaverSupported() throws RemoteException {
            return false;
        }

        @Override
        public BatterySaverPolicyConfig getFullPowerSavePolicy() throws RemoteException {
            return null;
        }

        @Override
        public boolean setFullPowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
            return false;
        }

        @Override
        public boolean setDynamicPowerSaveHint(boolean powerSaveHint, int disableThreshold) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAdaptivePowerSavePolicy(BatterySaverPolicyConfig config) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAdaptivePowerSaveEnabled(boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public int getPowerSaveModeTrigger() throws RemoteException {
            return 0;
        }

        @Override
        public void setBatteryDischargePrediction(ParcelDuration timeRemaining, boolean isCustomized) throws RemoteException {
        }

        @Override
        public ParcelDuration getBatteryDischargePrediction() throws RemoteException {
            return null;
        }

        @Override
        public boolean isBatteryDischargePredictionPersonalized() throws RemoteException {
            return false;
        }

        @Override
        public boolean isDeviceIdleMode() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLightDeviceIdleMode() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLowPowerStandbySupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isLowPowerStandbyEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setLowPowerStandbyEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void setLowPowerStandbyActiveDuringMaintenance(boolean activeDuringMaintenance) throws RemoteException {
        }

        @Override
        public void forceLowPowerStandbyActive(boolean active) throws RemoteException {
        }

        @Override
        public void setLowPowerStandbyPolicy(LowPowerStandbyPolicy policy) throws RemoteException {
        }

        @Override
        public LowPowerStandbyPolicy getLowPowerStandbyPolicy() throws RemoteException {
            return null;
        }

        @Override
        public boolean isExemptFromLowPowerStandby() throws RemoteException {
            return false;
        }

        @Override
        public boolean isReasonAllowedInLowPowerStandby(int reason) throws RemoteException {
            return false;
        }

        @Override
        public boolean isFeatureAllowedInLowPowerStandby(String feature) throws RemoteException {
            return false;
        }

        @Override
        public void acquireLowPowerStandbyPorts(IBinder token, List<LowPowerStandbyPortDescription> ports) throws RemoteException {
        }

        @Override
        public void releaseLowPowerStandbyPorts(IBinder token) throws RemoteException {
        }

        @Override
        public List<LowPowerStandbyPortDescription> getActiveLowPowerStandbyPorts() throws RemoteException {
            return null;
        }

        @Override
        public void reboot(boolean confirm, String reason, boolean wait) throws RemoteException {
        }

        @Override
        public void rebootSafeMode(boolean confirm, boolean wait) throws RemoteException {
        }

        @Override
        public void shutdown(boolean confirm, String reason, boolean wait) throws RemoteException {
        }

        @Override
        public void crash(String message) throws RemoteException {
        }

        @Override
        public int getLastShutdownReason() throws RemoteException {
            return 0;
        }

        @Override
        public int getLastSleepReason() throws RemoteException {
            return 0;
        }

        @Override
        public void setStayOnSetting(int val) throws RemoteException {
        }

        @Override
        public void boostScreenBrightness(long time) throws RemoteException {
        }

        @Override
        public void acquireWakeLockAsync(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag) throws RemoteException {
        }

        @Override
        public void releaseWakeLockAsync(IBinder lock, int flags) throws RemoteException {
        }

        @Override
        public void updateWakeLockUidsAsync(IBinder lock, int[] uids) throws RemoteException {
        }

        @Override
        public boolean isScreenBrightnessBoosted() throws RemoteException {
            return false;
        }

        @Override
        public void setAttentionLight(boolean on, int color2) throws RemoteException {
        }

        @Override
        public void setDozeAfterScreenOff(boolean on) throws RemoteException {
        }

        @Override
        public boolean isAmbientDisplayAvailable() throws RemoteException {
            return false;
        }

        @Override
        public void suppressAmbientDisplay(String token, boolean suppress) throws RemoteException {
        }

        @Override
        public void suppressAmbientDisplayBehavior(String token, int suppressionFlags) throws RemoteException {
        }

        @Override
        public boolean isAmbientDisplaySuppressedForToken(String token) throws RemoteException {
            return false;
        }

        @Override
        public boolean isAmbientDisplaySuppressed() throws RemoteException {
            return false;
        }

        @Override
        public boolean isAmbientDisplaySuppressedForTokenByApp(String token, int appUid) throws RemoteException {
            return false;
        }

        @Override
        public boolean forceSuspend() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

