/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.hardware.power.WorkDuration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IHintSession
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IHintSession";

    public void updateTargetWorkDuration(long var1) throws RemoteException;

    public void reportActualWorkDuration(long[] var1, long[] var2) throws RemoteException;

    public void close() throws RemoteException;

    public void sendHint(int var1) throws RemoteException;

    public void setMode(int var1, boolean var2) throws RemoteException;

    public void reportActualWorkDuration2(WorkDuration[] var1) throws RemoteException;

    public void associateToLayers(IBinder[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHintSession {
        static final int TRANSACTION_updateTargetWorkDuration = 1;
        static final int TRANSACTION_reportActualWorkDuration = 2;
        static final int TRANSACTION_close = 3;
        static final int TRANSACTION_sendHint = 4;
        static final int TRANSACTION_setMode = 5;
        static final int TRANSACTION_reportActualWorkDuration2 = 6;
        static final int TRANSACTION_associateToLayers = 7;

        public Stub() {
            this.attachInterface(this, IHintSession.DESCRIPTOR);
        }

        public static IHintSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IHintSession.DESCRIPTOR);
            if (iin != null && iin instanceof IHintSession) {
                return (IHintSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "updateTargetWorkDuration";
                }
                case 2: {
                    return "reportActualWorkDuration";
                }
                case 3: {
                    return "close";
                }
                case 4: {
                    return "sendHint";
                }
                case 5: {
                    return "setMode";
                }
                case 6: {
                    return "reportActualWorkDuration2";
                }
                case 7: {
                    return "associateToLayers";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IHintSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.updateTargetWorkDuration(_arg0);
                    break;
                }
                case 2: {
                    long[] _arg0 = data.createLongArray();
                    long[] _arg1 = data.createLongArray();
                    data.enforceNoDataAvail();
                    this.reportActualWorkDuration(_arg0, _arg1);
                    break;
                }
                case 3: {
                    this.close();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendHint(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMode(_arg0, _arg1);
                    break;
                }
                case 6: {
                    WorkDuration[] _arg0 = data.createTypedArray(WorkDuration.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportActualWorkDuration2(_arg0);
                    break;
                }
                case 7: {
                    IBinder[] _arg0 = data.createBinderArray();
                    data.enforceNoDataAvail();
                    this.associateToLayers(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IHintSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IHintSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateTargetWorkDuration(long targetDurationNanos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeLong(targetDurationNanos);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportActualWorkDuration(long[] actualDurationNanos, long[] timeStampNanos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeLongArray(actualDurationNanos);
                    _data.writeLongArray(timeStampNanos);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendHint(int hint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeInt(hint);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMode(int mode, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportActualWorkDuration2(WorkDuration[] workDurations) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeTypedArray(workDurations, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associateToLayers(IBinder[] layerTokens) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeBinderArray(layerTokens);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IHintSession {
        @Override
        public void updateTargetWorkDuration(long targetDurationNanos) throws RemoteException {
        }

        @Override
        public void reportActualWorkDuration(long[] actualDurationNanos, long[] timeStampNanos) throws RemoteException {
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void sendHint(int hint) throws RemoteException {
        }

        @Override
        public void setMode(int mode, boolean enabled) throws RemoteException {
        }

        @Override
        public void reportActualWorkDuration2(WorkDuration[] workDurations) throws RemoteException {
        }

        @Override
        public void associateToLayers(IBinder[] layerTokens) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

