/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.AudioAttributes;
import android.os.Binder;
import android.os.IBinder;
import android.os.IExternalVibrationController;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.VibrationAttributes;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import java.util.NoSuchElementException;

public class ExternalVibration
implements Parcelable {
    private static final String TAG = "ExternalVibration";
    private int mUid;
    @NonNull
    private String mPkg;
    @NonNull
    private AudioAttributes mAttrs;
    @NonNull
    private IExternalVibrationController mController;
    @NonNull
    private IBinder mToken;
    @NonNull
    public static final Parcelable.Creator<ExternalVibration> CREATOR = new Parcelable.Creator<ExternalVibration>(){

        @Override
        public ExternalVibration createFromParcel(Parcel in) {
            return new ExternalVibration(in);
        }

        public ExternalVibration[] newArray(int size) {
            return new ExternalVibration[size];
        }
    };

    public ExternalVibration(int uid, @NonNull String pkg, @NonNull AudioAttributes attrs, @NonNull IExternalVibrationController controller) {
        this(uid, pkg, attrs, controller, new Binder());
    }

    public ExternalVibration(int uid, @NonNull String pkg, @NonNull AudioAttributes attrs, @NonNull IExternalVibrationController controller, @NonNull IBinder token) {
        this.mUid = uid;
        this.mPkg = Preconditions.checkNotNull(pkg);
        this.mAttrs = Preconditions.checkNotNull(attrs);
        this.mController = Preconditions.checkNotNull(controller);
        this.mToken = Preconditions.checkNotNull(token);
        Binder.allowBlocking(this.mController.asBinder());
    }

    private ExternalVibration(Parcel in) {
        this(in.readInt(), in.readString(), ExternalVibration.readAudioAttributes(in), IExternalVibrationController.Stub.asInterface(in.readStrongBinder()), in.readStrongBinder());
    }

    private static AudioAttributes readAudioAttributes(Parcel in) {
        int usage = in.readInt();
        int contentType = in.readInt();
        int capturePreset = in.readInt();
        int flags = in.readInt();
        AudioAttributes.Builder builder = new AudioAttributes.Builder();
        if (AudioAttributes.isSystemUsage(usage)) {
            builder.setSystemUsage(usage);
        } else {
            builder.setUsage(usage);
        }
        return builder.setContentType(contentType).setCapturePreset(capturePreset).setFlags(flags).build();
    }

    public int getUid() {
        return this.mUid;
    }

    public String getPackage() {
        return this.mPkg;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAttrs;
    }

    public IBinder getToken() {
        return this.mToken;
    }

    public VibrationAttributes getVibrationAttributes() {
        return new VibrationAttributes.Builder(this.mAttrs).build();
    }

    public boolean mute() {
        try {
            this.mController.mute();
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "Failed to mute vibration stream: " + this, e);
            return false;
        }
        return true;
    }

    public boolean unmute() {
        try {
            this.mController.unmute();
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "Failed to unmute vibration stream: " + this, e);
            return false;
        }
        return true;
    }

    public void linkToDeath(IBinder.DeathRecipient recipient) {
        try {
            this.mToken.linkToDeath(recipient, 0);
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "Failed to link to token death: " + this, e);
        }
    }

    public void unlinkToDeath(IBinder.DeathRecipient recipient) {
        try {
            this.mToken.unlinkToDeath(recipient, 0);
        }
        catch (NoSuchElementException e) {
            Slog.wtf(TAG, "Failed to unlink to token death", e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || !(o instanceof ExternalVibration)) {
            return false;
        }
        ExternalVibration other = (ExternalVibration)o;
        return this.mToken.equals(other.mToken);
    }

    public String toString() {
        return "ExternalVibration{uid=" + this.mUid + ", pkg=" + this.mPkg + ", attrs=" + this.mAttrs + ", controller=" + this.mController + "token=" + this.mToken + "}";
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mUid);
        out.writeString(this.mPkg);
        ExternalVibration.writeAudioAttributes(this.mAttrs, out);
        out.writeStrongBinder(this.mController.asBinder());
        out.writeStrongBinder(this.mToken);
    }

    private static void writeAudioAttributes(AudioAttributes attrs, Parcel out) {
        out.writeInt(attrs.getSystemUsage());
        out.writeInt(attrs.getContentType());
        out.writeInt(attrs.getCapturePreset());
        out.writeInt(attrs.getAllFlags());
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

