/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BinaryOperator;

@RavenwoodKeepWholeClass
public class BundleMerger
implements Parcelable {
    private static final String TAG = "BundleMerger";
    private int mDefaultStrategy = 0;
    private final ArrayMap<String, Integer> mStrategies = new ArrayMap();
    public static final int STRATEGY_REJECT = 0;
    public static final int STRATEGY_FIRST = 1;
    public static final int STRATEGY_LAST = 2;
    public static final int STRATEGY_COMPARABLE_MIN = 3;
    public static final int STRATEGY_COMPARABLE_MAX = 4;
    public static final int STRATEGY_NUMBER_ADD = 10;
    public static final int STRATEGY_NUMBER_INCREMENT_FIRST = 20;
    public static final int STRATEGY_NUMBER_INCREMENT_FIRST_AND_ADD = 25;
    public static final int STRATEGY_BOOLEAN_AND = 30;
    public static final int STRATEGY_BOOLEAN_OR = 40;
    public static final int STRATEGY_ARRAY_APPEND = 50;
    public static final int STRATEGY_ARRAY_UNION = 55;
    public static final int STRATEGY_ARRAY_LIST_APPEND = 60;
    public static final int STRATEGY_STRING_APPEND = 70;
    @NonNull
    public static final Parcelable.Creator<BundleMerger> CREATOR = new Parcelable.Creator<BundleMerger>(){

        @Override
        public BundleMerger createFromParcel(Parcel in) {
            return new BundleMerger(in);
        }

        public BundleMerger[] newArray(int size) {
            return new BundleMerger[size];
        }
    };

    public BundleMerger() {
    }

    private BundleMerger(@NonNull Parcel in) {
        this.mDefaultStrategy = in.readInt();
        int N2 = in.readInt();
        for (int i = 0; i < N2; ++i) {
            this.mStrategies.put(in.readString(), in.readInt());
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mDefaultStrategy);
        int N2 = this.mStrategies.size();
        out.writeInt(N2);
        for (int i = 0; i < N2; ++i) {
            out.writeString(this.mStrategies.keyAt(i));
            out.writeInt(this.mStrategies.valueAt(i));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setDefaultMergeStrategy(int strategy) {
        this.mDefaultStrategy = strategy;
    }

    public void setMergeStrategy(@NonNull String key, int strategy) {
        this.mStrategies.put(key, strategy);
    }

    public int getMergeStrategy(@NonNull String key) {
        return this.mStrategies.getOrDefault(key, this.mDefaultStrategy);
    }

    public BinaryOperator<Bundle> asBinaryOperator() {
        return this::merge;
    }

    @Nullable
    public Bundle merge(@Nullable Bundle first, @Nullable Bundle last) {
        if (first == null && last == null) {
            return null;
        }
        if (first == null) {
            first = Bundle.EMPTY;
        }
        if (last == null) {
            last = Bundle.EMPTY;
        }
        Bundle res = new Bundle();
        res.putAll(first);
        res.putAll(last);
        ArraySet<String> conflictingKeys = new ArraySet<String>();
        conflictingKeys.addAll(first.keySet());
        conflictingKeys.retainAll(last.keySet());
        for (int i = 0; i < conflictingKeys.size(); ++i) {
            String key = (String)conflictingKeys.valueAt(i);
            int strategy = this.getMergeStrategy(key);
            Object firstValue = first.get(key);
            Object lastValue = last.get(key);
            try {
                res.putObject(key, BundleMerger.merge(strategy, firstValue, lastValue));
                continue;
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to merge key " + key + " with " + firstValue + " and " + lastValue + " using strategy " + strategy, e);
            }
        }
        return res;
    }

    @VisibleForTesting
    @Nullable
    public static Object merge(int strategy, @Nullable Object first, @Nullable Object last) {
        if (first == null) {
            return last;
        }
        if (last == null) {
            return first;
        }
        if (first.getClass() != last.getClass()) {
            throw new IllegalArgumentException("Merging requires consistent classes; first " + first.getClass() + " last " + last.getClass());
        }
        switch (strategy) {
            case 0: {
                if (Objects.deepEquals(first, last)) {
                    return first;
                }
                return null;
            }
            case 1: {
                return first;
            }
            case 2: {
                return last;
            }
            case 3: {
                return BundleMerger.comparableMin(first, last);
            }
            case 4: {
                return BundleMerger.comparableMax(first, last);
            }
            case 10: {
                return BundleMerger.numberAdd(first, last);
            }
            case 20: {
                return BundleMerger.numberIncrementFirst(first, last);
            }
            case 25: {
                return BundleMerger.numberAdd(BundleMerger.numberIncrementFirst(first, last), last);
            }
            case 30: {
                return BundleMerger.booleanAnd(first, last);
            }
            case 40: {
                return BundleMerger.booleanOr(first, last);
            }
            case 50: {
                return BundleMerger.arrayAppend(first, last);
            }
            case 55: {
                return BundleMerger.arrayUnion(first, last);
            }
            case 60: {
                return BundleMerger.arrayListAppend(first, last);
            }
            case 70: {
                return BundleMerger.stringAppend(first, last);
            }
        }
        throw new UnsupportedOperationException();
    }

    @NonNull
    private static Object comparableMin(@NonNull Object first, @NonNull Object last) {
        return ((Comparable)first).compareTo(last) < 0 ? first : last;
    }

    @NonNull
    private static Object comparableMax(@NonNull Object first, @NonNull Object last) {
        return ((Comparable)first).compareTo(last) >= 0 ? first : last;
    }

    @NonNull
    private static Object numberAdd(@NonNull Object first, @NonNull Object last) {
        if (first instanceof Integer) {
            return (Integer)first + (Integer)last;
        }
        if (first instanceof Long) {
            return (Long)first + (Long)last;
        }
        if (first instanceof Float) {
            return Float.valueOf(((Float)first).floatValue() + ((Float)last).floatValue());
        }
        if (first instanceof Double) {
            return (Double)first + (Double)last;
        }
        throw new IllegalArgumentException("Unable to add " + first.getClass());
    }

    @NonNull
    private static Number numberIncrementFirst(@NonNull Object first, @NonNull Object last) {
        if (first instanceof Integer) {
            return (Integer)first + 1;
        }
        if (first instanceof Long) {
            return (Long)first + 1L;
        }
        throw new IllegalArgumentException("Unable to add " + first.getClass());
    }

    @NonNull
    private static Object booleanAnd(@NonNull Object first, @NonNull Object last) {
        return (Boolean)first != false && (Boolean)last != false;
    }

    @NonNull
    private static Object booleanOr(@NonNull Object first, @NonNull Object last) {
        return (Boolean)first != false || (Boolean)last != false;
    }

    @NonNull
    private static Object arrayAppend(@NonNull Object first, @NonNull Object last) {
        if (!first.getClass().isArray()) {
            throw new IllegalArgumentException("Unable to append " + first.getClass());
        }
        Class<?> clazz = first.getClass().getComponentType();
        int firstLength = Array.getLength(first);
        int lastLength = Array.getLength(last);
        Object res = Array.newInstance(clazz, firstLength + lastLength);
        System.arraycopy(first, 0, res, 0, firstLength);
        System.arraycopy(last, 0, res, firstLength, lastLength);
        return res;
    }

    @NonNull
    private static Object arrayUnion(@NonNull Object first, @NonNull Object last) {
        int i;
        if (!first.getClass().isArray()) {
            throw new IllegalArgumentException("Unable to union " + first.getClass());
        }
        int firstLength = Array.getLength(first);
        int lastLength = Array.getLength(last);
        ArrayList list = new ArrayList(firstLength + lastLength);
        ArraySet<Object> set = new ArraySet<Object>();
        for (i = 0; i < firstLength; ++i) {
            set.add(Array.get(first, i));
        }
        for (i = 0; i < lastLength; ++i) {
            set.add(Array.get(last, i));
        }
        Class<?> clazz = first.getClass().getComponentType();
        int setSize = set.size();
        Object res = Array.newInstance(clazz, setSize);
        for (int i2 = 0; i2 < setSize; ++i2) {
            Array.set(res, i2, set.valueAt(i2));
        }
        return res;
    }

    @NonNull
    private static Object arrayListAppend(@NonNull Object first, @NonNull Object last) {
        if (!(first instanceof ArrayList)) {
            throw new IllegalArgumentException("Unable to append " + first.getClass());
        }
        ArrayList firstList = (ArrayList)first;
        ArrayList lastList = (ArrayList)last;
        ArrayList res = new ArrayList(firstList.size() + lastList.size());
        res.addAll(firstList);
        res.addAll(lastList);
        return res;
    }

    @NonNull
    private static Object stringAppend(@NonNull Object first, @NonNull Object last) {
        if (!(first instanceof String)) {
            throw new IllegalArgumentException("Unable to append " + first.getClass());
        }
        return (String)first + (String)last;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Strategy {
    }
}

