/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.app.job.JobParameters;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.AggregateBatteryConsumer;
import android.os.BatteryConsumer;
import android.os.BatteryUsageStats;
import android.os.BluetoothBatteryStats;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.SystemClock;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.os.WakeLockStats;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.telephony.CellSignalStrength;
import android.telephony.ModemActivityInfo;
import android.telephony.TelephonyManager;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.LongSparseArray;
import android.util.MutableBoolean;
import android.util.Pair;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseDoubleArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BatteryStatsHistoryIterator;
import com.android.internal.os.CpuScalingPolicies;
import com.android.internal.os.PowerStats;
import com.android.net.module.util.NetworkCapabilitiesUtils;
import com.google.android.collect.Lists;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@RavenwoodKeepWholeClass
public abstract class BatteryStats {
    private static final String TAG = "BatteryStats";
    private static final boolean LOCAL_LOGV = false;
    protected static final boolean SCREEN_OFF_RPM_STATS_ENABLED = false;
    public static final String SERVICE_NAME = "batterystats";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int WAKE_TYPE_PARTIAL = 0;
    public static final int WAKE_TYPE_FULL = 1;
    public static final int WAKE_TYPE_WINDOW = 2;
    public static final int SENSOR = 3;
    public static final int WIFI_RUNNING = 4;
    public static final int FULL_WIFI_LOCK = 5;
    public static final int WIFI_SCAN = 6;
    public static final int WIFI_MULTICAST_ENABLED = 7;
    public static final int VIDEO_TURNED_ON = 8;
    public static final int VIBRATOR_ON = 9;
    public static final int FOREGROUND_ACTIVITY = 10;
    public static final int WIFI_BATCHED_SCAN = 11;
    public static final int PROCESS_STATE = 12;
    public static final int SYNC = 13;
    public static final int JOB = 14;
    public static final int AUDIO_TURNED_ON = 15;
    public static final int FLASHLIGHT_TURNED_ON = 16;
    public static final int CAMERA_TURNED_ON = 17;
    public static final int WAKE_TYPE_DRAW = 18;
    public static final int BLUETOOTH_SCAN_ON = 19;
    public static final int AGGREGATED_WAKE_TYPE_PARTIAL = 20;
    public static final int BLUETOOTH_UNOPTIMIZED_SCAN_ON = 21;
    public static final int FOREGROUND_SERVICE = 22;
    public static final int WIFI_AGGREGATE_MULTICAST_ENABLED = 23;
    public static final int STATS_SINCE_CHARGED = 0;
    @Deprecated
    @UnsupportedAppUsage
    public static final int STATS_CURRENT = 1;
    @Deprecated
    public static final int STATS_SINCE_UNPLUGGED = 2;
    private static final String[] STAT_NAMES = new String[]{"l", "c", "u"};
    static final int CHECKIN_VERSION = 36;
    private static final int BATTERY_STATS_CHECKIN_VERSION = 9;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    public static final double MILLISECONDS_IN_HOUR = 3600000.0;
    private static final String VERSION_DATA = "vers";
    private static final String UID_DATA = "uid";
    private static final String WAKEUP_ALARM_DATA = "wua";
    private static final String APK_DATA = "apk";
    private static final String PROCESS_DATA = "pr";
    private static final String CPU_DATA = "cpu";
    private static final String GLOBAL_CPU_FREQ_DATA = "gcf";
    private static final String CPU_TIMES_AT_FREQ_DATA = "ctf";
    private static final String RESOURCE_POWER_MANAGER_DATA = "rpm";
    private static final String SENSOR_DATA = "sr";
    private static final String VIBRATOR_DATA = "vib";
    private static final String FOREGROUND_ACTIVITY_DATA = "fg";
    private static final String FOREGROUND_SERVICE_DATA = "fgs";
    private static final String STATE_TIME_DATA = "st";
    private static final String WAKELOCK_DATA = "wl";
    private static final String AGGREGATED_WAKELOCK_DATA = "awl";
    private static final String SYNC_DATA = "sy";
    private static final String JOB_DATA = "jb";
    private static final String JOB_COMPLETION_DATA = "jbc";
    private static final String JOBS_DEFERRED_DATA = "jbd";
    private static final String KERNEL_WAKELOCK_DATA = "kwl";
    private static final String WAKEUP_REASON_DATA = "wr";
    private static final String NETWORK_DATA = "nt";
    private static final String USER_ACTIVITY_DATA = "ua";
    private static final String BATTERY_DATA = "bt";
    private static final String BATTERY_DISCHARGE_DATA = "dc";
    private static final String BATTERY_LEVEL_DATA = "lv";
    private static final String GLOBAL_WIFI_DATA = "gwfl";
    private static final String WIFI_DATA = "wfl";
    private static final String GLOBAL_WIFI_CONTROLLER_DATA = "gwfcd";
    private static final String WIFI_CONTROLLER_DATA = "wfcd";
    private static final String GLOBAL_BLUETOOTH_CONTROLLER_DATA = "gble";
    private static final String BLUETOOTH_CONTROLLER_DATA = "ble";
    private static final String BLUETOOTH_MISC_DATA = "blem";
    private static final String MISC_DATA = "m";
    private static final String GLOBAL_NETWORK_DATA = "gn";
    private static final String GLOBAL_MODEM_CONTROLLER_DATA = "gmcd";
    private static final String MODEM_CONTROLLER_DATA = "mcd";
    private static final String HISTORY_STRING_POOL = "hsp";
    private static final String HISTORY_DATA = "h";
    private static final String SCREEN_BRIGHTNESS_DATA = "br";
    private static final String SIGNAL_STRENGTH_TIME_DATA = "sgt";
    private static final String SIGNAL_SCANNING_TIME_DATA = "sst";
    private static final String SIGNAL_STRENGTH_COUNT_DATA = "sgc";
    private static final String DATA_CONNECTION_TIME_DATA = "dct";
    private static final String DATA_CONNECTION_COUNT_DATA = "dcc";
    private static final String WIFI_STATE_TIME_DATA = "wst";
    private static final String WIFI_STATE_COUNT_DATA = "wsc";
    private static final String WIFI_SUPPL_STATE_TIME_DATA = "wsst";
    private static final String WIFI_SUPPL_STATE_COUNT_DATA = "wssc";
    private static final String WIFI_SIGNAL_STRENGTH_TIME_DATA = "wsgt";
    private static final String WIFI_SIGNAL_STRENGTH_COUNT_DATA = "wsgc";
    private static final String POWER_USE_SUMMARY_DATA = "pws";
    private static final String POWER_USE_ITEM_DATA = "pwi";
    private static final String DISCHARGE_STEP_DATA = "dsd";
    private static final String CHARGE_STEP_DATA = "csd";
    private static final String DISCHARGE_TIME_REMAIN_DATA = "dtr";
    private static final String CHARGE_TIME_REMAIN_DATA = "ctr";
    private static final String FLASHLIGHT_DATA = "fla";
    private static final String CAMERA_DATA = "cam";
    private static final String VIDEO_DATA = "vid";
    private static final String AUDIO_DATA = "aud";
    private static final String WIFI_MULTICAST_TOTAL_DATA = "wmct";
    private static final String WIFI_MULTICAST_DATA = "wmc";
    public static final String RESULT_RECEIVER_CONTROLLER_KEY = "controller_activity";
    private final StringBuilder mFormatBuilder = new StringBuilder(32);
    private final Formatter mFormatter = new Formatter(this.mFormatBuilder);
    private static final String CELLULAR_CONTROLLER_NAME = "Cellular";
    private static final String WIFI_CONTROLLER_NAME = "WiFi";
    @VisibleForTesting
    public static final String UID_TIMES_TYPE_ALL = "A";
    public static final long[] JOB_FRESHNESS_BUCKETS = new long[]{3600000L, 0x6DDD00L, 14400000L, 28800000L, Long.MAX_VALUE};
    public static final int SCREEN_BRIGHTNESS_DARK = 0;
    public static final int SCREEN_BRIGHTNESS_DIM = 1;
    public static final int SCREEN_BRIGHTNESS_MEDIUM = 2;
    public static final int SCREEN_BRIGHTNESS_LIGHT = 3;
    public static final int SCREEN_BRIGHTNESS_BRIGHT = 4;
    public static final String[] SCREEN_BRIGHTNESS_NAMES = new String[]{"dark", "dim", "medium", "light", "bright"};
    static final String[] SCREEN_BRIGHTNESS_SHORT_NAMES = new String[]{"0", "1", "2", "3", "4"};
    @UnsupportedAppUsage
    public static final int NUM_SCREEN_BRIGHTNESS_BINS = 5;
    public static final int DEVICE_IDLE_MODE_OFF = 0;
    public static final int DEVICE_IDLE_MODE_LIGHT = 1;
    public static final int DEVICE_IDLE_MODE_DEEP = 2;
    static final String[] DATA_CONNECTION_NAMES = new String[]{"oos", "gprs", "edge", "umts", "cdma", "evdo_0", "evdo_A", "1xrtt", "hsdpa", "hsupa", "hspa", "iden", "evdo_b", "lte", "ehrpd", "hspap", "gsm", "td_scdma", "iwlan", "lte_ca", "nr", "emngcy", "other"};
    public static final int NUM_ALL_NETWORK_TYPES = BatteryStats.getAllNetworkTypesCount();
    public static final int DATA_CONNECTION_OUT_OF_SERVICE = 0;
    public static final int DATA_CONNECTION_EMERGENCY_SERVICE = NUM_ALL_NETWORK_TYPES + 1;
    public static final int DATA_CONNECTION_OTHER = NUM_ALL_NETWORK_TYPES + 2;
    @UnsupportedAppUsage
    public static final int NUM_DATA_CONNECTION_TYPES = NUM_ALL_NETWORK_TYPES + 3;
    public static final int RADIO_ACCESS_TECHNOLOGY_OTHER = 0;
    public static final int RADIO_ACCESS_TECHNOLOGY_LTE = 1;
    public static final int RADIO_ACCESS_TECHNOLOGY_NR = 2;
    public static final int RADIO_ACCESS_TECHNOLOGY_COUNT = 3;
    public static final String[] RADIO_ACCESS_TECHNOLOGY_NAMES = new String[]{"Other", "LTE", "NR"};
    static final String[] WIFI_SUPPL_STATE_NAMES = new String[]{"invalid", "disconn", "disabled", "inactive", "scanning", "authenticating", "associating", "associated", "4-way-handshake", "group-handshake", "completed", "dormant", "uninit"};
    static final String[] WIFI_SUPPL_STATE_SHORT_NAMES = new String[]{"inv", "dsc", "dis", "inact", "scan", "auth", "ascing", "asced", "4-way", "group", "compl", "dorm", "uninit"};
    public static final long DURATION_UNAVAILABLE = -1L;
    public static final BitDescription[] HISTORY_STATE_DESCRIPTIONS = new BitDescription[]{new BitDescription(Integer.MIN_VALUE, "running", "r"), new BitDescription(0x40000000, "wake_lock", "w"), new BitDescription(0x800000, "sensor", "s"), new BitDescription(0x20000000, "gps", "g"), new BitDescription(0x10000000, "wifi_full_lock", "Wl"), new BitDescription(0x8000000, "wifi_scan", "Ws"), new BitDescription(65536, "wifi_multicast", "Wm"), new BitDescription(0x4000000, "wifi_radio", "Wr"), new BitDescription(0x2000000, "mobile_radio", "Pr"), new BitDescription(0x200000, "phone_scanning", "Psc"), new BitDescription(0x400000, "audio", "a"), new BitDescription(0x100000, "screen", "S"), new BitDescription(524288, "plugged", "BP"), new BitDescription(262144, "screen_doze", "Sd"), new BitDescription(15872, 9, "data_conn", "Pcn", DATA_CONNECTION_NAMES, DATA_CONNECTION_NAMES), new BitDescription(448, 6, "phone_state", "Pst", new String[]{"in", "out", "emergency", "off"}, new String[]{"in", "out", "em", "off"}), new BitDescription(56, 3, "phone_signal_strength", "Pss", new String[]{"none", "poor", "moderate", "good", "great"}, new String[]{"0", "1", "2", "3", "4"}), new BitDescription(7, 0, "brightness", "Sb", SCREEN_BRIGHTNESS_NAMES, SCREEN_BRIGHTNESS_SHORT_NAMES)};
    public static final BitDescription[] HISTORY_STATE2_DESCRIPTIONS = new BitDescription[]{new BitDescription(Integer.MIN_VALUE, "power_save", "ps"), new BitDescription(0x40000000, "video", "v"), new BitDescription(0x20000000, "wifi_running", "Ww"), new BitDescription(0x10000000, "wifi", "W"), new BitDescription(0x8000000, "flashlight", "fl"), new BitDescription(0x6000000, 25, "device_idle", "di", new String[]{"off", "light", "full", "???"}, new String[]{"off", "light", "full", "???"}), new BitDescription(0x1000000, "charging", "ch"), new BitDescription(262144, "usb_data", "Ud"), new BitDescription(0x800000, "phone_in_call", "Pcl"), new BitDescription(0x400000, "bluetooth", "b"), new BitDescription(112, 4, "wifi_signal_strength", "Wss", new String[]{"0", "1", "2", "3", "4"}, new String[]{"0", "1", "2", "3", "4"}), new BitDescription(15, 0, "wifi_suppl", "Wsp", WIFI_SUPPL_STATE_NAMES, WIFI_SUPPL_STATE_SHORT_NAMES), new BitDescription(0x200000, "camera", "ca"), new BitDescription(0x100000, "ble_scan", "bles"), new BitDescription(524288, "cellular_high_tx_power", "Chtp"), new BitDescription(384, 7, "gps_signal_quality", "Gss", new String[]{"poor", "good", "none"}, new String[]{"poor", "good", "none"}), new BitDescription(1536, 9, "nr_state", "nrs", new String[]{"none", "restricted", "not_restricted", "connected"}, new String[]{"0", "1", "2", "3"})};
    public static final String[] HISTORY_EVENT_NAMES = new String[]{"null", "proc", "fg", "top", "sync", "wake_lock_in", "job", "user", "userfg", "conn", "active", "pkginst", "pkgunin", "alarm", "stats", "pkginactive", "pkgactive", "tmpwhitelist", "screenwake", "wakeupap", "longwake", "state", "display_state_changed"};
    public static final String[] HISTORY_EVENT_CHECKIN_NAMES = new String[]{"Enl", "Epr", "Efg", "Etp", "Esy", "Ewl", "Ejb", "Eur", "Euf", "Ecn", "Eac", "Epi", "Epu", "Eal", "Est", "Eai", "Eaa", "Etw", "Esw", "Ewa", "Elw", "Esc", "Eds"};
    private static final IntToString sUidToString = UserHandle::formatUid;
    private static final IntToString sIntToString = Integer::toString;
    public static final IntToString[] HISTORY_EVENT_INT_FORMATTERS = new IntToString[]{sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sIntToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sUidToString, sIntToString, sUidToString};
    static final String[] WIFI_STATE_NAMES = new String[]{"off", "scanning", "no_net", "disconn", "sta", "p2p", "sta_p2p", "soft_ap"};
    public static final int NUM_WIFI_SIGNAL_STRENGTH_BINS = 5;
    public static final int NETWORK_MOBILE_RX_DATA = 0;
    public static final int NETWORK_MOBILE_TX_DATA = 1;
    public static final int NETWORK_WIFI_RX_DATA = 2;
    public static final int NETWORK_WIFI_TX_DATA = 3;
    public static final int NETWORK_BT_RX_DATA = 4;
    public static final int NETWORK_BT_TX_DATA = 5;
    public static final int NETWORK_MOBILE_BG_RX_DATA = 6;
    public static final int NETWORK_MOBILE_BG_TX_DATA = 7;
    public static final int NETWORK_WIFI_BG_RX_DATA = 8;
    public static final int NETWORK_WIFI_BG_TX_DATA = 9;
    public static final int NUM_NETWORK_ACTIVITY_TYPES = 10;
    public static final long STEP_LEVEL_TIME_MASK = 0xFFFFFFFFFFL;
    public static final long STEP_LEVEL_LEVEL_MASK = 0xFF0000000000L;
    public static final int STEP_LEVEL_LEVEL_SHIFT = 40;
    public static final long STEP_LEVEL_INITIAL_MODE_MASK = 0xFF000000000000L;
    public static final int STEP_LEVEL_INITIAL_MODE_SHIFT = 48;
    public static final long STEP_LEVEL_MODIFIED_MODE_MASK = -72057594037927936L;
    public static final int STEP_LEVEL_MODIFIED_MODE_SHIFT = 56;
    public static final int STEP_LEVEL_MODE_SCREEN_STATE = 3;
    public static final int MAX_TRACKED_SCREEN_STATE = 4;
    public static final int STEP_LEVEL_MODE_POWER_SAVE = 4;
    public static final int STEP_LEVEL_MODE_DEVICE_IDLE = 8;
    public static final int[] STEP_LEVEL_MODES_OF_INTEREST = new int[]{7, 15, 11, 7, 7, 7, 7, 7, 15, 11};
    public static final int[] STEP_LEVEL_MODE_VALUES = new int[]{0, 4, 8, 1, 5, 2, 6, 3, 7, 11};
    public static final String[] STEP_LEVEL_MODE_LABELS = new String[]{"screen off", "screen off power save", "screen off device idle", "screen on", "screen on power save", "screen doze", "screen doze power save", "screen doze-suspend", "screen doze-suspend power save", "screen doze-suspend device idle"};
    private static final String[] CHECKIN_POWER_COMPONENT_LABELS = new String[19];
    public static final int DUMP_CHARGED_ONLY = 2;
    public static final int DUMP_DAILY_ONLY = 4;
    public static final int DUMP_HISTORY_ONLY = 8;
    public static final int DUMP_INCLUDE_HISTORY = 16;
    public static final int DUMP_VERBOSE = 32;
    public static final int DUMP_DEVICE_WIFI_ONLY = 64;
    public static final int DUMP_DEBUG_PERF_BASELINE = 128;
    private static final int[] DISPLAY_TRANSPORT_PRIORITIES;

    @UnsupportedAppUsage(maxTargetSdk=28)
    public BatteryStats() {
    }

    public static int mapToInternalProcessState(int procState) {
        if (procState == 20) {
            return 7;
        }
        if (procState == 2) {
            return 0;
        }
        if (procState == 3) {
            return 3;
        }
        if (procState == 4) {
            return 1;
        }
        if (procState == 5) {
            return 1;
        }
        if (procState <= 6) {
            return 2;
        }
        if (procState <= 11) {
            return 3;
        }
        if (procState <= 12) {
            return 4;
        }
        if (procState <= 13) {
            return 5;
        }
        return 6;
    }

    public static int mapUidProcessStateToBatteryConsumerProcessState(int processState) {
        switch (processState) {
            case 0: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 6: {
                return 4;
            }
        }
        return 0;
    }

    public abstract boolean isProcessStateDataAvailable();

    public abstract DailyItem getDailyItemLocked(int var1);

    public abstract long getCurrentDailyStartTime();

    public abstract long getNextMinDailyDeadline();

    public abstract long getNextMaxDailyDeadline();

    public abstract CpuScalingPolicies getCpuScalingPolicies();

    public abstract void commitCurrentHistoryBatchLocked();

    public abstract int getHistoryTotalSize();

    public abstract int getHistoryUsedSize();

    public abstract int getHistoryStringPoolSize();

    public abstract int getHistoryStringPoolBytes();

    public abstract String getHistoryTagPoolString(int var1);

    public abstract int getHistoryTagPoolUid(int var1);

    public abstract BatteryStatsHistoryIterator iterateBatteryStatsHistory(long var1, long var3);

    public abstract int getStartCount();

    @UnsupportedAppUsage
    public abstract long getScreenOnTime(long var1, int var3);

    public abstract int getScreenOnCount(int var1);

    public abstract long getScreenDozeTime(long var1, int var3);

    public abstract int getScreenDozeCount(int var1);

    public abstract long getInteractiveTime(long var1, int var3);

    @UnsupportedAppUsage
    public abstract long getScreenBrightnessTime(int var1, long var2, int var4);

    public abstract Timer getScreenBrightnessTimer(int var1);

    public abstract int getDisplayCount();

    public abstract long getDisplayScreenOnTime(int var1, long var2);

    public abstract long getDisplayScreenDozeTime(int var1, long var2);

    public abstract long getDisplayScreenBrightnessTime(int var1, int var2, long var3);

    public abstract long getPowerSaveModeEnabledTime(long var1, int var3);

    public abstract int getPowerSaveModeEnabledCount(int var1);

    public abstract long getDeviceIdleModeTime(int var1, long var2, int var4);

    public abstract int getDeviceIdleModeCount(int var1, int var2);

    public abstract long getLongestDeviceIdleModeTime(int var1);

    public abstract long getDeviceIdlingTime(int var1, long var2, int var4);

    public abstract int getDeviceIdlingCount(int var1, int var2);

    public abstract int getNumConnectivityChange(int var1);

    public abstract long getGpsSignalQualityTime(int var1, long var2, int var4);

    public abstract long getGpsBatteryDrainMaMs();

    @UnsupportedAppUsage
    public abstract long getPhoneOnTime(long var1, int var3);

    public abstract int getPhoneOnCount(int var1);

    @UnsupportedAppUsage
    public abstract long getPhoneSignalStrengthTime(int var1, long var2, int var4);

    public abstract long getPhoneSignalScanningTime(long var1, int var3);

    public abstract Timer getPhoneSignalScanningTimer();

    public abstract int getPhoneSignalStrengthCount(int var1, int var2);

    protected abstract Timer getPhoneSignalStrengthTimer(int var1);

    @UnsupportedAppUsage(maxTargetSdk=28)
    public abstract long getMobileRadioActiveTime(long var1, int var3);

    public abstract int getMobileRadioActiveCount(int var1);

    public abstract long getMobileRadioActiveAdjustedTime(int var1);

    public abstract long getMobileRadioActiveUnknownTime(int var1);

    public abstract int getMobileRadioActiveUnknownCount(int var1);

    @RavenwoodReplace
    public static int getAllNetworkTypesCount() {
        int count = TelephonyManager.getAllNetworkTypes().length;
        if (DATA_CONNECTION_NAMES.length != count + 3) {
            throw new IllegalStateException("DATA_CONNECTION_NAMES length does not match network type count. Expected: " + (count + 3) + ", actual:" + DATA_CONNECTION_NAMES.length);
        }
        return count;
    }

    public static int getAllNetworkTypesCount$ravenwood() {
        return DATA_CONNECTION_NAMES.length - 3;
    }

    public abstract long getPhoneDataConnectionTime(int var1, long var2, int var4);

    public abstract int getPhoneDataConnectionCount(int var1, int var2);

    public abstract Timer getPhoneDataConnectionTimer(int var1);

    public abstract long getNrNsaTime(long var1);

    public abstract long getActiveRadioDurationMs(int var1, int var2, int var3, long var4);

    public abstract long getActiveTxRadioDurationMs(int var1, int var2, int var3, long var4);

    public abstract long getActiveRxRadioDurationMs(int var1, int var2, long var3);

    @NonNull
    public abstract String[] getCustomEnergyConsumerNames();

    public abstract long getWifiMulticastWakelockTime(long var1, int var3);

    public abstract int getWifiMulticastWakelockCount(int var1);

    @UnsupportedAppUsage
    public abstract long getWifiOnTime(long var1, int var3);

    public abstract long getWifiActiveTime(long var1, int var3);

    @UnsupportedAppUsage
    public abstract long getGlobalWifiRunningTime(long var1, int var3);

    public abstract long getWifiStateTime(int var1, long var2, int var4);

    public abstract int getWifiStateCount(int var1, int var2);

    public abstract Timer getWifiStateTimer(int var1);

    public abstract long getWifiSupplStateTime(int var1, long var2, int var4);

    public abstract int getWifiSupplStateCount(int var1, int var2);

    public abstract Timer getWifiSupplStateTimer(int var1);

    public abstract long getWifiSignalStrengthTime(int var1, long var2, int var4);

    public abstract int getWifiSignalStrengthCount(int var1, int var2);

    public abstract Timer getWifiSignalStrengthTimer(int var1);

    public abstract long getFlashlightOnTime(long var1, int var3);

    public abstract long getFlashlightOnCount(int var1);

    public abstract long getCameraOnTime(long var1, int var3);

    public abstract long getBluetoothScanTime(long var1, int var3);

    @UnsupportedAppUsage(maxTargetSdk=28)
    public abstract long getNetworkActivityBytes(int var1, int var2);

    public abstract long getNetworkActivityPackets(int var1, int var2);

    public abstract boolean hasWifiActivityReporting();

    public abstract ControllerActivityCounter getWifiControllerActivity();

    public abstract boolean hasBluetoothActivityReporting();

    public abstract ControllerActivityCounter getBluetoothControllerActivity();

    public abstract boolean hasModemActivityReporting();

    public abstract ControllerActivityCounter getModemControllerActivity();

    public abstract long getStartClockTime();

    public abstract String getStartPlatformVersion();

    public abstract String getEndPlatformVersion();

    public abstract int getParcelVersion();

    public abstract boolean getIsOnBattery();

    public abstract long getStatsStartRealtime();

    @UnsupportedAppUsage
    public abstract SparseArray<? extends Uid> getUidStats();

    @UnsupportedAppUsage
    public abstract long getBatteryUptime(long var1);

    public abstract long getBatteryRealtime(long var1);

    public abstract int getDischargeStartLevel();

    public abstract int getDischargeCurrentLevel();

    public abstract int getLowDischargeAmountSinceCharge();

    public abstract int getHighDischargeAmountSinceCharge();

    public abstract int getDischargeAmount(int var1);

    public abstract int getDischargeAmountScreenOn();

    public abstract int getDischargeAmountScreenOnSinceCharge();

    public abstract int getDischargeAmountScreenOff();

    public abstract int getDischargeAmountScreenOffSinceCharge();

    public abstract int getDischargeAmountScreenDoze();

    public abstract int getDischargeAmountScreenDozeSinceCharge();

    @UnsupportedAppUsage
    public abstract long computeBatteryUptime(long var1, int var3);

    @UnsupportedAppUsage
    public abstract long computeBatteryRealtime(long var1, int var3);

    public abstract long computeBatteryScreenOffUptime(long var1, int var3);

    public abstract long computeBatteryScreenOffRealtime(long var1, int var3);

    public abstract long computeUptime(long var1, int var3);

    public abstract long computeRealtime(long var1, int var3);

    @UnsupportedAppUsage
    public abstract long computeBatteryTimeRemaining(long var1);

    public abstract long getUahDischargeScreenOff(int var1);

    public abstract long getUahDischargeScreenDoze(int var1);

    public abstract long getUahDischarge(int var1);

    public abstract long getUahDischargeLightDoze(int var1);

    public abstract long getUahDischargeDeepDoze(int var1);

    public abstract int getEstimatedBatteryCapacity();

    public abstract int getMinLearnedBatteryCapacity();

    public abstract int getMaxLearnedBatteryCapacity();

    public abstract int getLearnedBatteryCapacity();

    public int getBatteryCapacity() {
        int batteryCapacityUah = this.getLearnedBatteryCapacity();
        if (batteryCapacityUah > 0) {
            return batteryCapacityUah / 1000;
        }
        batteryCapacityUah = this.getMinLearnedBatteryCapacity();
        if (batteryCapacityUah > 0) {
            return batteryCapacityUah / 1000;
        }
        return this.getEstimatedBatteryCapacity();
    }

    public abstract LevelStepTracker getDischargeLevelStepTracker();

    public abstract LevelStepTracker getDailyDischargeLevelStepTracker();

    @UnsupportedAppUsage
    public abstract long computeChargeTimeRemaining(long var1);

    public abstract LevelStepTracker getChargeLevelStepTracker();

    public abstract LevelStepTracker getDailyChargeLevelStepTracker();

    public abstract ArrayList<PackageChange> getDailyPackageChanges();

    public abstract Map<String, ? extends Timer> getWakeupReasonStats();

    public abstract Map<String, ? extends Timer> getKernelWakelockStats();

    public abstract WakeLockStats getWakeLockStats();

    public abstract BluetoothBatteryStats getBluetoothBatteryStats();

    public abstract Map<String, ? extends Timer> getRpmStats();

    public abstract Map<String, ? extends Timer> getScreenOffRpmStats();

    public abstract LongSparseArray<? extends Timer> getKernelMemoryStats();

    private static void formatTimeRaw(StringBuilder out, long seconds) {
        long mins;
        long used;
        long hours;
        long days = seconds / 86400L;
        if (days != 0L) {
            out.append(days);
            out.append("d ");
        }
        if ((hours = (seconds - (used = days * 60L * 60L * 24L)) / 3600L) != 0L || used != 0L) {
            out.append(hours);
            out.append("h ");
        }
        if ((mins = (seconds - (used += hours * 60L * 60L)) / 60L) != 0L || used != 0L) {
            out.append(mins);
            out.append("m ");
        }
        if (seconds != 0L || (used += mins * 60L) != 0L) {
            out.append(seconds - used);
            out.append("s ");
        }
    }

    public static void formatTimeMs(StringBuilder sb, long time) {
        long sec = time / 1000L;
        BatteryStats.formatTimeRaw(sb, sec);
        sb.append(time - sec * 1000L);
        sb.append("ms ");
    }

    public static void formatTimeMsNoSpace(StringBuilder sb, long time) {
        long sec = time / 1000L;
        BatteryStats.formatTimeRaw(sb, sec);
        sb.append(time - sec * 1000L);
        sb.append("ms");
    }

    public String formatRatioLocked(long num, long den) {
        if (den == 0L) {
            return "--%";
        }
        float perc = (float)num / (float)den * 100.0f;
        this.mFormatBuilder.setLength(0);
        this.mFormatter.format("%.1f%%", Float.valueOf(perc));
        return this.mFormatBuilder.toString();
    }

    String formatBytesLocked(long bytes) {
        this.mFormatBuilder.setLength(0);
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            this.mFormatter.format("%.2fKB", (double)bytes / 1024.0);
            return this.mFormatBuilder.toString();
        }
        if (bytes < 0x40000000L) {
            this.mFormatter.format("%.2fMB", (double)bytes / 1048576.0);
            return this.mFormatBuilder.toString();
        }
        this.mFormatter.format("%.2fGB", (double)bytes / 1.073741824E9);
        return this.mFormatBuilder.toString();
    }

    public static String formatCharge(double power) {
        return BatteryStats.formatValue(power);
    }

    private static String formatValue(double value) {
        if (value == 0.0) {
            return "0";
        }
        String format = value < 1.0E-5 ? "%.8f" : (value < 1.0E-4 ? "%.7f" : (value < 0.001 ? "%.6f" : (value < 0.01 ? "%.5f" : (value < 0.1 ? "%.4f" : (value < 1.0 ? "%.3f" : (value < 10.0 ? "%.2f" : (value < 100.0 ? "%.1f" : "%.0f")))))));
        return String.format(Locale.ENGLISH, format, value);
    }

    private static long roundUsToMs(long timeUs) {
        return (timeUs + 500L) / 1000L;
    }

    private static long computeWakeLock(Timer timer, long elapsedRealtimeUs, int which) {
        if (timer != null) {
            long totalTimeMicros = timer.getTotalTimeLocked(elapsedRealtimeUs, which);
            long totalTimeMillis = (totalTimeMicros + 500L) / 1000L;
            return totalTimeMillis;
        }
        return 0L;
    }

    private static String printWakeLock(StringBuilder sb, Timer timer, long elapsedRealtimeUs, String name, int which, String linePrefix) {
        if (timer != null) {
            long totalTimeMillis = BatteryStats.computeWakeLock(timer, elapsedRealtimeUs, which);
            int count = timer.getCountLocked(which);
            if (totalTimeMillis != 0L) {
                long totalDurMs;
                sb.append(linePrefix);
                BatteryStats.formatTimeMs(sb, totalTimeMillis);
                if (name != null) {
                    sb.append(name);
                    sb.append(' ');
                }
                sb.append('(');
                sb.append(count);
                sb.append(" times)");
                long maxDurationMs = timer.getMaxDurationMsLocked(elapsedRealtimeUs / 1000L);
                if (maxDurationMs >= 0L) {
                    sb.append(" max=");
                    sb.append(maxDurationMs);
                }
                if ((totalDurMs = timer.getTotalDurationMsLocked(elapsedRealtimeUs / 1000L)) > totalTimeMillis) {
                    sb.append(" actual=");
                    sb.append(totalDurMs);
                }
                if (timer.isRunningLocked()) {
                    long currentMs = timer.getCurrentDurationMsLocked(elapsedRealtimeUs / 1000L);
                    if (currentMs >= 0L) {
                        sb.append(" (running for ");
                        sb.append(currentMs);
                        sb.append("ms)");
                    } else {
                        sb.append(" (running)");
                    }
                }
                return ", ";
            }
        }
        return linePrefix;
    }

    private static boolean printTimer(PrintWriter pw, StringBuilder sb, Timer timer, long rawRealtimeUs, int which, String prefix, String type) {
        if (timer != null) {
            long totalTimeMs = (timer.getTotalTimeLocked(rawRealtimeUs, which) + 500L) / 1000L;
            int count = timer.getCountLocked(which);
            if (totalTimeMs != 0L) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    ");
                sb.append(type);
                sb.append(": ");
                BatteryStats.formatTimeMs(sb, totalTimeMs);
                sb.append("realtime (");
                sb.append(count);
                sb.append(" times)");
                long maxDurationMs = timer.getMaxDurationMsLocked(rawRealtimeUs / 1000L);
                if (maxDurationMs >= 0L) {
                    sb.append(" max=");
                    sb.append(maxDurationMs);
                }
                if (timer.isRunningLocked()) {
                    long currentMs = timer.getCurrentDurationMsLocked(rawRealtimeUs / 1000L);
                    if (currentMs >= 0L) {
                        sb.append(" (running for ");
                        sb.append(currentMs);
                        sb.append("ms)");
                    } else {
                        sb.append(" (running)");
                    }
                }
                pw.println(sb.toString());
                return true;
            }
        }
        return false;
    }

    private static String printWakeLockCheckin(StringBuilder sb, Timer timer, long elapsedRealtimeUs, String name, int which, String linePrefix) {
        long totalTimeMicros = 0L;
        int count = 0;
        long max = 0L;
        long current = 0L;
        long totalDuration = 0L;
        if (timer != null) {
            totalTimeMicros = timer.getTotalTimeLocked(elapsedRealtimeUs, which);
            count = timer.getCountLocked(which);
            current = timer.getCurrentDurationMsLocked(elapsedRealtimeUs / 1000L);
            max = timer.getMaxDurationMsLocked(elapsedRealtimeUs / 1000L);
            totalDuration = timer.getTotalDurationMsLocked(elapsedRealtimeUs / 1000L);
        }
        sb.append(linePrefix);
        sb.append((totalTimeMicros + 500L) / 1000L);
        sb.append(',');
        sb.append(name != null ? name + "," : "");
        sb.append(count);
        sb.append(',');
        sb.append(current);
        sb.append(',');
        sb.append(max);
        if (name != null) {
            sb.append(',');
            sb.append(totalDuration);
        }
        return ",";
    }

    private static void dumpLineHeader(PrintWriter pw, int uid, String category, String type) {
        pw.print(9);
        pw.print(',');
        pw.print(uid);
        pw.print(',');
        pw.print(category);
        pw.print(',');
        pw.print(type);
    }

    @UnsupportedAppUsage
    private static void dumpLine(PrintWriter pw, int uid, String category, String type, Object ... args) {
        BatteryStats.dumpLineHeader(pw, uid, category, type);
        for (Object arg : args) {
            pw.print(',');
            pw.print(arg);
        }
        pw.println();
    }

    private static void dumpTimer(PrintWriter pw, int uid, String category, String type, Timer timer, long rawRealtime, int which) {
        if (timer != null) {
            long totalTime = BatteryStats.roundUsToMs(timer.getTotalTimeLocked(rawRealtime, which));
            int count = timer.getCountLocked(which);
            if (totalTime != 0L || count != 0) {
                BatteryStats.dumpLine(pw, uid, category, type, totalTime, count);
            }
        }
    }

    private static void dumpTimer(ProtoOutputStream proto, long fieldId, Timer timer, long rawRealtimeUs, int which) {
        if (timer == null) {
            return;
        }
        long timeMs = BatteryStats.roundUsToMs(timer.getTotalTimeLocked(rawRealtimeUs, which));
        int count = timer.getCountLocked(which);
        long maxDurationMs = timer.getMaxDurationMsLocked(rawRealtimeUs / 1000L);
        long curDurationMs = timer.getCurrentDurationMsLocked(rawRealtimeUs / 1000L);
        long totalDurationMs = timer.getTotalDurationMsLocked(rawRealtimeUs / 1000L);
        if (timeMs != 0L || count != 0 || maxDurationMs != -1L || curDurationMs != -1L || totalDurationMs != -1L) {
            long token = proto.start(fieldId);
            proto.write(0x10300000001L, timeMs);
            proto.write(1112396529666L, count);
            if (maxDurationMs != -1L) {
                proto.write(0x10300000003L, maxDurationMs);
            }
            if (curDurationMs != -1L) {
                proto.write(1112396529668L, curDurationMs);
            }
            if (totalDurationMs != -1L) {
                proto.write(1112396529669L, totalDurationMs);
            }
            proto.end(token);
        }
    }

    private static boolean controllerActivityHasData(ControllerActivityCounter counter, int which) {
        if (counter == null) {
            return false;
        }
        if (counter.getIdleTimeCounter().getCountLocked(which) != 0L || counter.getRxTimeCounter().getCountLocked(which) != 0L || counter.getPowerCounter().getCountLocked(which) != 0L || counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(which) != 0L) {
            return true;
        }
        for (LongCounter c : counter.getTxTimeCounters()) {
            if (c.getCountLocked(which) == 0L) continue;
            return true;
        }
        return false;
    }

    private static void dumpControllerActivityLine(PrintWriter pw, int uid, String category, String type, ControllerActivityCounter counter, int which) {
        if (!BatteryStats.controllerActivityHasData(counter, which)) {
            return;
        }
        BatteryStats.dumpLineHeader(pw, uid, category, type);
        pw.print(",");
        pw.print(counter.getIdleTimeCounter().getCountLocked(which));
        pw.print(",");
        pw.print(counter.getRxTimeCounter().getCountLocked(which));
        pw.print(",");
        pw.print((double)counter.getPowerCounter().getCountLocked(which) / 3600000.0);
        pw.print(",");
        pw.print((double)counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(which) / 3600000.0);
        for (LongCounter c : counter.getTxTimeCounters()) {
            pw.print(",");
            pw.print(c.getCountLocked(which));
        }
        pw.println();
    }

    private static void dumpControllerActivityProto(ProtoOutputStream proto, long fieldId, ControllerActivityCounter counter, int which) {
        if (!BatteryStats.controllerActivityHasData(counter, which)) {
            return;
        }
        long cToken = proto.start(fieldId);
        proto.write(0x10300000001L, counter.getIdleTimeCounter().getCountLocked(which));
        proto.write(1112396529666L, counter.getRxTimeCounter().getCountLocked(which));
        proto.write(0x10300000003L, (double)counter.getPowerCounter().getCountLocked(which) / 3600000.0);
        proto.write(0x10100000005L, (double)counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(which) / 3600000.0);
        LongCounter[] txCounters = counter.getTxTimeCounters();
        for (int i = 0; i < txCounters.length; ++i) {
            LongCounter c = txCounters[i];
            long tToken = proto.start(2246267895812L);
            proto.write(0x10500000001L, i);
            proto.write(1112396529666L, c.getCountLocked(which));
            proto.end(tToken);
        }
        proto.end(cToken);
    }

    private void printControllerActivityIfInteresting(PrintWriter pw, StringBuilder sb, String prefix, String controllerName, ControllerActivityCounter counter, int which) {
        if (BatteryStats.controllerActivityHasData(counter, which)) {
            this.printControllerActivity(pw, sb, prefix, controllerName, counter, which);
        }
    }

    private void printControllerActivity(PrintWriter pw, StringBuilder sb, String prefix, String controllerName, ControllerActivityCounter counter, int which) {
        String[] powerLevel;
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(which);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(which);
        long powerDrainMaMs = counter.getPowerCounter().getCountLocked(which);
        long monitoredRailChargeConsumedMaMs = counter.getMonitoredRailChargeConsumedMaMs().getCountLocked(which);
        long totalControllerActivityTimeMs = this.computeBatteryRealtime(SystemClock.elapsedRealtime() * 1000L, which) / 1000L;
        long totalTxTimeMs = 0L;
        for (LongCounter txState : counter.getTxTimeCounters()) {
            totalTxTimeMs += txState.getCountLocked(which);
        }
        if (controllerName.equals(WIFI_CONTROLLER_NAME)) {
            long scanTimeMs = counter.getScanTimeCounter().getCountLocked(which);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("     ");
            sb.append(controllerName);
            sb.append(" Scan time:  ");
            BatteryStats.formatTimeMs(sb, scanTimeMs);
            sb.append("(");
            sb.append(this.formatRatioLocked(scanTimeMs, totalControllerActivityTimeMs));
            sb.append(")");
            pw.println(sb.toString());
            long sleepTimeMs = totalControllerActivityTimeMs - (idleTimeMs + rxTimeMs + totalTxTimeMs);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("     ");
            sb.append(controllerName);
            sb.append(" Sleep time:  ");
            BatteryStats.formatTimeMs(sb, sleepTimeMs);
            sb.append("(");
            sb.append(this.formatRatioLocked(sleepTimeMs, totalControllerActivityTimeMs));
            sb.append(")");
            pw.println(sb.toString());
        }
        if (controllerName.equals(CELLULAR_CONTROLLER_NAME)) {
            long sleepTimeMs = counter.getSleepTimeCounter().getCountLocked(which);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("     ");
            sb.append(controllerName);
            sb.append(" Sleep time:  ");
            BatteryStats.formatTimeMs(sb, sleepTimeMs);
            sb.append("(");
            sb.append(this.formatRatioLocked(sleepTimeMs, totalControllerActivityTimeMs));
            sb.append(")");
            pw.println(sb.toString());
        }
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     ");
        sb.append(controllerName);
        sb.append(" Idle time:   ");
        BatteryStats.formatTimeMs(sb, idleTimeMs);
        sb.append("(");
        sb.append(this.formatRatioLocked(idleTimeMs, totalControllerActivityTimeMs));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     ");
        sb.append(controllerName);
        sb.append(" Rx time:     ");
        BatteryStats.formatTimeMs(sb, rxTimeMs);
        sb.append("(");
        sb.append(this.formatRatioLocked(rxTimeMs, totalControllerActivityTimeMs));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     ");
        sb.append(controllerName);
        sb.append(" Tx time:     ");
        switch (controllerName) {
            case "Cellular": {
                powerLevel = new String[]{"   less than 0dBm: ", "   0dBm to 8dBm: ", "   8dBm to 15dBm: ", "   15dBm to 20dBm: ", "   above 20dBm: "};
                break;
            }
            default: {
                powerLevel = new String[]{"[0]", "[1]", "[2]", "[3]", "[4]"};
            }
        }
        int numTxLvls = Math.min(counter.getTxTimeCounters().length, powerLevel.length);
        if (numTxLvls > 1) {
            pw.println(sb.toString());
            for (int lvl = 0; lvl < numTxLvls; ++lvl) {
                long txLvlTimeMs = counter.getTxTimeCounters()[lvl].getCountLocked(which);
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    ");
                sb.append(powerLevel[lvl]);
                sb.append(" ");
                BatteryStats.formatTimeMs(sb, txLvlTimeMs);
                sb.append("(");
                sb.append(this.formatRatioLocked(txLvlTimeMs, totalControllerActivityTimeMs));
                sb.append(")");
                pw.println(sb.toString());
            }
        } else {
            long txLvlTimeMs = counter.getTxTimeCounters()[0].getCountLocked(which);
            BatteryStats.formatTimeMs(sb, txLvlTimeMs);
            sb.append("(");
            sb.append(this.formatRatioLocked(txLvlTimeMs, totalControllerActivityTimeMs));
            sb.append(")");
            pw.println(sb.toString());
        }
        if (powerDrainMaMs > 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("     ");
            sb.append(controllerName);
            sb.append(" Battery drain: ").append(BatteryStats.formatCharge((double)powerDrainMaMs / 3600000.0));
            sb.append("mAh");
            pw.println(sb.toString());
        }
        if (monitoredRailChargeConsumedMaMs > 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("     ");
            sb.append(controllerName);
            sb.append(" Monitored rail energy drain: ").append(new DecimalFormat("#.##").format((double)monitoredRailChargeConsumedMaMs / 3600000.0));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
    }

    private void printCellularPerRatBreakdown(PrintWriter pw, StringBuilder sb, String prefix, long rawRealtimeMs) {
        String allFrequenciesHeader = "    All frequencies:\n";
        String[] nrFrequencyRangeDescription = new String[]{"    Unknown frequency:\n", "    Low frequency (less than 1GHz):\n", "    Middle frequency (1GHz to 3GHz):\n", "    High frequency (3GHz to 6GHz):\n", "    Mmwave frequency (greater than 6GHz):\n"};
        String signalStrengthHeader = "      Signal Strength Time:\n";
        String txHeader = "      Tx Time:\n";
        String rxHeader = "      Rx Time: ";
        String[] signalStrengthDescription = new String[]{"        unknown:  ", "        poor:     ", "        moderate: ", "        good:     ", "        great:    "};
        long totalActiveTimesMs = this.getMobileRadioActiveTime(rawRealtimeMs * 1000L, 0) / 1000L;
        sb.setLength(0);
        sb.append(prefix);
        sb.append("Active Cellular Radio Access Technology Breakdown:");
        pw.println(sb);
        boolean hasData = false;
        int numSignalStrength = CellSignalStrength.getNumSignalStrengthLevels();
        for (int rat = 2; rat >= 0; --rat) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  ");
            sb.append(RADIO_ACCESS_TECHNOLOGY_NAMES[rat]);
            sb.append(":\n");
            sb.append(prefix);
            int numFreqLvl = rat == 2 ? nrFrequencyRangeDescription.length : 1;
            for (int freqLvl = numFreqLvl - 1; freqLvl >= 0; --freqLvl) {
                long timeMs;
                int strength;
                int freqDescriptionStart = sb.length();
                boolean hasFreqData = false;
                if (rat == 2) {
                    sb.append(nrFrequencyRangeDescription[freqLvl]);
                } else {
                    sb.append("    All frequencies:\n");
                }
                sb.append(prefix);
                sb.append("      Signal Strength Time:\n");
                for (strength = 0; strength < numSignalStrength; ++strength) {
                    timeMs = this.getActiveRadioDurationMs(rat, freqLvl, strength, rawRealtimeMs);
                    if (timeMs <= 0L) continue;
                    hasFreqData = true;
                    sb.append(prefix);
                    sb.append(signalStrengthDescription[strength]);
                    BatteryStats.formatTimeMs(sb, timeMs);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(timeMs, totalActiveTimesMs));
                    sb.append(")\n");
                }
                sb.append(prefix);
                sb.append("      Tx Time:\n");
                for (strength = 0; strength < numSignalStrength; ++strength) {
                    timeMs = this.getActiveTxRadioDurationMs(rat, freqLvl, strength, rawRealtimeMs);
                    if (timeMs <= 0L) continue;
                    hasFreqData = true;
                    sb.append(prefix);
                    sb.append(signalStrengthDescription[strength]);
                    BatteryStats.formatTimeMs(sb, timeMs);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(timeMs, totalActiveTimesMs));
                    sb.append(")\n");
                }
                sb.append(prefix);
                sb.append("      Rx Time: ");
                long rxTimeMs = this.getActiveRxRadioDurationMs(rat, freqLvl, rawRealtimeMs);
                BatteryStats.formatTimeMs(sb, rxTimeMs);
                sb.append("(");
                sb.append(this.formatRatioLocked(rxTimeMs, totalActiveTimesMs));
                sb.append(")\n");
                if (hasFreqData) {
                    hasData = true;
                    pw.print(sb);
                    sb.setLength(0);
                    sb.append(prefix);
                    continue;
                }
                sb.setLength(freqDescriptionStart);
            }
        }
        if (!hasData) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  (no activity)");
            pw.println(sb);
        }
    }

    public void dumpCheckinLocked(Context context, PrintWriter pw, int which, int reqUid, boolean wifiOnly, BatteryStatsDumpHelper dumpHelper) {
        int i;
        if (which != 0) {
            BatteryStats.dumpLine(pw, 0, STAT_NAMES[which], "err", "ERROR: BatteryStats.dumpCheckin called for which type " + which + " but only STATS_SINCE_CHARGED is supported.");
            return;
        }
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtimeMs = SystemClock.elapsedRealtime();
        long rawRealtime = rawRealtimeMs * 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long whichBatteryScreenOffUptime = this.computeBatteryScreenOffUptime(rawUptime, which);
        long whichBatteryScreenOffRealtime = this.computeBatteryScreenOffRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        long screenOnTime = this.getScreenOnTime(rawRealtime, which);
        long screenDozeTime = this.getScreenDozeTime(rawRealtime, which);
        long interactiveTime = this.getInteractiveTime(rawRealtime, which);
        long powerSaveModeEnabledTime = this.getPowerSaveModeEnabledTime(rawRealtime, which);
        long deviceIdleModeLightTime = this.getDeviceIdleModeTime(1, rawRealtime, which);
        long deviceIdleModeFullTime = this.getDeviceIdleModeTime(2, rawRealtime, which);
        long deviceLightIdlingTime = this.getDeviceIdlingTime(1, rawRealtime, which);
        long deviceIdlingTime = this.getDeviceIdlingTime(2, rawRealtime, which);
        int connChanges = this.getNumConnectivityChange(which);
        long phoneOnTime = this.getPhoneOnTime(rawRealtime, which);
        long dischargeCount = this.getUahDischarge(which);
        long dischargeScreenOffCount = this.getUahDischargeScreenOff(which);
        long dischargeScreenDozeCount = this.getUahDischargeScreenDoze(which);
        long dischargeLightDozeCount = this.getUahDischargeLightDoze(which);
        long dischargeDeepDozeCount = this.getUahDischargeDeepDoze(which);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        String category = STAT_NAMES[which];
        BatteryStats.dumpLine(pw, 0, category, BATTERY_DATA, which == 0 ? Integer.valueOf(this.getStartCount()) : "N/A", whichBatteryRealtime / 1000L, whichBatteryUptime / 1000L, totalRealtime / 1000L, totalUptime / 1000L, this.getStartClockTime(), whichBatteryScreenOffRealtime / 1000L, whichBatteryScreenOffUptime / 1000L, this.getEstimatedBatteryCapacity(), this.getMinLearnedBatteryCapacity(), this.getMaxLearnedBatteryCapacity(), screenDozeTime / 1000L);
        long fullWakeLockTimeTotal = 0L;
        long partialWakeLockTimeTotal = 0L;
        for (int iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            ArrayMap<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            for (int iw = wakelocks.size() - 1; iw >= 0; --iw) {
                Timer partialWakeTimer;
                Uid.Wakelock wl = wakelocks.valueAt(iw);
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotal += fullWakeTimer.getTotalTimeLocked(rawRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null) continue;
                partialWakeLockTimeTotal += partialWakeTimer.getTotalTimeLocked(rawRealtime, which);
            }
        }
        long mobileRxTotalBytes = this.getNetworkActivityBytes(0, which);
        long mobileTxTotalBytes = this.getNetworkActivityBytes(1, which);
        long wifiRxTotalBytes = this.getNetworkActivityBytes(2, which);
        long wifiTxTotalBytes = this.getNetworkActivityBytes(3, which);
        long mobileRxTotalPackets = this.getNetworkActivityPackets(0, which);
        long mobileTxTotalPackets = this.getNetworkActivityPackets(1, which);
        long wifiRxTotalPackets = this.getNetworkActivityPackets(2, which);
        long wifiTxTotalPackets = this.getNetworkActivityPackets(3, which);
        long btRxTotalBytes = this.getNetworkActivityBytes(4, which);
        long btTxTotalBytes = this.getNetworkActivityBytes(5, which);
        BatteryStats.dumpLine(pw, 0, category, GLOBAL_NETWORK_DATA, mobileRxTotalBytes, mobileTxTotalBytes, wifiRxTotalBytes, wifiTxTotalBytes, mobileRxTotalPackets, mobileTxTotalPackets, wifiRxTotalPackets, wifiTxTotalPackets, btRxTotalBytes, btTxTotalBytes);
        BatteryStats.dumpControllerActivityLine(pw, 0, category, GLOBAL_MODEM_CONTROLLER_DATA, this.getModemControllerActivity(), which);
        long wifiOnTime = this.getWifiOnTime(rawRealtime, which);
        long wifiRunningTime = this.getGlobalWifiRunningTime(rawRealtime, which);
        BatteryStats.dumpLine(pw, 0, category, GLOBAL_WIFI_DATA, wifiOnTime / 1000L, wifiRunningTime / 1000L, 0, 0, 0);
        BatteryStats.dumpControllerActivityLine(pw, 0, category, GLOBAL_WIFI_CONTROLLER_DATA, this.getWifiControllerActivity(), which);
        BatteryStats.dumpControllerActivityLine(pw, 0, category, GLOBAL_BLUETOOTH_CONTROLLER_DATA, this.getBluetoothControllerActivity(), which);
        BatteryStats.dumpLine(pw, 0, category, MISC_DATA, screenOnTime / 1000L, phoneOnTime / 1000L, fullWakeLockTimeTotal / 1000L, partialWakeLockTimeTotal / 1000L, this.getMobileRadioActiveTime(rawRealtime, which) / 1000L, this.getMobileRadioActiveAdjustedTime(which) / 1000L, interactiveTime / 1000L, powerSaveModeEnabledTime / 1000L, connChanges, deviceIdleModeFullTime / 1000L, this.getDeviceIdleModeCount(2, which), deviceIdlingTime / 1000L, this.getDeviceIdlingCount(2, which), this.getMobileRadioActiveCount(which), this.getMobileRadioActiveUnknownTime(which) / 1000L, deviceIdleModeLightTime / 1000L, this.getDeviceIdleModeCount(1, which), deviceLightIdlingTime / 1000L, this.getDeviceIdlingCount(1, which), this.getLongestDeviceIdleModeTime(1), this.getLongestDeviceIdleModeTime(2));
        Object[] args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getScreenBrightnessTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SCREEN_BRIGHTNESS_DATA, args);
        args = new Object[CellSignalStrength.getNumSignalStrengthLevels()];
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            args[i] = this.getPhoneSignalStrengthTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_TIME_DATA, args);
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_SCANNING_TIME_DATA, this.getPhoneSignalScanningTime(rawRealtime, which) / 1000L);
        for (i = 0; i < CellSignalStrength.getNumSignalStrengthLevels(); ++i) {
            args[i] = this.getPhoneSignalStrengthCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_COUNT_DATA, args);
        args = new Object[NUM_DATA_CONNECTION_TYPES];
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            args[i] = this.getPhoneDataConnectionTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_TIME_DATA, args);
        for (i = 0; i < NUM_DATA_CONNECTION_TYPES; ++i) {
            args[i] = this.getPhoneDataConnectionCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_COUNT_DATA, args);
        args = new Object[8];
        for (i = 0; i < 8; ++i) {
            args[i] = this.getWifiStateTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_STATE_TIME_DATA, args);
        for (i = 0; i < 8; ++i) {
            args[i] = this.getWifiStateCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_STATE_COUNT_DATA, args);
        args = new Object[13];
        for (i = 0; i < 13; ++i) {
            args[i] = this.getWifiSupplStateTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SUPPL_STATE_TIME_DATA, args);
        for (i = 0; i < 13; ++i) {
            args[i] = this.getWifiSupplStateCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SUPPL_STATE_COUNT_DATA, args);
        args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getWifiSignalStrengthTime(i, rawRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SIGNAL_STRENGTH_TIME_DATA, args);
        for (i = 0; i < 5; ++i) {
            args[i] = this.getWifiSignalStrengthCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, WIFI_SIGNAL_STRENGTH_COUNT_DATA, args);
        long multicastWakeLockTimeTotalMicros = this.getWifiMulticastWakelockTime(rawRealtime, which);
        int multicastWakeLockCountTotal = this.getWifiMulticastWakelockCount(which);
        BatteryStats.dumpLine(pw, 0, category, WIFI_MULTICAST_TOTAL_DATA, multicastWakeLockTimeTotalMicros / 1000L, multicastWakeLockCountTotal);
        BatteryStats.dumpLine(pw, 0, category, BATTERY_DISCHARGE_DATA, this.getLowDischargeAmountSinceCharge(), this.getHighDischargeAmountSinceCharge(), this.getDischargeAmountScreenOnSinceCharge(), this.getDischargeAmountScreenOffSinceCharge(), dischargeCount / 1000L, dischargeScreenOffCount / 1000L, this.getDischargeAmountScreenDozeSinceCharge(), dischargeScreenDozeCount / 1000L, dischargeLightDozeCount / 1000L, dischargeDeepDozeCount / 1000L);
        if (reqUid < 0) {
            Map<String, ? extends Timer> wakeupReasons;
            Map<String, ? extends Timer> kernelWakelocks = this.getKernelWakelockStats();
            if (kernelWakelocks.size() > 0) {
                for (Map.Entry<String, ? extends Timer> entry : kernelWakelocks.entrySet()) {
                    sb.setLength(0);
                    BatteryStats.printWakeLockCheckin(sb, entry.getValue(), rawRealtime, null, which, "");
                    BatteryStats.dumpLine(pw, 0, category, KERNEL_WAKELOCK_DATA, "\"" + entry.getKey() + "\"", sb.toString());
                }
            }
            if ((wakeupReasons = this.getWakeupReasonStats()).size() > 0) {
                for (Map.Entry<String, ? extends Timer> entry : wakeupReasons.entrySet()) {
                    long totalTimeMicros = entry.getValue().getTotalTimeLocked(rawRealtime, which);
                    int count = entry.getValue().getCountLocked(which);
                    BatteryStats.dumpLine(pw, 0, category, WAKEUP_REASON_DATA, "\"" + entry.getKey() + "\"", (totalTimeMicros + 500L) / 1000L, count);
                }
            }
        }
        Map<String, ? extends Timer> rpmStats = this.getRpmStats();
        Map<String, ? extends Timer> screenOffRpmStats = this.getScreenOffRpmStats();
        if (rpmStats.size() > 0) {
            for (Map.Entry<String, ? extends Timer> entry : rpmStats.entrySet()) {
                sb.setLength(0);
                Timer totalTimer = entry.getValue();
                long timeMs = (totalTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count = totalTimer.getCountLocked(which);
                Timer screenOffTimer = screenOffRpmStats.get(entry.getKey());
                long screenOffTimeMs = screenOffTimer != null ? (screenOffTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L : 0L;
                int screenOffCount = screenOffTimer != null ? screenOffTimer.getCountLocked(which) : 0;
                BatteryStats.dumpLine(pw, 0, category, RESOURCE_POWER_MANAGER_DATA, "\"" + entry.getKey() + "\"", timeMs, count);
            }
        }
        BatteryUsageStats batteryUsageStats = dumpHelper.getBatteryUsageStats(this, true);
        BatteryStats.dumpLine(pw, 0, category, POWER_USE_SUMMARY_DATA, BatteryStats.formatCharge(batteryUsageStats.getBatteryCapacity()), BatteryStats.formatCharge(batteryUsageStats.getConsumedPower()), BatteryStats.formatCharge(batteryUsageStats.getDischargedPowerRange().getLower()), BatteryStats.formatCharge(batteryUsageStats.getDischargedPowerRange().getUpper()));
        AggregateBatteryConsumer aggregateBatteryConsumer = batteryUsageStats.getAggregateBatteryConsumer(0);
        for (int powerComponent = 0; powerComponent < 19; ++powerComponent) {
            String label = CHECKIN_POWER_COMPONENT_LABELS[powerComponent];
            if (label == null) {
                label = "???";
            }
            BatteryStats.dumpLine(pw, 0, category, POWER_USE_ITEM_DATA, label, BatteryStats.formatCharge(aggregateBatteryConsumer.getConsumedPower(powerComponent)), this.shouldHidePowerComponent(powerComponent) ? 1 : 0, "0", "0");
        }
        ProportionalAttributionCalculator proportionalAttributionCalculator = new ProportionalAttributionCalculator(context, batteryUsageStats);
        List<UidBatteryConsumer> uidBatteryConsumers = batteryUsageStats.getUidBatteryConsumers();
        for (int i2 = 0; i2 < uidBatteryConsumers.size(); ++i2) {
            UidBatteryConsumer consumer = uidBatteryConsumers.get(i2);
            BatteryStats.dumpLine(pw, consumer.getUid(), category, POWER_USE_ITEM_DATA, UID_DATA, BatteryStats.formatCharge(consumer.getConsumedPower()), proportionalAttributionCalculator.isSystemBatteryConsumer(consumer) ? 1 : 0, BatteryStats.formatCharge(consumer.getConsumedPower(0)), BatteryStats.formatCharge(proportionalAttributionCalculator.getProportionalPowerMah(consumer)));
        }
        CpuScalingPolicies scalingPolicies = this.getCpuScalingPolicies();
        if (scalingPolicies != null) {
            sb.setLength(0);
            for (int policy : scalingPolicies.getPolicies()) {
                for (int frequency : scalingPolicies.getFrequencies(policy)) {
                    if (sb.length() != 0) {
                        sb.append(',');
                    }
                    sb.append(frequency);
                }
            }
            BatteryStats.dumpLine(pw, 0, category, GLOBAL_CPU_FREQ_DATA, sb.toString());
        }
        for (int iu = 0; iu < NU; ++iu) {
            long totalTime;
            int uid = uidStats.keyAt(iu);
            if (reqUid >= 0 && uid != reqUid) continue;
            Uid u = uidStats.valueAt(iu);
            long mobileBytesRx = u.getNetworkActivityBytes(0, which);
            long mobileBytesTx = u.getNetworkActivityBytes(1, which);
            long wifiBytesRx = u.getNetworkActivityBytes(2, which);
            long wifiBytesTx = u.getNetworkActivityBytes(3, which);
            long mobilePacketsRx = u.getNetworkActivityPackets(0, which);
            long mobilePacketsTx = u.getNetworkActivityPackets(1, which);
            long mobileActiveTime = u.getMobileRadioActiveTime(which);
            int mobileActiveCount = u.getMobileRadioActiveCount(which);
            long mobileWakeup = u.getMobileRadioApWakeupCount(which);
            long wifiPacketsRx = u.getNetworkActivityPackets(2, which);
            long wifiPacketsTx = u.getNetworkActivityPackets(3, which);
            long wifiWakeup = u.getWifiRadioApWakeupCount(which);
            long btBytesRx = u.getNetworkActivityBytes(4, which);
            long btBytesTx = u.getNetworkActivityBytes(5, which);
            long mobileBytesBgRx = u.getNetworkActivityBytes(6, which);
            long mobileBytesBgTx = u.getNetworkActivityBytes(7, which);
            long wifiBytesBgRx = u.getNetworkActivityBytes(8, which);
            long wifiBytesBgTx = u.getNetworkActivityBytes(9, which);
            long mobilePacketsBgRx = u.getNetworkActivityPackets(6, which);
            long mobilePacketsBgTx = u.getNetworkActivityPackets(7, which);
            long wifiPacketsBgRx = u.getNetworkActivityPackets(8, which);
            long wifiPacketsBgTx = u.getNetworkActivityPackets(9, which);
            if (mobileBytesRx > 0L || mobileBytesTx > 0L || wifiBytesRx > 0L || wifiBytesTx > 0L || mobilePacketsRx > 0L || mobilePacketsTx > 0L || wifiPacketsRx > 0L || wifiPacketsTx > 0L || mobileActiveTime > 0L || mobileActiveCount > 0 || btBytesRx > 0L || btBytesTx > 0L || mobileWakeup > 0L || wifiWakeup > 0L || mobileBytesBgRx > 0L || mobileBytesBgTx > 0L || wifiBytesBgRx > 0L || wifiBytesBgTx > 0L || mobilePacketsBgRx > 0L || mobilePacketsBgTx > 0L || wifiPacketsBgRx > 0L || wifiPacketsBgTx > 0L) {
                BatteryStats.dumpLine(pw, uid, category, NETWORK_DATA, mobileBytesRx, mobileBytesTx, wifiBytesRx, wifiBytesTx, mobilePacketsRx, mobilePacketsTx, wifiPacketsRx, wifiPacketsTx, mobileActiveTime, mobileActiveCount, btBytesRx, btBytesTx, mobileWakeup, wifiWakeup, mobileBytesBgRx, mobileBytesBgTx, wifiBytesBgRx, wifiBytesBgTx, mobilePacketsBgRx, mobilePacketsBgTx, wifiPacketsBgRx, wifiPacketsBgTx);
            }
            BatteryStats.dumpControllerActivityLine(pw, uid, category, MODEM_CONTROLLER_DATA, u.getModemControllerActivity(), which);
            long fullWifiLockOnTime = u.getFullWifiLockTime(rawRealtime, which);
            long wifiScanTime = u.getWifiScanTime(rawRealtime, which);
            int wifiScanCount = u.getWifiScanCount(which);
            int wifiScanCountBg = u.getWifiScanBackgroundCount(which);
            long wifiScanActualTimeMs = (u.getWifiScanActualTime(rawRealtime) + 500L) / 1000L;
            long wifiScanActualTimeMsBg = (u.getWifiScanBackgroundTime(rawRealtime) + 500L) / 1000L;
            long uidWifiRunningTime = u.getWifiRunningTime(rawRealtime, which);
            if (fullWifiLockOnTime != 0L || wifiScanTime != 0L || wifiScanCount != 0 || wifiScanCountBg != 0 || wifiScanActualTimeMs != 0L || wifiScanActualTimeMsBg != 0L || uidWifiRunningTime != 0L) {
                BatteryStats.dumpLine(pw, uid, category, WIFI_DATA, fullWifiLockOnTime, wifiScanTime, uidWifiRunningTime, wifiScanCount, 0, 0, 0, wifiScanCountBg, wifiScanActualTimeMs, wifiScanActualTimeMsBg);
            }
            BatteryStats.dumpControllerActivityLine(pw, uid, category, WIFI_CONTROLLER_DATA, u.getWifiControllerActivity(), which);
            Timer bleTimer = u.getBluetoothScanTimer();
            if (bleTimer != null && (totalTime = (bleTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L) != 0L) {
                int count = bleTimer.getCountLocked(which);
                Timer bleTimerBg = u.getBluetoothScanBackgroundTimer();
                int countBg = bleTimerBg != null ? bleTimerBg.getCountLocked(which) : 0;
                long actualTime = bleTimer.getTotalDurationMsLocked(rawRealtimeMs);
                long actualTimeBg = bleTimerBg != null ? bleTimerBg.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                int resultCount = u.getBluetoothScanResultCounter() != null ? u.getBluetoothScanResultCounter().getCountLocked(which) : 0;
                int resultCountBg = u.getBluetoothScanResultBgCounter() != null ? u.getBluetoothScanResultBgCounter().getCountLocked(which) : 0;
                Timer unoptimizedScanTimer = u.getBluetoothUnoptimizedScanTimer();
                long unoptimizedScanTotalTime = unoptimizedScanTimer != null ? unoptimizedScanTimer.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                long unoptimizedScanMaxTime = unoptimizedScanTimer != null ? unoptimizedScanTimer.getMaxDurationMsLocked(rawRealtimeMs) : 0L;
                Timer unoptimizedScanTimerBg = u.getBluetoothUnoptimizedScanBackgroundTimer();
                long unoptimizedScanTotalTimeBg = unoptimizedScanTimerBg != null ? unoptimizedScanTimerBg.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                long unoptimizedScanMaxTimeBg = unoptimizedScanTimerBg != null ? unoptimizedScanTimerBg.getMaxDurationMsLocked(rawRealtimeMs) : 0L;
                BatteryStats.dumpLine(pw, uid, category, BLUETOOTH_MISC_DATA, totalTime, count, countBg, actualTime, actualTimeBg, resultCount, resultCountBg, unoptimizedScanTotalTime, unoptimizedScanTotalTimeBg, unoptimizedScanMaxTime, unoptimizedScanMaxTimeBg);
            }
            BatteryStats.dumpControllerActivityLine(pw, uid, category, BLUETOOTH_CONTROLLER_DATA, u.getBluetoothControllerActivity(), which);
            if (u.hasUserActivity()) {
                args = new Object[Uid.NUM_USER_ACTIVITY_TYPES];
                boolean hasData = false;
                for (int i3 = 0; i3 < Uid.NUM_USER_ACTIVITY_TYPES; ++i3) {
                    int val = u.getUserActivityCount(i3, which);
                    args[i3] = val;
                    if (val == 0) continue;
                    hasData = true;
                }
                if (hasData) {
                    BatteryStats.dumpLine(pw, uid, category, USER_ACTIVITY_DATA, args);
                }
            }
            if (u.getAggregatedPartialWakelockTimer() != null) {
                Timer timer = u.getAggregatedPartialWakelockTimer();
                long totTimeMs = timer.getTotalDurationMsLocked(rawRealtimeMs);
                Timer bgTimer = timer.getSubTimer();
                long bgTimeMs = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                BatteryStats.dumpLine(pw, uid, category, AGGREGATED_WAKELOCK_DATA, totTimeMs, bgTimeMs);
            }
            ArrayMap<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            for (int iw = wakelocks.size() - 1; iw >= 0; --iw) {
                Uid.Wakelock wl = wakelocks.valueAt(iw);
                String linePrefix = "";
                sb.setLength(0);
                linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(1), rawRealtime, "f", which, linePrefix);
                Timer pTimer = wl.getWakeTime(0);
                linePrefix = BatteryStats.printWakeLockCheckin(sb, pTimer, rawRealtime, "p", which, linePrefix);
                linePrefix = BatteryStats.printWakeLockCheckin(sb, pTimer != null ? pTimer.getSubTimer() : null, rawRealtime, "bp", which, linePrefix);
                linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(2), rawRealtime, "w", which, linePrefix);
                if (sb.length() <= 0) continue;
                String name = wakelocks.keyAt(iw);
                if (name.indexOf(44) >= 0) {
                    name = name.replace(',', '_');
                }
                if (name.indexOf(10) >= 0) {
                    name = name.replace('\n', '_');
                }
                if (name.indexOf(13) >= 0) {
                    name = name.replace('\r', '_');
                }
                BatteryStats.dumpLine(pw, uid, category, WAKELOCK_DATA, name, sb.toString());
            }
            Timer mcTimer = u.getMulticastWakelockStats();
            if (mcTimer != null) {
                long totalMcWakelockTimeMs = mcTimer.getTotalTimeLocked(rawRealtime, which) / 1000L;
                int countMcWakelock = mcTimer.getCountLocked(which);
                if (totalMcWakelockTimeMs > 0L) {
                    BatteryStats.dumpLine(pw, uid, category, WIFI_MULTICAST_DATA, totalMcWakelockTimeMs, countMcWakelock);
                }
            }
            ArrayMap<String, ? extends Timer> syncs = u.getSyncStats();
            for (int isy = syncs.size() - 1; isy >= 0; --isy) {
                int bgCount;
                Timer timer = syncs.valueAt(isy);
                long totalTime2 = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count = timer.getCountLocked(which);
                Timer bgTimer = timer.getSubTimer();
                long bgTime = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : -1L;
                int n = bgCount = bgTimer != null ? bgTimer.getCountLocked(which) : -1;
                if (totalTime2 == 0L) continue;
                BatteryStats.dumpLine(pw, uid, category, SYNC_DATA, "\"" + syncs.keyAt(isy) + "\"", totalTime2, count, bgTime, bgCount);
            }
            ArrayMap<String, ? extends Timer> jobs = u.getJobStats();
            for (int ij = jobs.size() - 1; ij >= 0; --ij) {
                int bgCount;
                Timer timer = jobs.valueAt(ij);
                long totalTime3 = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                int count = timer.getCountLocked(which);
                Timer bgTimer = timer.getSubTimer();
                long bgTime = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : -1L;
                int n = bgCount = bgTimer != null ? bgTimer.getCountLocked(which) : -1;
                if (totalTime3 == 0L) continue;
                BatteryStats.dumpLine(pw, uid, category, JOB_DATA, "\"" + jobs.keyAt(ij) + "\"", totalTime3, count, bgTime, bgCount);
            }
            int[] jobStopReasonCodes = JobParameters.getJobStopReasonCodes();
            Object[] jobCompletionArgs = new Object[jobStopReasonCodes.length + 1];
            ArrayMap<String, SparseIntArray> completions = u.getJobCompletionStats();
            for (int ic = completions.size() - 1; ic >= 0; --ic) {
                SparseIntArray types = completions.valueAt(ic);
                if (types == null) continue;
                jobCompletionArgs[0] = "\"" + completions.keyAt(ic) + "\"";
                for (int i4 = 0; i4 < jobStopReasonCodes.length; ++i4) {
                    jobCompletionArgs[i4 + 1] = types.get(jobStopReasonCodes[i4], 0);
                }
                BatteryStats.dumpLine(pw, uid, category, JOB_COMPLETION_DATA, jobCompletionArgs);
            }
            u.getDeferredJobsCheckinLineLocked(sb, which);
            if (sb.length() > 0) {
                BatteryStats.dumpLine(pw, uid, category, JOBS_DEFERRED_DATA, sb.toString());
            }
            BatteryStats.dumpTimer(pw, uid, category, FLASHLIGHT_DATA, u.getFlashlightTurnedOnTimer(), rawRealtime, which);
            BatteryStats.dumpTimer(pw, uid, category, CAMERA_DATA, u.getCameraTurnedOnTimer(), rawRealtime, which);
            BatteryStats.dumpTimer(pw, uid, category, VIDEO_DATA, u.getVideoTurnedOnTimer(), rawRealtime, which);
            BatteryStats.dumpTimer(pw, uid, category, AUDIO_DATA, u.getAudioTurnedOnTimer(), rawRealtime, which);
            SparseArray<? extends Uid.Sensor> sensors = u.getSensorStats();
            int NSE = sensors.size();
            for (int ise = 0; ise < NSE; ++ise) {
                long totalTime4;
                Uid.Sensor se = sensors.valueAt(ise);
                int sensorNumber = sensors.keyAt(ise);
                Timer timer = se.getSensorTime();
                if (timer == null || (totalTime4 = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L) == 0L) continue;
                int count = timer.getCountLocked(which);
                Timer bgTimer = se.getSensorBackgroundTime();
                int bgCount = bgTimer != null ? bgTimer.getCountLocked(which) : 0;
                long actualTime = timer.getTotalDurationMsLocked(rawRealtimeMs);
                long bgActualTime = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                BatteryStats.dumpLine(pw, uid, category, SENSOR_DATA, sensorNumber, totalTime4, count, bgCount, actualTime, bgActualTime);
            }
            BatteryStats.dumpTimer(pw, uid, category, VIBRATOR_DATA, u.getVibratorOnTimer(), rawRealtime, which);
            BatteryStats.dumpTimer(pw, uid, category, FOREGROUND_ACTIVITY_DATA, u.getForegroundActivityTimer(), rawRealtime, which);
            BatteryStats.dumpTimer(pw, uid, category, FOREGROUND_SERVICE_DATA, u.getForegroundServiceTimer(), rawRealtime, which);
            Object[] stateTimes = new Object[7];
            long totalStateTime = 0L;
            for (int ips = 0; ips < 7; ++ips) {
                long time = u.getProcessStateTime(ips, rawRealtime, which);
                totalStateTime += time;
                stateTimes[ips] = (time + 500L) / 1000L;
            }
            if (totalStateTime > 0L) {
                BatteryStats.dumpLine(pw, uid, category, STATE_TIME_DATA, stateTimes);
            }
            long userCpuTimeUs = u.getUserCpuTimeUs(which);
            long systemCpuTimeUs = u.getSystemCpuTimeUs(which);
            if (userCpuTimeUs > 0L || systemCpuTimeUs > 0L) {
                BatteryStats.dumpLine(pw, uid, category, CPU_DATA, userCpuTimeUs / 1000L, systemCpuTimeUs / 1000L, 0);
            }
            if (scalingPolicies != null) {
                long[] cpuFreqTimeMs = u.getCpuFreqTimes(which);
                if (cpuFreqTimeMs != null && cpuFreqTimeMs.length == scalingPolicies.getScalingStepCount()) {
                    sb.setLength(0);
                    for (int i6 = 0; i6 < cpuFreqTimeMs.length; ++i6) {
                        if (i6 != 0) {
                            sb.append(',');
                        }
                        sb.append(cpuFreqTimeMs[i6]);
                    }
                    long[] screenOffCpuFreqTimeMs = u.getScreenOffCpuFreqTimes(which);
                    if (screenOffCpuFreqTimeMs != null) {
                        for (int i5 = 0; i5 < screenOffCpuFreqTimeMs.length; ++i5) {
                            sb.append(',').append(screenOffCpuFreqTimeMs[i5]);
                        }
                    } else {
                        for (int i2 = 0; i2 < cpuFreqTimeMs.length; ++i2) {
                            sb.append(",0");
                        }
                    }
                    BatteryStats.dumpLine(pw, uid, category, CPU_TIMES_AT_FREQ_DATA, UID_TIMES_TYPE_ALL, cpuFreqTimeMs.length, sb.toString());
                }
                long[] timesInFreqMs = new long[this.getCpuScalingPolicies().getScalingStepCount()];
                for (int procState = 0; procState < 7; ++procState) {
                    int i3;
                    if (!u.getCpuFreqTimes(timesInFreqMs, procState)) continue;
                    sb.setLength(0);
                    for (int i7 = 0; i7 < timesInFreqMs.length; ++i7) {
                        if (i7 != 0) {
                            sb.append(',');
                        }
                        sb.append(timesInFreqMs[i7]);
                    }
                    if (u.getScreenOffCpuFreqTimes(timesInFreqMs, procState)) {
                        for (i3 = 0; i3 < timesInFreqMs.length; ++i3) {
                            sb.append(',').append(timesInFreqMs[i3]);
                        }
                    } else {
                        for (i3 = 0; i3 < timesInFreqMs.length; ++i3) {
                            sb.append(",0");
                        }
                    }
                    BatteryStats.dumpLine(pw, uid, category, CPU_TIMES_AT_FREQ_DATA, Uid.UID_PROCESS_TYPES[procState], timesInFreqMs.length, sb.toString());
                }
            }
            ArrayMap<String, ? extends Uid.Proc> processStats = u.getProcessStats();
            for (int ipr = processStats.size() - 1; ipr >= 0; --ipr) {
                Uid.Proc ps = processStats.valueAt(ipr);
                long userMillis = ps.getUserTime(which);
                long systemMillis = ps.getSystemTime(which);
                long foregroundMillis = ps.getForegroundTime(which);
                int starts = ps.getStarts(which);
                int numCrashes = ps.getNumCrashes(which);
                int numAnrs = ps.getNumAnrs(which);
                if (userMillis == 0L && systemMillis == 0L && foregroundMillis == 0L && starts == 0 && numAnrs == 0 && numCrashes == 0) continue;
                BatteryStats.dumpLine(pw, uid, category, PROCESS_DATA, "\"" + processStats.keyAt(ipr) + "\"", userMillis, systemMillis, foregroundMillis, starts, numAnrs, numCrashes);
            }
            ArrayMap<String, ? extends Uid.Pkg> packageStats = u.getPackageStats();
            for (int ipkg = packageStats.size() - 1; ipkg >= 0; --ipkg) {
                Uid.Pkg ps = packageStats.valueAt(ipkg);
                int wakeups = 0;
                ArrayMap<String, ? extends Counter> alarms = ps.getWakeupAlarmStats();
                for (int iwa = alarms.size() - 1; iwa >= 0; --iwa) {
                    int count = alarms.valueAt(iwa).getCountLocked(which);
                    wakeups += count;
                    String name = alarms.keyAt(iwa).replace(',', '_');
                    BatteryStats.dumpLine(pw, uid, category, WAKEUP_ALARM_DATA, name, count);
                }
                ArrayMap<String, ? extends Uid.Pkg.Serv> serviceStats = ps.getServiceStats();
                for (int isvc = serviceStats.size() - 1; isvc >= 0; --isvc) {
                    Uid.Pkg.Serv ss = serviceStats.valueAt(isvc);
                    long startTime = ss.getStartTime(batteryUptime, which);
                    int starts = ss.getStarts(which);
                    int launches = ss.getLaunches(which);
                    if (startTime == 0L && starts == 0 && launches == 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, APK_DATA, wakeups, packageStats.keyAt(ipkg), serviceStats.keyAt(isvc), startTime / 1000L, starts, launches);
                }
            }
        }
    }

    private void printmAh(PrintWriter printer, double power) {
        printer.print(BatteryStats.formatCharge(power));
    }

    private void printmAh(StringBuilder sb, double power) {
        sb.append(BatteryStats.formatCharge(power));
    }

    /*
     * WARNING - void declaration
     */
    public void dumpLocked(Context context, PrintWriter pw, String prefix, int which, int reqUid, boolean wifiOnly, BatteryStatsDumpHelper dumpHelper) {
        void var124_118;
        CpuScalingPolicies scalingPolicies;
        Map<String, ? extends Timer> rpmStats;
        LongSparseArray<? extends Timer> mMemoryStats;
        int i;
        long time;
        int numDisplays;
        int connChanges;
        long dischargeDeepDozeCount;
        long dischargeLightDozeCount;
        long dischargeScreenOnCount;
        long dischargeScreenDozeCount;
        long dischargeScreenOffCount;
        long dischargeCount;
        int maxLearnedBatteryCapacity;
        int minLearnedBatteryCapacity;
        int lastLearnedBatteryCapacity;
        if (which != 0) {
            pw.println("ERROR: BatteryStats.dump called for which type " + which + " but only STATS_SINCE_CHARGED is supported");
            return;
        }
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        long rawRealtimeMs = (rawRealtime + 500L) / 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        long whichBatteryScreenOffUptime = this.computeBatteryScreenOffUptime(rawUptime, which);
        long whichBatteryScreenOffRealtime = this.computeBatteryScreenOffRealtime(rawRealtime, which);
        long batteryTimeRemaining = this.computeBatteryTimeRemaining(rawRealtime);
        long chargeTimeRemaining = this.computeChargeTimeRemaining(rawRealtime);
        long screenDozeTime = this.getScreenDozeTime(rawRealtime, which);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        int estimatedBatteryCapacity = this.getEstimatedBatteryCapacity();
        if (estimatedBatteryCapacity > 0) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Estimated battery capacity: ");
            sb.append(BatteryStats.formatCharge(estimatedBatteryCapacity));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((lastLearnedBatteryCapacity = this.getLearnedBatteryCapacity()) > 0) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Last learned battery capacity: ");
            sb.append(BatteryStats.formatCharge(lastLearnedBatteryCapacity / 1000));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((minLearnedBatteryCapacity = this.getMinLearnedBatteryCapacity()) > 0) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Min learned battery capacity: ");
            sb.append(BatteryStats.formatCharge(minLearnedBatteryCapacity / 1000));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((maxLearnedBatteryCapacity = this.getMaxLearnedBatteryCapacity()) > 0) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Max learned battery capacity: ");
            sb.append(BatteryStats.formatCharge(maxLearnedBatteryCapacity / 1000));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Time on battery: ");
        BatteryStats.formatTimeMs(sb, whichBatteryRealtime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryRealtime, totalRealtime));
        sb.append(") realtime, ");
        BatteryStats.formatTimeMs(sb, whichBatteryUptime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryUptime, whichBatteryRealtime));
        sb.append(") uptime");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Time on battery screen off: ");
        BatteryStats.formatTimeMs(sb, whichBatteryScreenOffRealtime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryScreenOffRealtime, whichBatteryRealtime));
        sb.append(") realtime, ");
        BatteryStats.formatTimeMs(sb, whichBatteryScreenOffUptime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryScreenOffUptime, whichBatteryRealtime));
        sb.append(") uptime");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Time on battery screen doze: ");
        BatteryStats.formatTimeMs(sb, screenDozeTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(screenDozeTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Total run time: ");
        BatteryStats.formatTimeMs(sb, totalRealtime / 1000L);
        sb.append("realtime, ");
        BatteryStats.formatTimeMs(sb, totalUptime / 1000L);
        sb.append("uptime");
        pw.println(sb.toString());
        if (batteryTimeRemaining >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Battery time remaining: ");
            BatteryStats.formatTimeMs(sb, batteryTimeRemaining / 1000L);
            pw.println(sb.toString());
        }
        if (chargeTimeRemaining >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Charge time remaining: ");
            BatteryStats.formatTimeMs(sb, chargeTimeRemaining / 1000L);
            pw.println(sb.toString());
        }
        if ((dischargeCount = this.getUahDischarge(which)) >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Discharge: ");
            sb.append(BatteryStats.formatCharge((double)dischargeCount / 1000.0));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((dischargeScreenOffCount = this.getUahDischargeScreenOff(which)) >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Screen off discharge: ");
            sb.append(BatteryStats.formatCharge((double)dischargeScreenOffCount / 1000.0));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((dischargeScreenDozeCount = this.getUahDischargeScreenDoze(which)) >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Screen doze discharge: ");
            sb.append(BatteryStats.formatCharge((double)dischargeScreenDozeCount / 1000.0));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((dischargeScreenOnCount = dischargeCount - dischargeScreenOffCount) >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Screen on discharge: ");
            sb.append(BatteryStats.formatCharge((double)dischargeScreenOnCount / 1000.0));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((dischargeLightDozeCount = this.getUahDischargeLightDoze(which)) >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Device light doze discharge: ");
            sb.append(BatteryStats.formatCharge((double)dischargeLightDozeCount / 1000.0));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        if ((dischargeDeepDozeCount = this.getUahDischargeDeepDoze(which)) >= 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Device deep doze discharge: ");
            sb.append(BatteryStats.formatCharge((double)dischargeDeepDozeCount / 1000.0));
            sb.append(" mAh");
            pw.println(sb.toString());
        }
        pw.print("  Start clock time: ");
        pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.getStartClockTime()).toString());
        long screenOnTime = this.getScreenOnTime(rawRealtime, which);
        long interactiveTime = this.getInteractiveTime(rawRealtime, which);
        long powerSaveModeEnabledTime = this.getPowerSaveModeEnabledTime(rawRealtime, which);
        long deviceIdleModeLightTime = this.getDeviceIdleModeTime(1, rawRealtime, which);
        long deviceIdleModeFullTime = this.getDeviceIdleModeTime(2, rawRealtime, which);
        long deviceLightIdlingTime = this.getDeviceIdlingTime(1, rawRealtime, which);
        long deviceIdlingTime = this.getDeviceIdlingTime(2, rawRealtime, which);
        long phoneOnTime = this.getPhoneOnTime(rawRealtime, which);
        long wifiRunningTime = this.getGlobalWifiRunningTime(rawRealtime, which);
        long wifiOnTime = this.getWifiOnTime(rawRealtime, which);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Screen on: ");
        BatteryStats.formatTimeMs(sb, screenOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(screenOnTime, whichBatteryRealtime));
        sb.append(") ");
        sb.append(this.getScreenOnCount(which));
        sb.append("x, Interactive: ");
        BatteryStats.formatTimeMs(sb, interactiveTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(interactiveTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Screen brightnesses:");
        boolean didOne = false;
        for (int i3 = 0; i3 < 5; ++i3) {
            long time2 = this.getScreenBrightnessTime(i3, rawRealtime, which);
            if (time2 == 0L) continue;
            sb.append("\n    ");
            sb.append(prefix);
            didOne = true;
            sb.append(SCREEN_BRIGHTNESS_NAMES[i3]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time2 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time2, screenOnTime));
            sb.append(")");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        if (powerSaveModeEnabledTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Power save mode enabled: ");
            BatteryStats.formatTimeMs(sb, powerSaveModeEnabledTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(powerSaveModeEnabledTime, whichBatteryRealtime));
            sb.append(")");
            pw.println(sb.toString());
        }
        if (deviceLightIdlingTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Device light idling: ");
            BatteryStats.formatTimeMs(sb, deviceLightIdlingTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(deviceLightIdlingTime, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getDeviceIdlingCount(1, which));
            sb.append("x");
            pw.println(sb.toString());
        }
        if (deviceIdleModeLightTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Idle mode light time: ");
            BatteryStats.formatTimeMs(sb, deviceIdleModeLightTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(deviceIdleModeLightTime, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getDeviceIdleModeCount(1, which));
            sb.append("x");
            sb.append(" -- longest ");
            BatteryStats.formatTimeMs(sb, this.getLongestDeviceIdleModeTime(1));
            pw.println(sb.toString());
        }
        if (deviceIdlingTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Device full idling: ");
            BatteryStats.formatTimeMs(sb, deviceIdlingTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(deviceIdlingTime, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getDeviceIdlingCount(2, which));
            sb.append("x");
            pw.println(sb.toString());
        }
        if (deviceIdleModeFullTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Idle mode full time: ");
            BatteryStats.formatTimeMs(sb, deviceIdleModeFullTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(deviceIdleModeFullTime, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getDeviceIdleModeCount(2, which));
            sb.append("x");
            sb.append(" -- longest ");
            BatteryStats.formatTimeMs(sb, this.getLongestDeviceIdleModeTime(2));
            pw.println(sb.toString());
        }
        if (phoneOnTime != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Active phone call: ");
            BatteryStats.formatTimeMs(sb, phoneOnTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(phoneOnTime, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneOnCount(which));
            sb.append("x");
        }
        if ((connChanges = this.getNumConnectivityChange(which)) != 0) {
            pw.print(prefix);
            pw.print("  Connectivity changes: ");
            pw.println(connChanges);
        }
        long fullWakeLockTimeTotalMicros = 0L;
        long partialWakeLockTimeTotalMicros = 0L;
        ArrayList<TimerEntry> timers = new ArrayList<TimerEntry>();
        for (int iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            ArrayMap<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            for (int iw = wakelocks.size() - 1; iw >= 0; --iw) {
                long totalTimeMicros;
                Timer partialWakeTimer;
                Uid.Wakelock wl = wakelocks.valueAt(iw);
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotalMicros += fullWakeTimer.getTotalTimeLocked(rawRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null || (totalTimeMicros = partialWakeTimer.getTotalTimeLocked(rawRealtime, which)) <= 0L) continue;
                if (reqUid < 0) {
                    timers.add(new TimerEntry(wakelocks.keyAt(iw), u.getUid(), partialWakeTimer, totalTimeMicros));
                }
                partialWakeLockTimeTotalMicros += totalTimeMicros;
            }
        }
        long mobileRxTotalBytes = this.getNetworkActivityBytes(0, which);
        long mobileTxTotalBytes = this.getNetworkActivityBytes(1, which);
        long wifiRxTotalBytes = this.getNetworkActivityBytes(2, which);
        long wifiTxTotalBytes = this.getNetworkActivityBytes(3, which);
        long mobileRxTotalPackets = this.getNetworkActivityPackets(0, which);
        long mobileTxTotalPackets = this.getNetworkActivityPackets(1, which);
        long wifiRxTotalPackets = this.getNetworkActivityPackets(2, which);
        long wifiTxTotalPackets = this.getNetworkActivityPackets(3, which);
        long btRxTotalBytes = this.getNetworkActivityBytes(4, which);
        long btTxTotalBytes = this.getNetworkActivityBytes(5, which);
        if (fullWakeLockTimeTotalMicros != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Total full wakelock time: ");
            BatteryStats.formatTimeMsNoSpace(sb, (fullWakeLockTimeTotalMicros + 500L) / 1000L);
            pw.println(sb.toString());
        }
        if (partialWakeLockTimeTotalMicros != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Total partial wakelock time: ");
            BatteryStats.formatTimeMsNoSpace(sb, (partialWakeLockTimeTotalMicros + 500L) / 1000L);
            pw.println(sb.toString());
        }
        long multicastWakeLockTimeTotalMicros = this.getWifiMulticastWakelockTime(rawRealtime, which);
        int multicastWakeLockCountTotal = this.getWifiMulticastWakelockCount(which);
        if (multicastWakeLockTimeTotalMicros != 0L) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Total WiFi Multicast wakelock Count: ");
            sb.append(multicastWakeLockCountTotal);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  Total WiFi Multicast wakelock time: ");
            BatteryStats.formatTimeMsNoSpace(sb, (multicastWakeLockTimeTotalMicros + 500L) / 1000L);
            pw.println(sb.toString());
        }
        if ((numDisplays = this.getDisplayCount()) > 1) {
            pw.println("");
            pw.print(prefix);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  MULTI-DISPLAY POWER SUMMARY START");
            pw.println(sb.toString());
            for (int display = 0; display < numDisplays; ++display) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("  Display ");
                sb.append(display);
                sb.append(" Statistics:");
                pw.println(sb.toString());
                long displayScreenOnTime = this.getDisplayScreenOnTime(display, rawRealtime);
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Screen on: ");
                BatteryStats.formatTimeMs(sb, displayScreenOnTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(displayScreenOnTime, whichBatteryRealtime));
                sb.append(") ");
                pw.println(sb.toString());
                sb.setLength(0);
                sb.append("    Screen brightness levels:");
                didOne = false;
                for (int bin = 0; bin < 5; ++bin) {
                    long timeUs = this.getDisplayScreenBrightnessTime(display, bin, rawRealtime);
                    if (timeUs == 0L) continue;
                    didOne = true;
                    sb.append("\n      ");
                    sb.append(prefix);
                    sb.append(SCREEN_BRIGHTNESS_NAMES[bin]);
                    sb.append(" ");
                    BatteryStats.formatTimeMs(sb, timeUs / 1000L);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(timeUs, displayScreenOnTime));
                    sb.append(")");
                }
                if (!didOne) {
                    sb.append(" (no activity)");
                }
                pw.println(sb.toString());
                long displayScreenDozeTimeUs = this.getDisplayScreenDozeTime(display, rawRealtime);
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Screen Doze: ");
                BatteryStats.formatTimeMs(sb, displayScreenDozeTimeUs / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(displayScreenDozeTimeUs, whichBatteryRealtime));
                sb.append(") ");
                pw.println(sb.toString());
            }
            pw.print(prefix);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("  MULTI-DISPLAY POWER SUMMARY END");
            pw.println(sb.toString());
        }
        pw.println("");
        pw.print(prefix);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  CONNECTIVITY POWER SUMMARY START");
        pw.println(sb.toString());
        pw.print(prefix);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Logging duration for connectivity statistics: ");
        BatteryStats.formatTimeMs(sb, whichBatteryRealtime / 1000L);
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Cellular Statistics:");
        pw.println(sb.toString());
        pw.print(prefix);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     Cellular kernel active time: ");
        long mobileActiveTime = this.getMobileRadioActiveTime(rawRealtime, which);
        BatteryStats.formatTimeMs(sb, mobileActiveTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(mobileActiveTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        this.printControllerActivity(pw, sb, prefix, CELLULAR_CONTROLLER_NAME, this.getModemControllerActivity(), which);
        this.printCellularPerRatBreakdown(pw, sb, prefix + "     ", rawRealtimeMs);
        pw.print("     Cellular data received: ");
        pw.println(this.formatBytesLocked(mobileRxTotalBytes));
        pw.print("     Cellular data sent: ");
        pw.println(this.formatBytesLocked(mobileTxTotalBytes));
        pw.print("     Cellular packets received: ");
        pw.println(mobileRxTotalPackets);
        pw.print("     Cellular packets sent: ");
        pw.println(mobileTxTotalPackets);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     Cellular Radio Access Technology:");
        didOne = false;
        for (int connType = 0; connType < NUM_DATA_CONNECTION_TYPES; ++connType) {
            long nrNsaTime;
            long time3 = this.getPhoneDataConnectionTime(connType, rawRealtime, which);
            if (time3 == 0L) continue;
            sb.append("\n       ");
            sb.append(prefix);
            didOne = true;
            sb.append(connType < DATA_CONNECTION_NAMES.length ? DATA_CONNECTION_NAMES[connType] : "ERROR");
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time3 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time3, whichBatteryRealtime));
            sb.append(") ");
            if (connType != 13 || (nrNsaTime = this.getNrNsaTime(rawRealtime)) == 0L) continue;
            sb.append("\n         ");
            sb.append(prefix);
            sb.append("nr_nsa");
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, nrNsaTime / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(nrNsaTime, whichBatteryRealtime));
            sb.append(") ");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     Cellular Rx signal strength (RSRP):");
        String[] cellularRxSignalStrengthDescription = new String[]{"very poor (less than -128dBm): ", "poor (-128dBm to -118dBm): ", "moderate (-118dBm to -108dBm): ", "good (-108dBm to -98dBm): ", "great (greater than -98dBm): "};
        didOne = false;
        int numCellularRxBins = Math.min(CellSignalStrength.getNumSignalStrengthLevels(), cellularRxSignalStrengthDescription.length);
        for (int i4 = 0; i4 < numCellularRxBins; ++i4) {
            long time4 = this.getPhoneSignalStrengthTime(i4, rawRealtime, which);
            if (time4 == 0L) continue;
            sb.append("\n       ");
            sb.append(prefix);
            didOne = true;
            sb.append(cellularRxSignalStrengthDescription[i4]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time4 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time4, whichBatteryRealtime));
            sb.append(") ");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        pw.print(prefix);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Wifi Statistics:");
        pw.println(sb.toString());
        pw.print(prefix);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     Wifi kernel active time: ");
        long wifiActiveTime = this.getWifiActiveTime(rawRealtime, which);
        BatteryStats.formatTimeMs(sb, wifiActiveTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(wifiActiveTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        this.printControllerActivity(pw, sb, prefix, WIFI_CONTROLLER_NAME, this.getWifiControllerActivity(), which);
        pw.print("     Wifi data received: ");
        pw.println(this.formatBytesLocked(wifiRxTotalBytes));
        pw.print("     Wifi data sent: ");
        pw.println(this.formatBytesLocked(wifiTxTotalBytes));
        pw.print("     Wifi packets received: ");
        pw.println(wifiRxTotalPackets);
        pw.print("     Wifi packets sent: ");
        pw.println(wifiTxTotalPackets);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     Wifi states:");
        didOne = false;
        for (int i2 = 0; i2 < 8; ++i2) {
            time = this.getWifiStateTime(i2, rawRealtime, which);
            if (time == 0L) continue;
            sb.append("\n       ");
            didOne = true;
            sb.append(WIFI_STATE_NAMES[i2]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     Wifi supplicant states:");
        didOne = false;
        for (int i2 = 0; i2 < 13; ++i2) {
            time = this.getWifiSupplStateTime(i2, rawRealtime, which);
            if (time == 0L) continue;
            sb.append("\n       ");
            didOne = true;
            sb.append(WIFI_SUPPL_STATE_NAMES[i2]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     Wifi Rx signal strength (RSSI):");
        String[] wifiRxSignalStrengthDescription = new String[]{"very poor (less than -88.75dBm): ", "poor (-88.75 to -77.5dBm): ", "moderate (-77.5dBm to -66.25dBm): ", "good (-66.25dBm to -55dBm): ", "great (greater than -55dBm): "};
        didOne = false;
        int numWifiRxBins = Math.min(5, wifiRxSignalStrengthDescription.length);
        for (int i5 = 0; i5 < numWifiRxBins; ++i5) {
            long time5 = this.getWifiSignalStrengthTime(i5, rawRealtime, which);
            if (time5 == 0L) continue;
            sb.append("\n    ");
            sb.append(prefix);
            didOne = true;
            sb.append("     ");
            sb.append(wifiRxSignalStrengthDescription[i5]);
            BatteryStats.formatTimeMs(sb, time5 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time5, whichBatteryRealtime));
            sb.append(") ");
        }
        if (!didOne) {
            sb.append(" (no activity)");
        }
        pw.println(sb.toString());
        pw.print(prefix);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  GPS Statistics:");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("     GPS signal quality (Top 4 Average CN0):");
        String[] gpsSignalQualityDescription = new String[]{"poor (less than 20 dBHz): ", "good (greater than 20 dBHz): "};
        int numGpsSignalQualityBins = Math.min(2, gpsSignalQualityDescription.length);
        for (int i6 = 0; i6 < numGpsSignalQualityBins; ++i6) {
            long time6 = this.getGpsSignalQualityTime(i6, rawRealtime, which);
            sb.append("\n    ");
            sb.append(prefix);
            sb.append("  ");
            sb.append(gpsSignalQualityDescription[i6]);
            BatteryStats.formatTimeMs(sb, time6 / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time6, whichBatteryRealtime));
            sb.append(") ");
        }
        pw.println(sb.toString());
        long gpsBatteryDrainMaMs = this.getGpsBatteryDrainMaMs();
        if (gpsBatteryDrainMaMs > 0L) {
            pw.print(prefix);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("     GPS Battery Drain: ");
            sb.append(new DecimalFormat("#.##").format((double)gpsBatteryDrainMaMs / 3600000.0));
            sb.append("mAh");
            pw.println(sb.toString());
        }
        pw.print(prefix);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  CONNECTIVITY POWER SUMMARY END");
        pw.println(sb.toString());
        pw.println("");
        pw.print(prefix);
        pw.print("  Bluetooth total received: ");
        pw.print(this.formatBytesLocked(btRxTotalBytes));
        pw.print(", sent: ");
        pw.println(this.formatBytesLocked(btTxTotalBytes));
        long bluetoothScanTimeMs = this.getBluetoothScanTime(rawRealtime, which) / 1000L;
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Bluetooth scan time: ");
        BatteryStats.formatTimeMs(sb, bluetoothScanTimeMs);
        pw.println(sb.toString());
        this.printControllerActivity(pw, sb, prefix, "Bluetooth", this.getBluetoothControllerActivity(), which);
        pw.println();
        pw.print(prefix);
        pw.println("  Device battery use since last full charge");
        pw.print(prefix);
        pw.print("    Amount discharged (lower bound): ");
        pw.println(this.getLowDischargeAmountSinceCharge());
        pw.print(prefix);
        pw.print("    Amount discharged (upper bound): ");
        pw.println(this.getHighDischargeAmountSinceCharge());
        pw.print(prefix);
        pw.print("    Amount discharged while screen on: ");
        pw.println(this.getDischargeAmountScreenOnSinceCharge());
        pw.print(prefix);
        pw.print("    Amount discharged while screen off: ");
        pw.println(this.getDischargeAmountScreenOffSinceCharge());
        pw.print(prefix);
        pw.print("    Amount discharged while screen doze: ");
        pw.println(this.getDischargeAmountScreenDozeSinceCharge());
        pw.println();
        BatteryUsageStats stats = dumpHelper.getBatteryUsageStats(this, true);
        stats.dump(pw, prefix);
        List<UidMobileRadioStats> uidMobileRadioStats = this.getUidMobileRadioStats(stats.getUidBatteryConsumers());
        if (uidMobileRadioStats.size() > 0) {
            pw.print(prefix);
            pw.println("  Per-app mobile ms per packet:");
            long totalTime = 0L;
            for (i = 0; i < uidMobileRadioStats.size(); ++i) {
                UidMobileRadioStats mrs = uidMobileRadioStats.get(i);
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Uid ");
                UserHandle.formatUid(sb, mrs.uid);
                sb.append(": ");
                sb.append(BatteryStats.formatValue(mrs.millisecondsPerPacket));
                sb.append(" (");
                sb.append(mrs.rxPackets + mrs.txPackets);
                sb.append(" packets over ");
                BatteryStats.formatTimeMsNoSpace(sb, mrs.radioActiveMs);
                sb.append(") ");
                sb.append(mrs.radioActiveCount);
                sb.append("x");
                pw.println(sb);
                totalTime += mrs.radioActiveMs;
            }
            sb.setLength(0);
            sb.append(prefix);
            sb.append("    TOTAL TIME: ");
            BatteryStats.formatTimeMs(sb, totalTime);
            sb.append("(");
            sb.append(this.formatRatioLocked(totalTime, whichBatteryRealtime));
            sb.append(")");
            pw.println(sb);
            pw.println();
        }
        Comparator<TimerEntry> timerComparator = new Comparator<TimerEntry>(this){

            @Override
            public int compare(TimerEntry lhs, TimerEntry rhs) {
                long lhsTime = lhs.mTime;
                long rhsTime = rhs.mTime;
                if (lhsTime < rhsTime) {
                    return 1;
                }
                if (lhsTime > rhsTime) {
                    return -1;
                }
                return 0;
            }
        };
        if (reqUid < 0) {
            Map<String, ? extends Timer> wakeupReasons;
            Object timer;
            Map<String, ? extends Timer> kernelWakelocks = this.getKernelWakelockStats();
            if (kernelWakelocks.size() > 0) {
                ArrayList<TimerEntry> ktimers = new ArrayList<TimerEntry>();
                for (Map.Entry entry : kernelWakelocks.entrySet()) {
                    timer = (Timer)entry.getValue();
                    long totalTimeMillis = BatteryStats.computeWakeLock((Timer)timer, rawRealtime, which);
                    if (totalTimeMillis <= 0L) continue;
                    ktimers.add(new TimerEntry((String)entry.getKey(), 0, (Timer)timer, totalTimeMillis));
                }
                if (ktimers.size() > 0) {
                    Collections.sort(ktimers, timerComparator);
                    pw.print(prefix);
                    pw.println("  All kernel wake locks:");
                    for (int i7 = 0; i7 < ktimers.size(); ++i7) {
                        TimerEntry timerEntry = (TimerEntry)ktimers.get(i7);
                        String linePrefix = ": ";
                        sb.setLength(0);
                        sb.append(prefix);
                        sb.append("  Kernel Wake lock ");
                        sb.append(timerEntry.mName);
                        linePrefix = BatteryStats.printWakeLock(sb, timerEntry.mTimer, rawRealtime, null, which, linePrefix);
                        if (linePrefix.equals(": ")) continue;
                        sb.append(" realtime");
                        pw.println(sb.toString());
                    }
                    pw.println();
                }
            }
            if (timers.size() > 0) {
                Collections.sort(timers, timerComparator);
                pw.print(prefix);
                pw.println("  All partial wake locks:");
                for (i = 0; i < timers.size(); ++i) {
                    TimerEntry timer3 = (TimerEntry)timers.get(i);
                    sb.setLength(0);
                    sb.append("  Wake lock ");
                    UserHandle.formatUid(sb, timer3.mId);
                    sb.append(" ");
                    sb.append(timer3.mName);
                    BatteryStats.printWakeLock(sb, timer3.mTimer, rawRealtime, null, which, ": ");
                    sb.append(" realtime");
                    pw.println(sb.toString());
                }
                timers.clear();
                pw.println();
            }
            if ((wakeupReasons = this.getWakeupReasonStats()).size() > 0) {
                void var124_114;
                pw.print(prefix);
                pw.println("  All wakeup reasons:");
                ArrayList<TimerEntry> reasons = new ArrayList<TimerEntry>();
                for (Map.Entry<String, ? extends Timer> ent : wakeupReasons.entrySet()) {
                    Timer timer4 = ent.getValue();
                    reasons.add(new TimerEntry(ent.getKey(), 0, timer4, timer4.getCountLocked(which)));
                }
                Collections.sort(reasons, timerComparator);
                boolean bl = false;
                while (var124_114 < reasons.size()) {
                    timer = (TimerEntry)reasons.get((int)var124_114);
                    String linePrefix = ": ";
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("  Wakeup reason ");
                    sb.append(((TimerEntry)timer).mName);
                    BatteryStats.printWakeLock(sb, ((TimerEntry)timer).mTimer, rawRealtime, null, which, ": ");
                    sb.append(" realtime");
                    pw.println(sb.toString());
                    ++var124_114;
                }
                pw.println();
            }
        }
        if ((mMemoryStats = this.getKernelMemoryStats()).size() > 0) {
            pw.println("  Memory Stats");
            for (i = 0; i < mMemoryStats.size(); ++i) {
                sb.setLength(0);
                sb.append("  Bandwidth ");
                sb.append(mMemoryStats.keyAt(i));
                sb.append(" Time ");
                sb.append(mMemoryStats.valueAt(i).getTotalTimeLocked(rawRealtime, which));
                pw.println(sb.toString());
            }
            pw.println();
        }
        if ((rpmStats = this.getRpmStats()).size() > 0) {
            pw.print(prefix);
            pw.println("  Resource Power Manager Stats");
            if (rpmStats.size() > 0) {
                for (Map.Entry<String, ? extends Timer> entry : rpmStats.entrySet()) {
                    String timerName = entry.getKey();
                    Timer timer = entry.getValue();
                    BatteryStats.printTimer(pw, sb, timer, rawRealtime, which, prefix, timerName);
                }
            }
            pw.println();
        }
        if ((scalingPolicies = this.getCpuScalingPolicies()) != null) {
            sb.setLength(0);
            sb.append("  CPU scaling: ");
            for (int policy : scalingPolicies.getPolicies()) {
                sb.append(" policy").append(policy).append(':');
                for (int frequency : scalingPolicies.getFrequencies(policy)) {
                    sb.append(' ').append(frequency);
                }
            }
            pw.println(sb);
            pw.println();
        }
        boolean bl = false;
        while (var124_118 < NU) {
            int uid = uidStats.keyAt((int)var124_118);
            if (reqUid < 0 || uid == reqUid || uid == 1000) {
                long[] screenOffCpuFreqTimes;
                long[] cpuFreqTimes;
                Timer mcTimer;
                long totalTimeMs;
                Timer bleTimer;
                Uid u = uidStats.valueAt((int)var124_118);
                pw.print(prefix);
                pw.print("  ");
                UserHandle.formatUid(pw, uid);
                pw.println(":");
                boolean uidActivity = false;
                long mobileRxBytes = u.getNetworkActivityBytes(0, which);
                long mobileTxBytes = u.getNetworkActivityBytes(1, which);
                long wifiRxBytes = u.getNetworkActivityBytes(2, which);
                long wifiTxBytes = u.getNetworkActivityBytes(3, which);
                long btRxBytes = u.getNetworkActivityBytes(4, which);
                long btTxBytes = u.getNetworkActivityBytes(5, which);
                long mobileRxPackets = u.getNetworkActivityPackets(0, which);
                long mobileTxPackets = u.getNetworkActivityPackets(1, which);
                long wifiRxPackets = u.getNetworkActivityPackets(2, which);
                long wifiTxPackets = u.getNetworkActivityPackets(3, which);
                long uidMobileActiveTime = u.getMobileRadioActiveTime(which);
                int uidMobileActiveCount = u.getMobileRadioActiveCount(which);
                long fullWifiLockOnTime = u.getFullWifiLockTime(rawRealtime, which);
                long wifiScanTime = u.getWifiScanTime(rawRealtime, which);
                int wifiScanCount = u.getWifiScanCount(which);
                int wifiScanCountBg = u.getWifiScanBackgroundCount(which);
                long wifiScanActualTime = u.getWifiScanActualTime(rawRealtime);
                long wifiScanActualTimeBg = u.getWifiScanBackgroundTime(rawRealtime);
                long uidWifiRunningTime = u.getWifiRunningTime(rawRealtime, which);
                long mobileWakeup = u.getMobileRadioApWakeupCount(which);
                long wifiWakeup = u.getWifiRadioApWakeupCount(which);
                if (mobileRxBytes > 0L || mobileTxBytes > 0L || mobileRxPackets > 0L || mobileTxPackets > 0L) {
                    pw.print(prefix);
                    pw.print("    Mobile network: ");
                    pw.print(this.formatBytesLocked(mobileRxBytes));
                    pw.print(" received, ");
                    pw.print(this.formatBytesLocked(mobileTxBytes));
                    pw.print(" sent (packets ");
                    pw.print(mobileRxPackets);
                    pw.print(" received, ");
                    pw.print(mobileTxPackets);
                    pw.println(" sent)");
                }
                if (uidMobileActiveTime > 0L || uidMobileActiveCount > 0) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Mobile radio active: ");
                    BatteryStats.formatTimeMs(sb, uidMobileActiveTime / 1000L);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(uidMobileActiveTime, mobileActiveTime));
                    sb.append(") ");
                    sb.append(uidMobileActiveCount);
                    sb.append("x");
                    long packets = mobileRxPackets + mobileTxPackets;
                    if (packets == 0L) {
                        packets = 1L;
                    }
                    sb.append(" @ ");
                    sb.append(BatteryStats.formatCharge((double)(uidMobileActiveTime / 1000L) / (double)packets));
                    sb.append(" mspp");
                    pw.println(sb.toString());
                }
                if (mobileWakeup > 0L) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Mobile radio AP wakeups: ");
                    sb.append(mobileWakeup);
                    pw.println(sb.toString());
                }
                this.printControllerActivityIfInteresting(pw, sb, prefix + "  ", CELLULAR_CONTROLLER_NAME, u.getModemControllerActivity(), which);
                if (wifiRxBytes > 0L || wifiTxBytes > 0L || wifiRxPackets > 0L || wifiTxPackets > 0L) {
                    pw.print(prefix);
                    pw.print("    Wi-Fi network: ");
                    pw.print(this.formatBytesLocked(wifiRxBytes));
                    pw.print(" received, ");
                    pw.print(this.formatBytesLocked(wifiTxBytes));
                    pw.print(" sent (packets ");
                    pw.print(wifiRxPackets);
                    pw.print(" received, ");
                    pw.print(wifiTxPackets);
                    pw.println(" sent)");
                }
                if (fullWifiLockOnTime != 0L || wifiScanTime != 0L || wifiScanCount != 0 || wifiScanCountBg != 0 || wifiScanActualTime != 0L || wifiScanActualTimeBg != 0L || uidWifiRunningTime != 0L) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Wifi Running: ");
                    BatteryStats.formatTimeMs(sb, uidWifiRunningTime / 1000L);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(uidWifiRunningTime, whichBatteryRealtime));
                    sb.append(")\n");
                    sb.append(prefix);
                    sb.append("    Full Wifi Lock: ");
                    BatteryStats.formatTimeMs(sb, fullWifiLockOnTime / 1000L);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(fullWifiLockOnTime, whichBatteryRealtime));
                    sb.append(")\n");
                    sb.append(prefix);
                    sb.append("    Wifi Scan (blamed): ");
                    BatteryStats.formatTimeMs(sb, wifiScanTime / 1000L);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(wifiScanTime, whichBatteryRealtime));
                    sb.append(") ");
                    sb.append(wifiScanCount);
                    sb.append("x\n");
                    sb.append(prefix);
                    sb.append("    Wifi Scan (actual): ");
                    BatteryStats.formatTimeMs(sb, wifiScanActualTime / 1000L);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(wifiScanActualTime, this.computeBatteryRealtime(rawRealtime, 0)));
                    sb.append(") ");
                    sb.append(wifiScanCount);
                    sb.append("x\n");
                    sb.append(prefix);
                    sb.append("    Background Wifi Scan: ");
                    BatteryStats.formatTimeMs(sb, wifiScanActualTimeBg / 1000L);
                    sb.append("(");
                    sb.append(this.formatRatioLocked(wifiScanActualTimeBg, this.computeBatteryRealtime(rawRealtime, 0)));
                    sb.append(") ");
                    sb.append(wifiScanCountBg);
                    sb.append("x");
                    pw.println(sb.toString());
                }
                if (wifiWakeup > 0L) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    WiFi AP wakeups: ");
                    sb.append(wifiWakeup);
                    pw.println(sb.toString());
                }
                this.printControllerActivityIfInteresting(pw, sb, prefix + "  ", WIFI_CONTROLLER_NAME, u.getWifiControllerActivity(), which);
                if (btRxBytes > 0L || btTxBytes > 0L) {
                    pw.print(prefix);
                    pw.print("    Bluetooth network: ");
                    pw.print(this.formatBytesLocked(btRxBytes));
                    pw.print(" received, ");
                    pw.print(this.formatBytesLocked(btTxBytes));
                    pw.println(" sent");
                }
                if ((bleTimer = u.getBluetoothScanTimer()) != null && (totalTimeMs = (bleTimer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L) != 0L) {
                    int count = bleTimer.getCountLocked(which);
                    Timer bleTimerBg = u.getBluetoothScanBackgroundTimer();
                    int countBg = bleTimerBg != null ? bleTimerBg.getCountLocked(which) : 0;
                    long actualTimeMs = bleTimer.getTotalDurationMsLocked(rawRealtimeMs);
                    long actualTimeMsBg = bleTimerBg != null ? bleTimerBg.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                    int resultCount = u.getBluetoothScanResultCounter() != null ? u.getBluetoothScanResultCounter().getCountLocked(which) : 0;
                    int resultCountBg = u.getBluetoothScanResultBgCounter() != null ? u.getBluetoothScanResultBgCounter().getCountLocked(which) : 0;
                    Timer unoptimizedScanTimer = u.getBluetoothUnoptimizedScanTimer();
                    long unoptimizedScanTotalTime = unoptimizedScanTimer != null ? unoptimizedScanTimer.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                    long unoptimizedScanMaxTime = unoptimizedScanTimer != null ? unoptimizedScanTimer.getMaxDurationMsLocked(rawRealtimeMs) : 0L;
                    Timer unoptimizedScanTimerBg = u.getBluetoothUnoptimizedScanBackgroundTimer();
                    long unoptimizedScanTotalTimeBg = unoptimizedScanTimerBg != null ? unoptimizedScanTimerBg.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                    long unoptimizedScanMaxTimeBg = unoptimizedScanTimerBg != null ? unoptimizedScanTimerBg.getMaxDurationMsLocked(rawRealtimeMs) : 0L;
                    sb.setLength(0);
                    if (actualTimeMs != totalTimeMs) {
                        sb.append(prefix);
                        sb.append("    Bluetooth Scan (total blamed realtime): ");
                        BatteryStats.formatTimeMs(sb, totalTimeMs);
                        sb.append(" (");
                        sb.append(count);
                        sb.append(" times)");
                        if (bleTimer.isRunningLocked()) {
                            sb.append(" (currently running)");
                        }
                        sb.append("\n");
                    }
                    sb.append(prefix);
                    sb.append("    Bluetooth Scan (total actual realtime): ");
                    BatteryStats.formatTimeMs(sb, actualTimeMs);
                    sb.append(" (");
                    sb.append(count);
                    sb.append(" times)");
                    if (bleTimer.isRunningLocked()) {
                        sb.append(" (currently running)");
                    }
                    sb.append("\n");
                    if (actualTimeMsBg > 0L || countBg > 0) {
                        sb.append(prefix);
                        sb.append("    Bluetooth Scan (background realtime): ");
                        BatteryStats.formatTimeMs(sb, actualTimeMsBg);
                        sb.append(" (");
                        sb.append(countBg);
                        sb.append(" times)");
                        if (bleTimerBg != null && bleTimerBg.isRunningLocked()) {
                            sb.append(" (currently running in background)");
                        }
                        sb.append("\n");
                    }
                    sb.append(prefix);
                    sb.append("    Bluetooth Scan Results: ");
                    sb.append(resultCount);
                    sb.append(" (");
                    sb.append(resultCountBg);
                    sb.append(" in background)");
                    if (unoptimizedScanTotalTime > 0L || unoptimizedScanTotalTimeBg > 0L) {
                        sb.append("\n");
                        sb.append(prefix);
                        sb.append("    Unoptimized Bluetooth Scan (realtime): ");
                        BatteryStats.formatTimeMs(sb, unoptimizedScanTotalTime);
                        sb.append(" (max ");
                        BatteryStats.formatTimeMs(sb, unoptimizedScanMaxTime);
                        sb.append(")");
                        if (unoptimizedScanTimer != null && unoptimizedScanTimer.isRunningLocked()) {
                            sb.append(" (currently running unoptimized)");
                        }
                        if (unoptimizedScanTimerBg != null && unoptimizedScanTotalTimeBg > 0L) {
                            sb.append("\n");
                            sb.append(prefix);
                            sb.append("    Unoptimized Bluetooth Scan (background realtime): ");
                            BatteryStats.formatTimeMs(sb, unoptimizedScanTotalTimeBg);
                            sb.append(" (max ");
                            BatteryStats.formatTimeMs(sb, unoptimizedScanMaxTimeBg);
                            sb.append(")");
                            if (unoptimizedScanTimerBg.isRunningLocked()) {
                                sb.append(" (currently running unoptimized in background)");
                            }
                        }
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
                if (u.hasUserActivity()) {
                    boolean hasData = false;
                    for (int i9 = 0; i9 < Uid.NUM_USER_ACTIVITY_TYPES; ++i9) {
                        int val = u.getUserActivityCount(i9, which);
                        if (val == 0) continue;
                        if (!hasData) {
                            sb.setLength(0);
                            sb.append("    User activity: ");
                            hasData = true;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(val);
                        sb.append(" ");
                        sb.append(Uid.USER_ACTIVITY_TYPES[i9]);
                    }
                    if (hasData) {
                        pw.println(sb.toString());
                    }
                }
                ArrayMap<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
                long totalFullWakelock = 0L;
                long totalPartialWakelock = 0L;
                long totalWindowWakelock = 0L;
                long totalDrawWakelock = 0L;
                int countWakelock = 0;
                for (int iw = wakelocks.size() - 1; iw >= 0; --iw) {
                    Uid.Wakelock wl = wakelocks.valueAt(iw);
                    String linePrefix = ": ";
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Wake lock ");
                    sb.append(wakelocks.keyAt(iw));
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(1), rawRealtime, "full", which, linePrefix);
                    Timer pTimer = wl.getWakeTime(0);
                    linePrefix = BatteryStats.printWakeLock(sb, pTimer, rawRealtime, "partial", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, pTimer != null ? pTimer.getSubTimer() : null, rawRealtime, "background partial", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(2), rawRealtime, "window", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(18), rawRealtime, "draw", which, linePrefix);
                    sb.append(" realtime");
                    pw.println(sb.toString());
                    uidActivity = true;
                    ++countWakelock;
                    totalFullWakelock += BatteryStats.computeWakeLock(wl.getWakeTime(1), rawRealtime, which);
                    totalPartialWakelock += BatteryStats.computeWakeLock(wl.getWakeTime(0), rawRealtime, which);
                    totalWindowWakelock += BatteryStats.computeWakeLock(wl.getWakeTime(2), rawRealtime, which);
                    totalDrawWakelock += BatteryStats.computeWakeLock(wl.getWakeTime(18), rawRealtime, which);
                }
                if (countWakelock > 1) {
                    long actualTotalPartialWakelock = 0L;
                    long actualBgPartialWakelock = 0L;
                    if (u.getAggregatedPartialWakelockTimer() != null) {
                        Timer aggTimer = u.getAggregatedPartialWakelockTimer();
                        actualTotalPartialWakelock = aggTimer.getTotalDurationMsLocked(rawRealtimeMs);
                        Timer bgAggTimer = aggTimer.getSubTimer();
                        long l = actualBgPartialWakelock = bgAggTimer != null ? bgAggTimer.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                    }
                    if (actualTotalPartialWakelock != 0L || actualBgPartialWakelock != 0L || totalFullWakelock != 0L || totalPartialWakelock != 0L || totalWindowWakelock != 0L) {
                        sb.setLength(0);
                        sb.append(prefix);
                        sb.append("    TOTAL wake: ");
                        boolean needComma = false;
                        if (totalFullWakelock != 0L) {
                            needComma = true;
                            BatteryStats.formatTimeMs(sb, totalFullWakelock);
                            sb.append("full");
                        }
                        if (totalPartialWakelock != 0L) {
                            if (needComma) {
                                sb.append(", ");
                            }
                            needComma = true;
                            BatteryStats.formatTimeMs(sb, totalPartialWakelock);
                            sb.append("blamed partial");
                        }
                        if (actualTotalPartialWakelock != 0L) {
                            if (needComma) {
                                sb.append(", ");
                            }
                            needComma = true;
                            BatteryStats.formatTimeMs(sb, actualTotalPartialWakelock);
                            sb.append("actual partial");
                        }
                        if (actualBgPartialWakelock != 0L) {
                            if (needComma) {
                                sb.append(", ");
                            }
                            needComma = true;
                            BatteryStats.formatTimeMs(sb, actualBgPartialWakelock);
                            sb.append("actual background partial");
                        }
                        if (totalWindowWakelock != 0L) {
                            if (needComma) {
                                sb.append(", ");
                            }
                            needComma = true;
                            BatteryStats.formatTimeMs(sb, totalWindowWakelock);
                            sb.append("window");
                        }
                        if (totalDrawWakelock != 0L) {
                            if (needComma) {
                                sb.append(",");
                            }
                            needComma = true;
                            BatteryStats.formatTimeMs(sb, totalDrawWakelock);
                            sb.append("draw");
                        }
                        sb.append(" realtime");
                        pw.println(sb.toString());
                    }
                }
                if ((mcTimer = u.getMulticastWakelockStats()) != null) {
                    long multicastWakeLockTimeMicros = mcTimer.getTotalTimeLocked(rawRealtime, which);
                    int multicastWakeLockCount = mcTimer.getCountLocked(which);
                    if (multicastWakeLockTimeMicros > 0L) {
                        sb.setLength(0);
                        sb.append(prefix);
                        sb.append("    WiFi Multicast Wakelock");
                        sb.append(" count = ");
                        sb.append(multicastWakeLockCount);
                        sb.append(" time = ");
                        BatteryStats.formatTimeMsNoSpace(sb, (multicastWakeLockTimeMicros + 500L) / 1000L);
                        pw.println(sb.toString());
                    }
                }
                ArrayMap<String, ? extends Timer> syncs = u.getSyncStats();
                for (int isy = syncs.size() - 1; isy >= 0; --isy) {
                    Timer timer = syncs.valueAt(isy);
                    long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                    int count = timer.getCountLocked(which);
                    Timer bgTimer = timer.getSubTimer();
                    long bgTime = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : -1L;
                    int bgCount = bgTimer != null ? bgTimer.getCountLocked(which) : -1;
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Sync ");
                    sb.append(syncs.keyAt(isy));
                    sb.append(": ");
                    if (totalTime != 0L) {
                        BatteryStats.formatTimeMs(sb, totalTime);
                        sb.append("realtime (");
                        sb.append(count);
                        sb.append(" times)");
                        if (bgTime > 0L) {
                            sb.append(", ");
                            BatteryStats.formatTimeMs(sb, bgTime);
                            sb.append("background (");
                            sb.append(bgCount);
                            sb.append(" times)");
                        }
                    } else {
                        sb.append("(not used)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
                ArrayMap<String, ? extends Timer> jobs = u.getJobStats();
                for (int ij = jobs.size() - 1; ij >= 0; --ij) {
                    Timer timer = jobs.valueAt(ij);
                    long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                    int count = timer.getCountLocked(which);
                    Timer bgTimer = timer.getSubTimer();
                    long bgTime = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : -1L;
                    int bgCount = bgTimer != null ? bgTimer.getCountLocked(which) : -1;
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Job ");
                    sb.append(jobs.keyAt(ij));
                    sb.append(": ");
                    if (totalTime != 0L) {
                        BatteryStats.formatTimeMs(sb, totalTime);
                        sb.append("realtime (");
                        sb.append(count);
                        sb.append(" times)");
                        if (bgTime > 0L) {
                            sb.append(", ");
                            BatteryStats.formatTimeMs(sb, bgTime);
                            sb.append("background (");
                            sb.append(bgCount);
                            sb.append(" times)");
                        }
                    } else {
                        sb.append("(not used)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
                ArrayMap<String, SparseIntArray> completions = u.getJobCompletionStats();
                for (int ic = completions.size() - 1; ic >= 0; --ic) {
                    SparseIntArray types = completions.valueAt(ic);
                    if (types == null) continue;
                    pw.print(prefix);
                    pw.print("    Job Completions ");
                    pw.print(completions.keyAt(ic));
                    pw.print(":");
                    for (int it = 0; it < types.size(); ++it) {
                        pw.print(" ");
                        pw.print(JobParameters.getInternalReasonCodeDescription(types.keyAt(it)));
                        pw.print("(");
                        pw.print(types.valueAt(it));
                        pw.print("x)");
                    }
                    pw.println();
                }
                u.getDeferredJobsLineLocked(sb, which);
                if (sb.length() > 0) {
                    pw.print("    Jobs deferred on launch ");
                    pw.println(sb.toString());
                }
                uidActivity |= BatteryStats.printTimer(pw, sb, u.getFlashlightTurnedOnTimer(), rawRealtime, which, prefix, "Flashlight");
                uidActivity |= BatteryStats.printTimer(pw, sb, u.getCameraTurnedOnTimer(), rawRealtime, which, prefix, "Camera");
                uidActivity |= BatteryStats.printTimer(pw, sb, u.getVideoTurnedOnTimer(), rawRealtime, which, prefix, "Video");
                uidActivity |= BatteryStats.printTimer(pw, sb, u.getAudioTurnedOnTimer(), rawRealtime, which, prefix, "Audio");
                SparseArray<? extends Uid.Sensor> sensors = u.getSensorStats();
                int NSE = sensors.size();
                for (int ise = 0; ise < NSE; ++ise) {
                    Uid.Sensor se = sensors.valueAt(ise);
                    int sensorNumber = sensors.keyAt(ise);
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Sensor ");
                    int handle = se.getHandle();
                    if (handle == -10000) {
                        sb.append("GPS");
                    } else {
                        sb.append(handle);
                    }
                    sb.append(": ");
                    Timer timer = se.getSensorTime();
                    if (timer != null) {
                        long bgActualTime;
                        long totalTime = (timer.getTotalTimeLocked(rawRealtime, which) + 500L) / 1000L;
                        int count = timer.getCountLocked(which);
                        Timer bgTimer = se.getSensorBackgroundTime();
                        int bgCount = bgTimer != null ? bgTimer.getCountLocked(which) : 0;
                        long actualTime = timer.getTotalDurationMsLocked(rawRealtimeMs);
                        long l = bgActualTime = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                        if (totalTime != 0L) {
                            if (actualTime != totalTime) {
                                BatteryStats.formatTimeMs(sb, totalTime);
                                sb.append("blamed realtime, ");
                            }
                            BatteryStats.formatTimeMs(sb, actualTime);
                            sb.append("realtime (");
                            sb.append(count);
                            sb.append(" times)");
                            if (bgActualTime != 0L || bgCount > 0) {
                                sb.append(", ");
                                BatteryStats.formatTimeMs(sb, bgActualTime);
                                sb.append("background (");
                                sb.append(bgCount);
                                sb.append(" times)");
                            }
                        } else {
                            sb.append("(not used)");
                        }
                    } else {
                        sb.append("(not used)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
                uidActivity |= BatteryStats.printTimer(pw, sb, u.getVibratorOnTimer(), rawRealtime, which, prefix, "Vibrator");
                uidActivity |= BatteryStats.printTimer(pw, sb, u.getForegroundActivityTimer(), rawRealtime, which, prefix, "Foreground activities");
                uidActivity |= BatteryStats.printTimer(pw, sb, u.getForegroundServiceTimer(), rawRealtime, which, prefix, "Foreground services");
                long totalStateTime = 0L;
                for (int ips = 0; ips < 7; ++ips) {
                    long time7 = u.getProcessStateTime(ips, rawRealtime, which);
                    if (time7 <= 0L) continue;
                    totalStateTime += time7;
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    ");
                    sb.append(Uid.PROCESS_STATE_NAMES[ips]);
                    sb.append(" for: ");
                    BatteryStats.formatTimeMs(sb, (time7 + 500L) / 1000L);
                    pw.println(sb.toString());
                    uidActivity = true;
                }
                if (totalStateTime > 0L) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Total running: ");
                    BatteryStats.formatTimeMs(sb, (totalStateTime + 500L) / 1000L);
                    pw.println(sb.toString());
                }
                long userCpuTimeUs = u.getUserCpuTimeUs(which);
                long systemCpuTimeUs = u.getSystemCpuTimeUs(which);
                if (userCpuTimeUs > 0L || systemCpuTimeUs > 0L) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Total cpu time: u=");
                    BatteryStats.formatTimeMs(sb, userCpuTimeUs / 1000L);
                    sb.append("s=");
                    BatteryStats.formatTimeMs(sb, systemCpuTimeUs / 1000L);
                    pw.println(sb.toString());
                }
                if ((cpuFreqTimes = u.getCpuFreqTimes(which)) != null) {
                    sb.setLength(0);
                    sb.append("    Total cpu time per freq:");
                    for (int i10 = 0; i10 < cpuFreqTimes.length; ++i10) {
                        sb.append(' ').append(cpuFreqTimes[i10]);
                    }
                    pw.println(sb.toString());
                }
                if ((screenOffCpuFreqTimes = u.getScreenOffCpuFreqTimes(which)) != null) {
                    sb.setLength(0);
                    sb.append("    Total screen-off cpu time per freq:");
                    for (int i11 = 0; i11 < screenOffCpuFreqTimes.length; ++i11) {
                        sb.append(' ').append(screenOffCpuFreqTimes[i11]);
                    }
                    pw.println(sb.toString());
                }
                long[] timesInFreqMs = new long[this.getCpuScalingPolicies().getScalingStepCount()];
                for (int procState = 0; procState < 7; ++procState) {
                    if (u.getCpuFreqTimes(timesInFreqMs, procState)) {
                        sb.setLength(0);
                        sb.append("    Cpu times per freq at state ").append(Uid.PROCESS_STATE_NAMES[procState]).append(':');
                        for (int i12 = 0; i12 < timesInFreqMs.length; ++i12) {
                            sb.append(" ").append(timesInFreqMs[i12]);
                        }
                        pw.println(sb.toString());
                    }
                    if (!u.getScreenOffCpuFreqTimes(timesInFreqMs, procState)) continue;
                    sb.setLength(0);
                    sb.append("   Screen-off cpu times per freq at state ").append(Uid.PROCESS_STATE_NAMES[procState]).append(':');
                    for (int i3 = 0; i3 < timesInFreqMs.length; ++i3) {
                        sb.append(" ").append(timesInFreqMs[i3]);
                    }
                    pw.println(sb.toString());
                }
                ArrayMap<String, ? extends Uid.Proc> processStats = u.getProcessStats();
                for (int ipr = processStats.size() - 1; ipr >= 0; --ipr) {
                    int numExcessive;
                    Uid.Proc ps = processStats.valueAt(ipr);
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    long foregroundTime = ps.getForegroundTime(which);
                    int starts = ps.getStarts(which);
                    int numCrashes = ps.getNumCrashes(which);
                    int numAnrs = ps.getNumAnrs(which);
                    int n = numExcessive = which == 0 ? ps.countExcessivePowers() : 0;
                    if (userTime == 0L && systemTime == 0L && foregroundTime == 0L && starts == 0 && numExcessive == 0 && numCrashes == 0 && numAnrs == 0) continue;
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Proc ");
                    sb.append(processStats.keyAt(ipr));
                    sb.append(":\n");
                    sb.append(prefix);
                    sb.append("      CPU: ");
                    BatteryStats.formatTimeMs(sb, userTime);
                    sb.append("usr + ");
                    BatteryStats.formatTimeMs(sb, systemTime);
                    sb.append("krn ; ");
                    BatteryStats.formatTimeMs(sb, foregroundTime);
                    sb.append(FOREGROUND_ACTIVITY_DATA);
                    if (starts != 0 || numCrashes != 0 || numAnrs != 0) {
                        sb.append("\n");
                        sb.append(prefix);
                        sb.append("      ");
                        boolean hasOne = false;
                        if (starts != 0) {
                            hasOne = true;
                            sb.append(starts);
                            sb.append(" starts");
                        }
                        if (numCrashes != 0) {
                            if (hasOne) {
                                sb.append(", ");
                            }
                            hasOne = true;
                            sb.append(numCrashes);
                            sb.append(" crashes");
                        }
                        if (numAnrs != 0) {
                            if (hasOne) {
                                sb.append(", ");
                            }
                            sb.append(numAnrs);
                            sb.append(" anrs");
                        }
                    }
                    pw.println(sb.toString());
                    for (int e = 0; e < numExcessive; ++e) {
                        Uid.Proc.ExcessivePower ew = ps.getExcessivePower(e);
                        if (ew == null) continue;
                        pw.print(prefix);
                        pw.print("      * Killed for ");
                        if (ew.type == 2) {
                            pw.print(CPU_DATA);
                        } else {
                            pw.print("unknown");
                        }
                        pw.print(" use: ");
                        TimeUtils.formatDuration(ew.usedTime, pw);
                        pw.print(" over ");
                        TimeUtils.formatDuration(ew.overTime, pw);
                        if (ew.overTime == 0L) continue;
                        pw.print(" (");
                        pw.print(ew.usedTime * 100L / ew.overTime);
                        pw.println("%)");
                    }
                    uidActivity = true;
                }
                ArrayMap<String, ? extends Uid.Pkg> packageStats = u.getPackageStats();
                for (int ipkg = packageStats.size() - 1; ipkg >= 0; --ipkg) {
                    pw.print(prefix);
                    pw.print("    Apk ");
                    pw.print(packageStats.keyAt(ipkg));
                    pw.println(":");
                    boolean apkActivity = false;
                    Uid.Pkg ps = packageStats.valueAt(ipkg);
                    ArrayMap<String, ? extends Counter> alarms = ps.getWakeupAlarmStats();
                    for (int iwa = alarms.size() - 1; iwa >= 0; --iwa) {
                        pw.print(prefix);
                        pw.print("      Wakeup alarm ");
                        pw.print(alarms.keyAt(iwa));
                        pw.print(": ");
                        pw.print(alarms.valueAt(iwa).getCountLocked(which));
                        pw.println(" times");
                        apkActivity = true;
                    }
                    ArrayMap<String, ? extends Uid.Pkg.Serv> serviceStats = ps.getServiceStats();
                    for (int isvc = serviceStats.size() - 1; isvc >= 0; --isvc) {
                        Uid.Pkg.Serv ss = serviceStats.valueAt(isvc);
                        long startTime = ss.getStartTime(batteryUptime, which);
                        int starts = ss.getStarts(which);
                        int launches = ss.getLaunches(which);
                        if (startTime == 0L && starts == 0 && launches == 0) continue;
                        sb.setLength(0);
                        sb.append(prefix);
                        sb.append("      Service ");
                        sb.append(serviceStats.keyAt(isvc));
                        sb.append(":\n");
                        sb.append(prefix);
                        sb.append("        Created for: ");
                        BatteryStats.formatTimeMs(sb, startTime / 1000L);
                        sb.append("uptime\n");
                        sb.append(prefix);
                        sb.append("        Starts: ");
                        sb.append(starts);
                        sb.append(", launches: ");
                        sb.append(launches);
                        pw.println(sb.toString());
                        apkActivity = true;
                    }
                    if (!apkActivity) {
                        pw.print(prefix);
                        pw.println("      (nothing executed)");
                    }
                    uidActivity = true;
                }
                if (!uidActivity) {
                    pw.print(prefix);
                    pw.println("    (nothing executed)");
                }
            }
            ++var124_118;
        }
    }

    static void printBitDescriptions(StringBuilder sb, int oldval, int newval, HistoryTag wakelockTag, BitDescription[] descriptions, boolean longNames) {
        int diff = oldval ^ newval;
        if (diff == 0) {
            return;
        }
        boolean didWake = false;
        for (int i = 0; i < descriptions.length; ++i) {
            BitDescription bd = descriptions[i];
            if ((diff & bd.mask) == 0) continue;
            sb.append(longNames ? " " : ",");
            if (bd.shift < 0) {
                sb.append((newval & bd.mask) != 0 ? "+" : "-");
                sb.append(longNames ? bd.name : bd.shortName);
                if (bd.mask != 0x40000000 || wakelockTag == null) continue;
                didWake = true;
                sb.append("=");
                if (longNames || wakelockTag.poolIdx == -1) {
                    UserHandle.formatUid(sb, wakelockTag.uid);
                    sb.append(":\"");
                    if (wakelockTag.string != null) {
                        sb.append(wakelockTag.string.replace("\"", "\"\""));
                    }
                    sb.append("\"");
                    continue;
                }
                sb.append(wakelockTag.poolIdx);
                continue;
            }
            sb.append(longNames ? bd.name : bd.shortName);
            sb.append("=");
            int val = (newval & bd.mask) >> bd.shift;
            if (bd.values != null && val >= 0 && val < bd.values.length) {
                sb.append(longNames ? bd.values[val] : bd.shortValues[val]);
                continue;
            }
            sb.append(val);
        }
        if (!didWake && wakelockTag != null) {
            sb.append(longNames ? " wake_lock=" : ",w=");
            if (longNames || wakelockTag.poolIdx == -1) {
                UserHandle.formatUid(sb, wakelockTag.uid);
                sb.append(":\"");
                sb.append(wakelockTag.string);
                sb.append("\"");
            } else {
                sb.append(wakelockTag.poolIdx);
            }
        }
    }

    public void prepareForDumpLocked() {
    }

    private void printSizeValue(PrintWriter pw, long size) {
        float result = size;
        String suffix = "";
        if (result >= 10240.0f) {
            suffix = "KB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "MB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "GB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "TB";
            result /= 1024.0f;
        }
        if (result >= 10240.0f) {
            suffix = "PB";
            result /= 1024.0f;
        }
        pw.print((int)result);
        pw.print(suffix);
    }

    private static boolean dumpTimeEstimate(PrintWriter pw, String label1, String label2, String label3, long estimatedTime) {
        if (estimatedTime < 0L) {
            return false;
        }
        pw.print(label1);
        pw.print(label2);
        pw.print(label3);
        StringBuilder sb = new StringBuilder(64);
        BatteryStats.formatTimeMs(sb, estimatedTime);
        pw.print(sb);
        pw.println();
        return true;
    }

    private static boolean dumpDurationSteps(PrintWriter pw, String prefix, String header, LevelStepTracker steps, boolean checkin) {
        if (steps == null) {
            return false;
        }
        int count = steps.mNumStepDurations;
        if (count <= 0) {
            return false;
        }
        if (!checkin) {
            pw.println(header);
        }
        String[] lineArgs = new String[5];
        for (int i = 0; i < count; ++i) {
            long duration = steps.getDurationAt(i);
            int level = steps.getLevelAt(i);
            long initMode = steps.getInitModeAt(i);
            long modMode = steps.getModModeAt(i);
            if (checkin) {
                lineArgs[0] = Long.toString(duration);
                lineArgs[1] = Integer.toString(level);
                if ((modMode & 3L) == 0L) {
                    switch ((int)(initMode & 3L) + 1) {
                        case 1: {
                            lineArgs[2] = "s-";
                            break;
                        }
                        case 2: {
                            lineArgs[2] = "s+";
                            break;
                        }
                        case 3: {
                            lineArgs[2] = "sd";
                            break;
                        }
                        case 4: {
                            lineArgs[2] = "sds";
                            break;
                        }
                        default: {
                            lineArgs[2] = "?";
                            break;
                        }
                    }
                } else {
                    lineArgs[2] = "";
                }
                lineArgs[3] = (modMode & 4L) == 0L ? ((initMode & 4L) != 0L ? "p+" : "p-") : "";
                lineArgs[4] = (modMode & 8L) == 0L ? ((initMode & 8L) != 0L ? "i+" : "i-") : "";
                BatteryStats.dumpLine(pw, 0, "i", header, lineArgs);
                continue;
            }
            pw.print(prefix);
            pw.print("#");
            pw.print(i);
            pw.print(": ");
            TimeUtils.formatDuration(duration, pw);
            pw.print(" to ");
            pw.print(level);
            boolean haveModes = false;
            if ((modMode & 3L) == 0L) {
                pw.print(" (");
                switch ((int)(initMode & 3L) + 1) {
                    case 1: {
                        pw.print("screen-off");
                        break;
                    }
                    case 2: {
                        pw.print("screen-on");
                        break;
                    }
                    case 3: {
                        pw.print("screen-doze");
                        break;
                    }
                    case 4: {
                        pw.print("screen-doze-suspend");
                        break;
                    }
                    default: {
                        pw.print("screen-?");
                    }
                }
                haveModes = true;
            }
            if ((modMode & 4L) == 0L) {
                pw.print(haveModes ? ", " : " (");
                pw.print((initMode & 4L) != 0L ? "power-save-on" : "power-save-off");
                haveModes = true;
            }
            if ((modMode & 8L) == 0L) {
                pw.print(haveModes ? ", " : " (");
                pw.print((initMode & 8L) != 0L ? "device-idle-on" : "device-idle-off");
                haveModes = true;
            }
            if (haveModes) {
                pw.print(")");
            }
            pw.println();
        }
        return true;
    }

    private static void dumpDurationSteps(ProtoOutputStream proto, long fieldId, LevelStepTracker steps) {
        if (steps == null) {
            return;
        }
        int count = steps.mNumStepDurations;
        for (int i = 0; i < count; ++i) {
            long token = proto.start(fieldId);
            proto.write(0x10300000001L, steps.getDurationAt(i));
            proto.write(1120986464258L, steps.getLevelAt(i));
            long initMode = steps.getInitModeAt(i);
            long modMode = steps.getModModeAt(i);
            int ds = 0;
            if ((modMode & 3L) == 0L) {
                switch ((int)(initMode & 3L) + 1) {
                    case 1: {
                        ds = 2;
                        break;
                    }
                    case 2: {
                        ds = 1;
                        break;
                    }
                    case 3: {
                        ds = 3;
                        break;
                    }
                    case 4: {
                        ds = 4;
                        break;
                    }
                    default: {
                        ds = 5;
                    }
                }
            }
            proto.write(1159641169923L, ds);
            int psm = 0;
            if ((modMode & 4L) == 0L) {
                psm = (initMode & 4L) != 0L ? 1 : 2;
            }
            proto.write(1159641169924L, psm);
            int im = 0;
            if ((modMode & 8L) == 0L) {
                im = (initMode & 8L) != 0L ? 2 : 3;
            }
            proto.write(1159641169925L, im);
            proto.end(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpHistory(PrintWriter pw, int flags, long histStart, boolean checkin, long monotonicClockStart) {
        block24: {
            block25: {
                block26: {
                    hprinter = new HistoryPrinter(flags);
                    var9_7 = this;
                    synchronized (var9_7) {
                        if (!checkin) {
                            historyTotalSize = this.getHistoryTotalSize();
                            historyUsedSize = this.getHistoryUsedSize();
                            pw.print("Battery History");
                            if (hprinter.mFormatVersion != 1) {
                                pw.print(" [Format: " + hprinter.mFormatVersion + "]");
                            }
                            pw.print(" (");
                            pw.print(100L * historyUsedSize / historyTotalSize);
                            pw.print("% used, ");
                            this.printSizeValue(pw, historyUsedSize);
                            pw.print(" used of ");
                            this.printSizeValue(pw, historyTotalSize);
                            pw.print(", ");
                            pw.print(this.getHistoryStringPoolSize());
                            pw.print(" strings using ");
                            this.printSizeValue(pw, this.getHistoryStringPoolBytes());
                            pw.println("):");
                        } else {
                            this.dumpHistoryTagPoolLocked(pw, checkin);
                        }
                    }
                    lastTime = -1L;
                    baseTime = -1L;
                    printed = false;
                    tracker = null;
                    iterator = this.iterateBatteryStatsHistory(monotonicClockStart, -1L);
                    block9: while ((rec = iterator.next()) != null) {
                        try {
                            lastTime = rec.time;
                            if (baseTime < 0L) {
                                baseTime = lastTime;
                            }
                            if (rec.time < histStart) continue;
                            if (histStart < 0L || printed) ** GOTO lbl64
                            if (rec.cmd == 5 || rec.cmd == 7 || rec.cmd == 4 || rec.cmd == 8) {
                                printed = true;
                                hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 32) != 0);
                                rec.cmd = 0;
                            } else if (rec.currentTime != 0L) {
                                printed = true;
                                cmd = rec.cmd;
                                rec.cmd = (byte)5;
                                hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 32) != 0);
                                rec.cmd = cmd;
                            }
                            if (tracker == null) ** GOTO lbl64
                            if (rec.cmd != 0) {
                                hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 32) != 0);
                                rec.cmd = 0;
                            }
                            oldEventCode = rec.eventCode;
                            oldEventTag = rec.eventTag;
                            rec.eventTag = new HistoryTag();
                            i = 0;
lbl55:
                            // 2 sources

                            while (true) {
                                if (i < 23) {
                                    active = tracker.getStateForEvent(i);
                                    if (active == null) break block24;
                                    var21_23 = active.entrySet().iterator();
                                    break block25;
                                }
                                rec.eventCode = oldEventCode;
                                rec.eventTag = oldEventTag;
                                tracker = null;
lbl64:
                                // 3 sources

                                hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 32) != 0);
                                continue block9;
                                break;
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace(pw);
                            Slog.wtf("BatteryStats", "Corrupted battery history", t);
                            break block26;
                        }
                    }
                    break block26;
                    finally {
                        if (iterator != null) {
                            iterator.close();
                        }
                    }
                }
                if (histStart >= 0L) {
                    this.commitCurrentHistoryBatchLocked();
                    pw.print(checkin != false ? "NEXT: " : "  NEXT: ");
                    pw.println(lastTime + 1L);
                }
                return;
            }
            while (var21_23.hasNext()) {
                ent = var21_23.next();
                uids = (SparseIntArray)ent.getValue();
                for (j = 0; j < uids.size(); ++j) {
                    rec.eventCode = i;
                    rec.eventTag.string = (String)ent.getKey();
                    rec.eventTag.uid = uids.keyAt(j);
                    rec.eventTag.poolIdx = uids.valueAt(j);
                    hprinter.printNextItem(pw, rec, baseTime, checkin, (flags & 32) != 0);
                    rec.wakeReasonTag = null;
                    rec.wakelockTag = null;
                }
            }
        }
        ++i;
        ** continue;
    }

    private void dumpHistoryTagPoolLocked(PrintWriter pw, boolean checkin) {
        if (checkin) {
            for (int i = 0; i < this.getHistoryStringPoolSize(); ++i) {
                pw.print(9);
                pw.print(',');
                pw.print(HISTORY_STRING_POOL);
                pw.print(',');
                pw.print(i);
                pw.print(",");
                pw.print(this.getHistoryTagPoolUid(i));
                pw.print(",\"");
                String str = this.getHistoryTagPoolString(i);
                if (str != null) {
                    str = str.replace("\\", "\\\\");
                    str = str.replace("\"", "\\\"");
                    pw.print(str);
                }
                pw.print("\"");
                pw.println();
            }
        }
    }

    private void dumpDailyLevelStepSummary(PrintWriter pw, String prefix, String label, LevelStepTracker steps, StringBuilder tmpSb, int[] tmpOutInt) {
        if (steps == null) {
            return;
        }
        long timeRemaining = steps.computeTimeEstimate(0L, 0L, tmpOutInt);
        if (timeRemaining >= 0L) {
            pw.print(prefix);
            pw.print(label);
            pw.print(" total time: ");
            tmpSb.setLength(0);
            BatteryStats.formatTimeMs(tmpSb, timeRemaining);
            pw.print(tmpSb);
            pw.print(" (from ");
            pw.print(tmpOutInt[0]);
            pw.println(" steps)");
        }
        for (int i = 0; i < STEP_LEVEL_MODES_OF_INTEREST.length; ++i) {
            long estimatedTime = steps.computeTimeEstimate(STEP_LEVEL_MODES_OF_INTEREST[i], STEP_LEVEL_MODE_VALUES[i], tmpOutInt);
            if (estimatedTime <= 0L) continue;
            pw.print(prefix);
            pw.print(label);
            pw.print(" ");
            pw.print(STEP_LEVEL_MODE_LABELS[i]);
            pw.print(" time: ");
            tmpSb.setLength(0);
            BatteryStats.formatTimeMs(tmpSb, estimatedTime);
            pw.print(tmpSb);
            pw.print(" (from ");
            pw.print(tmpOutInt[0]);
            pw.println(" steps)");
        }
    }

    private void dumpDailyPackageChanges(PrintWriter pw, String prefix, ArrayList<PackageChange> changes) {
        if (changes == null) {
            return;
        }
        pw.print(prefix);
        pw.println("Package changes:");
        for (int i = 0; i < changes.size(); ++i) {
            PackageChange pc = changes.get(i);
            if (pc.mUpdate) {
                pw.print(prefix);
                pw.print("  Update ");
                pw.print(pc.mPackageName);
                pw.print(" vers=");
                pw.println(pc.mVersionCode);
                continue;
            }
            pw.print(prefix);
            pw.print("  Uninstall ");
            pw.println(pc.mPackageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Context context, PrintWriter pw, int flags, int reqUid, long histStart, BatteryStatsDumpHelper dumpHelper, long monotonicClockStart) {
        boolean filtering;
        BatteryStats batteryStats = this;
        synchronized (batteryStats) {
            this.prepareForDumpLocked();
        }
        boolean bl = filtering = (flags & 0xE) != 0;
        if ((flags & 8) != 0 || !filtering) {
            this.dumpHistory(pw, flags, histStart, false, monotonicClockStart);
            pw.println();
        }
        if (filtering && (flags & 6) == 0) {
            return;
        }
        BatteryStats batteryStats2 = this;
        synchronized (batteryStats2) {
            this.dumpLocked(context, pw, flags, reqUid, filtering, dumpHelper);
        }
    }

    private void dumpLocked(Context context, PrintWriter pw, int flags, int reqUid, boolean filtering, BatteryStatsDumpHelper dumpHelper) {
        if (!filtering) {
            SparseArray<? extends Uid> uidStats = this.getUidStats();
            int NU = uidStats.size();
            boolean didPid = false;
            long nowRealtime = SystemClock.elapsedRealtime();
            for (int i = 0; i < NU; ++i) {
                Uid uid = uidStats.valueAt(i);
                SparseArray<? extends Uid.Pid> pids = uid.getPidStats();
                if (pids == null) continue;
                for (int j = 0; j < pids.size(); ++j) {
                    Uid.Pid pid = pids.valueAt(j);
                    if (!didPid) {
                        pw.println("Per-PID Stats:");
                        didPid = true;
                    }
                    long time = pid.mWakeSumMs + (pid.mWakeNesting > 0 ? nowRealtime - pid.mWakeStartMs : 0L);
                    pw.print("  PID ");
                    pw.print(pids.keyAt(j));
                    pw.print(" wake time: ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println("");
                }
            }
            if (didPid) {
                pw.println();
            }
        }
        if (!filtering || (flags & 2) != 0) {
            if (BatteryStats.dumpDurationSteps(pw, "  ", "Discharge step durations:", this.getDischargeLevelStepTracker(), false)) {
                long timeRemaining = this.computeBatteryTimeRemaining(SystemClock.elapsedRealtime() * 1000L);
                if (timeRemaining >= 0L) {
                    pw.print("  Estimated discharge time remaining: ");
                    TimeUtils.formatDuration(timeRemaining / 1000L, pw);
                    pw.println();
                }
                LevelStepTracker steps = this.getDischargeLevelStepTracker();
                for (int i = 0; i < STEP_LEVEL_MODES_OF_INTEREST.length; ++i) {
                    BatteryStats.dumpTimeEstimate(pw, "  Estimated ", STEP_LEVEL_MODE_LABELS[i], " time: ", steps.computeTimeEstimate(STEP_LEVEL_MODES_OF_INTEREST[i], STEP_LEVEL_MODE_VALUES[i], null));
                }
                pw.println();
            }
            if (BatteryStats.dumpDurationSteps(pw, "  ", "Charge step durations:", this.getChargeLevelStepTracker(), false)) {
                long timeRemaining = this.computeChargeTimeRemaining(SystemClock.elapsedRealtime() * 1000L);
                if (timeRemaining >= 0L) {
                    pw.print("  Estimated charge time remaining: ");
                    TimeUtils.formatDuration(timeRemaining / 1000L, pw);
                    pw.println();
                }
                pw.println();
            }
        }
        if (!filtering || (flags & 4) != 0) {
            DailyItem dit;
            pw.println("Daily stats:");
            pw.print("  Current start time: ");
            pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.getCurrentDailyStartTime()).toString());
            pw.print("  Next min deadline: ");
            pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.getNextMinDailyDeadline()).toString());
            pw.print("  Next max deadline: ");
            pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.getNextMaxDailyDeadline()).toString());
            StringBuilder sb = new StringBuilder(64);
            int[] outInt = new int[1];
            LevelStepTracker dsteps = this.getDailyDischargeLevelStepTracker();
            LevelStepTracker csteps = this.getDailyChargeLevelStepTracker();
            ArrayList<PackageChange> pkgc = this.getDailyPackageChanges();
            if (dsteps.mNumStepDurations > 0 || csteps.mNumStepDurations > 0 || pkgc != null) {
                if ((flags & 4) != 0 || !filtering) {
                    if (BatteryStats.dumpDurationSteps(pw, "    ", "  Current daily discharge step durations:", dsteps, false)) {
                        this.dumpDailyLevelStepSummary(pw, "      ", "Discharge", dsteps, sb, outInt);
                    }
                    if (BatteryStats.dumpDurationSteps(pw, "    ", "  Current daily charge step durations:", csteps, false)) {
                        this.dumpDailyLevelStepSummary(pw, "      ", "Charge", csteps, sb, outInt);
                    }
                    this.dumpDailyPackageChanges(pw, "    ", pkgc);
                } else {
                    pw.println("  Current daily steps:");
                    this.dumpDailyLevelStepSummary(pw, "    ", "Discharge", dsteps, sb, outInt);
                    this.dumpDailyLevelStepSummary(pw, "    ", "Charge", csteps, sb, outInt);
                }
            }
            int curIndex = 0;
            while ((dit = this.getDailyItemLocked(curIndex)) != null) {
                ++curIndex;
                if ((flags & 4) != 0) {
                    pw.println();
                }
                pw.print("  Daily from ");
                pw.print(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", dit.mStartTime).toString());
                pw.print(" to ");
                pw.print(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", dit.mEndTime).toString());
                pw.println(":");
                if ((flags & 4) != 0 || !filtering) {
                    if (BatteryStats.dumpDurationSteps(pw, "      ", "    Discharge step durations:", dit.mDischargeSteps, false)) {
                        this.dumpDailyLevelStepSummary(pw, "        ", "Discharge", dit.mDischargeSteps, sb, outInt);
                    }
                    if (BatteryStats.dumpDurationSteps(pw, "      ", "    Charge step durations:", dit.mChargeSteps, false)) {
                        this.dumpDailyLevelStepSummary(pw, "        ", "Charge", dit.mChargeSteps, sb, outInt);
                    }
                    this.dumpDailyPackageChanges(pw, "    ", dit.mPackageChanges);
                    continue;
                }
                this.dumpDailyLevelStepSummary(pw, "    ", "Discharge", dit.mDischargeSteps, sb, outInt);
                this.dumpDailyLevelStepSummary(pw, "    ", "Charge", dit.mChargeSteps, sb, outInt);
            }
            pw.println();
        }
        if (!filtering || (flags & 2) != 0) {
            pw.println("Statistics since last charge:");
            pw.println("  System starts: " + this.getStartCount() + ", currently on battery: " + this.getIsOnBattery());
            this.dumpLocked(context, pw, "", 0, reqUid, (flags & 0x40) != 0, dumpHelper);
            pw.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCheckin(Context context, PrintWriter pw, List<ApplicationInfo> apps, int flags, long histStart, BatteryStatsDumpHelper dumpHelper, long monotonicCheckinStartTime) {
        BatteryStats batteryStats = this;
        synchronized (batteryStats) {
            this.prepareForDumpLocked();
            BatteryStats.dumpLine(pw, 0, "i", VERSION_DATA, 36, this.getParcelVersion(), this.getStartPlatformVersion(), this.getEndPlatformVersion());
        }
        if ((flags & 0x18) != 0) {
            this.dumpHistory(pw, flags, histStart, true, monotonicCheckinStartTime);
        }
        if ((flags & 8) != 0) {
            return;
        }
        batteryStats = this;
        synchronized (batteryStats) {
            this.dumpCheckinLocked(context, pw, apps, flags, dumpHelper);
        }
    }

    private void dumpCheckinLocked(Context context, PrintWriter pw, List<ApplicationInfo> apps, int flags, BatteryStatsDumpHelper dumpHelper) {
        if (apps != null) {
            SparseArray uids = new SparseArray();
            for (int i = 0; i < apps.size(); ++i) {
                ApplicationInfo ai = apps.get(i);
                Pair pkgs = (Pair)uids.get(UserHandle.getAppId(ai.uid));
                if (pkgs == null) {
                    pkgs = new Pair(new ArrayList(), new MutableBoolean(false));
                    uids.put(UserHandle.getAppId(ai.uid), pkgs);
                }
                ((ArrayList)pkgs.first).add(ai.packageName);
            }
            SparseArray<? extends Uid> uidStats = this.getUidStats();
            int NU = uidStats.size();
            String[] lineArgs = new String[2];
            for (int i = 0; i < NU; ++i) {
                int uid = UserHandle.getAppId(uidStats.keyAt(i));
                Pair pkgs = (Pair)uids.get(uid);
                if (pkgs == null || ((MutableBoolean)pkgs.second).value) continue;
                ((MutableBoolean)pkgs.second).value = true;
                for (int j = 0; j < ((ArrayList)pkgs.first).size(); ++j) {
                    lineArgs[0] = Integer.toString(uid);
                    lineArgs[1] = (String)((ArrayList)pkgs.first).get(j);
                    BatteryStats.dumpLine(pw, 0, "i", UID_DATA, lineArgs);
                }
            }
        }
        if ((flags & 4) == 0) {
            BatteryStats.dumpDurationSteps(pw, "", DISCHARGE_STEP_DATA, this.getDischargeLevelStepTracker(), true);
            String[] lineArgs = new String[1];
            long timeRemaining = this.computeBatteryTimeRemaining(SystemClock.elapsedRealtime() * 1000L);
            if (timeRemaining >= 0L) {
                lineArgs[0] = Long.toString(timeRemaining);
                BatteryStats.dumpLine(pw, 0, "i", DISCHARGE_TIME_REMAIN_DATA, lineArgs);
            }
            BatteryStats.dumpDurationSteps(pw, "", CHARGE_STEP_DATA, this.getChargeLevelStepTracker(), true);
            timeRemaining = this.computeChargeTimeRemaining(SystemClock.elapsedRealtime() * 1000L);
            if (timeRemaining >= 0L) {
                lineArgs[0] = Long.toString(timeRemaining);
                BatteryStats.dumpLine(pw, 0, "i", CHARGE_TIME_REMAIN_DATA, lineArgs);
            }
            this.dumpCheckinLocked(context, pw, 0, -1, (flags & 0x40) != 0, dumpHelper);
        }
    }

    public void dumpProtoLocked(Context context, FileDescriptor fd, List<ApplicationInfo> apps, int flags, long histStart, BatteryStatsDumpHelper dumpHelper) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        this.prepareForDumpLocked();
        if ((flags & 0x18) != 0) {
            this.dumpProtoHistoryLocked(proto, flags, histStart);
            proto.flush();
            return;
        }
        long bToken = proto.start(0x10B00000001L);
        proto.write(0x10500000001L, 36);
        proto.write(1112396529666L, this.getParcelVersion());
        proto.write(1138166333443L, this.getStartPlatformVersion());
        proto.write(1138166333444L, this.getEndPlatformVersion());
        if ((flags & 4) == 0) {
            BatteryUsageStats stats = dumpHelper.getBatteryUsageStats(this, false);
            ProportionalAttributionCalculator proportionalAttributionCalculator = new ProportionalAttributionCalculator(context, stats);
            this.dumpProtoAppsLocked(proto, stats, apps, proportionalAttributionCalculator);
            this.dumpProtoSystemLocked(proto, stats);
        }
        proto.end(bToken);
        proto.flush();
    }

    private void dumpProtoAppsLocked(ProtoOutputStream proto, BatteryUsageStats stats, List<ApplicationInfo> apps, ProportionalAttributionCalculator proportionalAttributionCalculator) {
        boolean which = false;
        long rawUptimeUs = SystemClock.uptimeMillis() * 1000L;
        long rawRealtimeMs = SystemClock.elapsedRealtime();
        long rawRealtimeUs = rawRealtimeMs * 1000L;
        long batteryUptimeUs = this.getBatteryUptime(rawUptimeUs);
        SparseArray<ArrayList<String>> aidToPackages = new SparseArray<ArrayList<String>>();
        if (apps != null) {
            for (int i = 0; i < apps.size(); ++i) {
                ApplicationInfo ai = apps.get(i);
                int aid = UserHandle.getAppId(ai.uid);
                ArrayList<String> pkgs = (ArrayList<String>)aidToPackages.get(aid);
                if (pkgs == null) {
                    pkgs = new ArrayList<String>();
                    aidToPackages.put(aid, pkgs);
                }
                pkgs.add(ai.packageName);
            }
        }
        SparseArray<UidBatteryConsumer> uidToConsumer = new SparseArray<UidBatteryConsumer>();
        List<UidBatteryConsumer> consumers = stats.getUidBatteryConsumers();
        for (int i = consumers.size() - 1; i >= 0; --i) {
            UidBatteryConsumer bs = consumers.get(i);
            uidToConsumer.put(bs.getUid(), bs);
        }
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int n = uidStats.size();
        for (int iu = 0; iu < n; ++iu) {
            long[] cpuFreqTimeMs;
            long uTkn = proto.start(2246267895813L);
            Uid u = uidStats.valueAt(iu);
            int uid = uidStats.keyAt(iu);
            proto.write(0x10500000001L, uid);
            ArrayList pkgs = (ArrayList)aidToPackages.get(UserHandle.getAppId(uid));
            if (pkgs == null) {
                pkgs = new ArrayList();
            }
            ArrayMap<String, ? extends Uid.Pkg> packageStats = u.getPackageStats();
            for (int ipkg = packageStats.size() - 1; ipkg >= 0; --ipkg) {
                String pkg = packageStats.keyAt(ipkg);
                ArrayMap<String, ? extends Uid.Pkg.Serv> serviceStats = packageStats.valueAt(ipkg).getServiceStats();
                if (serviceStats.size() == 0) continue;
                long pToken = proto.start(0x20B00000002L);
                proto.write(0x10900000001L, pkg);
                pkgs.remove(pkg);
                for (int isvc = serviceStats.size() - 1; isvc >= 0; --isvc) {
                    Uid.Pkg.Serv ss = serviceStats.valueAt(isvc);
                    long startTimeMs = BatteryStats.roundUsToMs(ss.getStartTime(batteryUptimeUs, 0));
                    int starts = ss.getStarts(0);
                    int launches = ss.getLaunches(0);
                    if (startTimeMs == 0L && starts == 0 && launches == 0) continue;
                    long sToken = proto.start(0x20B00000002L);
                    proto.write(0x10900000001L, serviceStats.keyAt(isvc));
                    proto.write(1112396529666L, startTimeMs);
                    proto.write(1120986464259L, starts);
                    proto.write(1120986464260L, launches);
                    proto.end(sToken);
                }
                proto.end(pToken);
            }
            for (String p : pkgs) {
                long pToken = proto.start(0x20B00000002L);
                proto.write(0x10900000001L, p);
                proto.end(pToken);
            }
            if (u.getAggregatedPartialWakelockTimer() != null) {
                Timer timer = u.getAggregatedPartialWakelockTimer();
                long totTimeMs = timer.getTotalDurationMsLocked(rawRealtimeMs);
                Timer bgTimer = timer.getSubTimer();
                long bgTimeMs = bgTimer != null ? bgTimer.getTotalDurationMsLocked(rawRealtimeMs) : 0L;
                long awToken = proto.start(1146756268056L);
                proto.write(0x10300000001L, totTimeMs);
                proto.write(1112396529666L, bgTimeMs);
                proto.end(awToken);
            }
            BatteryStats.dumpTimer(proto, 1146756268040L, u.getAudioTurnedOnTimer(), rawRealtimeUs, 0);
            BatteryStats.dumpControllerActivityProto(proto, 1146756268035L, u.getBluetoothControllerActivity(), 0);
            Timer bleTimer = u.getBluetoothScanTimer();
            if (bleTimer != null) {
                long bmToken = proto.start(1146756268038L);
                BatteryStats.dumpTimer(proto, 0x10B00000001L, bleTimer, rawRealtimeUs, 0);
                BatteryStats.dumpTimer(proto, 1146756268034L, u.getBluetoothScanBackgroundTimer(), rawRealtimeUs, 0);
                BatteryStats.dumpTimer(proto, 1146756268035L, u.getBluetoothUnoptimizedScanTimer(), rawRealtimeUs, 0);
                BatteryStats.dumpTimer(proto, 1146756268036L, u.getBluetoothUnoptimizedScanBackgroundTimer(), rawRealtimeUs, 0);
                proto.write(0x10500000005L, u.getBluetoothScanResultCounter() != null ? u.getBluetoothScanResultCounter().getCountLocked(0) : 0);
                proto.write(1120986464262L, u.getBluetoothScanResultBgCounter() != null ? u.getBluetoothScanResultBgCounter().getCountLocked(0) : 0);
                proto.end(bmToken);
            }
            BatteryStats.dumpTimer(proto, 1146756268041L, u.getCameraTurnedOnTimer(), rawRealtimeUs, 0);
            long cpuToken = proto.start(1146756268039L);
            proto.write(0x10300000001L, BatteryStats.roundUsToMs(u.getUserCpuTimeUs(0)));
            proto.write(1112396529666L, BatteryStats.roundUsToMs(u.getSystemCpuTimeUs(0)));
            CpuScalingPolicies scalingPolicies = this.getCpuScalingPolicies();
            if (scalingPolicies != null && (cpuFreqTimeMs = u.getCpuFreqTimes(0)) != null && cpuFreqTimeMs.length == scalingPolicies.getScalingStepCount()) {
                long[] screenOffCpuFreqTimeMs = u.getScreenOffCpuFreqTimes(0);
                if (screenOffCpuFreqTimeMs == null) {
                    screenOffCpuFreqTimeMs = new long[cpuFreqTimeMs.length];
                }
                for (int ic = 0; ic < cpuFreqTimeMs.length; ++ic) {
                    long cToken = proto.start(2246267895811L);
                    proto.write(0x10500000001L, ic + 1);
                    proto.write(1112396529666L, cpuFreqTimeMs[ic]);
                    proto.write(0x10300000003L, screenOffCpuFreqTimeMs[ic]);
                    proto.end(cToken);
                }
            }
            int stepCount = this.getCpuScalingPolicies().getScalingStepCount();
            long[] timesInFreqMs = new long[stepCount];
            long[] timesInFreqScreenOffMs = new long[stepCount];
            for (int procState = 0; procState < 7; ++procState) {
                if (!u.getCpuFreqTimes(timesInFreqMs, procState)) continue;
                if (!u.getScreenOffCpuFreqTimes(timesInFreqScreenOffMs, procState)) {
                    Arrays.fill(timesInFreqScreenOffMs, 0L);
                }
                long procToken = proto.start(2246267895812L);
                proto.write(0x10E00000001L, procState);
                for (int ic = 0; ic < timesInFreqMs.length; ++ic) {
                    long cToken = proto.start(0x20B00000002L);
                    proto.write(0x10500000001L, ic + 1);
                    proto.write(1112396529666L, timesInFreqMs[ic]);
                    proto.write(0x10300000003L, timesInFreqScreenOffMs[ic]);
                    proto.end(cToken);
                }
                proto.end(procToken);
            }
            proto.end(cpuToken);
            BatteryStats.dumpTimer(proto, 1146756268042L, u.getFlashlightTurnedOnTimer(), rawRealtimeUs, 0);
            BatteryStats.dumpTimer(proto, 0x10B0000000BL, u.getForegroundActivityTimer(), rawRealtimeUs, 0);
            BatteryStats.dumpTimer(proto, 1146756268044L, u.getForegroundServiceTimer(), rawRealtimeUs, 0);
            ArrayMap<String, SparseIntArray> completions = u.getJobCompletionStats();
            for (int ic = 0; ic < completions.size(); ++ic) {
                SparseIntArray types = completions.valueAt(ic);
                if (types == null) continue;
                long jcToken = proto.start(2246267895824L);
                proto.write(0x10900000001L, completions.keyAt(ic));
                for (int r : JobParameters.getJobStopReasonCodes()) {
                    long rToken = proto.start(0x20B00000002L);
                    proto.write(0x10E00000001L, r);
                    proto.write(1120986464258L, types.get(r, 0));
                    proto.end(rToken);
                }
                proto.end(jcToken);
            }
            ArrayMap<String, ? extends Timer> jobs = u.getJobStats();
            for (int ij = jobs.size() - 1; ij >= 0; --ij) {
                Timer timer = jobs.valueAt(ij);
                Timer bgTimer = timer.getSubTimer();
                long jToken = proto.start(2246267895823L);
                proto.write(0x10900000001L, jobs.keyAt(ij));
                BatteryStats.dumpTimer(proto, 1146756268034L, timer, rawRealtimeUs, 0);
                BatteryStats.dumpTimer(proto, 1146756268035L, bgTimer, rawRealtimeUs, 0);
                proto.end(jToken);
            }
            BatteryStats.dumpControllerActivityProto(proto, 1146756268036L, u.getModemControllerActivity(), 0);
            long nToken = proto.start(0x10B00000011L);
            proto.write(0x10300000001L, u.getNetworkActivityBytes(0, 0));
            proto.write(1112396529666L, u.getNetworkActivityBytes(1, 0));
            proto.write(0x10300000003L, u.getNetworkActivityBytes(2, 0));
            proto.write(1112396529668L, u.getNetworkActivityBytes(3, 0));
            proto.write(1112396529669L, u.getNetworkActivityBytes(4, 0));
            proto.write(1112396529670L, u.getNetworkActivityBytes(5, 0));
            proto.write(1112396529671L, u.getNetworkActivityPackets(0, 0));
            proto.write(1112396529672L, u.getNetworkActivityPackets(1, 0));
            proto.write(1112396529673L, u.getNetworkActivityPackets(2, 0));
            proto.write(1112396529674L, u.getNetworkActivityPackets(3, 0));
            proto.write(1112396529675L, BatteryStats.roundUsToMs(u.getMobileRadioActiveTime(0)));
            proto.write(1120986464268L, u.getMobileRadioActiveCount(0));
            proto.write(1120986464269L, u.getMobileRadioApWakeupCount(0));
            proto.write(1120986464270L, u.getWifiRadioApWakeupCount(0));
            proto.write(1112396529679L, u.getNetworkActivityBytes(6, 0));
            proto.write(0x10300000010L, u.getNetworkActivityBytes(7, 0));
            proto.write(0x10300000011L, u.getNetworkActivityBytes(8, 0));
            proto.write(1112396529682L, u.getNetworkActivityBytes(9, 0));
            proto.write(0x10300000013L, u.getNetworkActivityPackets(6, 0));
            proto.write(1112396529684L, u.getNetworkActivityPackets(7, 0));
            proto.write(1112396529685L, u.getNetworkActivityPackets(8, 0));
            proto.write(1112396529686L, u.getNetworkActivityPackets(9, 0));
            proto.end(nToken);
            UidBatteryConsumer consumer = (UidBatteryConsumer)uidToConsumer.get(uid);
            if (consumer != null) {
                long bsToken = proto.start(1146756268050L);
                proto.write(0x10100000001L, consumer.getConsumedPower());
                proto.write(1133871366146L, proportionalAttributionCalculator.isSystemBatteryConsumer(consumer));
                proto.write(0x10100000003L, consumer.getConsumedPower(0));
                proto.write(0x10100000004L, proportionalAttributionCalculator.getProportionalPowerMah(consumer));
                proto.end(bsToken);
            }
            ArrayMap<String, ? extends Uid.Proc> processStats = u.getProcessStats();
            for (int ipr = processStats.size() - 1; ipr >= 0; --ipr) {
                Uid.Proc ps = processStats.valueAt(ipr);
                long prToken = proto.start(2246267895827L);
                proto.write(0x10900000001L, processStats.keyAt(ipr));
                proto.write(1112396529666L, ps.getUserTime(0));
                proto.write(0x10300000003L, ps.getSystemTime(0));
                proto.write(1112396529668L, ps.getForegroundTime(0));
                proto.write(0x10500000005L, ps.getStarts(0));
                proto.write(1120986464262L, ps.getNumAnrs(0));
                proto.write(1120986464263L, ps.getNumCrashes(0));
                proto.end(prToken);
            }
            SparseArray<? extends Uid.Sensor> sensors = u.getSensorStats();
            for (int ise = 0; ise < sensors.size(); ++ise) {
                Uid.Sensor se = sensors.valueAt(ise);
                Timer timer = se.getSensorTime();
                if (timer == null) continue;
                Timer bgTimer = se.getSensorBackgroundTime();
                int sensorNumber = sensors.keyAt(ise);
                long seToken = proto.start(2246267895829L);
                proto.write(0x10500000001L, sensorNumber);
                BatteryStats.dumpTimer(proto, 1146756268034L, timer, rawRealtimeUs, 0);
                BatteryStats.dumpTimer(proto, 1146756268035L, bgTimer, rawRealtimeUs, 0);
                proto.end(seToken);
            }
            for (int ips = 0; ips < 7; ++ips) {
                long durMs = BatteryStats.roundUsToMs(u.getProcessStateTime(ips, rawRealtimeUs, 0));
                if (durMs == 0L) continue;
                long stToken = proto.start(2246267895828L);
                proto.write(0x10E00000001L, ips);
                proto.write(1112396529666L, durMs);
                proto.end(stToken);
            }
            ArrayMap<String, ? extends Timer> syncs = u.getSyncStats();
            for (int isy = syncs.size() - 1; isy >= 0; --isy) {
                Timer timer = syncs.valueAt(isy);
                Timer bgTimer = timer.getSubTimer();
                long syToken = proto.start(2246267895830L);
                proto.write(0x10900000001L, syncs.keyAt(isy));
                BatteryStats.dumpTimer(proto, 1146756268034L, timer, rawRealtimeUs, 0);
                BatteryStats.dumpTimer(proto, 1146756268035L, bgTimer, rawRealtimeUs, 0);
                proto.end(syToken);
            }
            if (u.hasUserActivity()) {
                for (int i = 0; i < Uid.NUM_USER_ACTIVITY_TYPES; ++i) {
                    int val = u.getUserActivityCount(i, 0);
                    if (val == 0) continue;
                    long uaToken = proto.start(2246267895831L);
                    proto.write(0x10E00000001L, i);
                    proto.write(1120986464258L, val);
                    proto.end(uaToken);
                }
            }
            BatteryStats.dumpTimer(proto, 1146756268045L, u.getVibratorOnTimer(), rawRealtimeUs, 0);
            BatteryStats.dumpTimer(proto, 1146756268046L, u.getVideoTurnedOnTimer(), rawRealtimeUs, 0);
            ArrayMap<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            for (int iw = wakelocks.size() - 1; iw >= 0; --iw) {
                Uid.Wakelock wl = wakelocks.valueAt(iw);
                long wToken = proto.start(2246267895833L);
                proto.write(0x10900000001L, wakelocks.keyAt(iw));
                BatteryStats.dumpTimer(proto, 1146756268034L, wl.getWakeTime(1), rawRealtimeUs, 0);
                Timer pTimer = wl.getWakeTime(0);
                if (pTimer != null) {
                    BatteryStats.dumpTimer(proto, 1146756268035L, pTimer, rawRealtimeUs, 0);
                    BatteryStats.dumpTimer(proto, 1146756268036L, pTimer.getSubTimer(), rawRealtimeUs, 0);
                }
                BatteryStats.dumpTimer(proto, 1146756268037L, wl.getWakeTime(2), rawRealtimeUs, 0);
                proto.end(wToken);
            }
            BatteryStats.dumpTimer(proto, 1146756268060L, u.getMulticastWakelockStats(), rawRealtimeUs, 0);
            for (int ipkg = packageStats.size() - 1; ipkg >= 0; --ipkg) {
                Uid.Pkg ps = packageStats.valueAt(ipkg);
                ArrayMap<String, ? extends Counter> alarms = ps.getWakeupAlarmStats();
                for (int iwa = alarms.size() - 1; iwa >= 0; --iwa) {
                    long waToken = proto.start(2246267895834L);
                    proto.write(0x10900000001L, alarms.keyAt(iwa));
                    proto.write(1120986464258L, alarms.valueAt(iwa).getCountLocked(0));
                    proto.end(waToken);
                }
            }
            BatteryStats.dumpControllerActivityProto(proto, 1146756268037L, u.getWifiControllerActivity(), 0);
            long wToken = proto.start(0x10B0000001BL);
            proto.write(0x10300000001L, BatteryStats.roundUsToMs(u.getFullWifiLockTime(rawRealtimeUs, 0)));
            BatteryStats.dumpTimer(proto, 1146756268035L, u.getWifiScanTimer(), rawRealtimeUs, 0);
            proto.write(1112396529666L, BatteryStats.roundUsToMs(u.getWifiRunningTime(rawRealtimeUs, 0)));
            BatteryStats.dumpTimer(proto, 1146756268036L, u.getWifiScanBackgroundTimer(), rawRealtimeUs, 0);
            proto.end(wToken);
            proto.end(uTkn);
        }
    }

    private void dumpProtoHistoryLocked(ProtoOutputStream proto, int flags, long histStart) {
        proto.write(0x10500000001L, 36);
        proto.write(1112396529666L, this.getParcelVersion());
        proto.write(1138166333443L, this.getStartPlatformVersion());
        proto.write(1138166333444L, this.getEndPlatformVersion());
        for (int i = 0; i < this.getHistoryStringPoolSize(); ++i) {
            long token = proto.start(2246267895813L);
            proto.write(0x10500000001L, i);
            proto.write(1120986464258L, this.getHistoryTagPoolUid(i));
            proto.write(1138166333443L, this.getHistoryTagPoolString(i));
            proto.end(token);
        }
        HistoryPrinter hprinter = new HistoryPrinter(flags);
        long lastTime = -1L;
        long baseTime = -1L;
        boolean printed = false;
        HistoryEventTracker tracker = null;
        try (BatteryStatsHistoryIterator iterator = this.iterateBatteryStatsHistory(0L, -1L);){
            HistoryItem rec;
            while ((rec = iterator.next()) != null) {
                lastTime = rec.time;
                if (baseTime < 0L) {
                    baseTime = lastTime;
                }
                if (rec.time < histStart) continue;
                if (histStart >= 0L && !printed) {
                    if (rec.cmd == 5 || rec.cmd == 7 || rec.cmd == 4 || rec.cmd == 8) {
                        printed = true;
                        hprinter.printNextItem(proto, rec, baseTime, (flags & 0x20) != 0);
                        rec.cmd = 0;
                    } else if (rec.currentTime != 0L) {
                        printed = true;
                        byte cmd = rec.cmd;
                        rec.cmd = (byte)5;
                        hprinter.printNextItem(proto, rec, baseTime, (flags & 0x20) != 0);
                        rec.cmd = cmd;
                    }
                    if (tracker != null) {
                        if (rec.cmd != 0) {
                            hprinter.printNextItem(proto, rec, baseTime, (flags & 0x20) != 0);
                            rec.cmd = 0;
                        }
                        int oldEventCode = rec.eventCode;
                        HistoryTag oldEventTag = rec.eventTag;
                        rec.eventTag = new HistoryTag();
                        for (int i = 0; i < 23; ++i) {
                            HashMap<String, SparseIntArray> active = tracker.getStateForEvent(i);
                            if (active == null) continue;
                            for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                                SparseIntArray uids = ent.getValue();
                                for (int j = 0; j < uids.size(); ++j) {
                                    rec.eventCode = i;
                                    rec.eventTag.string = ent.getKey();
                                    rec.eventTag.uid = uids.keyAt(j);
                                    rec.eventTag.poolIdx = uids.valueAt(j);
                                    hprinter.printNextItem(proto, rec, baseTime, (flags & 0x20) != 0);
                                    rec.wakeReasonTag = null;
                                    rec.wakelockTag = null;
                                }
                            }
                        }
                        rec.eventCode = oldEventCode;
                        rec.eventTag = oldEventTag;
                        tracker = null;
                    }
                }
                hprinter.printNextItem(proto, rec, baseTime, (flags & 0x20) != 0);
            }
            if (histStart >= 0L) {
                this.commitCurrentHistoryBatchLocked();
                proto.write(2237677961222L, "NEXT: " + (lastTime + 1L));
            }
        }
    }

    private void dumpProtoSystemLocked(ProtoOutputStream proto, BatteryUsageStats stats) {
        int i;
        int i2;
        long sToken = proto.start(1146756268038L);
        long rawUptimeUs = SystemClock.uptimeMillis() * 1000L;
        long rawRealtimeMs = SystemClock.elapsedRealtime();
        long rawRealtimeUs = rawRealtimeMs * 1000L;
        boolean which = false;
        long bToken = proto.start(0x10B00000001L);
        proto.write(0x10300000001L, this.getStartClockTime());
        proto.write(1112396529666L, this.getStartCount());
        proto.write(0x10300000003L, this.computeRealtime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529668L, this.computeUptime(rawUptimeUs, 0) / 1000L);
        proto.write(1112396529669L, this.computeBatteryRealtime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529670L, this.computeBatteryUptime(rawUptimeUs, 0) / 1000L);
        proto.write(1112396529671L, this.computeBatteryScreenOffRealtime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529672L, this.computeBatteryScreenOffUptime(rawUptimeUs, 0) / 1000L);
        proto.write(1112396529673L, this.getScreenDozeTime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529674L, this.getEstimatedBatteryCapacity());
        proto.write(1112396529675L, this.getMinLearnedBatteryCapacity());
        proto.write(1112396529676L, this.getMaxLearnedBatteryCapacity());
        proto.end(bToken);
        long bdToken = proto.start(1146756268034L);
        proto.write(0x10500000001L, this.getLowDischargeAmountSinceCharge());
        proto.write(1120986464258L, this.getHighDischargeAmountSinceCharge());
        proto.write(1120986464259L, this.getDischargeAmountScreenOnSinceCharge());
        proto.write(1120986464260L, this.getDischargeAmountScreenOffSinceCharge());
        proto.write(0x10500000005L, this.getDischargeAmountScreenDozeSinceCharge());
        proto.write(1112396529670L, this.getUahDischarge(0) / 1000L);
        proto.write(1112396529671L, this.getUahDischargeScreenOff(0) / 1000L);
        proto.write(1112396529672L, this.getUahDischargeScreenDoze(0) / 1000L);
        proto.write(1112396529673L, this.getUahDischargeLightDoze(0) / 1000L);
        proto.write(1112396529674L, this.getUahDischargeDeepDoze(0) / 1000L);
        proto.end(bdToken);
        long timeRemainingUs = this.computeChargeTimeRemaining(rawRealtimeUs);
        if (timeRemainingUs >= 0L) {
            proto.write(0x10300000003L, timeRemainingUs / 1000L);
        } else {
            timeRemainingUs = this.computeBatteryTimeRemaining(rawRealtimeUs);
            if (timeRemainingUs >= 0L) {
                proto.write(1112396529668L, timeRemainingUs / 1000L);
            } else {
                proto.write(1112396529668L, -1);
            }
        }
        BatteryStats.dumpDurationSteps(proto, 2246267895813L, this.getChargeLevelStepTracker());
        for (int i3 = 0; i3 < NUM_DATA_CONNECTION_TYPES; ++i3) {
            boolean isNone = i3 == 0;
            int telephonyNetworkType = i3;
            if (i3 == DATA_CONNECTION_OTHER || i3 == DATA_CONNECTION_EMERGENCY_SERVICE) {
                telephonyNetworkType = 0;
            }
            long pdcToken = proto.start(2246267895816L);
            if (isNone) {
                proto.write(1133871366146L, isNone);
            } else {
                proto.write(0x10E00000001L, telephonyNetworkType);
            }
            BatteryStats.dumpTimer(proto, 1146756268035L, this.getPhoneDataConnectionTimer(i3), rawRealtimeUs, 0);
            proto.end(pdcToken);
        }
        BatteryStats.dumpDurationSteps(proto, 2246267895814L, this.getDischargeLevelStepTracker());
        CpuScalingPolicies scalingPolicies = this.getCpuScalingPolicies();
        if (scalingPolicies != null) {
            for (int policy : scalingPolicies.getPolicies()) {
                for (int frequency : scalingPolicies.getFrequencies(policy)) {
                    proto.write(2211908157447L, frequency);
                }
            }
        }
        BatteryStats.dumpControllerActivityProto(proto, 1146756268041L, this.getBluetoothControllerActivity(), 0);
        BatteryStats.dumpControllerActivityProto(proto, 1146756268042L, this.getModemControllerActivity(), 0);
        long gnToken = proto.start(1146756268044L);
        proto.write(0x10300000001L, this.getNetworkActivityBytes(0, 0));
        proto.write(1112396529666L, this.getNetworkActivityBytes(1, 0));
        proto.write(1112396529669L, this.getNetworkActivityPackets(0, 0));
        proto.write(1112396529670L, this.getNetworkActivityPackets(1, 0));
        proto.write(0x10300000003L, this.getNetworkActivityBytes(2, 0));
        proto.write(1112396529668L, this.getNetworkActivityBytes(3, 0));
        proto.write(1112396529671L, this.getNetworkActivityPackets(2, 0));
        proto.write(1112396529672L, this.getNetworkActivityPackets(3, 0));
        proto.write(1112396529673L, this.getNetworkActivityBytes(4, 0));
        proto.write(1112396529674L, this.getNetworkActivityBytes(5, 0));
        proto.end(gnToken);
        BatteryStats.dumpControllerActivityProto(proto, 0x10B0000000BL, this.getWifiControllerActivity(), 0);
        long gwToken = proto.start(1146756268045L);
        proto.write(0x10300000001L, this.getWifiOnTime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529666L, this.getGlobalWifiRunningTime(rawRealtimeUs, 0) / 1000L);
        proto.end(gwToken);
        Map<String, ? extends Timer> kernelWakelocks = this.getKernelWakelockStats();
        for (Map.Entry<String, ? extends Timer> ent : kernelWakelocks.entrySet()) {
            long kwToken = proto.start(2246267895822L);
            proto.write(0x10900000001L, ent.getKey());
            BatteryStats.dumpTimer(proto, 1146756268034L, ent.getValue(), rawRealtimeUs, 0);
            proto.end(kwToken);
        }
        long fullWakeLockTimeTotalUs = 0L;
        long partialWakeLockTimeTotalUs = 0L;
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        for (int iu = 0; iu < uidStats.size(); ++iu) {
            Uid u = uidStats.valueAt(iu);
            ArrayMap<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            for (int iw = wakelocks.size() - 1; iw >= 0; --iw) {
                Timer partialWakeTimer;
                Uid.Wakelock wl = wakelocks.valueAt(iw);
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotalUs += fullWakeTimer.getTotalTimeLocked(rawRealtimeUs, 0);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null) continue;
                partialWakeLockTimeTotalUs += partialWakeTimer.getTotalTimeLocked(rawRealtimeUs, 0);
            }
        }
        long mToken = proto.start(1146756268047L);
        proto.write(0x10300000001L, this.getScreenOnTime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529666L, this.getPhoneOnTime(rawRealtimeUs, 0) / 1000L);
        proto.write(0x10300000003L, fullWakeLockTimeTotalUs / 1000L);
        proto.write(1112396529668L, partialWakeLockTimeTotalUs / 1000L);
        proto.write(1112396529669L, this.getMobileRadioActiveTime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529670L, this.getMobileRadioActiveAdjustedTime(0) / 1000L);
        proto.write(1120986464263L, this.getMobileRadioActiveCount(0));
        proto.write(1120986464264L, this.getMobileRadioActiveUnknownTime(0) / 1000L);
        proto.write(1112396529673L, this.getInteractiveTime(rawRealtimeUs, 0) / 1000L);
        proto.write(1112396529674L, this.getPowerSaveModeEnabledTime(rawRealtimeUs, 0) / 1000L);
        proto.write(1120986464267L, this.getNumConnectivityChange(0));
        proto.write(1112396529676L, this.getDeviceIdleModeTime(2, rawRealtimeUs, 0) / 1000L);
        proto.write(1120986464269L, this.getDeviceIdleModeCount(2, 0));
        proto.write(1112396529678L, this.getDeviceIdlingTime(2, rawRealtimeUs, 0) / 1000L);
        proto.write(1120986464271L, this.getDeviceIdlingCount(2, 0));
        proto.write(0x10300000010L, this.getLongestDeviceIdleModeTime(2));
        proto.write(0x10300000011L, this.getDeviceIdleModeTime(1, rawRealtimeUs, 0) / 1000L);
        proto.write(1120986464274L, this.getDeviceIdleModeCount(1, 0));
        proto.write(0x10300000013L, this.getDeviceIdlingTime(1, rawRealtimeUs, 0) / 1000L);
        proto.write(1120986464276L, this.getDeviceIdlingCount(1, 0));
        proto.write(1112396529685L, this.getLongestDeviceIdleModeTime(1));
        proto.end(mToken);
        long multicastWakeLockTimeTotalUs = this.getWifiMulticastWakelockTime(rawRealtimeUs, 0);
        int multicastWakeLockCountTotal = this.getWifiMulticastWakelockCount(0);
        long wmctToken = proto.start(1146756268055L);
        proto.write(0x10300000001L, multicastWakeLockTimeTotalUs / 1000L);
        proto.write(1120986464258L, multicastWakeLockCountTotal);
        proto.end(wmctToken);
        AggregateBatteryConsumer deviceConsumer = stats.getAggregateBatteryConsumer(0);
        for (int powerComponent = 0; powerComponent < 19; ++powerComponent) {
            int n = 0;
            switch (powerComponent) {
                case 15: {
                    n = 13;
                    break;
                }
                case 16: {
                    n = 1;
                    break;
                }
                case 8: {
                    n = 2;
                    break;
                }
                case 14: {
                    n = 3;
                    break;
                }
                case 11: {
                    n = 4;
                    break;
                }
                case 2: {
                    n = 5;
                    break;
                }
                case 0: {
                    n = 7;
                    break;
                }
                case 6: {
                    n = 6;
                    break;
                }
                case 3: {
                    n = 11;
                    break;
                }
                case 13: {
                    n = 12;
                }
            }
            long puiToken = proto.start(2246267895825L);
            proto.write(0x10E00000001L, n);
            proto.write(1120986464258L, 0);
            proto.write(0x10100000003L, deviceConsumer.getConsumedPower(powerComponent));
            proto.write(1133871366148L, this.shouldHidePowerComponent(powerComponent));
            proto.write(0x10100000005L, 0);
            proto.write(0x10100000006L, 0);
            proto.end(puiToken);
        }
        long pusToken = proto.start(1146756268050L);
        proto.write(0x10100000001L, stats.getBatteryCapacity());
        proto.write(0x10100000002L, stats.getConsumedPower());
        proto.write(0x10100000003L, stats.getDischargedPowerRange().getLower());
        proto.write(0x10100000004L, stats.getDischargedPowerRange().getUpper());
        proto.end(pusToken);
        Map<String, ? extends Timer> rpmStats = this.getRpmStats();
        Map<String, ? extends Timer> screenOffRpmStats = this.getScreenOffRpmStats();
        for (Map.Entry<String, ? extends Timer> ent : rpmStats.entrySet()) {
            long rpmToken = proto.start(2246267895827L);
            proto.write(0x10900000001L, ent.getKey());
            BatteryStats.dumpTimer(proto, 1146756268034L, ent.getValue(), rawRealtimeUs, 0);
            BatteryStats.dumpTimer(proto, 1146756268035L, screenOffRpmStats.get(ent.getKey()), rawRealtimeUs, 0);
            proto.end(rpmToken);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            long sbToken = proto.start(2246267895828L);
            proto.write(0x10E00000001L, i2);
            BatteryStats.dumpTimer(proto, 1146756268034L, this.getScreenBrightnessTimer(i2), rawRealtimeUs, 0);
            proto.end(sbToken);
        }
        BatteryStats.dumpTimer(proto, 1146756268053L, this.getPhoneSignalScanningTimer(), rawRealtimeUs, 0);
        for (i2 = 0; i2 < CellSignalStrength.getNumSignalStrengthLevels(); ++i2) {
            long pssToken = proto.start(2246267895824L);
            proto.write(0x10E00000001L, i2);
            BatteryStats.dumpTimer(proto, 1146756268034L, this.getPhoneSignalStrengthTimer(i2), rawRealtimeUs, 0);
            proto.end(pssToken);
        }
        Map<String, ? extends Timer> wakeupReasons = this.getWakeupReasonStats();
        for (Map.Entry<String, ? extends Timer> ent : wakeupReasons.entrySet()) {
            long wrToken = proto.start(2246267895830L);
            proto.write(0x10900000001L, ent.getKey());
            BatteryStats.dumpTimer(proto, 1146756268034L, ent.getValue(), rawRealtimeUs, 0);
            proto.end(wrToken);
        }
        for (i = 0; i < 5; ++i) {
            long wssToken = proto.start(2246267895832L);
            proto.write(0x10E00000001L, i);
            BatteryStats.dumpTimer(proto, 1146756268034L, this.getWifiSignalStrengthTimer(i), rawRealtimeUs, 0);
            proto.end(wssToken);
        }
        for (i = 0; i < 8; ++i) {
            long wsToken = proto.start(2246267895833L);
            proto.write(0x10E00000001L, i);
            BatteryStats.dumpTimer(proto, 1146756268034L, this.getWifiStateTimer(i), rawRealtimeUs, 0);
            proto.end(wsToken);
        }
        for (i = 0; i < 13; ++i) {
            long wssToken = proto.start(2246267895834L);
            proto.write(0x10E00000001L, i);
            BatteryStats.dumpTimer(proto, 1146756268034L, this.getWifiSupplStateTimer(i), rawRealtimeUs, 0);
            proto.end(wssToken);
        }
        proto.end(sToken);
    }

    public static boolean checkWifiOnly(Context context) {
        TelephonyManager tm = context.getSystemService(TelephonyManager.class);
        if (tm == null) {
            return false;
        }
        return !tm.isDataCapable();
    }

    private boolean shouldHidePowerComponent(int powerComponent) {
        return powerComponent == 16 || powerComponent == 8 || powerComponent == 0 || powerComponent == 15;
    }

    private List<UidMobileRadioStats> getUidMobileRadioStats(List<UidBatteryConsumer> uidBatteryConsumers) {
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        ArrayList<UidMobileRadioStats> uidMobileRadioStats = Lists.newArrayList();
        for (int i = 0; i < uidBatteryConsumers.size(); ++i) {
            int uid;
            Uid u;
            UidBatteryConsumer consumer = uidBatteryConsumers.get(i);
            if (consumer.getConsumedPower(8) == 0.0 || (u = uidStats.get(uid = consumer.getUid())) == null) continue;
            long rxPackets = u.getNetworkActivityPackets(0, 0);
            long txPackets = u.getNetworkActivityPackets(1, 0);
            if (rxPackets == 0L && txPackets == 0L) continue;
            long radioActiveMs = u.getMobileRadioActiveTime(0) / 1000L;
            int radioActiveCount = u.getMobileRadioActiveCount(0);
            double msPerPacket = (double)radioActiveMs / (double)(rxPackets + txPackets);
            if (msPerPacket == 0.0) continue;
            uidMobileRadioStats.add(new UidMobileRadioStats(uid, rxPackets, txPackets, radioActiveMs, radioActiveCount, msPerPacket));
        }
        uidMobileRadioStats.sort((lhs, rhs) -> Double.compare(rhs.millisecondsPerPacket, lhs.millisecondsPerPacket));
        return uidMobileRadioStats;
    }

    @RavenwoodReplace
    @VisibleForTesting
    protected static boolean isLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    protected static boolean isLowRamDevice$ravenwood() {
        return false;
    }

    @RavenwoodReplace
    @VisibleForTesting
    protected static int getCellSignalStrengthLevelCount() {
        return CellSignalStrength.getNumSignalStrengthLevels();
    }

    protected static int getCellSignalStrengthLevelCount$ravenwood() {
        return 5;
    }

    @RavenwoodReplace
    @VisibleForTesting
    protected static int getModemTxPowerLevelCount() {
        return ModemActivityInfo.getNumTxPowerLevels();
    }

    protected static int getModemTxPowerLevelCount$ravenwood() {
        return 5;
    }

    @RavenwoodReplace
    @VisibleForTesting
    protected static boolean isKernelStatsAvailable() {
        return true;
    }

    protected static boolean isKernelStatsAvailable$ravenwood() {
        return false;
    }

    @RavenwoodReplace
    protected static int getDisplayTransport(int[] transports) {
        return NetworkCapabilitiesUtils.getDisplayTransport(transports);
    }

    protected static int getDisplayTransport$ravenwood(int[] transports) {
        for (int transport : DISPLAY_TRANSPORT_PRIORITIES) {
            for (int t : transports) {
                if (t != transport) continue;
                return transport;
            }
        }
        return transports[0];
    }

    static {
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[0] = "scrn";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[1] = CPU_DATA;
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[2] = "blue";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[3] = "camera";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[4] = "audio";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[5] = "video";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[6] = "flashlight";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[8] = "cell";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[9] = "sensors";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[10] = "gnss";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[11] = "wifi";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[13] = "memory";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[14] = "phone";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[15] = "ambi";
        BatteryStats.CHECKIN_POWER_COMPONENT_LABELS[16] = "idle";
        DISPLAY_TRANSPORT_PRIORITIES = new int[]{4, 0, 5, 2, 1, 3, 8};
    }

    public static abstract class Uid {
        public static final int PROCESS_STATE_TOP = 0;
        public static final int PROCESS_STATE_FOREGROUND_SERVICE = 1;
        public static final int PROCESS_STATE_FOREGROUND = 2;
        public static final int PROCESS_STATE_BACKGROUND = 3;
        public static final int PROCESS_STATE_TOP_SLEEPING = 4;
        public static final int PROCESS_STATE_HEAVY_WEIGHT = 5;
        public static final int PROCESS_STATE_CACHED = 6;
        public static final int NUM_PROCESS_STATE = 7;
        public static final int PROCESS_STATE_NONEXISTENT = 7;
        static final String[] PROCESS_STATE_NAMES = new String[]{"Top", "Fg Service", "Foreground", "Background", "Top Sleeping", "Heavy Weight", "Cached"};
        @VisibleForTesting
        public static final String[] UID_PROCESS_TYPES = new String[]{"T", "FS", "F", "B", "TS", "HW", "C"};
        public static final int NUM_WIFI_BATCHED_SCAN_BINS = 5;
        static final String[] USER_ACTIVITY_TYPES = new String[]{"other", "button", "touch", "accessibility", "attention", "faceDown", "deviceState"};
        public static final int NUM_USER_ACTIVITY_TYPES = USER_ACTIVITY_TYPES.length;

        @UnsupportedAppUsage
        public Uid() {
        }

        @UnsupportedAppUsage
        public abstract ArrayMap<String, ? extends Wakelock> getWakelockStats();

        public abstract Timer getMulticastWakelockStats();

        public abstract ArrayMap<String, ? extends Timer> getSyncStats();

        public abstract ArrayMap<String, ? extends Timer> getJobStats();

        public abstract ArrayMap<String, SparseIntArray> getJobCompletionStats();

        public abstract Timer getAggregatedPartialWakelockTimer();

        @UnsupportedAppUsage
        public abstract SparseArray<? extends Sensor> getSensorStats();

        public abstract SparseArray<? extends Pid> getPidStats();

        @UnsupportedAppUsage
        public abstract ArrayMap<String, ? extends Proc> getProcessStats();

        @UnsupportedAppUsage
        public abstract ArrayMap<String, ? extends Pkg> getPackageStats();

        public abstract ControllerActivityCounter getWifiControllerActivity();

        public abstract ControllerActivityCounter getBluetoothControllerActivity();

        public abstract ControllerActivityCounter getModemControllerActivity();

        @UnsupportedAppUsage
        public abstract int getUid();

        public abstract void noteWifiRunningLocked(long var1);

        public abstract void noteWifiStoppedLocked(long var1);

        public abstract void noteFullWifiLockAcquiredLocked(long var1);

        public abstract void noteFullWifiLockReleasedLocked(long var1);

        public abstract void noteWifiScanStartedLocked(long var1);

        public abstract void noteWifiScanStoppedLocked(long var1);

        public abstract void noteWifiBatchedScanStartedLocked(int var1, long var2);

        public abstract void noteWifiBatchedScanStoppedLocked(long var1);

        public abstract void noteWifiMulticastEnabledLocked(long var1);

        public abstract void noteWifiMulticastDisabledLocked(long var1);

        public abstract void noteActivityResumedLocked(long var1);

        public abstract void noteActivityPausedLocked(long var1);

        @UnsupportedAppUsage
        public abstract long getWifiRunningTime(long var1, int var3);

        @UnsupportedAppUsage
        public abstract long getFullWifiLockTime(long var1, int var3);

        @UnsupportedAppUsage
        public abstract long getWifiScanTime(long var1, int var3);

        public abstract int getWifiScanCount(int var1);

        public abstract Timer getWifiScanTimer();

        public abstract int getWifiScanBackgroundCount(int var1);

        public abstract long getWifiScanActualTime(long var1);

        public abstract long getWifiScanBackgroundTime(long var1);

        public abstract Timer getWifiScanBackgroundTimer();

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public abstract long getWifiBatchedScanTime(int var1, long var2, int var4);

        public abstract int getWifiBatchedScanCount(int var1, int var2);

        @UnsupportedAppUsage
        public abstract long getWifiMulticastTime(long var1, int var3);

        @UnsupportedAppUsage
        public abstract Timer getAudioTurnedOnTimer();

        @UnsupportedAppUsage
        public abstract Timer getVideoTurnedOnTimer();

        public abstract Timer getFlashlightTurnedOnTimer();

        public abstract Timer getCameraTurnedOnTimer();

        public abstract Timer getForegroundActivityTimer();

        public abstract Timer getForegroundServiceTimer();

        public abstract Timer getBluetoothScanTimer();

        public abstract Timer getBluetoothScanBackgroundTimer();

        public abstract Timer getBluetoothUnoptimizedScanTimer();

        public abstract Timer getBluetoothUnoptimizedScanBackgroundTimer();

        public abstract Counter getBluetoothScanResultCounter();

        public abstract Counter getBluetoothScanResultBgCounter();

        public abstract long[] getCpuFreqTimes(int var1);

        public abstract long[] getScreenOffCpuFreqTimes(int var1);

        public abstract long getCpuActiveTime();

        public abstract long getCpuActiveTime(int var1);

        public abstract long[] getCpuClusterTimes();

        public abstract boolean getCpuFreqTimes(@NonNull long[] var1, int var2);

        public abstract boolean getScreenOffCpuFreqTimes(@NonNull long[] var1, int var2);

        public abstract long getProcessStateTime(int var1, long var2, int var4);

        public abstract Timer getProcessStateTimer(int var1);

        public abstract Timer getVibratorOnTimer();

        public abstract void noteUserActivityLocked(int var1);

        public abstract boolean hasUserActivity();

        public abstract int getUserActivityCount(int var1, int var2);

        public abstract boolean hasNetworkActivity();

        @UnsupportedAppUsage
        public abstract long getNetworkActivityBytes(int var1, int var2);

        public abstract long getNetworkActivityPackets(int var1, int var2);

        @UnsupportedAppUsage
        public abstract long getMobileRadioActiveTime(int var1);

        public abstract long getMobileRadioActiveTimeInProcessState(int var1);

        public abstract int getMobileRadioActiveCount(int var1);

        public abstract long getUserCpuTimeUs(int var1);

        public abstract long getSystemCpuTimeUs(int var1);

        @Deprecated
        public abstract long getTimeAtCpuSpeed(int var1, int var2, int var3);

        public abstract long getMobileRadioApWakeupCount(int var1);

        public abstract long getWifiRadioApWakeupCount(int var1);

        public abstract void getDeferredJobsCheckinLineLocked(StringBuilder var1, int var2);

        public abstract void getDeferredJobsLineLocked(StringBuilder var1, int var2);

        public static abstract class Pkg {
            @UnsupportedAppUsage(maxTargetSdk=28)
            public Pkg() {
            }

            @UnsupportedAppUsage
            public abstract ArrayMap<String, ? extends Counter> getWakeupAlarmStats();

            @UnsupportedAppUsage
            public abstract ArrayMap<String, ? extends Serv> getServiceStats();

            public static abstract class Serv {
                @UnsupportedAppUsage
                public abstract long getStartTime(long var1, int var3);

                @UnsupportedAppUsage
                public abstract int getStarts(int var1);

                @UnsupportedAppUsage
                public abstract int getLaunches(int var1);
            }
        }

        public static abstract class Proc {
            @UnsupportedAppUsage(maxTargetSdk=28)
            public Proc() {
            }

            public abstract boolean isActive();

            @UnsupportedAppUsage
            public abstract long getUserTime(int var1);

            @UnsupportedAppUsage
            public abstract long getSystemTime(int var1);

            @UnsupportedAppUsage
            public abstract int getStarts(int var1);

            public abstract int getNumCrashes(int var1);

            public abstract int getNumAnrs(int var1);

            @UnsupportedAppUsage
            public abstract long getForegroundTime(int var1);

            @UnsupportedAppUsage
            public abstract int countExcessivePowers();

            @UnsupportedAppUsage
            public abstract ExcessivePower getExcessivePower(int var1);

            public static class ExcessivePower {
                public static final int TYPE_WAKE = 1;
                public static final int TYPE_CPU = 2;
                @UnsupportedAppUsage
                public int type;
                @UnsupportedAppUsage
                public long overTime;
                @UnsupportedAppUsage
                public long usedTime;

                @UnsupportedAppUsage
                public ExcessivePower() {
                }
            }
        }

        public class Pid {
            public int mWakeNesting;
            public long mWakeSumMs;
            public long mWakeStartMs;

            public Pid(Uid this$0) {
            }
        }

        public static abstract class Sensor {
            @UnsupportedAppUsage
            public static final int GPS = -10000;

            @UnsupportedAppUsage(maxTargetSdk=28)
            public Sensor() {
            }

            @UnsupportedAppUsage
            public abstract int getHandle();

            @UnsupportedAppUsage
            public abstract Timer getSensorTime();

            public abstract Timer getSensorBackgroundTime();
        }

        public static abstract class Wakelock {
            @UnsupportedAppUsage(maxTargetSdk=28)
            public Wakelock() {
            }

            @UnsupportedAppUsage
            public abstract Timer getWakeTime(int var1);
        }
    }

    public static abstract class Timer {
        @UnsupportedAppUsage(maxTargetSdk=28)
        public Timer() {
        }

        @UnsupportedAppUsage
        public abstract int getCountLocked(int var1);

        @UnsupportedAppUsage
        public abstract long getTotalTimeLocked(long var1, int var3);

        public abstract long getTimeSinceMarkLocked(long var1);

        public long getMaxDurationMsLocked(long elapsedRealtimeMs) {
            return -1L;
        }

        public long getCurrentDurationMsLocked(long elapsedRealtimeMs) {
            return -1L;
        }

        public long getTotalDurationMsLocked(long elapsedRealtimeMs) {
            return -1L;
        }

        public Timer getSubTimer() {
            return null;
        }

        public boolean isRunningLocked() {
            return false;
        }

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class ControllerActivityCounter {
        public abstract LongCounter getIdleTimeCounter();

        public abstract LongCounter getScanTimeCounter();

        public abstract LongCounter getSleepTimeCounter();

        public abstract LongCounter getRxTimeCounter();

        public abstract LongCounter[] getTxTimeCounters();

        public abstract LongCounter getPowerCounter();

        public abstract LongCounter getMonitoredRailChargeConsumedMaMs();
    }

    @RavenwoodKeepWholeClass
    public static abstract class LongCounter {
        public abstract long getCountLocked(int var1);

        public abstract long getCountForProcessState(int var1);

        public abstract void logState(Printer var1, String var2);
    }

    public static interface BatteryStatsDumpHelper {
        public BatteryUsageStats getBatteryUsageStats(BatteryStats var1, boolean var2);
    }

    private static class ProportionalAttributionCalculator {
        private static final double SYSTEM_BATTERY_CONSUMER = -1.0;
        private final PackageManager mPackageManager;
        private final HashSet<String> mSystemAndServicePackages;
        private final SparseDoubleArray mProportionalPowerMah;

        ProportionalAttributionCalculator(Context context, BatteryUsageStats stats) {
            this.mPackageManager = context.getPackageManager();
            Resources resources = context.getResources();
            String[] systemPackageArray = resources.getStringArray(17236006);
            String[] servicePackageArray = resources.getStringArray(17236005);
            this.mSystemAndServicePackages = new HashSet(systemPackageArray.length + servicePackageArray.length);
            for (String packageName : systemPackageArray) {
                this.mSystemAndServicePackages.add(packageName);
            }
            for (String packageName : servicePackageArray) {
                this.mSystemAndServicePackages.add(packageName);
            }
            List<UidBatteryConsumer> uidBatteryConsumers = stats.getUidBatteryConsumers();
            this.mProportionalPowerMah = new SparseDoubleArray(uidBatteryConsumers.size());
            double systemPowerMah = 0.0;
            for (int i = uidBatteryConsumers.size() - 1; i >= 0; --i) {
                UidBatteryConsumer consumer = uidBatteryConsumers.get(i);
                int uid = consumer.getUid();
                if (!this.isSystemUid(uid)) continue;
                this.mProportionalPowerMah.put(uid, -1.0);
                systemPowerMah += consumer.getConsumedPower();
            }
            double totalRemainingPower = stats.getConsumedPower() - systemPowerMah;
            if (Math.abs(totalRemainingPower) > 0.001) {
                for (int i = uidBatteryConsumers.size() - 1; i >= 0; --i) {
                    UidBatteryConsumer consumer = uidBatteryConsumers.get(i);
                    int uid = consumer.getUid();
                    if (this.mProportionalPowerMah.get(uid) == -1.0) continue;
                    double power = consumer.getConsumedPower();
                    this.mProportionalPowerMah.put(uid, power + systemPowerMah * power / totalRemainingPower);
                }
            }
        }

        boolean isSystemBatteryConsumer(UidBatteryConsumer consumer) {
            return this.mProportionalPowerMah.get(consumer.getUid()) < 0.0;
        }

        double getProportionalPowerMah(UidBatteryConsumer consumer) {
            double powerMah = this.mProportionalPowerMah.get(consumer.getUid());
            return powerMah >= 0.0 ? powerMah : 0.0;
        }

        private boolean isSystemUid(int uid) {
            if (uid >= 0 && uid < 10000) {
                return true;
            }
            String[] packages = this.mPackageManager.getPackagesForUid(uid);
            if (packages == null) {
                return false;
            }
            for (String packageName : packages) {
                if (!this.mSystemAndServicePackages.contains(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class Counter {
        @UnsupportedAppUsage(maxTargetSdk=28)
        public Counter() {
        }

        @UnsupportedAppUsage
        public abstract int getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }

    static class TimerEntry {
        final String mName;
        final int mId;
        final Timer mTimer;
        final long mTime;

        TimerEntry(String name, int id2, Timer timer, long time) {
            this.mName = name;
            this.mId = id2;
            this.mTimer = timer;
            this.mTime = time;
        }
    }

    private static class UidMobileRadioStats {
        public final int uid;
        public final long rxPackets;
        public final long txPackets;
        public final long radioActiveMs;
        public final int radioActiveCount;
        public final double millisecondsPerPacket;

        private UidMobileRadioStats(int uid, long rxPackets, long txPackets, long radioActiveMs, int radioActiveCount, double millisecondsPerPacket) {
            this.uid = uid;
            this.txPackets = txPackets;
            this.rxPackets = rxPackets;
            this.radioActiveMs = radioActiveMs;
            this.radioActiveCount = radioActiveCount;
            this.millisecondsPerPacket = millisecondsPerPacket;
        }
    }

    public static class BitDescription {
        public final int mask;
        public final int shift;
        public final String name;
        public final String shortName;
        public final String[] values;
        public final String[] shortValues;

        public BitDescription(int mask, String name, String shortName) {
            this.mask = mask;
            this.shift = -1;
            this.name = name;
            this.shortName = shortName;
            this.values = null;
            this.shortValues = null;
        }

        public BitDescription(int mask, int shift, String name, String shortName, String[] values, String[] shortValues) {
            this.mask = mask;
            this.shift = shift;
            this.name = name;
            this.shortName = shortName;
            this.values = values;
            this.shortValues = shortValues;
        }
    }

    @RavenwoodKeepWholeClass
    public static class HistoryItem {
        @UnsupportedAppUsage(maxTargetSdk=28)
        public HistoryItem next;
        @UnsupportedAppUsage
        public long time;
        public long currentTime;
        @UnsupportedAppUsage
        public static final byte CMD_UPDATE = 0;
        public static final byte CMD_NULL = -1;
        public static final byte CMD_START = 4;
        public static final byte CMD_CURRENT_TIME = 5;
        public static final byte CMD_OVERFLOW = 6;
        public static final byte CMD_RESET = 7;
        public static final byte CMD_SHUTDOWN = 8;
        @UnsupportedAppUsage
        public byte cmd = (byte)-1;
        @UnsupportedAppUsage
        public byte batteryLevel;
        @UnsupportedAppUsage
        public byte batteryStatus;
        @UnsupportedAppUsage
        public byte batteryHealth;
        @UnsupportedAppUsage
        public byte batteryPlugType;
        public short batteryTemperature;
        @UnsupportedAppUsage
        public short batteryVoltage;
        public int batteryChargeUah;
        public double modemRailChargeMah;
        public double wifiRailChargeMah;
        public static final int STATE_BRIGHTNESS_SHIFT = 0;
        public static final int STATE_BRIGHTNESS_MASK = 7;
        public static final int STATE_PHONE_SIGNAL_STRENGTH_SHIFT = 3;
        public static final int STATE_PHONE_SIGNAL_STRENGTH_MASK = 56;
        public static final int STATE_PHONE_STATE_SHIFT = 6;
        public static final int STATE_PHONE_STATE_MASK = 448;
        public static final int STATE_DATA_CONNECTION_SHIFT = 9;
        public static final int STATE_DATA_CONNECTION_MASK = 15872;
        public static final int STATE_CPU_RUNNING_FLAG = Integer.MIN_VALUE;
        public static final int STATE_WAKE_LOCK_FLAG = 0x40000000;
        public static final int STATE_GPS_ON_FLAG = 0x20000000;
        public static final int STATE_WIFI_FULL_LOCK_FLAG = 0x10000000;
        public static final int STATE_WIFI_SCAN_FLAG = 0x8000000;
        public static final int STATE_WIFI_RADIO_ACTIVE_FLAG = 0x4000000;
        public static final int STATE_MOBILE_RADIO_ACTIVE_FLAG = 0x2000000;
        private static final int STATE_RESERVED_0 = 0x1000000;
        public static final int STATE_SENSOR_ON_FLAG = 0x800000;
        public static final int STATE_AUDIO_ON_FLAG = 0x400000;
        public static final int STATE_PHONE_SCANNING_FLAG = 0x200000;
        public static final int STATE_SCREEN_ON_FLAG = 0x100000;
        public static final int STATE_BATTERY_PLUGGED_FLAG = 524288;
        public static final int STATE_SCREEN_DOZE_FLAG = 262144;
        public static final int STATE_WIFI_MULTICAST_ON_FLAG = 65536;
        public static final int MOST_INTERESTING_STATES = 0x1C0000;
        public static final int SETTLE_TO_ZERO_STATES = -1900544;
        public static final int IMPORTANT_FOR_POWER_STATS_STATES = 0x60C00000;
        @UnsupportedAppUsage
        public int states;
        public static final int STATE2_WIFI_SUPPL_STATE_SHIFT = 0;
        public static final int STATE2_WIFI_SUPPL_STATE_MASK = 15;
        public static final int STATE2_WIFI_SIGNAL_STRENGTH_SHIFT = 4;
        public static final int STATE2_WIFI_SIGNAL_STRENGTH_MASK = 112;
        public static final int STATE2_GPS_SIGNAL_QUALITY_SHIFT = 7;
        public static final int STATE2_GPS_SIGNAL_QUALITY_MASK = 384;
        public static final int STATE2_NR_STATE_SHIFT = 9;
        public static final int STATE2_NR_STATE_MASK = 1536;
        public static final int STATE2_POWER_SAVE_FLAG = Integer.MIN_VALUE;
        public static final int STATE2_VIDEO_ON_FLAG = 0x40000000;
        public static final int STATE2_WIFI_RUNNING_FLAG = 0x20000000;
        public static final int STATE2_WIFI_ON_FLAG = 0x10000000;
        public static final int STATE2_FLASHLIGHT_FLAG = 0x8000000;
        public static final int STATE2_DEVICE_IDLE_SHIFT = 25;
        public static final int STATE2_DEVICE_IDLE_MASK = 0x6000000;
        public static final int STATE2_CHARGING_FLAG = 0x1000000;
        public static final int STATE2_PHONE_IN_CALL_FLAG = 0x800000;
        public static final int STATE2_BLUETOOTH_ON_FLAG = 0x400000;
        public static final int STATE2_CAMERA_FLAG = 0x200000;
        public static final int STATE2_BLUETOOTH_SCAN_FLAG = 0x100000;
        public static final int STATE2_CELLULAR_HIGH_TX_POWER_FLAG = 524288;
        public static final int STATE2_USB_DATA_LINK_FLAG = 262144;
        public static final int STATE2_EXTENSIONS_FLAG = 131072;
        public static final int MOST_INTERESTING_STATES2 = -1749024768;
        public static final int SETTLE_TO_ZERO_STATES2 = 1748959232;
        public static final int IMPORTANT_FOR_POWER_STATS_STATES2 = 1210057088;
        public static final int GNSS_SIGNAL_QUALITY_NONE = 2;
        @UnsupportedAppUsage
        public int states2;
        public HistoryTag wakelockTag;
        public HistoryTag wakeReasonTag;
        public HistoryStepDetails stepDetails;
        public PowerStats powerStats;
        public ProcessStateChange processStateChange;
        public static final int EVENT_FLAG_START = 32768;
        public static final int EVENT_FLAG_FINISH = 16384;
        public static final int EVENT_NONE = 0;
        public static final int EVENT_PROC = 1;
        public static final int EVENT_FOREGROUND = 2;
        public static final int EVENT_TOP = 3;
        public static final int EVENT_SYNC = 4;
        public static final int EVENT_WAKE_LOCK = 5;
        public static final int EVENT_JOB = 6;
        public static final int EVENT_USER_RUNNING = 7;
        public static final int EVENT_USER_FOREGROUND = 8;
        public static final int EVENT_CONNECTIVITY_CHANGED = 9;
        public static final int EVENT_ACTIVE = 10;
        public static final int EVENT_PACKAGE_INSTALLED = 11;
        public static final int EVENT_PACKAGE_UNINSTALLED = 12;
        public static final int EVENT_ALARM = 13;
        public static final int EVENT_COLLECT_EXTERNAL_STATS = 14;
        public static final int EVENT_PACKAGE_INACTIVE = 15;
        public static final int EVENT_PACKAGE_ACTIVE = 16;
        public static final int EVENT_TEMP_WHITELIST = 17;
        public static final int EVENT_SCREEN_WAKE_UP = 18;
        public static final int EVENT_WAKEUP_AP = 19;
        public static final int EVENT_LONG_WAKE_LOCK = 20;
        public static final int EVENT_STATE_CHANGE = 21;
        public static final int EVENT_DISPLAY_STATE_CHANGED = 22;
        public static final int EVENT_COUNT = 23;
        public static final int EVENT_TYPE_MASK = -49153;
        public static final int EVENT_PROC_START = 32769;
        public static final int EVENT_PROC_FINISH = 16385;
        public static final int EVENT_FOREGROUND_START = 32770;
        public static final int EVENT_FOREGROUND_FINISH = 16386;
        public static final int EVENT_TOP_START = 32771;
        public static final int EVENT_TOP_FINISH = 16387;
        public static final int EVENT_SYNC_START = 32772;
        public static final int EVENT_SYNC_FINISH = 16388;
        public static final int EVENT_WAKE_LOCK_START = 32773;
        public static final int EVENT_WAKE_LOCK_FINISH = 16389;
        public static final int EVENT_JOB_START = 32774;
        public static final int EVENT_JOB_FINISH = 16390;
        public static final int EVENT_USER_RUNNING_START = 32775;
        public static final int EVENT_USER_RUNNING_FINISH = 16391;
        public static final int EVENT_USER_FOREGROUND_START = 32776;
        public static final int EVENT_USER_FOREGROUND_FINISH = 16392;
        public static final int EVENT_ALARM_START = 32781;
        public static final int EVENT_ALARM_FINISH = 16397;
        public static final int EVENT_TEMP_WHITELIST_START = 32785;
        public static final int EVENT_TEMP_WHITELIST_FINISH = 16401;
        public static final int EVENT_LONG_WAKE_LOCK_START = 32788;
        public static final int EVENT_LONG_WAKE_LOCK_FINISH = 16404;
        public int eventCode;
        public HistoryTag eventTag;
        public int numReadInts;
        public final HistoryTag localWakelockTag = new HistoryTag();
        public final HistoryTag localWakeReasonTag = new HistoryTag();
        public final HistoryTag localEventTag = new HistoryTag();
        public final ProcessStateChange localProcessStateChange = new ProcessStateChange();
        public boolean tagsFirstOccurrence;

        public boolean isDeltaData() {
            return this.cmd == 0;
        }

        @UnsupportedAppUsage
        public HistoryItem() {
        }

        public HistoryItem(Parcel src) {
            this.readFromParcel(src);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.time);
            int bat = this.cmd & 0xFF | this.batteryLevel << 8 & 0xFF00 | this.batteryStatus << 16 & 0xF0000 | this.batteryHealth << 20 & 0xF00000 | this.batteryPlugType << 24 & 0xF000000 | (this.wakelockTag != null ? 0x10000000 : 0) | (this.wakeReasonTag != null ? 0x20000000 : 0) | (this.eventCode != 0 ? 0x40000000 : 0);
            dest.writeInt(bat);
            bat = this.batteryTemperature & 0xFFFF | this.batteryVoltage << 16 & 0xFFFF0000;
            dest.writeInt(bat);
            dest.writeInt(this.batteryChargeUah);
            dest.writeDouble(this.modemRailChargeMah);
            dest.writeDouble(this.wifiRailChargeMah);
            dest.writeInt(this.states);
            dest.writeInt(this.states2);
            if (this.wakelockTag != null) {
                this.wakelockTag.writeToParcel(dest, flags);
            }
            if (this.wakeReasonTag != null) {
                this.wakeReasonTag.writeToParcel(dest, flags);
            }
            if (this.eventCode != 0) {
                dest.writeInt(this.eventCode);
                this.eventTag.writeToParcel(dest, flags);
            }
            if (this.cmd == 5 || this.cmd == 7) {
                dest.writeLong(this.currentTime);
            }
        }

        public void readFromParcel(Parcel src) {
            int start = src.dataPosition();
            this.time = src.readLong();
            int bat = src.readInt();
            this.cmd = (byte)(bat & 0xFF);
            this.batteryLevel = (byte)(bat >> 8 & 0xFF);
            this.batteryStatus = (byte)(bat >> 16 & 0xF);
            this.batteryHealth = (byte)(bat >> 20 & 0xF);
            this.batteryPlugType = (byte)(bat >> 24 & 0xF);
            int bat2 = src.readInt();
            this.batteryTemperature = (short)(bat2 & 0xFFFF);
            this.batteryVoltage = (short)(bat2 >> 16 & 0xFFFF);
            this.batteryChargeUah = src.readInt();
            this.modemRailChargeMah = src.readDouble();
            this.wifiRailChargeMah = src.readDouble();
            this.states = src.readInt();
            this.states2 = src.readInt();
            if ((bat & 0x10000000) != 0) {
                this.wakelockTag = this.localWakelockTag;
                this.wakelockTag.readFromParcel(src);
            } else {
                this.wakelockTag = null;
            }
            if ((bat & 0x20000000) != 0) {
                this.wakeReasonTag = this.localWakeReasonTag;
                this.wakeReasonTag.readFromParcel(src);
            } else {
                this.wakeReasonTag = null;
            }
            if ((bat & 0x40000000) != 0) {
                this.eventCode = src.readInt();
                this.eventTag = this.localEventTag;
                this.eventTag.readFromParcel(src);
            } else {
                this.eventCode = 0;
                this.eventTag = null;
            }
            this.currentTime = this.cmd == 5 || this.cmd == 7 ? src.readLong() : 0L;
            this.numReadInts += (src.dataPosition() - start) / 4;
        }

        @UnsupportedAppUsage(maxTargetSdk=28)
        public void clear() {
            this.time = 0L;
            this.cmd = (byte)-1;
            this.batteryLevel = 0;
            this.batteryStatus = 0;
            this.batteryHealth = 0;
            this.batteryPlugType = 0;
            this.batteryTemperature = 0;
            this.batteryVoltage = 0;
            this.batteryChargeUah = 0;
            this.modemRailChargeMah = 0.0;
            this.wifiRailChargeMah = 0.0;
            this.states = 0;
            this.states2 = 256;
            this.wakelockTag = null;
            this.wakeReasonTag = null;
            this.eventCode = 0;
            this.eventTag = null;
            this.tagsFirstOccurrence = false;
            this.powerStats = null;
            this.processStateChange = null;
            this.stepDetails = null;
        }

        @UnsupportedAppUsage(maxTargetSdk=28)
        public void setTo(HistoryItem o) {
            this.time = o.time;
            this.cmd = o.cmd;
            this.setToCommon(o);
        }

        @UnsupportedAppUsage(maxTargetSdk=28)
        public void setTo(long time, byte cmd, HistoryItem o) {
            this.time = time;
            this.cmd = cmd;
            this.setToCommon(o);
        }

        private void setToCommon(HistoryItem o) {
            this.batteryLevel = o.batteryLevel;
            this.batteryStatus = o.batteryStatus;
            this.batteryHealth = o.batteryHealth;
            this.batteryPlugType = o.batteryPlugType;
            this.batteryTemperature = o.batteryTemperature;
            this.batteryVoltage = o.batteryVoltage;
            this.batteryChargeUah = o.batteryChargeUah;
            this.modemRailChargeMah = o.modemRailChargeMah;
            this.wifiRailChargeMah = o.wifiRailChargeMah;
            this.states = o.states;
            this.states2 = o.states2;
            if (o.wakelockTag != null) {
                this.wakelockTag = this.localWakelockTag;
                this.wakelockTag.setTo(o.wakelockTag);
            } else {
                this.wakelockTag = null;
            }
            if (o.wakeReasonTag != null) {
                this.wakeReasonTag = this.localWakeReasonTag;
                this.wakeReasonTag.setTo(o.wakeReasonTag);
            } else {
                this.wakeReasonTag = null;
            }
            this.eventCode = o.eventCode;
            if (o.eventTag != null) {
                this.eventTag = this.localEventTag;
                this.eventTag.setTo(o.eventTag);
            } else {
                this.eventTag = null;
            }
            this.tagsFirstOccurrence = o.tagsFirstOccurrence;
            this.currentTime = o.currentTime;
            this.powerStats = o.powerStats;
            this.processStateChange = o.processStateChange;
            this.stepDetails = o.stepDetails;
        }

        public boolean sameNonEvent(HistoryItem o) {
            return this.batteryLevel == o.batteryLevel && this.batteryStatus == o.batteryStatus && this.batteryHealth == o.batteryHealth && this.batteryPlugType == o.batteryPlugType && this.batteryTemperature == o.batteryTemperature && this.batteryVoltage == o.batteryVoltage && this.batteryChargeUah == o.batteryChargeUah && this.modemRailChargeMah == o.modemRailChargeMah && this.wifiRailChargeMah == o.wifiRailChargeMah && this.states == o.states && this.states2 == o.states2 && this.currentTime == o.currentTime;
        }

        @UnsupportedAppUsage(maxTargetSdk=28)
        public boolean same(HistoryItem o) {
            if (!this.sameNonEvent(o) || this.eventCode != o.eventCode) {
                return false;
            }
            if (this.wakelockTag != o.wakelockTag) {
                if (this.wakelockTag == null || o.wakelockTag == null) {
                    return false;
                }
                if (!this.wakelockTag.equals(o.wakelockTag)) {
                    return false;
                }
            }
            if (this.wakeReasonTag != o.wakeReasonTag) {
                if (this.wakeReasonTag == null || o.wakeReasonTag == null) {
                    return false;
                }
                if (!this.wakeReasonTag.equals(o.wakeReasonTag)) {
                    return false;
                }
            }
            if (this.eventTag != o.eventTag) {
                if (this.eventTag == null || o.eventTag == null) {
                    return false;
                }
                if (!this.eventTag.equals(o.eventTag)) {
                    return false;
                }
            }
            return true;
        }
    }

    @RavenwoodKeepWholeClass
    public static class HistoryTag {
        public static final int HISTORY_TAG_POOL_OVERFLOW = -1;
        public String string;
        public int uid;
        public int poolIdx;

        public void setTo(HistoryTag o) {
            this.string = o.string;
            this.uid = o.uid;
            this.poolIdx = o.poolIdx;
        }

        public void setTo(String _string, int _uid) {
            this.string = _string;
            this.uid = _uid;
            this.poolIdx = -1;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.string);
            dest.writeInt(this.uid);
        }

        public void readFromParcel(Parcel src) {
            this.string = src.readString();
            this.uid = src.readInt();
            this.poolIdx = -1;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryTag that = (HistoryTag)o;
            if (this.uid != that.uid) {
                return false;
            }
            return this.string.equals(that.string);
        }

        public int hashCode() {
            int result = this.string.hashCode();
            result = 31 * result + this.uid;
            return result;
        }
    }

    public static class LevelStepTracker {
        public long mLastStepTime = -1L;
        public int mNumStepDurations;
        public final long[] mStepDurations;

        public LevelStepTracker(int maxLevelSteps) {
            this.mStepDurations = new long[maxLevelSteps];
        }

        public LevelStepTracker(int numSteps, long[] steps) {
            this.mNumStepDurations = numSteps;
            this.mStepDurations = new long[numSteps];
            System.arraycopy(steps, 0, this.mStepDurations, 0, numSteps);
        }

        public long getDurationAt(int index) {
            return this.mStepDurations[index] & 0xFFFFFFFFFFL;
        }

        public int getLevelAt(int index) {
            return (int)((this.mStepDurations[index] & 0xFF0000000000L) >> 40);
        }

        public int getInitModeAt(int index) {
            return (int)((this.mStepDurations[index] & 0xFF000000000000L) >> 48);
        }

        public int getModModeAt(int index) {
            return (int)((this.mStepDurations[index] & 0xFF00000000000000L) >> 56);
        }

        private void appendHex(long val, int topOffset, StringBuilder out) {
            boolean hasData = false;
            while (topOffset >= 0) {
                int digit = (int)(val >> topOffset & 0xFL);
                topOffset -= 4;
                if (!hasData && digit == 0) continue;
                hasData = true;
                if (digit >= 0 && digit <= 9) {
                    out.append((char)(48 + digit));
                    continue;
                }
                out.append((char)(97 + digit - 10));
            }
        }

        public void encodeEntryAt(int index, StringBuilder out) {
            long item = this.mStepDurations[index];
            long duration = item & 0xFFFFFFFFFFL;
            int level = (int)((item & 0xFF0000000000L) >> 40);
            int initMode = (int)((item & 0xFF000000000000L) >> 48);
            int modMode = (int)((item & 0xFF00000000000000L) >> 56);
            switch ((initMode & 3) + 1) {
                case 1: {
                    out.append('f');
                    break;
                }
                case 2: {
                    out.append('o');
                    break;
                }
                case 3: {
                    out.append('d');
                    break;
                }
                case 4: {
                    out.append('z');
                }
            }
            if ((initMode & 4) != 0) {
                out.append('p');
            }
            if ((initMode & 8) != 0) {
                out.append('i');
            }
            switch ((modMode & 3) + 1) {
                case 1: {
                    out.append('F');
                    break;
                }
                case 2: {
                    out.append('O');
                    break;
                }
                case 3: {
                    out.append('D');
                    break;
                }
                case 4: {
                    out.append('Z');
                }
            }
            if ((modMode & 4) != 0) {
                out.append('P');
            }
            if ((modMode & 8) != 0) {
                out.append('I');
            }
            out.append('-');
            this.appendHex(level, 4, out);
            out.append('-');
            this.appendHex(duration, 36, out);
        }

        public void decodeEntryAt(int index, String value) {
            char c;
            int N2 = value.length();
            int i = 0;
            long out = 0L;
            while (i < N2 && (c = value.charAt(i)) != '-') {
                ++i;
                switch (c) {
                    case 'f': {
                        out |= 0L;
                        break;
                    }
                    case 'o': {
                        out |= 0x1000000000000L;
                        break;
                    }
                    case 'd': {
                        out |= 0x2000000000000L;
                        break;
                    }
                    case 'z': {
                        out |= 0x3000000000000L;
                        break;
                    }
                    case 'p': {
                        out |= 0x4000000000000L;
                        break;
                    }
                    case 'i': {
                        out |= 0x8000000000000L;
                        break;
                    }
                    case 'F': {
                        out |= 0L;
                        break;
                    }
                    case 'O': {
                        out |= 0x100000000000000L;
                        break;
                    }
                    case 'D': {
                        out |= 0x200000000000000L;
                        break;
                    }
                    case 'Z': {
                        out |= 0x300000000000000L;
                        break;
                    }
                    case 'P': {
                        out |= 0x400000000000000L;
                        break;
                    }
                    case 'I': {
                        out |= 0x800000000000000L;
                    }
                }
            }
            ++i;
            long level = 0L;
            while (i < N2 && (c = value.charAt(i)) != '-') {
                ++i;
                level <<= 4;
                if (c >= '0' && c <= '9') {
                    level += (long)(c - 48);
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    level += (long)(c - 97 + 10);
                    continue;
                }
                if (c < 'A' || c > 'F') continue;
                level += (long)(c - 65 + 10);
            }
            ++i;
            out |= level << 40 & 0xFF0000000000L;
            long duration = 0L;
            while (i < N2 && (c = value.charAt(i)) != '-') {
                ++i;
                duration <<= 4;
                if (c >= '0' && c <= '9') {
                    duration += (long)(c - 48);
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    duration += (long)(c - 97 + 10);
                    continue;
                }
                if (c < 'A' || c > 'F') continue;
                duration += (long)(c - 65 + 10);
            }
            this.mStepDurations[index] = out | duration & 0xFFFFFFFFFFL;
        }

        public void init() {
            this.mLastStepTime = -1L;
            this.mNumStepDurations = 0;
        }

        public void clearTime() {
            this.mLastStepTime = -1L;
        }

        public long computeTimePerLevel() {
            long[] steps = this.mStepDurations;
            int numSteps = this.mNumStepDurations;
            if (numSteps <= 0) {
                return -1L;
            }
            long total = 0L;
            for (int i = 0; i < numSteps; ++i) {
                total += steps[i] & 0xFFFFFFFFFFL;
            }
            return total / (long)numSteps;
        }

        public long computeTimeEstimate(long modesOfInterest, long modeValues, int[] outNumOfInterest) {
            long[] steps = this.mStepDurations;
            int count = this.mNumStepDurations;
            if (count <= 0) {
                return -1L;
            }
            long total = 0L;
            int numOfInterest = 0;
            for (int i = 0; i < count; ++i) {
                long initMode = (steps[i] & 0xFF000000000000L) >> 48;
                long modMode = (steps[i] & 0xFF00000000000000L) >> 56;
                if ((modMode & modesOfInterest) != 0L || (initMode & modesOfInterest) != modeValues) continue;
                ++numOfInterest;
                total += steps[i] & 0xFFFFFFFFFFL;
            }
            if (numOfInterest <= 0) {
                return -1L;
            }
            if (outNumOfInterest != null) {
                outNumOfInterest[0] = numOfInterest;
            }
            return total / (long)numOfInterest * 100L;
        }

        public void addLevelSteps(int numStepLevels, long modeBits, long elapsedRealtime) {
            int stepCount = this.mNumStepDurations;
            long lastStepTime = this.mLastStepTime;
            if (lastStepTime >= 0L && numStepLevels > 0) {
                long[] steps = this.mStepDurations;
                long duration = elapsedRealtime - lastStepTime;
                for (int i = 0; i < numStepLevels; ++i) {
                    System.arraycopy(steps, 0, steps, 1, steps.length - 1);
                    long thisDuration = duration / (long)(numStepLevels - i);
                    duration -= thisDuration;
                    if (thisDuration > 0xFFFFFFFFFFL) {
                        thisDuration = 0xFFFFFFFFFFL;
                    }
                    steps[0] = thisDuration | modeBits;
                }
                if ((stepCount += numStepLevels) > steps.length) {
                    stepCount = steps.length;
                }
            }
            this.mNumStepDurations = stepCount;
            this.mLastStepTime = elapsedRealtime;
        }

        public void readFromParcel(Parcel in) {
            int N2 = in.readInt();
            if (N2 > this.mStepDurations.length) {
                throw new ParcelFormatException("more step durations than available: " + N2);
            }
            this.mNumStepDurations = N2;
            for (int i = 0; i < N2; ++i) {
                this.mStepDurations[i] = in.readLong();
            }
        }

        public void writeToParcel(Parcel out) {
            int N2 = this.mNumStepDurations;
            out.writeInt(N2);
            for (int i = 0; i < N2; ++i) {
                out.writeLong(this.mStepDurations[i]);
            }
        }
    }

    public static class HistoryPrinter {
        private static final int FORMAT_LEGACY = 1;
        private static final int FORMAT_VERSION = 2;
        private static final boolean DEBUG_TIMELINE = false;
        private final boolean mPerformanceBaseline;
        private final HistoryLogTimeFormatter mHistoryLogTimeFormatter;
        private final SimpleDateFormat mHistoryItemTimestampFormat;
        private final SimpleDateFormat mCurrentTimeEventTimeFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
        private final Date mDate = new Date();
        private final int mFormatVersion;
        private final StringBuilder mStringBuilder = new StringBuilder();
        int oldState = 0;
        int oldState2 = 0;
        int oldLevel = -1;
        int oldStatus = -1;
        int oldHealth = -1;
        int oldPlug = -1;
        int oldTemp = -1;
        int oldVolt = -1;
        int oldChargeMAh = -1;
        double oldModemRailChargeMah = -1.0;
        double oldWifiRailChargeMah = -1.0;
        long lastTime = -1L;

        public HistoryPrinter() {
            this(0);
        }

        public HistoryPrinter(int flags) {
            this(TimeZone.getDefault(), flags);
        }

        public HistoryPrinter(TimeZone timeZone, int flags) {
            this(2, timeZone, flags);
        }

        private HistoryPrinter(int formatVersion, TimeZone timeZone, int flags) {
            this.mFormatVersion = formatVersion;
            boolean bl = this.mPerformanceBaseline = (flags & 0x80) != 0;
            if (this.mPerformanceBaseline) {
                this.mHistoryItemTimestampFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
                this.mHistoryItemTimestampFormat.getCalendar().setTimeZone(timeZone);
                this.mHistoryLogTimeFormatter = null;
            } else {
                this.mHistoryItemTimestampFormat = null;
                this.mHistoryLogTimeFormatter = new HistoryLogTimeFormatter(timeZone);
            }
            this.mCurrentTimeEventTimeFormat.getCalendar().setTimeZone(timeZone);
        }

        void reset() {
            this.oldState2 = 0;
            this.oldState = 0;
            this.oldLevel = -1;
            this.oldStatus = -1;
            this.oldHealth = -1;
            this.oldPlug = -1;
            this.oldTemp = -1;
            this.oldVolt = -1;
            this.oldChargeMAh = -1;
            this.oldModemRailChargeMah = -1.0;
            this.oldWifiRailChargeMah = -1.0;
        }

        public void printNextItem(PrintWriter pw, HistoryItem rec, long baseTime, boolean checkin, boolean verbose) {
            pw.print(this.printNextItem(rec, baseTime, checkin, verbose));
        }

        public void printNextItem(ProtoOutputStream proto, HistoryItem rec, long baseTime, boolean verbose) {
            String item = this.printNextItem(rec, baseTime, true, verbose);
            for (String line : item.split("\n")) {
                proto.write(2237677961222L, line);
            }
        }

        private String printNextItem(HistoryItem rec, long baseTime, boolean checkin, boolean verbose) {
            StringBuilder item = this.mStringBuilder;
            item.setLength(0);
            if (!checkin) {
                item.append("  ");
                if (this.mFormatVersion == 1) {
                    TimeUtils.formatDuration(rec.time - baseTime, item, 19);
                    item.append(" (");
                    item.append(rec.numReadInts);
                    item.append(") ");
                } else if (this.mPerformanceBaseline) {
                    this.mDate.setTime(rec.currentTime);
                    item.append(this.mHistoryItemTimestampFormat.format(this.mDate)).append(' ');
                } else {
                    this.mHistoryLogTimeFormatter.append(item, rec.currentTime);
                    item.append(' ');
                }
            } else {
                item.append(9);
                item.append(',');
                item.append(BatteryStats.HISTORY_DATA);
                item.append(',');
                if (this.lastTime < 0L) {
                    item.append(rec.time - baseTime);
                } else {
                    item.append(rec.time - this.lastTime);
                }
            }
            this.lastTime = rec.time;
            if (rec.cmd == 4) {
                if (checkin) {
                    item.append(":");
                }
                item.append("START\n");
                this.reset();
            } else if (rec.cmd == 5 || rec.cmd == 7) {
                if (checkin) {
                    item.append(":");
                }
                if (rec.cmd == 7) {
                    item.append("RESET:");
                    this.reset();
                }
                item.append("TIME:");
                if (checkin) {
                    item.append(rec.currentTime);
                    item.append("\n");
                } else {
                    item.append(" ");
                    this.mDate.setTime(rec.currentTime);
                    item.append(this.mCurrentTimeEventTimeFormat.format(this.mDate));
                    item.append("\n");
                }
            } else if (rec.cmd == 8) {
                if (checkin) {
                    item.append(":");
                }
                item.append("SHUTDOWN\n");
            } else if (rec.cmd == 6) {
                if (checkin) {
                    item.append(":");
                }
                item.append("*OVERFLOW*\n");
            } else {
                int chargeMAh;
                if (!checkin) {
                    if (rec.batteryLevel < 10) {
                        item.append("00");
                    } else if (rec.batteryLevel < 100) {
                        item.append("0");
                    }
                    item.append(rec.batteryLevel);
                    if (verbose) {
                        item.append(" ");
                        if (rec.states >= 0) {
                            if (rec.states < 16) {
                                item.append("0000000");
                            } else if (rec.states < 256) {
                                item.append("000000");
                            } else if (rec.states < 4096) {
                                item.append("00000");
                            } else if (rec.states < 65536) {
                                item.append("0000");
                            } else if (rec.states < 0x100000) {
                                item.append("000");
                            } else if (rec.states < 0x1000000) {
                                item.append("00");
                            } else if (rec.states < 0x10000000) {
                                item.append("0");
                            }
                        }
                        item.append(Integer.toHexString(rec.states));
                    }
                } else if (this.oldLevel != rec.batteryLevel) {
                    this.oldLevel = rec.batteryLevel;
                    item.append(",Bl=");
                    item.append(rec.batteryLevel);
                }
                if (this.oldStatus != rec.batteryStatus) {
                    this.oldStatus = rec.batteryStatus;
                    item.append(checkin ? ",Bs=" : " status=");
                    switch (this.oldStatus) {
                        case 1: {
                            item.append(checkin ? "?" : "unknown");
                            break;
                        }
                        case 2: {
                            item.append(checkin ? "c" : "charging");
                            break;
                        }
                        case 3: {
                            item.append(checkin ? "d" : "discharging");
                            break;
                        }
                        case 4: {
                            item.append(checkin ? "n" : "not-charging");
                            break;
                        }
                        case 5: {
                            item.append(checkin ? "f" : "full");
                            break;
                        }
                        default: {
                            item.append(this.oldStatus);
                        }
                    }
                }
                if (this.oldHealth != rec.batteryHealth) {
                    this.oldHealth = rec.batteryHealth;
                    item.append(checkin ? ",Bh=" : " health=");
                    switch (this.oldHealth) {
                        case 1: {
                            item.append(checkin ? "?" : "unknown");
                            break;
                        }
                        case 2: {
                            item.append(checkin ? "g" : "good");
                            break;
                        }
                        case 3: {
                            item.append(checkin ? BatteryStats.HISTORY_DATA : "overheat");
                            break;
                        }
                        case 4: {
                            item.append(checkin ? "d" : "dead");
                            break;
                        }
                        case 5: {
                            item.append(checkin ? "v" : "over-voltage");
                            break;
                        }
                        case 6: {
                            item.append(checkin ? "f" : "failure");
                            break;
                        }
                        case 7: {
                            item.append(checkin ? "c" : "cold");
                            break;
                        }
                        default: {
                            item.append(this.oldHealth);
                        }
                    }
                }
                if (this.oldPlug != rec.batteryPlugType) {
                    this.oldPlug = rec.batteryPlugType;
                    item.append(checkin ? ",Bp=" : " plug=");
                    switch (this.oldPlug) {
                        case 0: {
                            item.append(checkin ? "n" : "none");
                            break;
                        }
                        case 1: {
                            item.append(checkin ? "a" : "ac");
                            break;
                        }
                        case 2: {
                            item.append(checkin ? "u" : "usb");
                            break;
                        }
                        case 4: {
                            item.append(checkin ? "w" : "wireless");
                            break;
                        }
                        case 8: {
                            item.append(checkin ? "d" : "dock");
                            break;
                        }
                        default: {
                            item.append(this.oldPlug);
                        }
                    }
                }
                if (this.oldTemp != rec.batteryTemperature) {
                    this.oldTemp = rec.batteryTemperature;
                    item.append(checkin ? ",Bt=" : " temp=");
                    item.append(this.oldTemp);
                }
                if (this.oldVolt != rec.batteryVoltage) {
                    this.oldVolt = rec.batteryVoltage;
                    item.append(checkin ? ",Bv=" : " volt=");
                    item.append(this.oldVolt);
                }
                if (this.oldChargeMAh != (chargeMAh = rec.batteryChargeUah / 1000)) {
                    this.oldChargeMAh = chargeMAh;
                    item.append(checkin ? ",Bcc=" : " charge=");
                    item.append(this.oldChargeMAh);
                }
                if (this.oldModemRailChargeMah != rec.modemRailChargeMah) {
                    this.oldModemRailChargeMah = rec.modemRailChargeMah;
                    item.append(checkin ? ",Mrc=" : " modemRailChargemAh=");
                    item.append(new DecimalFormat("#.##").format(this.oldModemRailChargeMah));
                }
                if (this.oldWifiRailChargeMah != rec.wifiRailChargeMah) {
                    this.oldWifiRailChargeMah = rec.wifiRailChargeMah;
                    item.append(checkin ? ",Wrc=" : " wifiRailChargemAh=");
                    item.append(new DecimalFormat("#.##").format(this.oldWifiRailChargeMah));
                }
                BatteryStats.printBitDescriptions(item, this.oldState, rec.states, rec.wakelockTag, HISTORY_STATE_DESCRIPTIONS, !checkin);
                BatteryStats.printBitDescriptions(item, this.oldState2, rec.states2, null, HISTORY_STATE2_DESCRIPTIONS, !checkin);
                if (rec.wakeReasonTag != null) {
                    if (checkin) {
                        item.append(",wr=");
                        if (rec.wakeReasonTag.poolIdx == -1) {
                            item.append(sUidToString.applyAsString(rec.wakeReasonTag.uid));
                            item.append(":\"");
                            item.append(rec.wakeReasonTag.string.replace("\"", "\"\""));
                            item.append("\"");
                        } else {
                            item.append(rec.wakeReasonTag.poolIdx);
                        }
                    } else {
                        item.append(" wake_reason=");
                        item.append(rec.wakeReasonTag.uid);
                        item.append(":\"");
                        item.append(rec.wakeReasonTag.string);
                        item.append("\"");
                    }
                }
                if (rec.eventCode != 0) {
                    item.append(checkin ? "," : " ");
                    if ((rec.eventCode & 0x8000) != 0) {
                        item.append("+");
                    } else if ((rec.eventCode & 0x4000) != 0) {
                        item.append("-");
                    }
                    String[] eventNames = checkin ? HISTORY_EVENT_CHECKIN_NAMES : HISTORY_EVENT_NAMES;
                    int idx = rec.eventCode & 0xFFFF3FFF;
                    if (idx >= 0 && idx < eventNames.length) {
                        item.append(eventNames[idx]);
                    } else {
                        item.append(checkin ? "Ev" : "event");
                        item.append(idx);
                    }
                    item.append("=");
                    if (checkin) {
                        if (rec.eventTag.poolIdx == -1) {
                            item.append(HISTORY_EVENT_INT_FORMATTERS[idx].applyAsString(rec.eventTag.uid));
                            item.append(":\"");
                            item.append(rec.eventTag.string.replace("\"", "\"\""));
                            item.append("\"");
                        } else {
                            item.append(rec.eventTag.poolIdx);
                        }
                    } else {
                        item.append(HISTORY_EVENT_INT_FORMATTERS[idx].applyAsString(rec.eventTag.uid));
                        item.append(":\"");
                        item.append(rec.eventTag.string);
                        item.append("\"");
                    }
                }
                if (rec.powerStats != null && verbose && !checkin) {
                    item.append("\n                 Stats: ");
                    item.append(rec.powerStats.formatForBatteryHistory("\n                    "));
                }
                if (rec.processStateChange != null && verbose && !checkin) {
                    item.append(" procstate: ");
                    item.append(rec.processStateChange.formatForBatteryHistory());
                }
                item.append("\n");
                if (rec.stepDetails != null) {
                    if (!checkin) {
                        item.append("                 Details: cpu=");
                        item.append(rec.stepDetails.userTime);
                        item.append("u+");
                        item.append(rec.stepDetails.systemTime);
                        item.append("s");
                        if (rec.stepDetails.appCpuUid1 >= 0) {
                            item.append(" (");
                            this.printStepCpuUidDetails(item, rec.stepDetails.appCpuUid1, rec.stepDetails.appCpuUTime1, rec.stepDetails.appCpuSTime1);
                            if (rec.stepDetails.appCpuUid2 >= 0) {
                                item.append(", ");
                                this.printStepCpuUidDetails(item, rec.stepDetails.appCpuUid2, rec.stepDetails.appCpuUTime2, rec.stepDetails.appCpuSTime2);
                            }
                            if (rec.stepDetails.appCpuUid3 >= 0) {
                                item.append(", ");
                                this.printStepCpuUidDetails(item, rec.stepDetails.appCpuUid3, rec.stepDetails.appCpuUTime3, rec.stepDetails.appCpuSTime3);
                            }
                            item.append(')');
                        }
                        item.append("\n");
                        item.append("                          /proc/stat=");
                        item.append(rec.stepDetails.statUserTime);
                        item.append(" usr, ");
                        item.append(rec.stepDetails.statSystemTime);
                        item.append(" sys, ");
                        item.append(rec.stepDetails.statIOWaitTime);
                        item.append(" io, ");
                        item.append(rec.stepDetails.statIrqTime);
                        item.append(" irq, ");
                        item.append(rec.stepDetails.statSoftIrqTime);
                        item.append(" sirq, ");
                        item.append(rec.stepDetails.statIdlTime);
                        item.append(" idle");
                        int totalRun = rec.stepDetails.statUserTime + rec.stepDetails.statSystemTime + rec.stepDetails.statIOWaitTime + rec.stepDetails.statIrqTime + rec.stepDetails.statSoftIrqTime;
                        int total = totalRun + rec.stepDetails.statIdlTime;
                        if (total > 0) {
                            item.append(" (");
                            float perc = (float)totalRun / (float)total * 100.0f;
                            item.append(String.format("%.1f%%", Float.valueOf(perc)));
                            item.append(" of ");
                            StringBuilder sb = new StringBuilder(64);
                            BatteryStats.formatTimeMsNoSpace(sb, total * 10);
                            item.append((CharSequence)sb);
                            item.append(")");
                        }
                        item.append(", SubsystemPowerState ");
                        item.append(rec.stepDetails.statSubsystemPowerState != null ? rec.stepDetails.statSubsystemPowerState : "Empty");
                        item.append("\n");
                    } else {
                        item.append(9);
                        item.append(',');
                        item.append(BatteryStats.HISTORY_DATA);
                        item.append(",0,Dcpu=");
                        item.append(rec.stepDetails.userTime);
                        item.append(":");
                        item.append(rec.stepDetails.systemTime);
                        if (rec.stepDetails.appCpuUid1 >= 0) {
                            this.printStepCpuUidCheckinDetails(item, rec.stepDetails.appCpuUid1, rec.stepDetails.appCpuUTime1, rec.stepDetails.appCpuSTime1);
                            if (rec.stepDetails.appCpuUid2 >= 0) {
                                this.printStepCpuUidCheckinDetails(item, rec.stepDetails.appCpuUid2, rec.stepDetails.appCpuUTime2, rec.stepDetails.appCpuSTime2);
                            }
                            if (rec.stepDetails.appCpuUid3 >= 0) {
                                this.printStepCpuUidCheckinDetails(item, rec.stepDetails.appCpuUid3, rec.stepDetails.appCpuUTime3, rec.stepDetails.appCpuSTime3);
                            }
                        }
                        item.append("\n");
                        item.append(9);
                        item.append(',');
                        item.append(BatteryStats.HISTORY_DATA);
                        item.append(",0,Dpst=");
                        item.append(rec.stepDetails.statUserTime);
                        item.append(',');
                        item.append(rec.stepDetails.statSystemTime);
                        item.append(',');
                        item.append(rec.stepDetails.statIOWaitTime);
                        item.append(',');
                        item.append(rec.stepDetails.statIrqTime);
                        item.append(',');
                        item.append(rec.stepDetails.statSoftIrqTime);
                        item.append(',');
                        item.append(rec.stepDetails.statIdlTime);
                        item.append(',');
                        if (rec.stepDetails.statSubsystemPowerState != null) {
                            item.append(rec.stepDetails.statSubsystemPowerState);
                        }
                        item.append("\n");
                    }
                }
                this.oldState = rec.states;
                this.oldState2 = rec.states2;
                if ((rec.states2 & 0x80000) != 0) {
                    rec.states2 &= 0xFFF7FFFF;
                }
            }
            return item.toString();
        }

        private void printStepCpuUidDetails(StringBuilder sb, int uid, int utime, int stime) {
            UserHandle.formatUid(sb, uid);
            sb.append("=");
            sb.append(utime);
            sb.append("u+");
            sb.append(stime);
            sb.append("s");
        }

        private void printStepCpuUidCheckinDetails(StringBuilder sb, int uid, int utime, int stime) {
            sb.append('/');
            sb.append(uid);
            sb.append(":");
            sb.append(utime);
            sb.append(":");
            sb.append(stime);
        }

        private static class HistoryLogTimeFormatter {
            private static final long HOUR_MILLIS = 3600000L;
            private static final long MINUTE_MILLIS = 60000L;
            private final SimpleDateFormat mDateFormat = new SimpleDateFormat("MM-dd HH:", Locale.US);
            private final Date mDate = new Date();
            private final long mTimeZoneOffset;
            private long mCachedHour;
            private String mCachedHourFormatted;

            private HistoryLogTimeFormatter(TimeZone timeZone) {
                this.mTimeZoneOffset = timeZone.getRawOffset();
                this.mDateFormat.getCalendar().setTimeZone(timeZone);
            }

            void append(StringBuilder sb, long timestampMs) {
                long localTime = timestampMs + this.mTimeZoneOffset;
                long hour = localTime / 3600000L;
                if (hour != this.mCachedHour) {
                    this.mDate.setTime(timestampMs);
                    this.mCachedHourFormatted = this.mDateFormat.format(this.mDate);
                    this.mCachedHour = hour;
                }
                sb.append(this.mCachedHourFormatted);
                long remainder = localTime % 3600000L;
                long minutes = remainder / 60000L;
                if (minutes < 10L) {
                    sb.append('0');
                }
                sb.append(minutes).append(':');
                long seconds = (remainder %= 60000L) / 1000L;
                if (seconds < 10L) {
                    sb.append('0');
                }
                sb.append(seconds).append('.');
                long millis = remainder % 1000L;
                if (millis < 100L) {
                    sb.append('0');
                    if (millis < 10L) {
                        sb.append('0');
                    }
                }
                sb.append(millis);
            }
        }
    }

    public static class HistoryEventTracker {
        private final HashMap<String, SparseIntArray>[] mActiveEvents = new HashMap[23];

        public boolean updateState(int code, String name, int uid, int poolIdx) {
            if ((code & 0x8000) != 0) {
                SparseIntArray uids;
                int idx = code & 0xFFFF3FFF;
                HashMap<String, SparseIntArray> active = this.mActiveEvents[idx];
                if (active == null) {
                    active = new HashMap();
                    this.mActiveEvents[idx] = active;
                }
                if ((uids = active.get(name)) == null) {
                    uids = new SparseIntArray();
                    active.put(name, uids);
                }
                if (uids.indexOfKey(uid) >= 0) {
                    return false;
                }
                uids.put(uid, poolIdx);
            } else if ((code & 0x4000) != 0) {
                int idx = code & 0xFFFF3FFF;
                HashMap<String, SparseIntArray> active = this.mActiveEvents[idx];
                if (active == null) {
                    return false;
                }
                SparseIntArray uids = active.get(name);
                if (uids == null) {
                    return false;
                }
                idx = uids.indexOfKey(uid);
                if (idx < 0) {
                    return false;
                }
                uids.removeAt(idx);
                if (uids.size() <= 0) {
                    active.remove(name);
                }
            }
            return true;
        }

        public void removeEvents(int code) {
            int idx = code & 0xFFFF3FFF;
            this.mActiveEvents[idx] = null;
        }

        public HashMap<String, SparseIntArray> getStateForEvent(int code) {
            return this.mActiveEvents[code];
        }
    }

    public static class PackageChange {
        public String mPackageName;
        public boolean mUpdate;
        public long mVersionCode;
    }

    public static class DailyItem {
        public long mStartTime;
        public long mEndTime;
        public LevelStepTracker mDischargeSteps;
        public LevelStepTracker mChargeSteps;
        public ArrayList<PackageChange> mPackageChanges;
    }

    @FunctionalInterface
    public static interface IntToString {
        public String applyAsString(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RadioAccessTechnology {
    }

    @RavenwoodKeepWholeClass
    public static class ProcessStateChange {
        public int uid;
        public int processState;
        private static final int LARGE_UID_FLAG = Integer.MIN_VALUE;
        private static final int SMALL_UID_MASK = 0xFFFFFF;
        private static final int PROC_STATE_MASK = 0x7F000000;
        private static final int PROC_STATE_SHIFT = Integer.numberOfTrailingZeros(0x7F000000);

        public void writeToParcel(Parcel out) {
            int bits = this.processState << PROC_STATE_SHIFT;
            if ((this.uid & 0xFF000000) == 0) {
                out.writeInt(bits |= this.uid);
            } else {
                out.writeInt(bits |= Integer.MIN_VALUE);
                out.writeInt(this.uid);
            }
        }

        public void readFromParcel(Parcel in) {
            int bits = in.readInt();
            this.processState = (bits & 0x7F000000) >>> PROC_STATE_SHIFT;
            if (this.processState >= 5) {
                Slog.e(BatteryStats.TAG, "Unrecognized proc state in battery history: " + this.processState);
                this.processState = 0;
            }
            this.uid = (bits & Integer.MIN_VALUE) == 0 ? bits & 0x80FFFFFF : in.readInt();
        }

        public String formatForBatteryHistory() {
            return UserHandle.formatUid(this.uid) + ": " + BatteryConsumer.processStateToString(this.processState);
        }
    }

    @RavenwoodKeepWholeClass
    public static class HistoryStepDetails {
        public int userTime;
        public int systemTime;
        public int appCpuUid1;
        public int appCpuUTime1;
        public int appCpuSTime1;
        public int appCpuUid2;
        public int appCpuUTime2;
        public int appCpuSTime2;
        public int appCpuUid3;
        public int appCpuUTime3;
        public int appCpuSTime3;
        public int statUserTime;
        public int statSystemTime;
        public int statIOWaitTime;
        public int statIrqTime;
        public int statSoftIrqTime;
        public int statIdlTime;
        public String statSubsystemPowerState;

        public HistoryStepDetails() {
            this.clear();
        }

        public void clear() {
            this.systemTime = 0;
            this.userTime = 0;
            this.appCpuUid3 = -1;
            this.appCpuUid2 = -1;
            this.appCpuUid1 = -1;
            this.appCpuSTime3 = 0;
            this.appCpuUTime3 = 0;
            this.appCpuSTime2 = 0;
            this.appCpuUTime2 = 0;
            this.appCpuSTime1 = 0;
            this.appCpuUTime1 = 0;
        }

        public void writeToParcel(Parcel out) {
            out.writeInt(this.userTime);
            out.writeInt(this.systemTime);
            out.writeInt(this.appCpuUid1);
            out.writeInt(this.appCpuUTime1);
            out.writeInt(this.appCpuSTime1);
            out.writeInt(this.appCpuUid2);
            out.writeInt(this.appCpuUTime2);
            out.writeInt(this.appCpuSTime2);
            out.writeInt(this.appCpuUid3);
            out.writeInt(this.appCpuUTime3);
            out.writeInt(this.appCpuSTime3);
            out.writeInt(this.statUserTime);
            out.writeInt(this.statSystemTime);
            out.writeInt(this.statIOWaitTime);
            out.writeInt(this.statIrqTime);
            out.writeInt(this.statSoftIrqTime);
            out.writeInt(this.statIdlTime);
            out.writeString8(this.statSubsystemPowerState);
        }

        public void readFromParcel(Parcel in) {
            this.userTime = in.readInt();
            this.systemTime = in.readInt();
            this.appCpuUid1 = in.readInt();
            this.appCpuUTime1 = in.readInt();
            this.appCpuSTime1 = in.readInt();
            this.appCpuUid2 = in.readInt();
            this.appCpuUTime2 = in.readInt();
            this.appCpuSTime2 = in.readInt();
            this.appCpuUid3 = in.readInt();
            this.appCpuUTime3 = in.readInt();
            this.appCpuSTime3 = in.readInt();
            this.statUserTime = in.readInt();
            this.statSystemTime = in.readInt();
            this.statIOWaitTime = in.readInt();
            this.statIrqTime = in.readInt();
            this.statSoftIrqTime = in.readInt();
            this.statIdlTime = in.readInt();
            this.statSubsystemPowerState = in.readString8();
        }

        public boolean isEmpty() {
            return this.userTime == 0 && this.systemTime == 0 && this.appCpuUid1 == -1 && this.appCpuUid2 == -1 && this.appCpuUid3 == -1 && this.statSystemTime == 0 && this.statIOWaitTime == 0 && this.statIrqTime == 0 && this.statSoftIrqTime == 0 && this.statIdlTime == 0 && this.statSubsystemPowerState == null;
        }
    }

    public static abstract class LongCounterArray {
        public abstract long[] getCountsLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatName {
    }
}

