/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HexFormat;

public class PollingFrame
implements Parcelable {
    public static final int POLLING_LOOP_TYPE_A = 65;
    public static final int POLLING_LOOP_TYPE_B = 66;
    public static final int POLLING_LOOP_TYPE_F = 70;
    public static final int POLLING_LOOP_TYPE_ON = 79;
    public static final int POLLING_LOOP_TYPE_OFF = 88;
    public static final int POLLING_LOOP_TYPE_UNKNOWN = 85;
    private static final String KEY_POLLING_LOOP_TYPE = "android.nfc.cardemulation.TYPE";
    private static final String KEY_POLLING_LOOP_DATA = "android.nfc.cardemulation.DATA";
    private static final String KEY_POLLING_LOOP_GAIN = "android.nfc.cardemulation.GAIN";
    private static final String KEY_POLLING_LOOP_TIMESTAMP = "android.nfc.cardemulation.TIMESTAMP";
    private static final String KEY_POLLING_LOOP_TRIGGERED_AUTOTRANSACT = "android.nfc.cardemulation.TRIGGERED_AUTOTRANSACT";
    private final int mType;
    private final byte[] mData;
    private final int mGain;
    private final long mTimestamp;
    private boolean mTriggeredAutoTransact;
    @NonNull
    public static final Parcelable.Creator<PollingFrame> CREATOR = new Parcelable.Creator<PollingFrame>(){

        @Override
        public PollingFrame createFromParcel(Parcel source) {
            return new PollingFrame(source.readBundle());
        }

        public PollingFrame[] newArray(int size) {
            return new PollingFrame[size];
        }
    };

    private PollingFrame(Bundle frame) {
        this.mType = frame.getInt(KEY_POLLING_LOOP_TYPE);
        byte[] data = frame.getByteArray(KEY_POLLING_LOOP_DATA);
        this.mData = data == null ? new byte[]{} : data;
        this.mGain = frame.getInt(KEY_POLLING_LOOP_GAIN, -1);
        this.mTimestamp = frame.getLong(KEY_POLLING_LOOP_TIMESTAMP);
        this.mTriggeredAutoTransact = frame.containsKey(KEY_POLLING_LOOP_TRIGGERED_AUTOTRANSACT) && frame.getBoolean(KEY_POLLING_LOOP_TRIGGERED_AUTOTRANSACT);
    }

    public PollingFrame(int type, @Nullable byte[] data, int gain, long timestampMicros, boolean triggeredAutoTransact) {
        this.mType = type;
        this.mData = data == null ? new byte[]{} : data;
        this.mGain = gain;
        this.mTimestamp = timestampMicros;
        this.mTriggeredAutoTransact = triggeredAutoTransact;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public byte[] getData() {
        return this.mData;
    }

    public int getVendorSpecificGain() {
        return this.mGain;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public void setTriggeredAutoTransact(boolean triggeredAutoTransact) {
        this.mTriggeredAutoTransact = triggeredAutoTransact;
    }

    public boolean getTriggeredAutoTransact() {
        return this.mTriggeredAutoTransact;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBundle(this.toBundle());
    }

    private Bundle toBundle() {
        Bundle frame = new Bundle();
        frame.putInt(KEY_POLLING_LOOP_TYPE, this.getType());
        if (this.getVendorSpecificGain() != -1) {
            frame.putInt(KEY_POLLING_LOOP_GAIN, (byte)this.getVendorSpecificGain());
        }
        frame.putByteArray(KEY_POLLING_LOOP_DATA, this.getData());
        frame.putLong(KEY_POLLING_LOOP_TIMESTAMP, this.getTimestamp());
        frame.putBoolean(KEY_POLLING_LOOP_TRIGGERED_AUTOTRANSACT, this.getTriggeredAutoTransact());
        return frame;
    }

    public String toString() {
        return "PollingFrame { Type: " + (char)this.getType() + ", gain: " + this.getVendorSpecificGain() + ", timestamp: " + Long.toUnsignedString(this.getTimestamp()) + ", data: [" + HexFormat.ofDelimiter(" ").formatHex(this.getData()) + "] }";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PollingFrameType {
    }
}

