/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@SystemApi
@FlaggedApi(value="android.nfc.enable_nfc_mainline")
public class AidGroup
implements Parcelable {
    private static final int MAX_NUM_AIDS = 256;
    private static final String TAG = "AidGroup";
    private final List<String> mAids;
    private final String mCategory;
    private final String mDescription;
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public static final Parcelable.Creator<AidGroup> CREATOR = new Parcelable.Creator<AidGroup>(){

        @Override
        public AidGroup createFromParcel(Parcel source) {
            String category = source.readString8();
            int listSize = source.readInt();
            ArrayList<String> aidList = new ArrayList<String>();
            if (listSize > 0) {
                source.readStringList(aidList);
            }
            return new AidGroup(aidList, category);
        }

        public AidGroup[] newArray(int size) {
            return new AidGroup[size];
        }
    };
    private static final Pattern AID_PATTERN = Pattern.compile("[0-9A-Fa-f]{10,32}\\*?\\#?");

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public AidGroup(@NonNull List<String> aids, @Nullable String category) {
        if (aids == null || aids.size() == 0) {
            throw new IllegalArgumentException("No AIDS in AID group.");
        }
        if (aids.size() > 256) {
            throw new IllegalArgumentException("Too many AIDs in AID group.");
        }
        for (String aid : aids) {
            if (AidGroup.isValidAid(aid)) continue;
            throw new IllegalArgumentException("AID " + aid + " is not a valid AID.");
        }
        this.mCategory = AidGroup.isValidCategory(category) ? category : "other";
        this.mAids = new ArrayList<String>(aids.size());
        for (String aid : aids) {
            this.mAids.add(aid.toUpperCase(Locale.US));
        }
        this.mDescription = null;
    }

    AidGroup(@NonNull String category, @NonNull String description) {
        this.mAids = new ArrayList<String>();
        this.mCategory = category;
        this.mDescription = description;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getCategory() {
        return this.mCategory;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public List<String> getAids() {
        return this.mAids;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("Category: " + this.mCategory + ", AIDs:");
        for (String aid : this.mAids) {
            out.append(aid);
            out.append(", ");
        }
        return out.toString();
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void dump(@NonNull ProtoOutputStream proto) {
        proto.write(0x10900000001L, this.mCategory);
        for (String aid : this.mAids) {
            proto.write(0x20900000002L, aid);
        }
    }

    @Override
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mCategory);
        dest.writeInt(this.mAids.size());
        if (this.mAids.size() > 0) {
            dest.writeStringList(this.mAids);
        }
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @Nullable
    public static AidGroup createFromXml(@NonNull XmlPullParser parser) throws XmlPullParserException, IOException {
        String category = null;
        ArrayList<String> aids = new ArrayList<String>();
        AidGroup group = null;
        boolean inGroup = false;
        int eventType = parser.getEventType();
        int minDepth = parser.getDepth();
        while (eventType != 1 && parser.getDepth() >= minDepth) {
            String tagName = parser.getName();
            if (eventType == 2) {
                if (tagName.equals("aid")) {
                    if (inGroup) {
                        String aid = parser.getAttributeValue(null, "value");
                        if (aid != null) {
                            aids.add(aid.toUpperCase());
                        }
                    } else {
                        Log.d(TAG, "Ignoring <aid> tag while not in group");
                    }
                } else if (tagName.equals("aid-group")) {
                    category = parser.getAttributeValue(null, "category");
                    if (category == null) {
                        Log.e(TAG, "<aid-group> tag without valid category");
                        return null;
                    }
                    inGroup = true;
                } else {
                    Log.d(TAG, "Ignoring unexpected tag: " + tagName);
                }
            } else if (eventType == 3 && tagName.equals("aid-group") && inGroup && aids.size() > 0) {
                group = new AidGroup(aids, category);
                break;
            }
            eventType = parser.next();
        }
        return group;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void writeAsXml(@NonNull XmlSerializer out) throws IOException {
        out.startTag(null, "aid-group");
        out.attribute(null, "category", this.mCategory);
        for (String aid : this.mAids) {
            out.startTag(null, "aid");
            out.attribute(null, "value", aid);
            out.endTag(null, "aid");
        }
        out.endTag(null, "aid-group");
    }

    private static boolean isValidCategory(String category) {
        return "payment".equals(category) || "other".equals(category);
    }

    private static boolean isValidAid(String aid) {
        if (aid == null) {
            return false;
        }
        if ((aid.endsWith("*") || aid.endsWith("#")) && aid.length() % 2 == 0) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!aid.endsWith("*") && !aid.endsWith("#") && aid.length() % 2 != 0) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!AID_PATTERN.matcher(aid).matches()) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        return true;
    }
}

