/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.NonNull;
import android.nfc.INfcVendorNciCallback;
import android.nfc.NfcAdapter;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class NfcVendorNciCallbackListener
extends INfcVendorNciCallback.Stub {
    private static final String TAG = "Nfc.NfcVendorNciCallbacks";
    private boolean mIsRegistered = false;
    private final Map<NfcAdapter.NfcVendorNciCallback, Executor> mCallbackMap = new HashMap<NfcAdapter.NfcVendorNciCallback, Executor>();
    private IBinder.DeathRecipient mDeathRecipient;

    private void linkToNfcDeath() {
        try {
            this.mDeathRecipient = new IBinder.DeathRecipient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void binderDied() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        NfcVendorNciCallbackListener.this.mDeathRecipient = null;
                    }
                    final Handler handler = new Handler(Looper.getMainLooper());
                    handler.postDelayed(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    if (NfcVendorNciCallbackListener.this.mCallbackMap.size() > 0) {
                                        NfcAdapter.callService(() -> NfcAdapter.getService().registerVendorExtensionCallback(NfcVendorNciCallbackListener.this));
                                        NfcVendorNciCallbackListener.this.linkToNfcDeath();
                                    }
                                }
                            }
                            catch (Throwable t) {
                                handler.postDelayed(this, 50L);
                            }
                        }
                    }, 50L);
                }
            };
            NfcAdapter.getService().asBinder().linkToDeath(this.mDeathRecipient, 0);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't link to death");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull Executor executor, @NonNull NfcAdapter.NfcVendorNciCallback callback) {
        NfcVendorNciCallbackListener nfcVendorNciCallbackListener = this;
        synchronized (nfcVendorNciCallbackListener) {
            if (this.mCallbackMap.containsKey(callback)) {
                return;
            }
            this.mCallbackMap.put(callback, executor);
            if (!this.mIsRegistered) {
                NfcVendorNciCallbackListener listener = this;
                NfcAdapter.callService(() -> {
                    NfcAdapter.getService().registerVendorExtensionCallback(listener);
                    this.linkToNfcDeath();
                    this.mIsRegistered = true;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@NonNull NfcAdapter.NfcVendorNciCallback callback) {
        NfcVendorNciCallbackListener nfcVendorNciCallbackListener = this;
        synchronized (nfcVendorNciCallbackListener) {
            if (!this.mCallbackMap.containsKey(callback) || !this.mIsRegistered) {
                return;
            }
            if (this.mCallbackMap.size() == 1) {
                NfcVendorNciCallbackListener listener = this;
                NfcAdapter.callService(() -> {
                    NfcAdapter.getService().unregisterVendorExtensionCallback(listener);
                    if (this.mDeathRecipient != null) {
                        NfcAdapter.getService().asBinder().unlinkToDeath(this.mDeathRecipient, 0);
                        this.mDeathRecipient = null;
                    }
                    this.mIsRegistered = false;
                });
            }
            this.mCallbackMap.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVendorResponseReceived(int gid, int oid, @NonNull byte[] payload) throws RemoteException {
        NfcVendorNciCallbackListener nfcVendorNciCallbackListener = this;
        synchronized (nfcVendorNciCallbackListener) {
            long identity = Binder.clearCallingIdentity();
            try {
                for (NfcAdapter.NfcVendorNciCallback callback : this.mCallbackMap.keySet()) {
                    Executor executor = this.mCallbackMap.get(callback);
                    executor.execute(() -> callback.onVendorNciResponse(gid, oid, payload));
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVendorNotificationReceived(int gid, int oid, @NonNull byte[] payload) throws RemoteException {
        NfcVendorNciCallbackListener nfcVendorNciCallbackListener = this;
        synchronized (nfcVendorNciCallbackListener) {
            long identity = Binder.clearCallingIdentity();
            try {
                for (NfcAdapter.NfcVendorNciCallback callback : this.mCallbackMap.keySet()) {
                    Executor executor = this.mCallbackMap.get(callback);
                    executor.execute(() -> callback.onVendorNciNotification(gid, oid, payload));
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

