/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.util;

import android.annotation.Nullable;
import android.os.PersistableBundle;
import java.util.Arrays;
import java.util.Objects;

public class PersistableBundleUtils {
    public static int getHashCode(@Nullable PersistableBundle bundle) {
        if (bundle == null) {
            return -1;
        }
        int iterativeHashcode = 0;
        for (String key : bundle.keySet()) {
            Object val = bundle.get(key);
            if (val instanceof PersistableBundle) {
                iterativeHashcode = Objects.hash(iterativeHashcode, key, PersistableBundleUtils.getHashCode((PersistableBundle)val));
                continue;
            }
            if (val.getClass().isArray()) {
                iterativeHashcode = Objects.hash(iterativeHashcode, key, PersistableBundleUtils.getArrayHashCode(val));
                continue;
            }
            iterativeHashcode = Objects.hash(iterativeHashcode, key, val);
        }
        return iterativeHashcode;
    }

    private static int getArrayHashCode(Object arr) {
        if (arr instanceof boolean[]) {
            return Arrays.hashCode((boolean[])arr);
        }
        if (arr instanceof double[]) {
            return Arrays.hashCode((double[])arr);
        }
        if (arr instanceof int[]) {
            return Arrays.hashCode((int[])arr);
        }
        if (arr instanceof long[]) {
            return Arrays.hashCode((long[])arr);
        }
        if (arr instanceof String[]) {
            return Arrays.hashCode((String[])arr);
        }
        return -1;
    }

    private static boolean arraysEqual(Object left, Object right) {
        if (left instanceof boolean[]) {
            return Arrays.equals((boolean[])left, (boolean[])right);
        }
        if (left instanceof double[]) {
            return Arrays.equals((double[])left, (double[])right);
        }
        if (left instanceof int[]) {
            return Arrays.equals((int[])left, (int[])right);
        }
        if (left instanceof long[]) {
            return Arrays.equals((long[])left, (long[])right);
        }
        if (left instanceof String[]) {
            return Arrays.equals((String[])left, (String[])right);
        }
        return false;
    }

    public static boolean isEqual(@Nullable PersistableBundle left, @Nullable PersistableBundle right) {
        if (Objects.equals(left, right)) {
            return true;
        }
        if (Objects.isNull(left) != Objects.isNull(right)) {
            return false;
        }
        if (!left.keySet().equals(right.keySet())) {
            return false;
        }
        for (String key : left.keySet()) {
            Object rightVal;
            Object leftVal = left.get(key);
            if (Objects.equals(leftVal, rightVal = right.get(key))) continue;
            if (!Objects.equals(leftVal.getClass(), rightVal.getClass())) {
                return false;
            }
            if (!(leftVal instanceof PersistableBundle ? !PersistableBundleUtils.isEqual((PersistableBundle)leftVal, (PersistableBundle)rightVal) : (leftVal.getClass().isArray() ? !PersistableBundleUtils.arraysEqual(leftVal, rightVal) : !Objects.equals(leftVal, rightVal)))) continue;
            return false;
        }
        return true;
    }
}

